define("local_autotag/autotag",["exports","core/ajax","local_autotag/selectors"],(function(_exports,_ajax,_selectors){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * AMD module for the AutoTag feature.
   *
   * @module     local_autotag/autotag
   * @copyright  2025 Christian Grévisse <christian.grevisse@uni.lu>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_ajax=_interopRequireDefault(_ajax),_selectors=_interopRequireDefault(_selectors);class AutoTag{constructor(resourceID){this.resourceID=resourceID,this.registerEventListeners(),this.hideErrorMessage()}registerEventListeners(){const tagger=document.querySelector(_selectors.default.ELEMENTS.AUTOTAGBUTTON);tagger&&tagger.addEventListener("click",(async()=>{this.hideErrorMessage(),tagger.setAttribute("disabled","disabled");const oldText=tagger.innerHTML;tagger.innerHTML='<i class="fa fa-spinner fa-spin"></i>';const request={methodname:"local_autotag_tag_resource",args:{resourceid:this.resourceID}};try{const responseObj=await _ajax.default.call([request])[0];if(responseObj.error)this.showErrorMessage(responseObj.error.exception.message);else{const tagField=document.querySelector(_selectors.default.ELEMENTS.TAGFIELD);if(!tagField)return;const enterEvent=new KeyboardEvent("keydown",{code:"Enter",key:"Enter",charKode:13,keyCode:13,view:window});for(const tag of responseObj)tagField.value=tag,tagField.dispatchEvent(enterEvent);const tagSection=document.querySelector(_selectors.default.ELEMENTS.TAGSECTION),tagSectionLink=document.querySelector(_selectors.default.ELEMENTS.TAGSECTIONLINK);tagSection&&!tagSection.classList.contains("show")&&tagSectionLink&&tagSectionLink.click()}}catch(error){this.showErrorMessage(error.message)}finally{tagger.removeAttribute("disabled"),tagger.innerHTML=oldText}}))}showErrorMessage(message){const errorField=document.querySelector(_selectors.default.ELEMENTS.ERRORFIELD);errorField&&(errorField.innerHTML=message,errorField.style.display="block")}hideErrorMessage(){const errorField=document.querySelector(_selectors.default.ELEMENTS.ERRORFIELD);errorField&&(errorField.innerHTML="",errorField.style.display="none")}}_exports.init=resourceID=>{new AutoTag(resourceID)}}));

//# sourceMappingURL=autotag.min.js.map