define("local_tagmap/tagcloud",["exports","core/ajax","../js/d3.v7.min.js","../js/d3.layout.cloud.js","core/modal","core/templates","./utils"],(function(_exports,_ajax,d3,_d3LayoutCloud,_modal,_templates,_utils){function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * AMD module for the TagMap cloud.
   * Based on https://d3-graph-gallery.com/graph/wordcloud_size.html
   *
   * @module     local_tagmap/tagcloud
   * @copyright  2025 Christian Grévisse <christian.grevisse@uni.lu>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_ajax=_interopRequireDefault(_ajax),d3=function(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!=typeof obj&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}newObj.default=obj,cache&&cache.set(obj,newObj);return newObj}(d3),_d3LayoutCloud=_interopRequireDefault(_d3LayoutCloud),_modal=_interopRequireDefault(_modal),_templates=_interopRequireDefault(_templates);class TagCloud{constructor(courseID,data,container,resourceCentric){this.courseID=courseID,this.data=data,this.container=container,this.resourceCentric=resourceCentric,this.initGraph()}initGraph(){const graph=d3.select(this.container),margin_top=10,margin_right=10,margin_bottom=10,margin_left=10,rect=graph.node().getBoundingClientRect(),width=rect.width-margin_left-margin_right,height=rect.height-margin_top-margin_bottom;this.svg=graph.append("svg").attr("width",width+margin_left+margin_right).attr("height",height+margin_top+margin_bottom).append("g").attr("transform","translate("+margin_left+","+margin_top+")"),this.layout=(0,_d3LayoutCloud.default)().size([width,height]).words(Object.entries(this.data.tags).map((_ref=>{let[tag,value]=_ref;return{text:tag,size:this.resourceCentric?value.resources.length:value.questions.length}}))).padding(5).rotate(0).fontSize((d=>10*d.size)).on("end",this.draw.bind(this)),this.layout.start()}draw(words){this.svg.append("g").attr("transform","translate("+this.layout.size()[0]/2+","+this.layout.size()[1]/2+")").selectAll("text").data(words).enter().append("text").style("font-size",(d=>d.size)).style("fill",this.color.bind(this)).attr("text-anchor","middle").style("font-family","Arial").attr("transform",(d=>"translate("+[d.x,d.y]+")rotate("+d.rotate+")")).text((d=>d.text)).on("click",this.handleClick.bind(this)).on("mouseover",(function(){d3.select(this).transition().duration(150).style("fill","orange")})).on("mouseout",(event=>{d3.select(event.currentTarget).transition().duration(150).style("fill",(d=>this.color(d)))}))}async handleClick(event,d){const tag=d.text;await showTagModal(tag,this.data)}color(d){const tag=d.text;if(this.resourceCentric){const ratio=this.data.tags[tag].questions.length/this.data.maxQuestionsPerTag,lowerColor=(0,_utils.hexToRgb)("#777777"),higherColor=(0,_utils.hexToRgb)("#00ff00");return(0,_utils.interpolateColor)(ratio,lowerColor,higherColor)}return this.data.tags[tag].resources.length>0?"#2ca02c":"#d62728"}}async function showTagModal(tag,data){const resources=data.tags[tag].resources,questions=data.tags[tag].questions;await _modal.default.create({title:tag,body:_templates.default.render("local_tagmap/tagmodal",{tag:tag,resources:resources,questions:questions,numResources:resources.length,numQuestions:questions.length}),show:!0,removeOnClose:!0})}_exports.init=async(courseID,resourceTagCloudContainer,questionTagCloudContainer)=>{const data=await async function(courseID){const request={methodname:"local_tagmap_get_graphdata",args:{courseid:courseID}};try{const responseObj=await _ajax.default.call([request])[0];return responseObj.error?(window.console.log(responseObj.error.exception.message),null):responseObj}catch(error){return window.console.log(error.message),null}}(courseID);!function(data){let tags={};data.resources.forEach((resource=>{resource.tags.forEach((tag=>{tags[tag]||(tags[tag]={resources:[],questions:[]}),tags[tag].resources.push(resource)}))})),data.questions.forEach((question=>{question.tags.forEach((tag=>{tags[tag]||(tags[tag]={resources:[],questions:[]}),tags[tag].questions.push(question)}))})),data.tags=tags,data.maxQuestionsPerTag=Math.max(...Object.values(data.tags).map((v=>v.questions.length))),data.maxResourcesPerTag=Math.max(...Object.values(data.tags).map((v=>v.resources.length))),data.resources.forEach((resource=>{resource.tags=resource.tags.map((tag=>({name:tag,used:data.tags[tag].questions.length>0}))).sort(_utils.sortTags);const usedTags=resource.tags.map((tag=>tag.used?1:0)).reduce(((a,b)=>a+b),0);resource.tagUsage=resource.tags.length>0?Math.round(usedTags/resource.tags.length*100):0})),data.questions.forEach((question=>{question.tags=question.tags.map((tag=>({name:tag,covered:data.tags[tag].resources.length>0}))).sort(_utils.sortTags);const coveredTags=question.tags.map((tag=>tag.covered?1:0)).reduce(((a,b)=>a+b),0);question.tagCoverage=question.tags.length>0?Math.round(coveredTags/question.tags.length*100):0}))}(data),new TagCloud(courseID,data,resourceTagCloudContainer,!0),new TagCloud(courseID,data,questionTagCloudContainer,!1),await async function(data){try{const html=await _templates.default.render("local_tagmap/resourceusage",{resources:data.resources});return document.getElementById("resourceUsage").innerHTML=html,!0}catch(error){return document.getElementById("resourceUsage").innerHTML=error.message,!1}}(data),await async function(data){try{const html=await _templates.default.render("local_tagmap/questioncoverage",{questions:data.questions});return document.getElementById("questionCoverage").innerHTML=html,!0}catch(error){return document.getElementById("questionCoverage").innerHTML=error.message,!1}}(data),function(data){document.querySelectorAll(".badge-tag").forEach((badge=>{badge.addEventListener("click",(e=>{showTagModal(e.currentTarget.innerHTML,data)}))}))}(data)}}));

//# sourceMappingURL=tagcloud.min.js.map