# Corolair Moodle Plugin

**Version:** 1.8.11

**Last Updated:** 2025/09/25

## Overview

The Corolair Moodle Plugin enables seamless integration of **AI Tutors** into Moodle courses, enhancing the learning experience for both trainers and learners. This plugin transforms courses into interactive, AI-powered learning assistants tailored to the course content.

### Key Features

- **For Instructional Designers & Trainers:**
  - Easily create and customize AI Tutors directly from Moodle courses.
  - Curate additional resources to enhance AI Tutor responses.
  - Monitor learner interactions and insights, including trending topics and discussion analytics.
  - Manage AI Tutor behavior, update sources, and track usage.
- **For Learners:**
  - Access AI Tutors embedded natively within Moodle courses.
  - Ask course-related questions and receive instant, AI-driven answers.
  - Self-assess understanding using an AI-generated question bank, curated and validated by the trainer.
  - Enjoy a flexible, stop-and-resume chatbot experience for ongoing discussions and auto-evaluation mode.

---

## Installation

1. Install the latest version of the plugin from Moodle Plugins directory
2. Upon installation, a Corolair account with a trial plan will be automatically created for the administrator who installed the plugin.
3. Assign the _Corolair Manager_ role to Trainers to configure access permissions. This role includes the capability to access Corolair from Home or Courses. You can also include the corresponding capability to existing roles. Trial accounts will also be automatically set up for all assigned Trainers.

---

## Access

### For Trainers & Instructional Designers:

- **Via Moodle Homepage:** Navigate to **Plus > Corolair** to access the Creator tools.
- **From Course View:** Select **Plus > Corolair: Create AI Tutor** to initiate the AI Tutor creation process for a specific course.

Once in the Creator platform, trainers can:

- Create, share, and monitor AI Tutors.
- Update sources and adjust behavior.
- Track discussions and gain insights into key learner queries.

---

### For Learners:

- Access Corolair directly as an embedded chatbot within their enrolled courses.
- **Start and Resume Discussions:** Click to interact with AI Tutors anytime, with the ability to pause and return.
- **Switch Modes:** Seamlessly transition from discussion to self-assessment mode.

---

## Roadmap

### Version 2.0: Proactive AI Tutor

- **Mobile Compatibility:** Seamlessly continue the AI Assistant experience on mobile devices.
- **Expanded Learning Capabilities:** Beyond Q&A, the AI Tutor will provide a complete learning experience, enabling learners to explore topics from scratch in new and engaging ways, distinct from the current Moodle course structure.
- **Personalized Learning Paths:** Tailor learning journeys to individual skill levels and performance, ensuring optimal progress for each learner.
- **Microlearning Support:** Break down courses and resources into bite-sized lessons that can be completed in under 5 minutes for greater focus and retention.
- **Multimedia Integration:** Offer lessons in multimedia formats, including videos, audio clips, and interactive visuals, to enhance comprehension and engagement.
- **Voice Search:** Enable learners to interact with the AI Tutor using voice commands for quick and intuitive navigation.

---

## Contributing

We welcome contributions on the Moodle plugin! Do not hesitate to submit feature requests, bug fixes, or enhancements on [Corolair Plugin Github Repository](https://github.com/corolair/moodle-local_corolair).

---

## Support

For support, please contact our team at contact@corolair.com.

---

_Copyright © 2024 Corolair. All rights reserved._
