define("tiny_cursive/analytic_events",["exports","./analytic_modal","core/ajax","jquery","core/str","core/chartjs"],(function(_exports,_analytic_modal,_ajax,_jquery,_str,_chartjs){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Module for handling analytics events in the Tiny Cursive plugin.
   * Provides functionality for displaying analytics data, replaying writing,
   * checking differences and showing quality metrics.
   *
   * @module     tiny_cursive/analytic_events
   * @copyright  2024 CTI <info@cursivetechnology.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_analytic_modal=_interopRequireDefault(_analytic_modal),_jquery=_interopRequireDefault(_jquery),_chartjs=_interopRequireDefault(_chartjs);return _exports.default=class{createModal(userid,context){let questionid=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"",authIcon=arguments.length>3?arguments[3]:void 0;(0,_jquery.default)("#analytics"+userid+questionid).on("click",(function(e){e.preventDefault(),_analytic_modal.default.create({templateContext:context}).then((modal=>((0,_jquery.default)("#content"+userid+" .tiny_cursive_table  tbody tr:first-child td:nth-child(2)").html(authIcon),modal.show(),!0))).catch((error=>{window.console.error("Failed to create modal:",error)}))}))}analytics(userid,templates,context){let questionid=arguments.length>3&&void 0!==arguments[3]?arguments[3]:"",replayInstances=arguments.length>4&&void 0!==arguments[4]?arguments[4]:null,authIcon=arguments.length>5?arguments[5]:void 0;(0,_jquery.default)("body").on("click","#analytic"+userid+questionid,(function(e){(0,_jquery.default)("#rep"+userid+questionid).prop("disabled",!1),(0,_jquery.default)("#quality"+userid+questionid).prop("disabled",!1),e.preventDefault(),(0,_jquery.default)("#content"+userid).html((0,_jquery.default)("<div>").addClass("d-flex justify-content-center my-5").append((0,_jquery.default)("<div>").addClass("tiny_cursive-loader"))),replayInstances&&replayInstances[userid]&&replayInstances[userid].stopReplay(),(0,_jquery.default)(".tiny_cursive-nav-tab").find(".active").removeClass("active"),(0,_jquery.default)(this).addClass("active"),templates.render("tiny_cursive/analytics_table",context).then((function(html){return(0,_jquery.default)("#content"+userid).html(html),(0,_jquery.default)("#content"+userid+" .tiny_cursive_table  tbody tr:first-child td:nth-child(2)").html(authIcon),!0})).fail((function(error){window.console.error("Failed to render template:",error)}))}))}checkDiff(userid,fileid){let questionid=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"",replayInstances=arguments.length>3&&void 0!==arguments[3]?arguments[3]:null;const nodata=document.createElement("p");nodata.classList.add("tiny_cursive_nopayload","bg-light"),(0,_str.get_string)("nopaylod","tiny_cursive").then((str=>(nodata.textContent=str,!0))).catch((error=>window.console.log(error))),(0,_jquery.default)("body").on("click","#diff"+userid+questionid,(function(e){if((0,_jquery.default)("#rep"+userid+questionid).prop("disabled",!1),(0,_jquery.default)("#quality"+userid+questionid).prop("disabled",!1),e.preventDefault(),(0,_jquery.default)("#content"+userid).html((0,_jquery.default)("<div>").addClass("d-flex justify-content-center my-5").append((0,_jquery.default)("<div>").addClass("tiny_cursive-loader"))),(0,_jquery.default)(".tiny_cursive-nav-tab").find(".active").removeClass("active"),(0,_jquery.default)(this).addClass("active"),replayInstances&&replayInstances[userid]&&replayInstances[userid].stopReplay(),!fileid)throw(0,_jquery.default)("#content"+userid).html(nodata),new Error("Missing file id or Difference Content not received yet");(0,_ajax.call)([{methodname:"cursive_get_writing_differences",args:{fileid:fileid}}])[0].done((response=>{let responsedata=JSON.parse(response.data);if(responsedata){let submittedText=atob(responsedata.submitted_text);(0,_str.get_strings)([{key:"original_text",component:"tiny_cursive"},{key:"editspastesai",component:"tiny_cursive"}]).done((strings=>{const originalTextString=strings[0],editsPastesAIString=strings[1],commentBox=(0,_jquery.default)('<div class="p-2 border rounded mb-2">');var pasteCountDiv=(0,_jquery.default)("<div></div>");(0,_str.get_string)("pastecount","tiny_cursive").then((str=>(pasteCountDiv.append("<div><strong>"+str+" :</strong> "+responsedata.commentscount+"</div>"),!0))).catch((error=>window.console.log(error)));var commentsDiv=(0,_jquery.default)('<div class="border-bottom"></div>');(0,_str.get_string)("comments","tiny_cursive").then((str=>(commentsDiv.append("<strong>"+str+"</strong>"),!0))).catch((error=>window.console.error(error)));var commentsList=(0,_jquery.default)("<div></div>");let comments=responsedata.comments;for(let index in comments){var commentDiv=(0,_jquery.default)('<div class="shadow-sm p-1 my-1"></div>').text(comments[index].usercomment);commentsList.append(commentDiv)}commentBox.append(pasteCountDiv).append(commentsDiv).append(commentsList);const $legend=(0,_jquery.default)('<div class="d-flex p-2 border rounded mb-2">'),$attributedItem=(0,_jquery.default)("<div>",{class:"tiny_cursive-legend-item"}),$attributedBox=(0,_jquery.default)("<div>",{class:"tiny_cursive-box attributed"}),$attributedText=(0,_jquery.default)("<span>").text(originalTextString);$attributedItem.append($attributedBox).append($attributedText);const $unattributedItem=(0,_jquery.default)("<div>",{class:"tiny_cursive-legend-item"}),$unattributedBox=(0,_jquery.default)("<div>",{class:"tiny_cursive-box tiny_cursive_added"}),$unattributedText=(0,_jquery.default)("<span>").text(editsPastesAIString);$unattributedItem.append($unattributedBox).append($unattributedText),$legend.append($attributedItem).append($unattributedItem);let contents=(0,_jquery.default)("<div>").addClass("tiny_cursive-comparison-content"),textBlock2=(0,_jquery.default)("<div>").addClass("tiny_cursive-text-block").append((0,_jquery.default)("<div>").attr("id","tiny_cursive-reconstructed_text").html(JSON.parse(submittedText)));contents.append(commentBox,$legend,textBlock2),(0,_jquery.default)("#content"+userid).html(contents)})).fail((error=>{window.console.error("Failed to load language strings:",error),(0,_jquery.default)("#content"+userid).html(nodata)}))}else(0,_jquery.default)("#content"+userid).html(nodata)})).fail((error=>{throw(0,_jquery.default)("#content"+userid).html(nodata),new Error("Error loading JSON file: "+error.message)}))}))}replyWriting(userid,filepath){let questionid=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"",replayInstances=arguments.length>3&&void 0!==arguments[3]?arguments[3]:null;(0,_jquery.default)("body").on("click","#rep"+userid+questionid,(function(e){(0,_jquery.default)(this).prop("disabled",!0),(0,_jquery.default)("#quality"+userid+questionid).prop("disabled",!1),e.preventDefault(),(0,_jquery.default)("#content"+userid).html((0,_jquery.default)("<div>").addClass("d-flex justify-content-center my-5").append((0,_jquery.default)("<div>").addClass("tiny_cursive-loader"))),(0,_jquery.default)(".tiny_cursive-nav-tab").find(".active").removeClass("active"),(0,_jquery.default)(this).addClass("active"),replayInstances&&replayInstances[userid]&&replayInstances[userid].stopReplay(),questionid?video_playback(userid,filepath,questionid):video_playback(userid,filepath)}))}quality(userid,templates,context){let questionid=arguments.length>3&&void 0!==arguments[3]?arguments[3]:"",replayInstances=arguments.length>4&&void 0!==arguments[4]?arguments[4]:null,cmid=arguments.length>5?arguments[5]:void 0,metricsData="";const nodata=document.createElement("p");nodata.classList.add("text-center","p-5","bg-light","rounded","m-5","text-primary"),nodata.style.verticalAlign="middle",nodata.style.textTransform="uppercase",nodata.style.fontWeight="500",(0,_str.get_string)("nopaylod","tiny_cursive").then((str=>(nodata.textContent=str,!0))).catch((error=>window.console.error(error))),(0,_jquery.default)("body").on("click","#quality"+userid+questionid,(function(e){var _context$tabledata$fi;(0,_jquery.default)(this).prop("disabled",!0),(0,_jquery.default)("#rep"+userid+questionid).prop("disabled",!1),e.preventDefault(),(0,_jquery.default)(".tiny_cursive-nav-tab").find(".active").removeClass("active"),(0,_jquery.default)(this).addClass("active");let res=(0,_ajax.call)([{methodname:"cursive_get_quality_metrics",args:{file_id:null!==(_context$tabledata$fi=context.tabledata.file_id)&&void 0!==_context$tabledata$fi?_context$tabledata$fi:userid,cmid:cmid}}]);const content=document.getElementById("content"+userid);if(content){content.innerHTML="";const loaderDiv=document.createElement("div");loaderDiv.className="d-flex justify-content-center my-5";const loader=document.createElement("div");loader.className="tiny_cursive-loader",loaderDiv.appendChild(loader),content.appendChild(loaderDiv)}replayInstances&&replayInstances[userid]&&replayInstances[userid].stopReplay(),templates.render("tiny_cursive/quality_chart",context).then((function(html){const content=document.getElementById("content"+userid);return res[0].done((response=>{if(response.status){if(metricsData=response.data,metricsData.quality_access){content&&(content.innerHTML=html),metricsData||(0,_jquery.default)("#content"+userid).html(nodata);var originalData=[metricsData.word_len_mean,metricsData.edits,metricsData.p_burst_mean,metricsData.q_count,metricsData.sentence_count,metricsData.verbosity,metricsData.word_count,metricsData.sent_word_count_mean];Promise.all([(0,_str.get_string)("word_len_mean","tiny_cursive"),(0,_str.get_string)("edits","tiny_cursive"),(0,_str.get_string)("p_burst_mean","tiny_cursive"),(0,_str.get_string)("q_count","tiny_cursive"),(0,_str.get_string)("sentence_count","tiny_cursive"),(0,_str.get_string)("verbosity","tiny_cursive"),(0,_str.get_string)("word_count","tiny_cursive"),(0,_str.get_string)("sent_word_count_mean","tiny_cursive"),(0,_str.get_string)("average","tiny_cursive")]).then((_ref=>{let[wordLength,edits,pBurstMean,qCount,sentenceCount,verbosity,wordCount,sentWordCountMean,average]=_ref,chartvas=document.querySelector("#chart"+userid);const data={labels:[[wordLength,edits,pBurstMean,qCount,sentenceCount,verbosity,wordCount,sentWordCountMean]],datasets:[{data:originalData.map((d=>d>100?100:d<-100?-100:d)),backgroundColor:function(context){const value=context.raw;return value>0&&value<100?"#43BB97":value<0?"#AAAAAA":"#00432F"},barPercentage:.75}]},drawPercentage={id:"drawPercentage",afterDraw:chart=>{const{ctx:ctx,data:data}=chart;let value;ctx.save(),chart.getDatasetMeta(0).data.forEach(((dataPoint,index)=>{value=parseInt(data.datasets[0].data[index]),value||(value=0),value=originalData[index],ctx.font="bold 14px sans-serif",value>50&&value<=100?(ctx.fillStyle="white",ctx.textAlign="right",ctx.fillText(value+"%",dataPoint.x-5,dataPoint.y+5)):value<=10&&value>0?(ctx.fillStyle="#43bb97",ctx.textAlign="left",value>=1?ctx.fillText("0"+value+"%",dataPoint.x+5,dataPoint.y+5):ctx.fillText(value+"%",dataPoint.x+5,dataPoint.y+5)):0==value||null==value||(value>100?(ctx.fillStyle="white",ctx.textAlign="right",ctx.fillText(value+"%",dataPoint.x-5,dataPoint.y+5)):value<-50&&value>=-100||value<-100?(ctx.fillStyle="white",ctx.textAlign="left",ctx.fillText(value+"%",dataPoint.x+5,dataPoint.y+5)):value>-50&&value<0?(ctx.fillStyle="grey",ctx.textAlign="right",ctx.fillText(value+"%",dataPoint.x-5,dataPoint.y+5)):(ctx.fillStyle="#43bb97",ctx.textAlign="left",ctx.fillText(value+"%",dataPoint.x+5,dataPoint.y+5)))}))}};return new _chartjs.default(chartvas,{type:"bar",data:data,options:{responsive:!1,maintainAspectRatio:!1,indexAxis:"y",elements:{bar:{borderRadius:16,borderWidth:0,zIndex:1}},scales:{x:{beginAtZero:!0,min:-100,max:100,ticks:{callback:function(value){return-100===value||100===value?value+"%":0===value?average:""},display:!0,font:function(context){return context&&context.tick&&0===context.tick.value?{weight:"bold",size:14,color:"black"}:{weight:"bold",size:13,color:"black"}},color:"black"},grid:{display:!0,color:function(context){return 0===context.tick.value?"black":"#eaeaea"},tickLength:0},position:"top"},y:{beginAtZero:!0,ticks:{display:!0,align:"center",crossAlign:"far",font:{size:18},tickLength:100,color:"black"},grid:{display:!0,tickLength:1e3}}},plugins:{legend:{display:!1},title:{display:!1},tooltip:{yAlign:"bottom",xAlign:"center",callbacks:{label:function(context){return originalData[context.dataIndex]}}}}},plugins:[{id:"chartAreaBg",beforeDraw:chart=>{const{ctx:ctx,scales:{x:x,y:y}}=chart;ctx.save();const segmentPixel=y.getPixelForValue(y.ticks[0].value)-y.getPixelForValue(y.ticks[1].value),doubleSegment=y.ticks[2].value-y.ticks[0].value;let tickArray=[];for(let i=0;i<=y.max;i+=doubleSegment)i!==y.max&&tickArray.push(i);tickArray.forEach((tick=>{ctx.fillStyle="rgba(0, 0, 0, 0.02)",ctx.fillRect(0,y.getPixelForValue(tick)+80,x.width+x.width+21,segmentPixel)}))}},drawPercentage]})})).catch((error=>{window.console.log(error)}))}else templates.render("tiny_cursive/upgrade_to_pro",[]).then((function(html){return(0,_jquery.default)("#content"+userid).html(html),!0})).fail((function(error){window.console.error(error)}))}})).fail((error=>{throw(0,_jquery.default)("#content"+userid).html(nodata),new Error("Error: no data received yet",error)})),!0})).catch((function(error){window.console.error("Failed to render template:",error)})),document.querySelectorAll(".tiny_cursive-nav-tab .active").forEach((el=>el.classList.remove("active"))),e.target.classList.add("active")}))}formatedTime(data){if(data.total_time_seconds){let totalTimeSeconds=data.total_time_seconds,hours=Math.floor(totalTimeSeconds/3600).toString().padStart(2,0),minutes=Math.floor(totalTimeSeconds%3600/60).toString().padStart(2,0),seconds=(totalTimeSeconds%60).toString().padStart(2,0);return"".concat(hours,"h ").concat(minutes,"m ").concat(seconds,"s")}return"0h 0m 0s"}authorshipStatus(firstFile,score,scoreSetting){var icon="fa fa-circle-o",color="font-size:32px;color:black";return score=parseFloat(score),firstFile?(icon="fa fa-solid fa-info-circle",color="font-size:32px;color:#000000"):score>=scoreSetting?(icon="fa fa-check-circle",color="font-size:32px;color:green"):score<scoreSetting&&(icon="fa fa-question-circle",color="font-size:32px;color:#A9A9A9"),(0,_jquery.default)("<i>").addClass(icon).attr("style",color)}},_exports.default}));

//# sourceMappingURL=analytic_events.min.js.map