/**
 * Provides the block_todo/control module
 *
 * @category   output
 * @copyright  2018 David Mudrák <david@moodle.com>
 * @author     2023 David Woloszyn <david.woloszyn@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("block_todo/control",["jquery","core/log","core/ajax","core/templates","core/str","core/modal_factory","core/modal_events"],(function($,Log,Ajax,Templates,Str,ModalFactory,ModalEvents){let instanceid=null;function init(id){var region=$('[data-region="block_todo-instance-'+id+'"]').first();region.length?(instanceid=id,new TodoControl(region).main()):Log.error("block_todo/control: wrapping region not found!")}function TodoControl(region){this.region=region}TodoControl.prototype.main=function(){this.main=this.region.find('[data-control="main"]'),this.itemsList=this.region.find(".list-wrapper"),this.currentHideDone=this.region.find("[data-hidedone]"),this.currentGroup=this.region.find("[data-currentgroup]"),this.hideDoneButton=this.region.find('[data-control="hidedone"]'),this.groupButtons=this.region.find('[data-control="hidedone"]'),this.initFeatures()},TodoControl.prototype.initFeatures=function(){var self=this;self.main.off(),self.itemsList.off(),self.main.on("click",'[data-control="additem"]',(function(e){self.addItem(e)})),self.itemsList.on("click",'[data-control="toggle"]',(function(e){var id=$(e.currentTarget).closest("[data-item]").attr("data-item");self.toggleItem(id)})),self.itemsList.on("click",'[data-control="delete"]',(function(e){var id=$(e.currentTarget).closest("[data-item]").attr("data-item"),text=$(e.currentTarget).closest("[data-item]").attr("data-text");self.deleteItem(e,id,text)})),self.itemsList.on("click",'[data-control="edit"]',(function(e){var id=$(e.currentTarget).closest("[data-item]").attr("data-item"),text=$(e.currentTarget).closest("[data-item]").attr("data-text"),duedate=$(e.currentTarget).closest("[data-item]").attr("data-duedate"),groupid=$(e.currentTarget).closest("[data-item]").attr("data-groupid");self.editItem(e,id,text,duedate,groupid)})),self.itemsList.on("click",'[data-control="pin"]',(function(e){var id=$(e.currentTarget).closest("[data-item]").attr("data-item");self.pinItem(id)})),self.main.on("click",'[data-control="hidedone"]',(function(){var currentlyHidden=getHiddenState(self);void 0!==currentlyHidden&&self.hideDoneItems(currentlyHidden)})),self.main.on("click",'[data-control="group"]',(function(e){var groupid=$(e.currentTarget).find("[data-groupid]").attr("data-groupid");self.groupItems(groupid)})),self.itemsList.on("click",'[data-control="deletedone"]',(function(e){self.deleteCompleted(e)}))};const getHiddenState=self=>Boolean(parseInt(self.currentHideDone.attr("data-hidedone"))),getCurrentGroup=self=>parseInt(self.currentGroup.attr("data-currentgroup"));TodoControl.prototype.addItem=async function(e){var self=this,trigger=$(e.currentTarget);const args={groups:await getGroupList()};return ModalFactory.create({type:ModalFactory.types.SAVE_CANCEL,title:Str.getString("additem","block_todo"),body:Templates.render("block_todo/add",args)},trigger).done((function(modal){modal.getRoot().on(ModalEvents.save,(function(e){var modalBody=modal.getBody(),text=$.trim(modalBody.find(".block_todo_add_text").val()),duedate=dateToTimestamp(modalBody.find(".block_todo_add_duedate").val()),groupid=parseInt(modalBody.find('input[name="block_todo_group"]:checked').val())||0;return text?Ajax.call([{methodname:"block_todo_add_item",args:{instanceid:instanceid,todotext:text,duedate:duedate,groupid:groupid,includehidden:!getHiddenState(self),currentgroup:getCurrentGroup(self)}}])[0].fail((function(reason){return Log.error("block_todo/control: unable to add the item"),Log.debug(reason),$.Deferred().reject()})).then((function(response){return self.itemsList.replaceWith(response),init(instanceid),$.Deferred().resolve()})):(modalBody.find(".block_todo_add_text").focus(),e.preventDefault(),!1)})),modal.getRoot().on(ModalEvents.hidden,(function(){modal.destroy()})),modal.show()})),$.Deferred().resolve()},TodoControl.prototype.toggleItem=function(id){var self=this;return id?Ajax.call([{methodname:"block_todo_toggle_item",args:{instanceid:instanceid,id:id,hide:getHiddenState(self),includehidden:!getHiddenState(self),currentgroup:getCurrentGroup(self)}}])[0].fail((function(reason){return Log.error("block_todo/control: unable to toggle the item"),Log.debug(reason),$.Deferred().reject()})).then((function(response){return self.itemsList.replaceWith(response),init(instanceid),$.Deferred().resolve()})):(Log.error("block_todo/control: no id provided"),$.Deferred().resolve())},TodoControl.prototype.editItem=async function(e,id,text,duedate,groupid){var self=this,trigger=$(e.currentTarget);if(!id)return Log.error("block_todo/control: no id provided"),$.Deferred().resolve();var groups=await getGroupList(groupid);const args={id:id,text:text,duedate:null,groups:groups,includehidden:!getHiddenState(self),currentgroup:getCurrentGroup(self)};return duedate&&(args.duedate=function(timestamp){const date=new Date(1e3*timestamp);return[date.getFullYear(),("0"+(date.getMonth()+1)).slice(-2),("0"+date.getDate()).slice(-2)].join("-")}(duedate)),ModalFactory.create({type:ModalFactory.types.SAVE_CANCEL,title:Str.getString("edititem","block_todo"),body:Templates.render("block_todo/edit",args)},trigger).done((function(modal){modal.getRoot().on(ModalEvents.save,(function(e){var modalBody=modal.getBody(),newText=$.trim(modalBody.find(".block_todo_edit_text").val()),newDuedate=dateToTimestamp(modalBody.find(".block_todo_edit_duedate").val()),newGroupId=parseInt(modalBody.find('input[name="block_todo_group"]:checked').val())||0;return newText?Ajax.call([{methodname:"block_todo_edit_item",args:{instanceid:instanceid,id:id,todotext:newText,duedate:newDuedate,groupid:newGroupId,includehidden:!getHiddenState(self),currentgroup:getCurrentGroup(self)}}])[0].fail((function(reason){return Log.error("block_todo/control: unable to edit the item"),Log.debug(reason),$.Deferred().reject()})).then((function(response){return self.itemsList.replaceWith(response),init(instanceid),$.Deferred().resolve()})):(modalBody.find(".block_todo_edit_text").focus(),e.preventDefault(),!1)})),modal.getRoot().on(ModalEvents.hidden,(function(){modal.destroy()})),modal.show()})),$.Deferred().resolve()},TodoControl.prototype.deleteItem=function(e,id,text){var self=this,trigger=$(e.currentTarget);return id?(ModalFactory.create({type:ModalFactory.types.SAVE_CANCEL,title:Str.getString("deleteitem","block_todo"),body:Str.getString("confirmdeletesingle","block_todo",text)},trigger).done((function(modal){modal.setSaveButtonText("Confirm"),modal.getRoot().on(ModalEvents.save,(function(){return Ajax.call([{methodname:"block_todo_delete_item",args:{instanceid:instanceid,id:id,includehidden:!getHiddenState(self),currentgroup:getCurrentGroup(self)}}])[0].fail((function(reason){return Log.error("block_todo/control: unable to delete the item"),Log.debug(reason),$.Deferred().reject()})).then((function(response){return self.itemsList.replaceWith(response),init(instanceid),$.Deferred().resolve()}))})),modal.getRoot().on(ModalEvents.hidden,(function(){modal.destroy()})),modal.show()})),$.Deferred().resolve()):(Log.error("block_todo/control: no id provided"),$.Deferred().resolve())},TodoControl.prototype.deleteCompleted=function(e){var self=this,trigger=$(e.currentTarget);return ModalFactory.create({type:ModalFactory.types.SAVE_CANCEL,title:Str.getString("deletecompleted","block_todo"),body:Str.getString("confirmdeletecompleted","block_todo")},trigger).done((function(modal){modal.setSaveButtonText("Confirm"),modal.getRoot().on(ModalEvents.save,(function(){return Ajax.call([{methodname:"block_todo_delete_completed",args:{instanceid:instanceid,includehidden:!getHiddenState(self),currentgroup:getCurrentGroup(self)}}])[0].fail((function(reason){return Log.error("block_todo/control: unable to delete completed items"),Log.debug(reason),$.Deferred().reject()})).then((function(response){return self.itemsList.replaceWith(response),init(instanceid),$.Deferred().resolve()}))})),modal.getRoot().on(ModalEvents.hidden,(function(){modal.destroy()})),modal.show()})),$.Deferred().resolve()},TodoControl.prototype.pinItem=function(id){var self=this;return id?Ajax.call([{methodname:"block_todo_pin_item",args:{instanceid:instanceid,id:id,includehidden:!getHiddenState(self),currentgroup:getCurrentGroup(self)}}])[0].fail((function(reason){return Log.error("block_todo/control: unable to pin the item"),Log.debug(reason),$.Deferred().reject()})).then((function(response){return self.itemsList.replaceWith(response),init(instanceid),$.Deferred().resolve()})):(Log.error("block_todo/control: no id provided"),$.Deferred().resolve())},TodoControl.prototype.hideDoneItems=function(hide){var self=this;return hide=!hide,Ajax.call([{methodname:"block_todo_hide_done_items",args:{instanceid:instanceid,hide:hide,includehidden:!1,currentgroup:getCurrentGroup(self)}}])[0].fail((function(reason){return Log.error("block_todo/control: unable to hide/show the items"),Log.debug(reason),$.Deferred().reject()})).then((function(response){return self.itemsList.replaceWith(response),getHiddenState(self)?(self.hideDoneButton.find("i").addClass("fa-eye-slash"),self.hideDoneButton.find("i").removeClass("fa-eye")):(self.hideDoneButton.find("i").addClass("fa-eye"),self.hideDoneButton.find("i").removeClass("fa-eye-slash")),init(instanceid),$.Deferred().resolve()}))},TodoControl.prototype.groupItems=function(groupid){var self=this;return Ajax.call([{methodname:"block_todo_group_items",args:{instanceid:instanceid,groupid:groupid,includehidden:!getHiddenState(self)}}])[0].fail((function(reason){return Log.error("block_todo/control: unable to group the items"),Log.debug(reason),$.Deferred().reject()})).then((function(response){return self.itemsList.replaceWith(response),init(instanceid),$.Deferred().resolve()}))};const getGroupList=async function(){let selected=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null;return[{groupid:0,groupname:await Str.getString("labelgroup0","block_todo"),groupicon:"",selected:0==selected},{groupid:1,groupname:await Str.getString("labelgroup1","block_todo"),groupicon:"fa-star",selected:1==selected},{groupid:2,groupname:await Str.getString("labelgroup2","block_todo"),groupicon:"fa-star",selected:2==selected},{groupid:3,groupname:await Str.getString("labelgroup3","block_todo"),groupicon:"fa-star",selected:3==selected},{groupid:4,groupname:await Str.getString("labelgroup4","block_todo"),groupicon:"fa-star",selected:4==selected},{groupid:5,groupname:await Str.getString("labelgroup5","block_todo"),groupicon:"fa-star",selected:5==selected}]};function dateToTimestamp(date){return Date.parse(date)/1e3}return{init:init}}));

//# sourceMappingURL=control.min.js.map