# Ludilearn Course Format

## Plugin Overview
Ludilearn is an innovative course format for Moodle that aims to improve learner success through adaptive gamification. This plugin is part of the LudiMoodle+ project, winner of the "Support for the deployment of e-FRAN projects" call for projects launched by the French National Research Agency as part of France 2030.

## Plugin Objectives
The main objective of this plugin is to improve learning performance and academic success through the development of game-based resources adapted to students. It aims to create a more engaging and motivating learning environment by integrating game elements into the Moodle course structure.

## Features Added to Moodle
- Adaptive gamification based on the learner's profile
- 6 game elements that are used according to the learner's profile or the teacher's settings
- Customizable avatars for learners
- Various game elements (badges, progression, timer, score, avatar, ranking)
- Questionnaire with an algorithm to identify the appropriate game profile for each learner
- Report on learner progression and engagement

## Configuration and Settings
The plugin offers several configuration options:
- Choice of game element assignment mode: default, manual, automatic with the algorithm to allow adapted gamification
- Setting of game elements for each course section when setting up the course with the manual option
- Customization of certain game elements

## Installation
1. Download the plugin ZIP file from the Moodle plugin page.
2. Log in to your Moodle site as an administrator and go to Site administration > Plugins > Install plugins.
3. Upload the plugin ZIP file.
4. Follow the on-screen installation instructions.

Alternatively, you can install the plugin manually by extracting the contents of the ZIP file into the folder:
`{your/moodle/dirroot}/course/format/ludilearn`
Then, go to Site administration > Notifications to complete the installation.

## Compatibility
This plugin is compatible with Moodle 4.1 and later versions. It is regularly tested and updated to ensure compatibility with the latest versions of Moodle.

## Maintenance Responsibility
The Ludilearn plugin is developed and maintained by the Pimenko team. Regular updates are made to ensure compatibility with new versions of Moodle and to add new features.

## Technical contact
For any questions or suggestions regarding this plugin, you can contact:
- Pimenko: support@pimenko.com
- Website: https://pimenko.com
- GitHub: https://github.com/DigiDago/moodle-format_ludilearn

## Contribution
Contributions to this project are welcome. If you wish to contribute, please follow Moodle development best practices and submit your pull requests on the project's GitHub repository.

## Information
Ludilearn is an innovative course format for Moodle that aims to improve learner success through adaptive gamification. This plugin is part of the LudiMoodle+ project, winner of the "Support for the deployment of e-FRAN projects" call for projects launched by the French National Research Agency as part of France 2030.

The LudiMoodle+ project, led by the University of Lyon, benefits from state aid managed by the French National Research Agency under France 2030 with the reference "ANR-22-FRAN-0005".

## License
This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.


Adaptation algorithm and scientific expertise
===================

LudiLearn integrates an adaptation algorithm developed by the SICAL team of the LIRIS laboratory. This algorithm is based on data collected during experiments carried out with middle-school students from the educational institution of Lyon (France). The laboratory also contributed its expertise to the design of the game elements.

**Scientific contact**: Pr. Élise Lavoué (elise.lavoue@univ-lyon3.fr)
**Publications available at the LudiMoodle+ project website**: [https://ludimoodle.universite-lyon.fr](https://ludimoodle.universite-lyon.fr)


About Pimenko
===================
Pimenko is a leading company and official Moodle Partner specialising in the development and creation of e-learning solutions. With a team of experienced developers and e-learning experts, we are committed to creating innovative, high-quality plugins that enhance the Moodle experience for educators and learners.

### Our Expertise

- Custom Moodle development
- Moodle plugin creation and maintenance
- E-learning platform optimization
- Moodle theme development
- Learning analytics solutions
- Course creation (elearning, LMS and MOOC)
- Video production

### Connect with Us

- **Website**: [https://www.pimenko.com](https://www.pimenko.com)
- **Email**: contact@pimenko.com
- **GitHub**: [https://github.com/DigiDago](https://github.com/DigiDago)
- **LinkedIn**: [Pimenko LinkedIn Profile](https://www.linkedin.com/company/pimenko/)

We are passionate about improving e-learning experiences through technology. If you have any questions about our services or need custom Moodle solutions, don't hesitate to reach out!

@copyright Pimenko https://www.pimenko.com