define("format_ludilearn/local/score/section",["exports","core/reactive","core/str"],function(_exports,_reactive,_str){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;
/**
   * Score section component.
   *
   * @module     format_ludilearn/local/score/section
   * @copyright  2025 Pimenko <contact@pimenko.com>
   * @author     Jordan Kesraoui
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
class _default extends _reactive.BaseComponent{create(descriptor){this.sectionid=descriptor.data.sectionid,this.cms=descriptor.data.cms,this.selectors={SCORE:"[data-for='ludilearn-section-score']",MAXSCORE:"[data-for='ludilearn-section-maxscore']",SUMMARY:"[data-for='ludilearn-section-summary']",CM:"[data-for='ludilearn-section-cm']",CM_LABELTEXT:"[data-for='ludilearn-section-cm-labeltext']",CM_BONUSCOMPLETION:"[data-for='ludilearn-section-cm-bonuscompletion']",CM_BLOCK_BONUSCOMPLETION:".bonuscompletion",CM_NAME:"[data-for='ludilearn-section-cm-name']",CM_SCORE:"[data-for='ludilearn-section-cm-score']",CM_MAXSCORE:"[data-for='ludilearn-section-cm-maxscore']"}}static init(target,reactive,data){return new this({element:document.getElementById(target),reactive:reactive,data:data})}stateReady(){this.reactive.dispatch("syncSectionAuto",this.sectionid)}getWatchers(){return[{watch:"currentsection.score:updated",handler:this._refreshScore},{watch:"currentsection.maxscore:updated",handler:this._refreshMaxScore},{watch:"currentsection.summary:updated",handler:this._refreshSummary},{watch:"cms.labeltext:updated",handler:this._refreshCMLabelText},{watch:"cms.bonuscompletion:updated",handler:this._refreshCMBonusCompletion},{watch:"cms.score:updated",handler:this._refreshCMSCore},{watch:"cms.maxscore:updated",handler:this._refreshCMMaxSCore},{watch:"cms.name:updated",handler:this._refreshCMName}]}_refreshScore(_ref){let{element:element}=_ref;const target=this.getElement(this.selectors.SCORE);target&&(target.innerHTML=element.score)}_refreshMaxScore(_ref2){let{element:element}=_ref2;const target=this.getElement(this.selectors.MAXSCORE);target&&(target.innerHTML=element.maxscore)}_refreshSummary(_ref3){let{element:element}=_ref3;const target=this.getElement(this.selectors.SUMMARY);target&&(target.innerHTML=element.summary)}_refreshCMLabelText(_ref4){let{element:element}=_ref4;const target=this.getElement(this.selectors.CM_LABELTEXT,element.id);target&&(target.innerHTML=element.labeltext)}_refreshCMBonusCompletion(_ref5){let{element:element}=_ref5;if(!element.gamified)return;const target=this.getElement(this.selectors.CM_BONUSCOMPLETION,element.id);if(!target&&element.bonuscompletion>0)this._createCMBonusCompletion({element:element});else{if(0===element.bonuscompletion){const targetcm=this.getElement(this.selectors.CM_BLOCK_BONUSCOMPLETION);if(!targetcm)return;return void targetcm.remove()}target&&(target.innerHTML="+ ".concat(element.bonuscompletion))}}_createCMBonusCompletion(_ref6){let{element:element}=_ref6;if(!element.gamified)return;const target=this.getElement(this.selectors.CM,element.id);if(!target)return;const bonuscompletiondiv=document.createElement("div");bonuscompletiondiv.className="bonuscompletion";const bonuscompletionvalue=document.createElement("span");bonuscompletionvalue.className="bonuscompletion-value",bonuscompletionvalue.setAttribute("data-for",this.selectors.CM_BONUSCOMPLETION),bonuscompletionvalue.setAttribute("data-id",element.id),bonuscompletionvalue.innerHTML="+ ".concat(element.bonuscompletion);const bonuscompletionstr=document.createElement("span");bonuscompletionstr.className="bonuscompletion-str",(0,_str.getString)("settings:bonuscompletion","format_ludilearn").then(str=>{bonuscompletionstr.innerHTML=str}),bonuscompletiondiv.appendChild(bonuscompletionvalue),bonuscompletiondiv.appendChild(bonuscompletionstr),target.querySelector(".ludilearn-img-bag").after(bonuscompletiondiv)}_refreshCMSCore(_ref7){let{element:element}=_ref7;if(!element.gamified)return;const target=this.getElement(this.selectors.CM_SCORE,element.id);target&&(target.innerHTML=element.score)}_refreshCMMaxSCore(_ref8){let{element:element}=_ref8;if(!element.gamified)return;const target=this.getElement(this.selectors.CM_MAXSCORE,element.id);target&&(target.innerHTML=element.maxscore)}_refreshCMName(_ref9){let{element:element}=_ref9;if(!element.gamified)return;const target=this.getElement(this.selectors.CM_NAME,element.id);target&&(target.innerHTML=element.name)}}return _exports.default=_default,_exports.default});

//# sourceMappingURL=section.min.js.map