# moodle-format_softcourse

## Plugin Overview

Softcourse is an innovative course format plugin for Moodle that enhances the visual presentation and organization of course content. It displays sections with images and optional text on the course homepage, providing a more engaging and intuitive navigation experience for learners.

## Plugin Objectives

The main objectives of the Softcourse format are:

1. Enhance Visual Appeal: Present course sections with images and text for a more attractive course layout.
2. Improve Navigation: Offer an intuitive way for students to navigate through course content.
3. Increase Engagement: Create a more interactive and engaging course homepage to motivate learners.
4. Customize Course Presentation: Provide teachers with options to tailor the course appearance to their needs.
5. Simplify Course Structure: Organize course content in a clear, visually-oriented manner.

## Features

- Display course sections as image cards with optional text
- Customizable section images
- Option to hide all sections or only section zero
- Customizable course introduction
- Compatible with Moodle's course index for easy navigation
- Progression tracking for each section
- "Start" button for quick access to section content
- Activity count display for each section
- Responsive design, compatible with various themes including Boost

## Requirements

- Moodle 3.5 or later (check version.php for specific version requirements)
- PHP 7.0 or later

## Installation

1. Download the plugin from GitHub or the Moodle plugins directory.
2. Extract the contents to /course/format/softcourse in your Moodle installation.
3. Log in as an administrator and visit the notifications page to complete the installation.
4. Go to Site administration > Plugins > Course formats > Manage course formats and ensure that "Soft Course format" is enabled.

## Usage

1. Create a new course or edit an existing one.
2. In the course settings, select "Soft Course format" as the course format.
3. Customize the course sections, adding images and descriptions as desired.
4. Save the changes and view the course to see the new layout.

## Configuration

The plugin offers several configuration options:

- Hide all sections: Option to hide all course sections on the main page.
- Hide section zero: Option to hide the general section (section 0) of the course.
- Course introduction: Add an introduction text to be displayed on the course page.
- Section images: Upload and manage images for each course section.

## Customization

You can further customize the appearance of the Softcourse format using CSS. Refer to the plugin's CSS files for specific selectors and classes.

## Compatibility

Softcourse is compatible with Moodle 3.5 and later versions, including Moodle 4.0. It has been tested with various Moodle themes, including Boost.

## Known Issues

- Text may be truncated if there are multiple paragraphs in the section description. Consider limiting the character count in section summaries.

## Contributing

Contributions to the Softcourse format are welcome. Please submit pull requests to the GitHub repository.

## Support

If you encounter any issues or have questions, please use the GitHub issue tracker or contact the maintainers.

## License

This plugin is licensed under the GNU GPL v3 or later. See the LICENSE file for details.

## Maintainer

The Softcourse format is currently maintained by:

Pimenko
- Email: contact@pimenko.com
- GitHub: https://github.com/DigiDago/moodle-format_softcourse

## Acknowledgements

Softcourse was developed by Pimenko to enhance the learning experience in Moodle courses.




About Pimenko
===================

Pimenko is a leading company specializing in Moodle development and e-learning solutions. With a team of experienced developers and e-learning experts, we are committed to creating innovative and high-quality plugins that enhance the Moodle experience for educators and learners alike.

### Our Expertise

- Custom Moodle development
- Moodle plugin creation and maintenance
- E-learning platform optimization
- Moodle theme development
- Learning analytics solutions

### Connect with Us

- **Website**: [https://www.pimenko.com](https://www.pimenko.com)
- **Email**: contact@pimenko.com
- **GitHub**: [https://github.com/DigiDago](https://github.com/DigiDago)
- **LinkedIn**: [Pimenko LinkedIn Profile](https://www.linkedin.com/company/pimenko/)

We are passionate about improving e-learning experiences through technology. If you have any questions about our services or need custom Moodle solutions, don't hesitate to reach out!

@copyright Pimenko https://www.pimenko.com
