<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.
/**
 * Report settings
 *
 * @package    report
 * @copyright  2024 CAPES/UFLA
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require(__DIR__ . '/../../config.php');
require_once($CFG->libdir . '/adminlib.php');
require_once('mapper.php');
require_login();


//main function that will process the input
admin_externalpage_setup('reportcoursestatsv2', '', null, '', array('pagelayout' => 'report'));

$customcatnames = get_config('report_coursestats_v2', 'customcatnames');

echo $OUTPUT->header();


if (!empty($customcatnames)) {
    $DB->delete_records('report_coursestatsv2_cat');
    $DB->delete_records('report_coursestatsv2_course');
    report_coursestats_v2_process_custom_config($customcatnames);
} else {
    $DB->delete_records('report_coursestatsv2_cat');
    $DB->delete_records('report_coursestatsv2_course');
    report_coursestats_v2_process_moodle_config();
}

redirect(new moodle_url($CFG->wwwroot . '/report/coursestats_v2/table_categories.php'));

echo $OUTPUT->footer();
