<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * List courses report page.
 *
 * @package   report_edumetrics
 * @copyright 2026, Paulo Júnior <pauloa.junior@ufla.br>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require(__DIR__ . '/../../config.php');
require_once($CFG->libdir . '/adminlib.php');

require_login();

admin_externalpage_setup('reportedumetrics');

// Set up the page.
$pageurl = new moodle_url($CFG->wwwroot . '/report/edumetrics/list_courses.php');
$PAGE->set_url($pageurl);
$PAGE->set_context(context_system::instance());
$PAGE->set_pagelayout('report');
$PAGE->set_primary_active_tab('siteadminnode');
echo $OUTPUT->header();

// Show heading.
$heading = get_string('available_courses', 'report_edumetrics');
echo $OUTPUT->heading($heading);

// Get visible courses.
$courses = get_courses('all', 'c.fullname ASC', 'c.id, c.shortname, c.fullname, c.visible');

// Filter only visible courses and add URLs.
$visiblecourses = [];
foreach ($courses as $course) {
    if ($course->visible == 1 && $course->id != SITEID) {
        $course->url = (new moodle_url($CFG->wwwroot . '/report/edumetrics/participants_metrics.php', ['courseid' => $course->id]))->out(false);
        $visiblecourses[] = $course;
    }
}

// Prepare template context.
$templatecontext = [
    'courses' => array_values($visiblecourses),
];

// Render courses list template.
echo $OUTPUT->render_from_template('report_edumetrics/list_courses', $templatecontext);

echo $OUTPUT->footer();
