<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Participants filter form.
 *
 * @package   report_edumetrics
 * @copyright 2026, Paulo Júnior <pauloa.junior@ufla.br>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

require_once($CFG->libdir . '/formslib.php');

/**
 * Form for filtering participants by role.
 */
class report_edumetrics_filter_form extends moodleform {

    /**
     * Define the form elements.
     */
    public function definition() {
        $mform = $this->_form;
        $courseid = $this->_customdata['courseid'];
        $context = $this->_customdata['context'];

        // Get all roles in this context.
        $roles = role_fix_names(get_all_roles($context), $context, ROLENAME_ALIAS);
        
        // Build role options.
        $roleoptions = [0 => get_string('all')];
        foreach ($roles as $role) {
            $roleoptions[$role->id] = $role->localname;
        }

        // Add role filter select.
        $mform->addElement('select', 'role', get_string('role'), $roleoptions);
        $mform->setDefault('role', 0);

        // Add date filters.
        $mform->addElement('date_selector', 'datefrom', get_string('datefrom', 'report_edumetrics'), 
            ['optional' => true]);
        $mform->addHelpButton('datefrom', 'datefrom', 'report_edumetrics');

        $mform->addElement('date_selector', 'dateto', get_string('dateto', 'report_edumetrics'), 
            ['optional' => true]);
        $mform->addHelpButton('dateto', 'dateto', 'report_edumetrics');

        // Hidden field for courseid.
        $mform->addElement('hidden', 'courseid', $courseid);
        $mform->setType('courseid', PARAM_INT);

        // Submit button.
        $this->add_action_buttons(false, get_string('filter', 'report_edumetrics'));
    }

    /**
     * Validate the form data.
     *
     * @param array $data Form data
     * @param array $files Files uploaded
     * @return array Array of errors
     */
    public function validation($data, $files) {
        $errors = parent::validation($data, $files);

        // Validate that end date is greater than or equal to start date.
        if (!empty($data['datefrom']) && !empty($data['dateto'])) {
            if ($data['dateto'] < $data['datefrom']) {
                $errors['dateto'] = get_string('dateto_error', 'report_edumetrics');
            }
        }

        return $errors;
    }
}
