<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Courses list filter form.
 *
 * @package   report_edumetrics
 * @copyright 2026, Paulo Júnior <pauloa.junior@ufla.br>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

require_once($CFG->libdir . '/formslib.php');

/**
 * Form for filtering courses by category.
 */
class report_edumetrics_list_courses_filter_form extends moodleform {

    /**
     * Define the form elements.
     */
    public function definition() {
        global $DB;
        
        $mform = $this->_form;

        // Get all visible categories, ordered by name.
        $categories = $DB->get_records('course_categories', ['visible' => 1], 'name ASC', 'id, name');

        // Build category options.
        $categoryoptions = [0 => get_string('all_categories', 'report_edumetrics')];
        foreach ($categories as $category) {
            $categoryoptions[$category->id] = format_string($category->name);
        }

        // Add category filter select.
        $mform->addElement('select', 'category', get_string('category', 'report_edumetrics'), $categoryoptions);
        $mform->setDefault('category', 0);

        // Submit button.
        $this->add_action_buttons(false, get_string('filter', 'report_edumetrics'));
    }
}
