define("block_sharing_cart/lib/sortablejs",["exports"],(function(_exports){
/**!
   * Sortable 1.15.0
   * @author    RubaXa   <trash@rubaxa.org>
   * @author    owenm    <owen23355@gmail.com>
   * @license MIT
   * @link https://github.com/SortableJS/Sortable/blob/master/modular/sortable.complete.esm.js
   */
function ownKeys(object,enumerableOnly){var keys=Object.keys(object);if(Object.getOwnPropertySymbols){var symbols=Object.getOwnPropertySymbols(object);enumerableOnly&&(symbols=symbols.filter((function(sym){return Object.getOwnPropertyDescriptor(object,sym).enumerable}))),keys.push.apply(keys,symbols)}return keys}function _objectSpread2(target){for(var i=1;i<arguments.length;i++){var source=null!=arguments[i]?arguments[i]:{};i%2?ownKeys(Object(source),!0).forEach((function(key){_defineProperty(target,key,source[key])})):Object.getOwnPropertyDescriptors?Object.defineProperties(target,Object.getOwnPropertyDescriptors(source)):ownKeys(Object(source)).forEach((function(key){Object.defineProperty(target,key,Object.getOwnPropertyDescriptor(source,key))}))}return target}function _typeof(obj){return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj},_typeof(obj)}function _defineProperty(obj,key,value){return key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}function _extends(){return _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source)Object.prototype.hasOwnProperty.call(source,key)&&(target[key]=source[key])}return target},_extends.apply(this,arguments)}function _objectWithoutProperties(source,excluded){if(null==source)return{};var key,i,target=function(source,excluded){if(null==source)return{};var key,i,target={},sourceKeys=Object.keys(source);for(i=0;i<sourceKeys.length;i++)key=sourceKeys[i],excluded.indexOf(key)>=0||(target[key]=source[key]);return target}(source,excluded);if(Object.getOwnPropertySymbols){var sourceSymbolKeys=Object.getOwnPropertySymbols(source);for(i=0;i<sourceSymbolKeys.length;i++)key=sourceSymbolKeys[i],excluded.indexOf(key)>=0||Object.prototype.propertyIsEnumerable.call(source,key)&&(target[key]=source[key])}return target}function _toConsumableArray(arr){return function(arr){if(Array.isArray(arr))return _arrayLikeToArray(arr)}(arr)||function(iter){if("undefined"!=typeof Symbol&&null!=iter[Symbol.iterator]||null!=iter["@@iterator"])return Array.from(iter)}(arr)||function(o,minLen){if(!o)return;if("string"==typeof o)return _arrayLikeToArray(o,minLen);var n=Object.prototype.toString.call(o).slice(8,-1);"Object"===n&&o.constructor&&(n=o.constructor.name);if("Map"===n||"Set"===n)return Array.from(o);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return _arrayLikeToArray(o,minLen)}(arr)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function _arrayLikeToArray(arr,len){(null==len||len>arr.length)&&(len=arr.length);for(var i=0,arr2=new Array(len);i<len;i++)arr2[i]=arr[i];return arr2}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;function userAgent(pattern){if("undefined"!=typeof window&&window.navigator)return!!navigator.userAgent.match(pattern)}var IE11OrLess=userAgent(/(?:Trident.*rv[ :]?11\.|msie|iemobile|Windows Phone)/i),Edge=userAgent(/Edge/i),FireFox=userAgent(/firefox/i),Safari=userAgent(/safari/i)&&!userAgent(/chrome/i)&&!userAgent(/android/i),IOS=userAgent(/iP(ad|od|hone)/i),ChromeForAndroid=userAgent(/chrome/i)&&userAgent(/android/i),captureMode={capture:!1,passive:!1};function on(el,event,fn){el.addEventListener(event,fn,!IE11OrLess&&captureMode)}function off(el,event,fn){el.removeEventListener(event,fn,!IE11OrLess&&captureMode)}function matches(el,selector){if(selector){if(">"===selector[0]&&(selector=selector.substring(1)),el)try{if(el.matches)return el.matches(selector);if(el.msMatchesSelector)return el.msMatchesSelector(selector);if(el.webkitMatchesSelector)return el.webkitMatchesSelector(selector)}catch(_){return!1}return!1}}function getParentOrHost(el){return el.host&&el!==document&&el.host.nodeType?el.host:el.parentNode}function closest(el,selector,ctx,includeCTX){if(el){ctx=ctx||document;do{if(null!=selector&&(">"===selector[0]?el.parentNode===ctx&&matches(el,selector):matches(el,selector))||includeCTX&&el===ctx)return el;if(el===ctx)break}while(el=getParentOrHost(el))}return null}var _throttleTimeout,R_SPACE=/\s+/g;function toggleClass(el,name,state){if(el&&name)if(el.classList)el.classList[state?"add":"remove"](name);else{var className=(" "+el.className+" ").replace(R_SPACE," ").replace(" "+name+" "," ");el.className=(className+(state?" "+name:"")).replace(R_SPACE," ")}}function css(el,prop,val){var style=el&&el.style;if(style){if(void 0===val)return document.defaultView&&document.defaultView.getComputedStyle?val=document.defaultView.getComputedStyle(el,""):el.currentStyle&&(val=el.currentStyle),void 0===prop?val:val[prop];prop in style||-1!==prop.indexOf("webkit")||(prop="-webkit-"+prop),style[prop]=val+("string"==typeof val?"":"px")}}function matrix(el,selfOnly){var appliedTransforms="";if("string"==typeof el)appliedTransforms=el;else do{var transform=css(el,"transform");transform&&"none"!==transform&&(appliedTransforms=transform+" "+appliedTransforms)}while(!selfOnly&&(el=el.parentNode));var matrixFn=window.DOMMatrix||window.WebKitCSSMatrix||window.CSSMatrix||window.MSCSSMatrix;return matrixFn&&new matrixFn(appliedTransforms)}function find(ctx,tagName,iterator){if(ctx){var list=ctx.getElementsByTagName(tagName),i=0,n=list.length;if(iterator)for(;i<n;i++)iterator(list[i],i);return list}return[]}function getWindowScrollingElement(){var scrollingElement=document.scrollingElement;return scrollingElement||document.documentElement}function getRect(el,relativeToContainingBlock,relativeToNonStaticParent,undoScale,container){if(el.getBoundingClientRect||el===window){var elRect,top,left,bottom,right,height,width;if(el!==window&&el.parentNode&&el!==getWindowScrollingElement()?(top=(elRect=el.getBoundingClientRect()).top,left=elRect.left,bottom=elRect.bottom,right=elRect.right,height=elRect.height,width=elRect.width):(top=0,left=0,bottom=window.innerHeight,right=window.innerWidth,height=window.innerHeight,width=window.innerWidth),(relativeToContainingBlock||relativeToNonStaticParent)&&el!==window&&(container=container||el.parentNode,!IE11OrLess))do{if(container&&container.getBoundingClientRect&&("none"!==css(container,"transform")||relativeToNonStaticParent&&"static"!==css(container,"position"))){var containerRect=container.getBoundingClientRect();top-=containerRect.top+parseInt(css(container,"border-top-width")),left-=containerRect.left+parseInt(css(container,"border-left-width")),bottom=top+elRect.height,right=left+elRect.width;break}}while(container=container.parentNode);if(undoScale&&el!==window){var elMatrix=matrix(container||el),scaleX=elMatrix&&elMatrix.a,scaleY=elMatrix&&elMatrix.d;elMatrix&&(bottom=(top/=scaleY)+(height/=scaleY),right=(left/=scaleX)+(width/=scaleX))}return{top:top,left:left,bottom:bottom,right:right,width:width,height:height}}}function isScrolledPast(el,elSide,parentSide){for(var parent=getParentAutoScrollElement(el,!0),elSideVal=getRect(el)[elSide];parent;){var parentSideVal=getRect(parent)[parentSide];if(!("top"===parentSide||"left"===parentSide?elSideVal>=parentSideVal:elSideVal<=parentSideVal))return parent;if(parent===getWindowScrollingElement())break;parent=getParentAutoScrollElement(parent,!1)}return!1}function getChild(el,childNum,options,includeDragEl){for(var currentChild=0,i=0,children=el.children;i<children.length;){if("none"!==children[i].style.display&&children[i]!==Sortable.ghost&&(includeDragEl||children[i]!==Sortable.dragged)&&closest(children[i],options.draggable,el,!1)){if(currentChild===childNum)return children[i];currentChild++}i++}return null}function lastChild(el,selector){for(var last=el.lastElementChild;last&&(last===Sortable.ghost||"none"===css(last,"display")||selector&&!matches(last,selector));)last=last.previousElementSibling;return last||null}function index(el,selector){var index=0;if(!el||!el.parentNode)return-1;for(;el=el.previousElementSibling;)"TEMPLATE"===el.nodeName.toUpperCase()||el===Sortable.clone||selector&&!matches(el,selector)||index++;return index}function getRelativeScrollOffset(el){var offsetLeft=0,offsetTop=0,winScroller=getWindowScrollingElement();if(el)do{var elMatrix=matrix(el),scaleX=elMatrix.a,scaleY=elMatrix.d;offsetLeft+=el.scrollLeft*scaleX,offsetTop+=el.scrollTop*scaleY}while(el!==winScroller&&(el=el.parentNode));return[offsetLeft,offsetTop]}function getParentAutoScrollElement(el,includeSelf){if(!el||!el.getBoundingClientRect)return getWindowScrollingElement();var elem=el,gotSelf=!1;do{if(elem.clientWidth<elem.scrollWidth||elem.clientHeight<elem.scrollHeight){var elemCSS=css(elem);if(elem.clientWidth<elem.scrollWidth&&("auto"==elemCSS.overflowX||"scroll"==elemCSS.overflowX)||elem.clientHeight<elem.scrollHeight&&("auto"==elemCSS.overflowY||"scroll"==elemCSS.overflowY)){if(!elem.getBoundingClientRect||elem===document.body)return getWindowScrollingElement();if(gotSelf||includeSelf)return elem;gotSelf=!0}}}while(elem=elem.parentNode);return getWindowScrollingElement()}function isRectEqual(rect1,rect2){return Math.round(rect1.top)===Math.round(rect2.top)&&Math.round(rect1.left)===Math.round(rect2.left)&&Math.round(rect1.height)===Math.round(rect2.height)&&Math.round(rect1.width)===Math.round(rect2.width)}function throttle(callback,ms){return function(){if(!_throttleTimeout){var args=arguments,_this=this;1===args.length?callback.call(_this,args[0]):callback.apply(_this,args),_throttleTimeout=setTimeout((function(){_throttleTimeout=void 0}),ms)}}}function scrollBy(el,x,y){el.scrollLeft+=x,el.scrollTop+=y}function clone(el){var Polymer=window.Polymer,$=window.jQuery||window.Zepto;return Polymer&&Polymer.dom?Polymer.dom(el).cloneNode(!0):$?$(el).clone(!0)[0]:el.cloneNode(!0)}function setRect(el,rect){css(el,"position","absolute"),css(el,"top",rect.top),css(el,"left",rect.left),css(el,"width",rect.width),css(el,"height",rect.height)}function unsetRect(el){css(el,"position",""),css(el,"top",""),css(el,"left",""),css(el,"width",""),css(el,"height","")}var expando="Sortable"+(new Date).getTime();function AnimationStateManager(){var animationCallbackId,animationStates=[];return{captureAnimationState:function(){(animationStates=[],this.options.animation)&&[].slice.call(this.el.children).forEach((function(child){if("none"!==css(child,"display")&&child!==Sortable.ghost){animationStates.push({target:child,rect:getRect(child)});var fromRect=_objectSpread2({},animationStates[animationStates.length-1].rect);if(child.thisAnimationDuration){var childMatrix=matrix(child,!0);childMatrix&&(fromRect.top-=childMatrix.f,fromRect.left-=childMatrix.e)}child.fromRect=fromRect}}))},addAnimationState:function(state){animationStates.push(state)},removeAnimationState:function(target){animationStates.splice(function(arr,obj){for(var i in arr)if(arr.hasOwnProperty(i))for(var key in obj)if(obj.hasOwnProperty(key)&&obj[key]===arr[i][key])return Number(i);return-1}(animationStates,{target:target}),1)},animateAll:function(callback){var _this=this;if(!this.options.animation)return clearTimeout(animationCallbackId),void("function"==typeof callback&&callback());var animating=!1,animationTime=0;animationStates.forEach((function(state){var time=0,target=state.target,fromRect=target.fromRect,toRect=getRect(target),prevFromRect=target.prevFromRect,prevToRect=target.prevToRect,animatingRect=state.rect,targetMatrix=matrix(target,!0);targetMatrix&&(toRect.top-=targetMatrix.f,toRect.left-=targetMatrix.e),target.toRect=toRect,target.thisAnimationDuration&&isRectEqual(prevFromRect,toRect)&&!isRectEqual(fromRect,toRect)&&(animatingRect.top-toRect.top)/(animatingRect.left-toRect.left)==(fromRect.top-toRect.top)/(fromRect.left-toRect.left)&&(time=function(animatingRect,fromRect,toRect,options){return Math.sqrt(Math.pow(fromRect.top-animatingRect.top,2)+Math.pow(fromRect.left-animatingRect.left,2))/Math.sqrt(Math.pow(fromRect.top-toRect.top,2)+Math.pow(fromRect.left-toRect.left,2))*options.animation}(animatingRect,prevFromRect,prevToRect,_this.options)),isRectEqual(toRect,fromRect)||(target.prevFromRect=fromRect,target.prevToRect=toRect,time||(time=_this.options.animation),_this.animate(target,animatingRect,toRect,time)),time&&(animating=!0,animationTime=Math.max(animationTime,time),clearTimeout(target.animationResetTimer),target.animationResetTimer=setTimeout((function(){target.animationTime=0,target.prevFromRect=null,target.fromRect=null,target.prevToRect=null,target.thisAnimationDuration=null}),time),target.thisAnimationDuration=time)})),clearTimeout(animationCallbackId),animating?animationCallbackId=setTimeout((function(){"function"==typeof callback&&callback()}),animationTime):"function"==typeof callback&&callback(),animationStates=[]},animate:function(target,currentRect,toRect,duration){if(duration){css(target,"transition",""),css(target,"transform","");var elMatrix=matrix(this.el),scaleX=elMatrix&&elMatrix.a,scaleY=elMatrix&&elMatrix.d,translateX=(currentRect.left-toRect.left)/(scaleX||1),translateY=(currentRect.top-toRect.top)/(scaleY||1);target.animatingX=!!translateX,target.animatingY=!!translateY,css(target,"transform","translate3d("+translateX+"px,"+translateY+"px,0)"),this.forRepaintDummy=function(target){return target.offsetWidth}(target),css(target,"transition","transform "+duration+"ms"+(this.options.easing?" "+this.options.easing:"")),css(target,"transform","translate3d(0,0,0)"),"number"==typeof target.animated&&clearTimeout(target.animated),target.animated=setTimeout((function(){css(target,"transition",""),css(target,"transform",""),target.animated=!1,target.animatingX=!1,target.animatingY=!1}),duration)}}}}var plugins=[],defaults={initializeByDefault:!0},PluginManager={mount:function(plugin){for(var option in defaults)defaults.hasOwnProperty(option)&&!(option in plugin)&&(plugin[option]=defaults[option]);plugins.forEach((function(p){if(p.pluginName===plugin.pluginName)throw"Sortable: Cannot mount plugin ".concat(plugin.pluginName," more than once")})),plugins.push(plugin)},pluginEvent:function(eventName,sortable,evt){var _this=this;this.eventCanceled=!1,evt.cancel=function(){_this.eventCanceled=!0};var eventNameGlobal=eventName+"Global";plugins.forEach((function(plugin){sortable[plugin.pluginName]&&(sortable[plugin.pluginName][eventNameGlobal]&&sortable[plugin.pluginName][eventNameGlobal](_objectSpread2({sortable:sortable},evt)),sortable.options[plugin.pluginName]&&sortable[plugin.pluginName][eventName]&&sortable[plugin.pluginName][eventName](_objectSpread2({sortable:sortable},evt)))}))},initializePlugins:function(sortable,el,defaults,options){for(var option in plugins.forEach((function(plugin){var pluginName=plugin.pluginName;if(sortable.options[pluginName]||plugin.initializeByDefault){var initialized=new plugin(sortable,el,sortable.options);initialized.sortable=sortable,initialized.options=sortable.options,sortable[pluginName]=initialized,_extends(defaults,initialized.defaults)}})),sortable.options)if(sortable.options.hasOwnProperty(option)){var modified=this.modifyOption(sortable,option,sortable.options[option]);void 0!==modified&&(sortable.options[option]=modified)}},getEventProperties:function(name,sortable){var eventProperties={};return plugins.forEach((function(plugin){"function"==typeof plugin.eventProperties&&_extends(eventProperties,plugin.eventProperties.call(sortable[plugin.pluginName],name))})),eventProperties},modifyOption:function(sortable,name,value){var modifiedValue;return plugins.forEach((function(plugin){sortable[plugin.pluginName]&&plugin.optionListeners&&"function"==typeof plugin.optionListeners[name]&&(modifiedValue=plugin.optionListeners[name].call(sortable[plugin.pluginName],value))})),modifiedValue}};function dispatchEvent(_ref){var sortable=_ref.sortable,rootEl=_ref.rootEl,name=_ref.name,targetEl=_ref.targetEl,cloneEl=_ref.cloneEl,toEl=_ref.toEl,fromEl=_ref.fromEl,oldIndex=_ref.oldIndex,newIndex=_ref.newIndex,oldDraggableIndex=_ref.oldDraggableIndex,newDraggableIndex=_ref.newDraggableIndex,originalEvent=_ref.originalEvent,putSortable=_ref.putSortable,extraEventProperties=_ref.extraEventProperties;if(sortable=sortable||rootEl&&rootEl[expando]){var evt,options=sortable.options,onName="on"+name.charAt(0).toUpperCase()+name.substr(1);!window.CustomEvent||IE11OrLess||Edge?(evt=document.createEvent("Event")).initEvent(name,!0,!0):evt=new CustomEvent(name,{bubbles:!0,cancelable:!0}),evt.to=toEl||rootEl,evt.from=fromEl||rootEl,evt.item=targetEl||rootEl,evt.clone=cloneEl,evt.oldIndex=oldIndex,evt.newIndex=newIndex,evt.oldDraggableIndex=oldDraggableIndex,evt.newDraggableIndex=newDraggableIndex,evt.originalEvent=originalEvent,evt.pullMode=putSortable?putSortable.lastPutMode:void 0;var allEventProperties=_objectSpread2(_objectSpread2({},extraEventProperties),PluginManager.getEventProperties(name,sortable));for(var option in allEventProperties)evt[option]=allEventProperties[option];rootEl&&rootEl.dispatchEvent(evt),options[onName]&&options[onName].call(sortable,evt)}}var _excluded=["evt"],pluginEvent=function(eventName,sortable){var _ref=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},originalEvent=_ref.evt,data=_objectWithoutProperties(_ref,_excluded);PluginManager.pluginEvent.bind(Sortable)(eventName,sortable,_objectSpread2({dragEl:dragEl,parentEl:parentEl,ghostEl:ghostEl,rootEl:rootEl,nextEl:nextEl,lastDownEl:lastDownEl,cloneEl:cloneEl,cloneHidden:cloneHidden,dragStarted:moved,putSortable:putSortable,activeSortable:Sortable.active,originalEvent:originalEvent,oldIndex:oldIndex,oldDraggableIndex:oldDraggableIndex,newIndex:newIndex,newDraggableIndex:newDraggableIndex,hideGhostForTarget:_hideGhostForTarget,unhideGhostForTarget:_unhideGhostForTarget,cloneNowHidden:function(){cloneHidden=!0},cloneNowShown:function(){cloneHidden=!1},dispatchSortableEvent:function(name){_dispatchEvent({sortable:sortable,name:name,originalEvent:originalEvent})}},data))};function _dispatchEvent(info){dispatchEvent(_objectSpread2({putSortable:putSortable,cloneEl:cloneEl,targetEl:dragEl,rootEl:rootEl,oldIndex:oldIndex,oldDraggableIndex:oldDraggableIndex,newIndex:newIndex,newDraggableIndex:newDraggableIndex},info))}var dragEl,parentEl,ghostEl,rootEl,nextEl,lastDownEl,cloneEl,cloneHidden,oldIndex,newIndex,oldDraggableIndex,newDraggableIndex,activeGroup,putSortable,tapEvt,touchEvt,lastDx,lastDy,tapDistanceLeft,tapDistanceTop,moved,lastTarget,lastDirection,targetMoveDistance,ghostRelativeParent,awaitingDragStarted=!1,ignoreNextClick=!1,sortables=[],pastFirstInvertThresh=!1,isCircumstantialInvert=!1,ghostRelativeParentInitialScroll=[],_silent=!1,savedInputChecked=[],documentExists="undefined"!=typeof document,PositionGhostAbsolutely=IOS,CSSFloatProperty=Edge||IE11OrLess?"cssFloat":"float",supportDraggable=documentExists&&!ChromeForAndroid&&!IOS&&"draggable"in document.createElement("div"),supportCssPointerEvents=function(){if(documentExists){if(IE11OrLess)return!1;var el=document.createElement("x");return el.style.cssText="pointer-events:auto","auto"===el.style.pointerEvents}}(),_detectDirection=function(el,options){var elCSS=css(el),elWidth=parseInt(elCSS.width)-parseInt(elCSS.paddingLeft)-parseInt(elCSS.paddingRight)-parseInt(elCSS.borderLeftWidth)-parseInt(elCSS.borderRightWidth),child1=getChild(el,0,options),child2=getChild(el,1,options),firstChildCSS=child1&&css(child1),secondChildCSS=child2&&css(child2),firstChildWidth=firstChildCSS&&parseInt(firstChildCSS.marginLeft)+parseInt(firstChildCSS.marginRight)+getRect(child1).width,secondChildWidth=secondChildCSS&&parseInt(secondChildCSS.marginLeft)+parseInt(secondChildCSS.marginRight)+getRect(child2).width;if("flex"===elCSS.display)return"column"===elCSS.flexDirection||"column-reverse"===elCSS.flexDirection?"vertical":"horizontal";if("grid"===elCSS.display)return elCSS.gridTemplateColumns.split(" ").length<=1?"vertical":"horizontal";if(child1&&firstChildCSS.float&&"none"!==firstChildCSS.float){var touchingSideChild2="left"===firstChildCSS.float?"left":"right";return!child2||"both"!==secondChildCSS.clear&&secondChildCSS.clear!==touchingSideChild2?"horizontal":"vertical"}return child1&&("block"===firstChildCSS.display||"flex"===firstChildCSS.display||"table"===firstChildCSS.display||"grid"===firstChildCSS.display||firstChildWidth>=elWidth&&"none"===elCSS[CSSFloatProperty]||child2&&"none"===elCSS[CSSFloatProperty]&&firstChildWidth+secondChildWidth>elWidth)?"vertical":"horizontal"},_prepareGroup=function(options){function toFn(value,pull){return function(to,from,dragEl,evt){var sameGroup=to.options.group.name&&from.options.group.name&&to.options.group.name===from.options.group.name;if(null==value&&(pull||sameGroup))return!0;if(null==value||!1===value)return!1;if(pull&&"clone"===value)return value;if("function"==typeof value)return toFn(value(to,from,dragEl,evt),pull)(to,from,dragEl,evt);var otherGroup=(pull?to:from).options.group.name;return!0===value||"string"==typeof value&&value===otherGroup||value.join&&value.indexOf(otherGroup)>-1}}var group={},originalGroup=options.group;originalGroup&&"object"==_typeof(originalGroup)||(originalGroup={name:originalGroup}),group.name=originalGroup.name,group.checkPull=toFn(originalGroup.pull,!0),group.checkPut=toFn(originalGroup.put),group.revertClone=originalGroup.revertClone,options.group=group},_hideGhostForTarget=function(){!supportCssPointerEvents&&ghostEl&&css(ghostEl,"display","none")},_unhideGhostForTarget=function(){!supportCssPointerEvents&&ghostEl&&css(ghostEl,"display","")};documentExists&&!ChromeForAndroid&&document.addEventListener("click",(function(evt){if(ignoreNextClick)return evt.preventDefault(),evt.stopPropagation&&evt.stopPropagation(),evt.stopImmediatePropagation&&evt.stopImmediatePropagation(),ignoreNextClick=!1,!1}),!0);var nearestEmptyInsertDetectEvent=function(evt){if(dragEl){evt=evt.touches?evt.touches[0]:evt;var nearest=(x=evt.clientX,y=evt.clientY,sortables.some((function(sortable){var threshold=sortable[expando].options.emptyInsertThreshold;if(threshold&&!lastChild(sortable)){var rect=getRect(sortable),insideHorizontally=x>=rect.left-threshold&&x<=rect.right+threshold,insideVertically=y>=rect.top-threshold&&y<=rect.bottom+threshold;return insideHorizontally&&insideVertically?ret=sortable:void 0}})),ret);if(nearest){var event={};for(var i in evt)evt.hasOwnProperty(i)&&(event[i]=evt[i]);event.target=event.rootEl=nearest,event.preventDefault=void 0,event.stopPropagation=void 0,nearest[expando]._onDragOver(event)}}var x,y,ret},_checkOutsideTargetEl=function(evt){dragEl&&dragEl.parentNode[expando]._isOutsideThisEl(evt.target)};function Sortable(el,options){if(!el||!el.nodeType||1!==el.nodeType)throw"Sortable: `el` must be an HTMLElement, not ".concat({}.toString.call(el));this.el=el,this.options=options=_extends({},options),el[expando]=this;var defaults={group:null,sort:!0,disabled:!1,store:null,handle:null,draggable:/^[uo]l$/i.test(el.nodeName)?">li":">*",swapThreshold:1,invertSwap:!1,invertedSwapThreshold:null,removeCloneOnHide:!0,direction:function(){return _detectDirection(el,this.options)},ghostClass:"sortable-ghost",chosenClass:"sortable-chosen",dragClass:"sortable-drag",ignore:"a, img",filter:null,preventOnFilter:!0,animation:0,easing:null,setData:function(dataTransfer,dragEl){dataTransfer.setData("Text",dragEl.textContent)},dropBubble:!1,dragoverBubble:!1,dataIdAttr:"data-id",delay:0,delayOnTouchOnly:!1,touchStartThreshold:(Number.parseInt?Number:window).parseInt(window.devicePixelRatio,10)||1,forceFallback:!1,fallbackClass:"sortable-fallback",fallbackOnBody:!1,fallbackTolerance:0,fallbackOffset:{x:0,y:0},supportPointer:!1!==Sortable.supportPointer&&"PointerEvent"in window&&!Safari,emptyInsertThreshold:5};for(var name in PluginManager.initializePlugins(this,el,defaults),defaults)!(name in options)&&(options[name]=defaults[name]);for(var fn in _prepareGroup(options),this)"_"===fn.charAt(0)&&"function"==typeof this[fn]&&(this[fn]=this[fn].bind(this));this.nativeDraggable=!options.forceFallback&&supportDraggable,this.nativeDraggable&&(this.options.touchStartThreshold=1),options.supportPointer?on(el,"pointerdown",this._onTapStart):(on(el,"mousedown",this._onTapStart),on(el,"touchstart",this._onTapStart)),this.nativeDraggable&&(on(el,"dragover",this),on(el,"dragenter",this)),sortables.push(this.el),options.store&&options.store.get&&this.sort(options.store.get(this)||[]),_extends(this,AnimationStateManager())}function _onMove(fromEl,toEl,dragEl,dragRect,targetEl,targetRect,originalEvent,willInsertAfter){var evt,retVal,sortable=fromEl[expando],onMoveFn=sortable.options.onMove;return!window.CustomEvent||IE11OrLess||Edge?(evt=document.createEvent("Event")).initEvent("move",!0,!0):evt=new CustomEvent("move",{bubbles:!0,cancelable:!0}),evt.to=toEl,evt.from=fromEl,evt.dragged=dragEl,evt.draggedRect=dragRect,evt.related=targetEl||toEl,evt.relatedRect=targetRect||getRect(toEl),evt.willInsertAfter=willInsertAfter,evt.originalEvent=originalEvent,fromEl.dispatchEvent(evt),onMoveFn&&(retVal=onMoveFn.call(sortable,evt,originalEvent)),retVal}function _disableDraggable(el){el.draggable=!1}function _unsilent(){_silent=!1}function _generateId(el){for(var str=el.tagName+el.className+el.src+el.href+el.textContent,i=str.length,sum=0;i--;)sum+=str.charCodeAt(i);return sum.toString(36)}function _nextTick(fn){return setTimeout(fn,0)}function _cancelNextTick(id){return clearTimeout(id)}Sortable.prototype={constructor:Sortable,_isOutsideThisEl:function(target){this.el.contains(target)||target===this.el||(lastTarget=null)},_getDirection:function(evt,target){return"function"==typeof this.options.direction?this.options.direction.call(this,evt,target,dragEl):this.options.direction},_onTapStart:function(evt){if(evt.cancelable){var _this=this,el=this.el,options=this.options,preventOnFilter=options.preventOnFilter,type=evt.type,touch=evt.touches&&evt.touches[0]||evt.pointerType&&"touch"===evt.pointerType&&evt,target=(touch||evt).target,originalTarget=evt.target.shadowRoot&&(evt.path&&evt.path[0]||evt.composedPath&&evt.composedPath()[0])||target,filter=options.filter;if(function(root){savedInputChecked.length=0;var inputs=root.getElementsByTagName("input"),idx=inputs.length;for(;idx--;){var el=inputs[idx];el.checked&&savedInputChecked.push(el)}}(el),!dragEl&&!(/mousedown|pointerdown/.test(type)&&0!==evt.button||options.disabled)&&!originalTarget.isContentEditable&&(this.nativeDraggable||!Safari||!target||"SELECT"!==target.tagName.toUpperCase())&&!((target=closest(target,options.draggable,el,!1))&&target.animated||lastDownEl===target)){if(oldIndex=index(target),oldDraggableIndex=index(target,options.draggable),"function"==typeof filter){if(filter.call(this,evt,target,this))return _dispatchEvent({sortable:_this,rootEl:originalTarget,name:"filter",targetEl:target,toEl:el,fromEl:el}),pluginEvent("filter",_this,{evt:evt}),void(preventOnFilter&&evt.cancelable&&evt.preventDefault())}else if(filter&&(filter=filter.split(",").some((function(criteria){if(criteria=closest(originalTarget,criteria.trim(),el,!1))return _dispatchEvent({sortable:_this,rootEl:criteria,name:"filter",targetEl:target,fromEl:el,toEl:el}),pluginEvent("filter",_this,{evt:evt}),!0}))))return void(preventOnFilter&&evt.cancelable&&evt.preventDefault());options.handle&&!closest(originalTarget,options.handle,el,!1)||this._prepareDragStart(evt,touch,target)}}},_prepareDragStart:function(evt,touch,target){var dragStartFn,_this=this,el=_this.el,options=_this.options,ownerDocument=el.ownerDocument;if(target&&!dragEl&&target.parentNode===el){var dragRect=getRect(target);if(rootEl=el,parentEl=(dragEl=target).parentNode,nextEl=dragEl.nextSibling,lastDownEl=target,activeGroup=options.group,Sortable.dragged=dragEl,tapEvt={target:dragEl,clientX:(touch||evt).clientX,clientY:(touch||evt).clientY},tapDistanceLeft=tapEvt.clientX-dragRect.left,tapDistanceTop=tapEvt.clientY-dragRect.top,this._lastX=(touch||evt).clientX,this._lastY=(touch||evt).clientY,dragEl.style["will-change"]="all",dragStartFn=function(){pluginEvent("delayEnded",_this,{evt:evt}),Sortable.eventCanceled?_this._onDrop():(_this._disableDelayedDragEvents(),!FireFox&&_this.nativeDraggable&&(dragEl.draggable=!0),_this._triggerDragStart(evt,touch),_dispatchEvent({sortable:_this,name:"choose",originalEvent:evt}),toggleClass(dragEl,options.chosenClass,!0))},options.ignore.split(",").forEach((function(criteria){find(dragEl,criteria.trim(),_disableDraggable)})),on(ownerDocument,"dragover",nearestEmptyInsertDetectEvent),on(ownerDocument,"mousemove",nearestEmptyInsertDetectEvent),on(ownerDocument,"touchmove",nearestEmptyInsertDetectEvent),on(ownerDocument,"mouseup",_this._onDrop),on(ownerDocument,"touchend",_this._onDrop),on(ownerDocument,"touchcancel",_this._onDrop),FireFox&&this.nativeDraggable&&(this.options.touchStartThreshold=4,dragEl.draggable=!0),pluginEvent("delayStart",this,{evt:evt}),!options.delay||options.delayOnTouchOnly&&!touch||this.nativeDraggable&&(Edge||IE11OrLess))dragStartFn();else{if(Sortable.eventCanceled)return void this._onDrop();on(ownerDocument,"mouseup",_this._disableDelayedDrag),on(ownerDocument,"touchend",_this._disableDelayedDrag),on(ownerDocument,"touchcancel",_this._disableDelayedDrag),on(ownerDocument,"mousemove",_this._delayedDragTouchMoveHandler),on(ownerDocument,"touchmove",_this._delayedDragTouchMoveHandler),options.supportPointer&&on(ownerDocument,"pointermove",_this._delayedDragTouchMoveHandler),_this._dragStartTimer=setTimeout(dragStartFn,options.delay)}}},_delayedDragTouchMoveHandler:function(e){var touch=e.touches?e.touches[0]:e;Math.max(Math.abs(touch.clientX-this._lastX),Math.abs(touch.clientY-this._lastY))>=Math.floor(this.options.touchStartThreshold/(this.nativeDraggable&&window.devicePixelRatio||1))&&this._disableDelayedDrag()},_disableDelayedDrag:function(){dragEl&&_disableDraggable(dragEl),clearTimeout(this._dragStartTimer),this._disableDelayedDragEvents()},_disableDelayedDragEvents:function(){var ownerDocument=this.el.ownerDocument;off(ownerDocument,"mouseup",this._disableDelayedDrag),off(ownerDocument,"touchend",this._disableDelayedDrag),off(ownerDocument,"touchcancel",this._disableDelayedDrag),off(ownerDocument,"mousemove",this._delayedDragTouchMoveHandler),off(ownerDocument,"touchmove",this._delayedDragTouchMoveHandler),off(ownerDocument,"pointermove",this._delayedDragTouchMoveHandler)},_triggerDragStart:function(evt,touch){touch=touch||"touch"==evt.pointerType&&evt,!this.nativeDraggable||touch?this.options.supportPointer?on(document,"pointermove",this._onTouchMove):on(document,touch?"touchmove":"mousemove",this._onTouchMove):(on(dragEl,"dragend",this),on(rootEl,"dragstart",this._onDragStart));try{document.selection?_nextTick((function(){document.selection.empty()})):window.getSelection().removeAllRanges()}catch(err){}},_dragStarted:function(fallback,evt){if(awaitingDragStarted=!1,rootEl&&dragEl){pluginEvent("dragStarted",this,{evt:evt}),this.nativeDraggable&&on(document,"dragover",_checkOutsideTargetEl);var options=this.options;!fallback&&toggleClass(dragEl,options.dragClass,!1),toggleClass(dragEl,options.ghostClass,!0),Sortable.active=this,fallback&&this._appendGhost(),_dispatchEvent({sortable:this,name:"start",originalEvent:evt})}else this._nulling()},_emulateDragOver:function(){if(touchEvt){this._lastX=touchEvt.clientX,this._lastY=touchEvt.clientY,_hideGhostForTarget();for(var target=document.elementFromPoint(touchEvt.clientX,touchEvt.clientY),parent=target;target&&target.shadowRoot&&(target=target.shadowRoot.elementFromPoint(touchEvt.clientX,touchEvt.clientY))!==parent;)parent=target;if(dragEl.parentNode[expando]._isOutsideThisEl(target),parent)do{if(parent[expando]){if(parent[expando]._onDragOver({clientX:touchEvt.clientX,clientY:touchEvt.clientY,target:target,rootEl:parent})&&!this.options.dragoverBubble)break}target=parent}while(parent=parent.parentNode);_unhideGhostForTarget()}},_onTouchMove:function(evt){if(tapEvt){var options=this.options,fallbackTolerance=options.fallbackTolerance,fallbackOffset=options.fallbackOffset,touch=evt.touches?evt.touches[0]:evt,ghostMatrix=ghostEl&&matrix(ghostEl,!0),scaleX=ghostEl&&ghostMatrix&&ghostMatrix.a,scaleY=ghostEl&&ghostMatrix&&ghostMatrix.d,relativeScrollOffset=PositionGhostAbsolutely&&ghostRelativeParent&&getRelativeScrollOffset(ghostRelativeParent),dx=(touch.clientX-tapEvt.clientX+fallbackOffset.x)/(scaleX||1)+(relativeScrollOffset?relativeScrollOffset[0]-ghostRelativeParentInitialScroll[0]:0)/(scaleX||1),dy=(touch.clientY-tapEvt.clientY+fallbackOffset.y)/(scaleY||1)+(relativeScrollOffset?relativeScrollOffset[1]-ghostRelativeParentInitialScroll[1]:0)/(scaleY||1);if(!Sortable.active&&!awaitingDragStarted){if(fallbackTolerance&&Math.max(Math.abs(touch.clientX-this._lastX),Math.abs(touch.clientY-this._lastY))<fallbackTolerance)return;this._onDragStart(evt,!0)}if(ghostEl){ghostMatrix?(ghostMatrix.e+=dx-(lastDx||0),ghostMatrix.f+=dy-(lastDy||0)):ghostMatrix={a:1,b:0,c:0,d:1,e:dx,f:dy};var cssMatrix="matrix(".concat(ghostMatrix.a,",").concat(ghostMatrix.b,",").concat(ghostMatrix.c,",").concat(ghostMatrix.d,",").concat(ghostMatrix.e,",").concat(ghostMatrix.f,")");css(ghostEl,"webkitTransform",cssMatrix),css(ghostEl,"mozTransform",cssMatrix),css(ghostEl,"msTransform",cssMatrix),css(ghostEl,"transform",cssMatrix),lastDx=dx,lastDy=dy,touchEvt=touch}evt.cancelable&&evt.preventDefault()}},_appendGhost:function(){if(!ghostEl){var container=this.options.fallbackOnBody?document.body:rootEl,rect=getRect(dragEl,!0,PositionGhostAbsolutely,!0,container),options=this.options;if(PositionGhostAbsolutely){for(ghostRelativeParent=container;"static"===css(ghostRelativeParent,"position")&&"none"===css(ghostRelativeParent,"transform")&&ghostRelativeParent!==document;)ghostRelativeParent=ghostRelativeParent.parentNode;ghostRelativeParent!==document.body&&ghostRelativeParent!==document.documentElement?(ghostRelativeParent===document&&(ghostRelativeParent=getWindowScrollingElement()),rect.top+=ghostRelativeParent.scrollTop,rect.left+=ghostRelativeParent.scrollLeft):ghostRelativeParent=getWindowScrollingElement(),ghostRelativeParentInitialScroll=getRelativeScrollOffset(ghostRelativeParent)}toggleClass(ghostEl=dragEl.cloneNode(!0),options.ghostClass,!1),toggleClass(ghostEl,options.fallbackClass,!0),toggleClass(ghostEl,options.dragClass,!0),css(ghostEl,"transition",""),css(ghostEl,"transform",""),css(ghostEl,"box-sizing","border-box"),css(ghostEl,"margin",0),css(ghostEl,"top",rect.top),css(ghostEl,"left",rect.left),css(ghostEl,"width",rect.width),css(ghostEl,"height",rect.height),css(ghostEl,"opacity","0.8"),css(ghostEl,"position",PositionGhostAbsolutely?"absolute":"fixed"),css(ghostEl,"zIndex","100000"),css(ghostEl,"pointerEvents","none"),Sortable.ghost=ghostEl,container.appendChild(ghostEl),css(ghostEl,"transform-origin",tapDistanceLeft/parseInt(ghostEl.style.width)*100+"% "+tapDistanceTop/parseInt(ghostEl.style.height)*100+"%")}},_onDragStart:function(evt,fallback){var _this=this,dataTransfer=evt.dataTransfer,options=_this.options;pluginEvent("dragStart",this,{evt:evt}),Sortable.eventCanceled?this._onDrop():(pluginEvent("setupClone",this),Sortable.eventCanceled||((cloneEl=clone(dragEl)).removeAttribute("id"),cloneEl.draggable=!1,cloneEl.style["will-change"]="",this._hideClone(),toggleClass(cloneEl,this.options.chosenClass,!1),Sortable.clone=cloneEl),_this.cloneId=_nextTick((function(){pluginEvent("clone",_this),Sortable.eventCanceled||(_this.options.removeCloneOnHide||rootEl.insertBefore(cloneEl,dragEl),_this._hideClone(),_dispatchEvent({sortable:_this,name:"clone"}))})),!fallback&&toggleClass(dragEl,options.dragClass,!0),fallback?(ignoreNextClick=!0,_this._loopId=setInterval(_this._emulateDragOver,50)):(off(document,"mouseup",_this._onDrop),off(document,"touchend",_this._onDrop),off(document,"touchcancel",_this._onDrop),dataTransfer&&(dataTransfer.effectAllowed="move",options.setData&&options.setData.call(_this,dataTransfer,dragEl)),on(document,"drop",_this),css(dragEl,"transform","translateZ(0)")),awaitingDragStarted=!0,_this._dragStartId=_nextTick(_this._dragStarted.bind(_this,fallback,evt)),on(document,"selectstart",_this),moved=!0,Safari&&css(document.body,"user-select","none"))},_onDragOver:function(evt){var dragRect,targetRect,revert,vertical,el=this.el,target=evt.target,options=this.options,group=options.group,activeSortable=Sortable.active,isOwner=activeGroup===group,canSort=options.sort,fromSortable=putSortable||activeSortable,_this=this,completedFired=!1;if(!_silent){if(void 0!==evt.preventDefault&&evt.cancelable&&evt.preventDefault(),target=closest(target,options.draggable,el,!0),dragOverEvent("dragOver"),Sortable.eventCanceled)return completedFired;if(dragEl.contains(evt.target)||target.animated&&target.animatingX&&target.animatingY||_this._ignoreWhileAnimating===target)return completed(!1);if(ignoreNextClick=!1,activeSortable&&!options.disabled&&(isOwner?canSort||(revert=parentEl!==rootEl):putSortable===this||(this.lastPutMode=activeGroup.checkPull(this,activeSortable,dragEl,evt))&&group.checkPut(this,activeSortable,dragEl,evt))){if(vertical="vertical"===this._getDirection(evt,target),dragRect=getRect(dragEl),dragOverEvent("dragOverValid"),Sortable.eventCanceled)return completedFired;if(revert)return parentEl=rootEl,capture(),this._hideClone(),dragOverEvent("revert"),Sortable.eventCanceled||(nextEl?rootEl.insertBefore(dragEl,nextEl):rootEl.appendChild(dragEl)),completed(!0);var elLastChild=lastChild(el,options.draggable);if(!elLastChild||function(evt,vertical,sortable){var rect=getRect(lastChild(sortable.el,sortable.options.draggable)),spacer=10;return vertical?evt.clientX>rect.right+spacer||evt.clientX<=rect.right&&evt.clientY>rect.bottom&&evt.clientX>=rect.left:evt.clientX>rect.right&&evt.clientY>rect.top||evt.clientX<=rect.right&&evt.clientY>rect.bottom+spacer}(evt,vertical,this)&&!elLastChild.animated){if(elLastChild===dragEl)return completed(!1);if(elLastChild&&el===evt.target&&(target=elLastChild),target&&(targetRect=getRect(target)),!1!==_onMove(rootEl,el,dragEl,dragRect,target,targetRect,evt,!!target))return capture(),elLastChild&&elLastChild.nextSibling?el.insertBefore(dragEl,elLastChild.nextSibling):el.appendChild(dragEl),parentEl=el,changed(),completed(!0)}else if(elLastChild&&function(evt,vertical,sortable){var rect=getRect(getChild(sortable.el,0,sortable.options,!0)),spacer=10;return vertical?evt.clientX<rect.left-spacer||evt.clientY<rect.top&&evt.clientX<rect.right:evt.clientY<rect.top-spacer||evt.clientY<rect.bottom&&evt.clientX<rect.left}(evt,vertical,this)){var firstChild=getChild(el,0,options,!0);if(firstChild===dragEl)return completed(!1);if(targetRect=getRect(target=firstChild),!1!==_onMove(rootEl,el,dragEl,dragRect,target,targetRect,evt,!1))return capture(),el.insertBefore(dragEl,firstChild),parentEl=el,changed(),completed(!0)}else if(target.parentNode===el){targetRect=getRect(target);var direction,targetBeforeFirstSwap,sibling,differentLevel=dragEl.parentNode!==el,differentRowCol=!function(dragRect,targetRect,vertical){var dragElS1Opp=vertical?dragRect.left:dragRect.top,dragElS2Opp=vertical?dragRect.right:dragRect.bottom,dragElOppLength=vertical?dragRect.width:dragRect.height,targetS1Opp=vertical?targetRect.left:targetRect.top,targetS2Opp=vertical?targetRect.right:targetRect.bottom,targetOppLength=vertical?targetRect.width:targetRect.height;return dragElS1Opp===targetS1Opp||dragElS2Opp===targetS2Opp||dragElS1Opp+dragElOppLength/2===targetS1Opp+targetOppLength/2}(dragEl.animated&&dragEl.toRect||dragRect,target.animated&&target.toRect||targetRect,vertical),side1=vertical?"top":"left",scrolledPastTop=isScrolledPast(target,"top","top")||isScrolledPast(dragEl,"top","top"),scrollBefore=scrolledPastTop?scrolledPastTop.scrollTop:void 0;if(lastTarget!==target&&(targetBeforeFirstSwap=targetRect[side1],pastFirstInvertThresh=!1,isCircumstantialInvert=!differentRowCol&&options.invertSwap||differentLevel),direction=function(evt,target,targetRect,vertical,swapThreshold,invertedSwapThreshold,invertSwap,isLastTarget){var mouseOnAxis=vertical?evt.clientY:evt.clientX,targetLength=vertical?targetRect.height:targetRect.width,targetS1=vertical?targetRect.top:targetRect.left,targetS2=vertical?targetRect.bottom:targetRect.right,invert=!1;if(!invertSwap)if(isLastTarget&&targetMoveDistance<targetLength*swapThreshold){if(!pastFirstInvertThresh&&(1===lastDirection?mouseOnAxis>targetS1+targetLength*invertedSwapThreshold/2:mouseOnAxis<targetS2-targetLength*invertedSwapThreshold/2)&&(pastFirstInvertThresh=!0),pastFirstInvertThresh)invert=!0;else if(1===lastDirection?mouseOnAxis<targetS1+targetMoveDistance:mouseOnAxis>targetS2-targetMoveDistance)return-lastDirection}else if(mouseOnAxis>targetS1+targetLength*(1-swapThreshold)/2&&mouseOnAxis<targetS2-targetLength*(1-swapThreshold)/2)return function(target){return index(dragEl)<index(target)?1:-1}(target);if((invert=invert||invertSwap)&&(mouseOnAxis<targetS1+targetLength*invertedSwapThreshold/2||mouseOnAxis>targetS2-targetLength*invertedSwapThreshold/2))return mouseOnAxis>targetS1+targetLength/2?1:-1;return 0}(evt,target,targetRect,vertical,differentRowCol?1:options.swapThreshold,null==options.invertedSwapThreshold?options.swapThreshold:options.invertedSwapThreshold,isCircumstantialInvert,lastTarget===target),0!==direction){var dragIndex=index(dragEl);do{dragIndex-=direction,sibling=parentEl.children[dragIndex]}while(sibling&&("none"===css(sibling,"display")||sibling===ghostEl))}if(0===direction||sibling===target)return completed(!1);lastTarget=target,lastDirection=direction;var nextSibling=target.nextElementSibling,after=!1,moveVector=_onMove(rootEl,el,dragEl,dragRect,target,targetRect,evt,after=1===direction);if(!1!==moveVector)return 1!==moveVector&&-1!==moveVector||(after=1===moveVector),_silent=!0,setTimeout(_unsilent,30),capture(),after&&!nextSibling?el.appendChild(dragEl):target.parentNode.insertBefore(dragEl,after?nextSibling:target),scrolledPastTop&&scrollBy(scrolledPastTop,0,scrollBefore-scrolledPastTop.scrollTop),parentEl=dragEl.parentNode,void 0===targetBeforeFirstSwap||isCircumstantialInvert||(targetMoveDistance=Math.abs(targetBeforeFirstSwap-getRect(target)[side1])),changed(),completed(!0)}if(el.contains(dragEl))return completed(!1)}return!1}function dragOverEvent(name,extra){pluginEvent(name,_this,_objectSpread2({evt:evt,isOwner:isOwner,axis:vertical?"vertical":"horizontal",revert:revert,dragRect:dragRect,targetRect:targetRect,canSort:canSort,fromSortable:fromSortable,target:target,completed:completed,onMove:function(target,after){return _onMove(rootEl,el,dragEl,dragRect,target,getRect(target),evt,after)},changed:changed},extra))}function capture(){dragOverEvent("dragOverAnimationCapture"),_this.captureAnimationState(),_this!==fromSortable&&fromSortable.captureAnimationState()}function completed(insertion){return dragOverEvent("dragOverCompleted",{insertion:insertion}),insertion&&(isOwner?activeSortable._hideClone():activeSortable._showClone(_this),_this!==fromSortable&&(toggleClass(dragEl,putSortable?putSortable.options.ghostClass:activeSortable.options.ghostClass,!1),toggleClass(dragEl,options.ghostClass,!0)),putSortable!==_this&&_this!==Sortable.active?putSortable=_this:_this===Sortable.active&&putSortable&&(putSortable=null),fromSortable===_this&&(_this._ignoreWhileAnimating=target),_this.animateAll((function(){dragOverEvent("dragOverAnimationComplete"),_this._ignoreWhileAnimating=null})),_this!==fromSortable&&(fromSortable.animateAll(),fromSortable._ignoreWhileAnimating=null)),(target===dragEl&&!dragEl.animated||target===el&&!target.animated)&&(lastTarget=null),options.dragoverBubble||evt.rootEl||target===document||(dragEl.parentNode[expando]._isOutsideThisEl(evt.target),!insertion&&nearestEmptyInsertDetectEvent(evt)),!options.dragoverBubble&&evt.stopPropagation&&evt.stopPropagation(),completedFired=!0}function changed(){newIndex=index(dragEl),newDraggableIndex=index(dragEl,options.draggable),_dispatchEvent({sortable:_this,name:"change",toEl:el,newIndex:newIndex,newDraggableIndex:newDraggableIndex,originalEvent:evt})}},_ignoreWhileAnimating:null,_offMoveEvents:function(){off(document,"mousemove",this._onTouchMove),off(document,"touchmove",this._onTouchMove),off(document,"pointermove",this._onTouchMove),off(document,"dragover",nearestEmptyInsertDetectEvent),off(document,"mousemove",nearestEmptyInsertDetectEvent),off(document,"touchmove",nearestEmptyInsertDetectEvent)},_offUpEvents:function(){var ownerDocument=this.el.ownerDocument;off(ownerDocument,"mouseup",this._onDrop),off(ownerDocument,"touchend",this._onDrop),off(ownerDocument,"pointerup",this._onDrop),off(ownerDocument,"touchcancel",this._onDrop),off(document,"selectstart",this)},_onDrop:function(evt){var el=this.el,options=this.options;newIndex=index(dragEl),newDraggableIndex=index(dragEl,options.draggable),pluginEvent("drop",this,{evt:evt}),parentEl=dragEl&&dragEl.parentNode,newIndex=index(dragEl),newDraggableIndex=index(dragEl,options.draggable),Sortable.eventCanceled||(awaitingDragStarted=!1,isCircumstantialInvert=!1,pastFirstInvertThresh=!1,clearInterval(this._loopId),clearTimeout(this._dragStartTimer),_cancelNextTick(this.cloneId),_cancelNextTick(this._dragStartId),this.nativeDraggable&&(off(document,"drop",this),off(el,"dragstart",this._onDragStart)),this._offMoveEvents(),this._offUpEvents(),Safari&&css(document.body,"user-select",""),css(dragEl,"transform",""),evt&&(moved&&(evt.cancelable&&evt.preventDefault(),!options.dropBubble&&evt.stopPropagation()),ghostEl&&ghostEl.parentNode&&ghostEl.parentNode.removeChild(ghostEl),(rootEl===parentEl||putSortable&&"clone"!==putSortable.lastPutMode)&&cloneEl&&cloneEl.parentNode&&cloneEl.parentNode.removeChild(cloneEl),dragEl&&(this.nativeDraggable&&off(dragEl,"dragend",this),_disableDraggable(dragEl),dragEl.style["will-change"]="",moved&&!awaitingDragStarted&&toggleClass(dragEl,putSortable?putSortable.options.ghostClass:this.options.ghostClass,!1),toggleClass(dragEl,this.options.chosenClass,!1),_dispatchEvent({sortable:this,name:"unchoose",toEl:parentEl,newIndex:null,newDraggableIndex:null,originalEvent:evt}),rootEl!==parentEl?(newIndex>=0&&(_dispatchEvent({rootEl:parentEl,name:"add",toEl:parentEl,fromEl:rootEl,originalEvent:evt}),_dispatchEvent({sortable:this,name:"remove",toEl:parentEl,originalEvent:evt}),_dispatchEvent({rootEl:parentEl,name:"sort",toEl:parentEl,fromEl:rootEl,originalEvent:evt}),_dispatchEvent({sortable:this,name:"sort",toEl:parentEl,originalEvent:evt})),putSortable&&putSortable.save()):newIndex!==oldIndex&&newIndex>=0&&(_dispatchEvent({sortable:this,name:"update",toEl:parentEl,originalEvent:evt}),_dispatchEvent({sortable:this,name:"sort",toEl:parentEl,originalEvent:evt})),Sortable.active&&(null!=newIndex&&-1!==newIndex||(newIndex=oldIndex,newDraggableIndex=oldDraggableIndex),_dispatchEvent({sortable:this,name:"end",toEl:parentEl,originalEvent:evt}),this.save())))),this._nulling()},_nulling:function(){pluginEvent("nulling",this),rootEl=dragEl=parentEl=ghostEl=nextEl=cloneEl=lastDownEl=cloneHidden=tapEvt=touchEvt=moved=newIndex=newDraggableIndex=oldIndex=oldDraggableIndex=lastTarget=lastDirection=putSortable=activeGroup=Sortable.dragged=Sortable.ghost=Sortable.clone=Sortable.active=null,savedInputChecked.forEach((function(el){el.checked=!0})),savedInputChecked.length=lastDx=lastDy=0},handleEvent:function(evt){switch(evt.type){case"drop":case"dragend":this._onDrop(evt);break;case"dragenter":case"dragover":dragEl&&(this._onDragOver(evt),function(evt){evt.dataTransfer&&(evt.dataTransfer.dropEffect="move");evt.cancelable&&evt.preventDefault()}(evt));break;case"selectstart":evt.preventDefault()}},toArray:function(){for(var el,order=[],children=this.el.children,i=0,n=children.length,options=this.options;i<n;i++)closest(el=children[i],options.draggable,this.el,!1)&&order.push(el.getAttribute(options.dataIdAttr)||_generateId(el));return order},sort:function(order,useAnimation){var items={},rootEl=this.el;this.toArray().forEach((function(id,i){var el=rootEl.children[i];closest(el,this.options.draggable,rootEl,!1)&&(items[id]=el)}),this),useAnimation&&this.captureAnimationState(),order.forEach((function(id){items[id]&&(rootEl.removeChild(items[id]),rootEl.appendChild(items[id]))})),useAnimation&&this.animateAll()},save:function(){var store=this.options.store;store&&store.set&&store.set(this)},closest:function(el,selector){return closest(el,selector||this.options.draggable,this.el,!1)},option:function(name,value){var options=this.options;if(void 0===value)return options[name];var modifiedValue=PluginManager.modifyOption(this,name,value);options[name]=void 0!==modifiedValue?modifiedValue:value,"group"===name&&_prepareGroup(options)},destroy:function(){pluginEvent("destroy",this);var el=this.el;el[expando]=null,off(el,"mousedown",this._onTapStart),off(el,"touchstart",this._onTapStart),off(el,"pointerdown",this._onTapStart),this.nativeDraggable&&(off(el,"dragover",this),off(el,"dragenter",this)),Array.prototype.forEach.call(el.querySelectorAll("[draggable]"),(function(el){el.removeAttribute("draggable")})),this._onDrop(),this._disableDelayedDragEvents(),sortables.splice(sortables.indexOf(this.el),1),this.el=el=null},_hideClone:function(){if(!cloneHidden){if(pluginEvent("hideClone",this),Sortable.eventCanceled)return;css(cloneEl,"display","none"),this.options.removeCloneOnHide&&cloneEl.parentNode&&cloneEl.parentNode.removeChild(cloneEl),cloneHidden=!0}},_showClone:function(putSortable){if("clone"===putSortable.lastPutMode){if(cloneHidden){if(pluginEvent("showClone",this),Sortable.eventCanceled)return;dragEl.parentNode!=rootEl||this.options.group.revertClone?nextEl?rootEl.insertBefore(cloneEl,nextEl):rootEl.appendChild(cloneEl):rootEl.insertBefore(cloneEl,dragEl),this.options.group.revertClone&&this.animate(dragEl,cloneEl),css(cloneEl,"display",""),cloneHidden=!1}}else this._hideClone()}},documentExists&&on(document,"touchmove",(function(evt){(Sortable.active||awaitingDragStarted)&&evt.cancelable&&evt.preventDefault()})),Sortable.utils={on:on,off:off,css:css,find:find,is:function(el,selector){return!!closest(el,selector,el,!1)},extend:function(dst,src){if(dst&&src)for(var key in src)src.hasOwnProperty(key)&&(dst[key]=src[key]);return dst},throttle:throttle,closest:closest,toggleClass:toggleClass,clone:clone,index:index,nextTick:_nextTick,cancelNextTick:_cancelNextTick,detectDirection:_detectDirection,getChild:getChild},Sortable.get=function(element){return element[expando]},Sortable.mount=function(){for(var _len=arguments.length,plugins=new Array(_len),_key=0;_key<_len;_key++)plugins[_key]=arguments[_key];plugins[0].constructor===Array&&(plugins=plugins[0]),plugins.forEach((function(plugin){if(!plugin.prototype||!plugin.prototype.constructor)throw"Sortable: Mounted plugin must be a constructor function, not ".concat({}.toString.call(plugin));plugin.utils&&(Sortable.utils=_objectSpread2(_objectSpread2({},Sortable.utils),plugin.utils)),PluginManager.mount(plugin)}))},Sortable.create=function(el,options){return new Sortable(el,options)},Sortable.version="1.15.0";var scrollEl,scrollRootEl,lastAutoScrollX,lastAutoScrollY,touchEvt$1,pointerElemChangedInterval,autoScrolls=[],scrolling=!1;function clearAutoScrolls(){autoScrolls.forEach((function(autoScroll){clearInterval(autoScroll.pid)})),autoScrolls=[]}function clearPointerElemChangedInterval(){clearInterval(pointerElemChangedInterval)}var lastSwapEl,autoScroll=throttle((function(evt,options,rootEl,isFallback){if(options.scroll){var scrollCustomFn,x=(evt.touches?evt.touches[0]:evt).clientX,y=(evt.touches?evt.touches[0]:evt).clientY,sens=options.scrollSensitivity,speed=options.scrollSpeed,winScroller=getWindowScrollingElement(),scrollThisInstance=!1;scrollRootEl!==rootEl&&(scrollRootEl=rootEl,clearAutoScrolls(),scrollEl=options.scroll,scrollCustomFn=options.scrollFn,!0===scrollEl&&(scrollEl=getParentAutoScrollElement(rootEl,!0)));var layersOut=0,currentParent=scrollEl;do{var el=currentParent,rect=getRect(el),top=rect.top,bottom=rect.bottom,left=rect.left,right=rect.right,width=rect.width,height=rect.height,canScrollX=void 0,canScrollY=void 0,scrollWidth=el.scrollWidth,scrollHeight=el.scrollHeight,elCSS=css(el),scrollPosX=el.scrollLeft,scrollPosY=el.scrollTop;el===winScroller?(canScrollX=width<scrollWidth&&("auto"===elCSS.overflowX||"scroll"===elCSS.overflowX||"visible"===elCSS.overflowX),canScrollY=height<scrollHeight&&("auto"===elCSS.overflowY||"scroll"===elCSS.overflowY||"visible"===elCSS.overflowY)):(canScrollX=width<scrollWidth&&("auto"===elCSS.overflowX||"scroll"===elCSS.overflowX),canScrollY=height<scrollHeight&&("auto"===elCSS.overflowY||"scroll"===elCSS.overflowY));var vx=canScrollX&&(Math.abs(right-x)<=sens&&scrollPosX+width<scrollWidth)-(Math.abs(left-x)<=sens&&!!scrollPosX),vy=canScrollY&&(Math.abs(bottom-y)<=sens&&scrollPosY+height<scrollHeight)-(Math.abs(top-y)<=sens&&!!scrollPosY);if(!autoScrolls[layersOut])for(var i=0;i<=layersOut;i++)autoScrolls[i]||(autoScrolls[i]={});autoScrolls[layersOut].vx==vx&&autoScrolls[layersOut].vy==vy&&autoScrolls[layersOut].el===el||(autoScrolls[layersOut].el=el,autoScrolls[layersOut].vx=vx,autoScrolls[layersOut].vy=vy,clearInterval(autoScrolls[layersOut].pid),0==vx&&0==vy||(scrollThisInstance=!0,autoScrolls[layersOut].pid=setInterval(function(){isFallback&&0===this.layer&&Sortable.active._onTouchMove(touchEvt$1);var scrollOffsetY=autoScrolls[this.layer].vy?autoScrolls[this.layer].vy*speed:0,scrollOffsetX=autoScrolls[this.layer].vx?autoScrolls[this.layer].vx*speed:0;"function"==typeof scrollCustomFn&&"continue"!==scrollCustomFn.call(Sortable.dragged.parentNode[expando],scrollOffsetX,scrollOffsetY,evt,touchEvt$1,autoScrolls[this.layer].el)||scrollBy(autoScrolls[this.layer].el,scrollOffsetX,scrollOffsetY)}.bind({layer:layersOut}),24))),layersOut++}while(options.bubbleScroll&&currentParent!==winScroller&&(currentParent=getParentAutoScrollElement(currentParent,!1)));scrolling=scrollThisInstance}}),30),drop=function(_ref){var originalEvent=_ref.originalEvent,putSortable=_ref.putSortable,dragEl=_ref.dragEl,activeSortable=_ref.activeSortable,dispatchSortableEvent=_ref.dispatchSortableEvent,hideGhostForTarget=_ref.hideGhostForTarget,unhideGhostForTarget=_ref.unhideGhostForTarget;if(originalEvent){var toSortable=putSortable||activeSortable;hideGhostForTarget();var touch=originalEvent.changedTouches&&originalEvent.changedTouches.length?originalEvent.changedTouches[0]:originalEvent,target=document.elementFromPoint(touch.clientX,touch.clientY);unhideGhostForTarget(),toSortable&&!toSortable.el.contains(target)&&(dispatchSortableEvent("spill"),this.onSpill({dragEl:dragEl,putSortable:putSortable}))}};function Revert(){}function Remove(){}Revert.prototype={startIndex:null,dragStart:function(_ref2){var oldDraggableIndex=_ref2.oldDraggableIndex;this.startIndex=oldDraggableIndex},onSpill:function(_ref3){var dragEl=_ref3.dragEl,putSortable=_ref3.putSortable;this.sortable.captureAnimationState(),putSortable&&putSortable.captureAnimationState();var nextSibling=getChild(this.sortable.el,this.startIndex,this.options);nextSibling?this.sortable.el.insertBefore(dragEl,nextSibling):this.sortable.el.appendChild(dragEl),this.sortable.animateAll(),putSortable&&putSortable.animateAll()},drop:drop},_extends(Revert,{pluginName:"revertOnSpill"}),Remove.prototype={onSpill:function(_ref4){var dragEl=_ref4.dragEl,parentSortable=_ref4.putSortable||this.sortable;parentSortable.captureAnimationState(),dragEl.parentNode&&dragEl.parentNode.removeChild(dragEl),parentSortable.animateAll()},drop:drop},_extends(Remove,{pluginName:"removeOnSpill"});var lastMultiDragSelect,multiDragSortable,dragEl$1,clonesFromRect,clonesHidden,multiDragElements=[],multiDragClones=[],initialFolding=!1,folding=!1,dragStarted=!1;function insertMultiDragClones(elementsInserted,rootEl){multiDragClones.forEach((function(clone,i){var target=rootEl.children[clone.sortableIndex+(elementsInserted?Number(i):0)];target?rootEl.insertBefore(clone,target):rootEl.appendChild(clone)}))}function removeMultiDragElements(){multiDragElements.forEach((function(multiDragElement){multiDragElement!==dragEl$1&&multiDragElement.parentNode&&multiDragElement.parentNode.removeChild(multiDragElement)}))}Sortable.mount(new function(){function AutoScroll(){for(var fn in this.defaults={scroll:!0,forceAutoScrollFallback:!1,scrollSensitivity:30,scrollSpeed:10,bubbleScroll:!0},this)"_"===fn.charAt(0)&&"function"==typeof this[fn]&&(this[fn]=this[fn].bind(this))}return AutoScroll.prototype={dragStarted:function(_ref){var originalEvent=_ref.originalEvent;this.sortable.nativeDraggable?on(document,"dragover",this._handleAutoScroll):this.options.supportPointer?on(document,"pointermove",this._handleFallbackAutoScroll):originalEvent.touches?on(document,"touchmove",this._handleFallbackAutoScroll):on(document,"mousemove",this._handleFallbackAutoScroll)},dragOverCompleted:function(_ref2){var originalEvent=_ref2.originalEvent;this.options.dragOverBubble||originalEvent.rootEl||this._handleAutoScroll(originalEvent)},drop:function(){this.sortable.nativeDraggable?off(document,"dragover",this._handleAutoScroll):(off(document,"pointermove",this._handleFallbackAutoScroll),off(document,"touchmove",this._handleFallbackAutoScroll),off(document,"mousemove",this._handleFallbackAutoScroll)),clearPointerElemChangedInterval(),clearAutoScrolls(),clearTimeout(_throttleTimeout),_throttleTimeout=void 0},nulling:function(){touchEvt$1=scrollRootEl=scrollEl=scrolling=pointerElemChangedInterval=lastAutoScrollX=lastAutoScrollY=null,autoScrolls.length=0},_handleFallbackAutoScroll:function(evt){this._handleAutoScroll(evt,!0)},_handleAutoScroll:function(evt,fallback){var _this=this,x=(evt.touches?evt.touches[0]:evt).clientX,y=(evt.touches?evt.touches[0]:evt).clientY,elem=document.elementFromPoint(x,y);if(touchEvt$1=evt,fallback||this.options.forceAutoScrollFallback||Edge||IE11OrLess||Safari){autoScroll(evt,this.options,elem,fallback);var ogElemScroller=getParentAutoScrollElement(elem,!0);!scrolling||pointerElemChangedInterval&&x===lastAutoScrollX&&y===lastAutoScrollY||(pointerElemChangedInterval&&clearPointerElemChangedInterval(),pointerElemChangedInterval=setInterval((function(){var newElem=getParentAutoScrollElement(document.elementFromPoint(x,y),!0);newElem!==ogElemScroller&&(ogElemScroller=newElem,clearAutoScrolls()),autoScroll(evt,_this.options,newElem,fallback)}),10),lastAutoScrollX=x,lastAutoScrollY=y)}else{if(!this.options.bubbleScroll||getParentAutoScrollElement(elem,!0)===getWindowScrollingElement())return void clearAutoScrolls();autoScroll(evt,this.options,getParentAutoScrollElement(elem,!1),!1)}}},_extends(AutoScroll,{pluginName:"scroll",initializeByDefault:!0})}),Sortable.mount(Remove,Revert),Sortable.mount(new function(){function Swap(){this.defaults={swapClass:"sortable-swap-highlight"}}return Swap.prototype={dragStart:function(_ref){var dragEl=_ref.dragEl;lastSwapEl=dragEl},dragOverValid:function(_ref2){var completed=_ref2.completed,target=_ref2.target,onMove=_ref2.onMove,activeSortable=_ref2.activeSortable,changed=_ref2.changed,cancel=_ref2.cancel;if(activeSortable.options.swap){var el=this.sortable.el,options=this.options;if(target&&target!==el){var prevSwapEl=lastSwapEl;!1!==onMove(target)?(toggleClass(target,options.swapClass,!0),lastSwapEl=target):lastSwapEl=null,prevSwapEl&&prevSwapEl!==lastSwapEl&&toggleClass(prevSwapEl,options.swapClass,!1)}changed(),completed(!0),cancel()}},drop:function(_ref3){var activeSortable=_ref3.activeSortable,putSortable=_ref3.putSortable,dragEl=_ref3.dragEl,toSortable=putSortable||this.sortable,options=this.options;lastSwapEl&&toggleClass(lastSwapEl,options.swapClass,!1),lastSwapEl&&(options.swap||putSortable&&putSortable.options.swap)&&dragEl!==lastSwapEl&&(toSortable.captureAnimationState(),toSortable!==activeSortable&&activeSortable.captureAnimationState(),function(n1,n2){var i1,i2,p1=n1.parentNode,p2=n2.parentNode;if(!p1||!p2||p1.isEqualNode(n2)||p2.isEqualNode(n1))return;i1=index(n1),i2=index(n2),p1.isEqualNode(p2)&&i1<i2&&i2++;p1.insertBefore(n2,p1.children[i1]),p2.insertBefore(n1,p2.children[i2])}(dragEl,lastSwapEl),toSortable.animateAll(),toSortable!==activeSortable&&activeSortable.animateAll())},nulling:function(){lastSwapEl=null}},_extends(Swap,{pluginName:"swap",eventProperties:function(){return{swapItem:lastSwapEl}}})}),Sortable.mount(new function(){function MultiDrag(sortable){for(var fn in this)"_"===fn.charAt(0)&&"function"==typeof this[fn]&&(this[fn]=this[fn].bind(this));sortable.options.avoidImplicitDeselect||(sortable.options.supportPointer?on(document,"pointerup",this._deselectMultiDrag):(on(document,"mouseup",this._deselectMultiDrag),on(document,"touchend",this._deselectMultiDrag))),on(document,"keydown",this._checkKeyDown),on(document,"keyup",this._checkKeyUp),this.defaults={selectedClass:"sortable-selected",multiDragKey:null,avoidImplicitDeselect:!1,setData:function(dataTransfer,dragEl){var data="";multiDragElements.length&&multiDragSortable===sortable?multiDragElements.forEach((function(multiDragElement,i){data+=(i?", ":"")+multiDragElement.textContent})):data=dragEl.textContent,dataTransfer.setData("Text",data)}}}return MultiDrag.prototype={multiDragKeyDown:!1,isMultiDrag:!1,delayStartGlobal:function(_ref){var dragged=_ref.dragEl;dragEl$1=dragged},delayEnded:function(){this.isMultiDrag=~multiDragElements.indexOf(dragEl$1)},setupClone:function(_ref2){var sortable=_ref2.sortable,cancel=_ref2.cancel;if(this.isMultiDrag){for(var i=0;i<multiDragElements.length;i++)multiDragClones.push(clone(multiDragElements[i])),multiDragClones[i].sortableIndex=multiDragElements[i].sortableIndex,multiDragClones[i].draggable=!1,multiDragClones[i].style["will-change"]="",toggleClass(multiDragClones[i],this.options.selectedClass,!1),multiDragElements[i]===dragEl$1&&toggleClass(multiDragClones[i],this.options.chosenClass,!1);sortable._hideClone(),cancel()}},clone:function(_ref3){var sortable=_ref3.sortable,rootEl=_ref3.rootEl,dispatchSortableEvent=_ref3.dispatchSortableEvent,cancel=_ref3.cancel;this.isMultiDrag&&(this.options.removeCloneOnHide||multiDragElements.length&&multiDragSortable===sortable&&(insertMultiDragClones(!0,rootEl),dispatchSortableEvent("clone"),cancel()))},showClone:function(_ref4){var cloneNowShown=_ref4.cloneNowShown,rootEl=_ref4.rootEl,cancel=_ref4.cancel;this.isMultiDrag&&(insertMultiDragClones(!1,rootEl),multiDragClones.forEach((function(clone){css(clone,"display","")})),cloneNowShown(),clonesHidden=!1,cancel())},hideClone:function(_ref5){var _this=this,cloneNowHidden=(_ref5.sortable,_ref5.cloneNowHidden),cancel=_ref5.cancel;this.isMultiDrag&&(multiDragClones.forEach((function(clone){css(clone,"display","none"),_this.options.removeCloneOnHide&&clone.parentNode&&clone.parentNode.removeChild(clone)})),cloneNowHidden(),clonesHidden=!0,cancel())},dragStartGlobal:function(_ref6){_ref6.sortable;!this.isMultiDrag&&multiDragSortable&&multiDragSortable.multiDrag._deselectMultiDrag(),multiDragElements.forEach((function(multiDragElement){multiDragElement.sortableIndex=index(multiDragElement)})),multiDragElements=multiDragElements.sort((function(a,b){return a.sortableIndex-b.sortableIndex})),dragStarted=!0},dragStarted:function(_ref7){var _this2=this,sortable=_ref7.sortable;if(this.isMultiDrag){if(this.options.sort&&(sortable.captureAnimationState(),this.options.animation)){multiDragElements.forEach((function(multiDragElement){multiDragElement!==dragEl$1&&css(multiDragElement,"position","absolute")}));var dragRect=getRect(dragEl$1,!1,!0,!0);multiDragElements.forEach((function(multiDragElement){multiDragElement!==dragEl$1&&setRect(multiDragElement,dragRect)})),folding=!0,initialFolding=!0}sortable.animateAll((function(){folding=!1,initialFolding=!1,_this2.options.animation&&multiDragElements.forEach((function(multiDragElement){unsetRect(multiDragElement)})),_this2.options.sort&&removeMultiDragElements()}))}},dragOver:function(_ref8){var target=_ref8.target,completed=_ref8.completed,cancel=_ref8.cancel;folding&&~multiDragElements.indexOf(target)&&(completed(!1),cancel())},revert:function(_ref9){var fromSortable=_ref9.fromSortable,rootEl=_ref9.rootEl,sortable=_ref9.sortable,dragRect=_ref9.dragRect;multiDragElements.length>1&&(multiDragElements.forEach((function(multiDragElement){sortable.addAnimationState({target:multiDragElement,rect:folding?getRect(multiDragElement):dragRect}),unsetRect(multiDragElement),multiDragElement.fromRect=dragRect,fromSortable.removeAnimationState(multiDragElement)})),folding=!1,function(clonesInserted,rootEl){multiDragElements.forEach((function(multiDragElement,i){var target=rootEl.children[multiDragElement.sortableIndex+(clonesInserted?Number(i):0)];target?rootEl.insertBefore(multiDragElement,target):rootEl.appendChild(multiDragElement)}))}(!this.options.removeCloneOnHide,rootEl))},dragOverCompleted:function(_ref10){var sortable=_ref10.sortable,isOwner=_ref10.isOwner,insertion=_ref10.insertion,activeSortable=_ref10.activeSortable,parentEl=_ref10.parentEl,putSortable=_ref10.putSortable,options=this.options;if(insertion){if(isOwner&&activeSortable._hideClone(),initialFolding=!1,options.animation&&multiDragElements.length>1&&(folding||!isOwner&&!activeSortable.options.sort&&!putSortable)){var dragRectAbsolute=getRect(dragEl$1,!1,!0,!0);multiDragElements.forEach((function(multiDragElement){multiDragElement!==dragEl$1&&(setRect(multiDragElement,dragRectAbsolute),parentEl.appendChild(multiDragElement))})),folding=!0}if(!isOwner)if(folding||removeMultiDragElements(),multiDragElements.length>1){var clonesHiddenBefore=clonesHidden;activeSortable._showClone(sortable),activeSortable.options.animation&&!clonesHidden&&clonesHiddenBefore&&multiDragClones.forEach((function(clone){activeSortable.addAnimationState({target:clone,rect:clonesFromRect}),clone.fromRect=clonesFromRect,clone.thisAnimationDuration=null}))}else activeSortable._showClone(sortable)}},dragOverAnimationCapture:function(_ref11){var dragRect=_ref11.dragRect,isOwner=_ref11.isOwner,activeSortable=_ref11.activeSortable;if(multiDragElements.forEach((function(multiDragElement){multiDragElement.thisAnimationDuration=null})),activeSortable.options.animation&&!isOwner&&activeSortable.multiDrag.isMultiDrag){clonesFromRect=_extends({},dragRect);var dragMatrix=matrix(dragEl$1,!0);clonesFromRect.top-=dragMatrix.f,clonesFromRect.left-=dragMatrix.e}},dragOverAnimationComplete:function(){folding&&(folding=!1,removeMultiDragElements())},drop:function(_ref12){var evt=_ref12.originalEvent,rootEl=_ref12.rootEl,parentEl=_ref12.parentEl,sortable=_ref12.sortable,dispatchSortableEvent=_ref12.dispatchSortableEvent,oldIndex=_ref12.oldIndex,putSortable=_ref12.putSortable,toSortable=putSortable||this.sortable;if(evt){var options=this.options,children=parentEl.children;if(!dragStarted)if(options.multiDragKey&&!this.multiDragKeyDown&&this._deselectMultiDrag(),toggleClass(dragEl$1,options.selectedClass,!~multiDragElements.indexOf(dragEl$1)),~multiDragElements.indexOf(dragEl$1))multiDragElements.splice(multiDragElements.indexOf(dragEl$1),1),lastMultiDragSelect=null,dispatchEvent({sortable:sortable,rootEl:rootEl,name:"deselect",targetEl:dragEl$1,originalEvent:evt});else{if(multiDragElements.push(dragEl$1),dispatchEvent({sortable:sortable,rootEl:rootEl,name:"select",targetEl:dragEl$1,originalEvent:evt}),evt.shiftKey&&lastMultiDragSelect&&sortable.el.contains(lastMultiDragSelect)){var n,i,lastIndex=index(lastMultiDragSelect),currentIndex=index(dragEl$1);if(~lastIndex&&~currentIndex&&lastIndex!==currentIndex)for(currentIndex>lastIndex?(i=lastIndex,n=currentIndex):(i=currentIndex,n=lastIndex+1);i<n;i++)~multiDragElements.indexOf(children[i])||(toggleClass(children[i],options.selectedClass,!0),multiDragElements.push(children[i]),dispatchEvent({sortable:sortable,rootEl:rootEl,name:"select",targetEl:children[i],originalEvent:evt}))}else lastMultiDragSelect=dragEl$1;multiDragSortable=toSortable}if(dragStarted&&this.isMultiDrag){if(folding=!1,(parentEl[expando].options.sort||parentEl!==rootEl)&&multiDragElements.length>1){var dragRect=getRect(dragEl$1),multiDragIndex=index(dragEl$1,":not(."+this.options.selectedClass+")");if(!initialFolding&&options.animation&&(dragEl$1.thisAnimationDuration=null),toSortable.captureAnimationState(),!initialFolding&&(options.animation&&(dragEl$1.fromRect=dragRect,multiDragElements.forEach((function(multiDragElement){if(multiDragElement.thisAnimationDuration=null,multiDragElement!==dragEl$1){var rect=folding?getRect(multiDragElement):dragRect;multiDragElement.fromRect=rect,toSortable.addAnimationState({target:multiDragElement,rect:rect})}}))),removeMultiDragElements(),multiDragElements.forEach((function(multiDragElement){children[multiDragIndex]?parentEl.insertBefore(multiDragElement,children[multiDragIndex]):parentEl.appendChild(multiDragElement),multiDragIndex++})),oldIndex===index(dragEl$1))){var update=!1;multiDragElements.forEach((function(multiDragElement){multiDragElement.sortableIndex===index(multiDragElement)||(update=!0)})),update&&dispatchSortableEvent("update")}multiDragElements.forEach((function(multiDragElement){unsetRect(multiDragElement)})),toSortable.animateAll()}multiDragSortable=toSortable}(rootEl===parentEl||putSortable&&"clone"!==putSortable.lastPutMode)&&multiDragClones.forEach((function(clone){clone.parentNode&&clone.parentNode.removeChild(clone)}))}},nullingGlobal:function(){this.isMultiDrag=dragStarted=!1,multiDragClones.length=0},destroyGlobal:function(){this._deselectMultiDrag(),off(document,"pointerup",this._deselectMultiDrag),off(document,"mouseup",this._deselectMultiDrag),off(document,"touchend",this._deselectMultiDrag),off(document,"keydown",this._checkKeyDown),off(document,"keyup",this._checkKeyUp)},_deselectMultiDrag:function(evt){if(!(void 0!==dragStarted&&dragStarted||multiDragSortable!==this.sortable||evt&&closest(evt.target,this.options.draggable,this.sortable.el,!1)||evt&&0!==evt.button))for(;multiDragElements.length;){var el=multiDragElements[0];toggleClass(el,this.options.selectedClass,!1),multiDragElements.shift(),dispatchEvent({sortable:this.sortable,rootEl:this.sortable.el,name:"deselect",targetEl:el,originalEvent:evt})}},_checkKeyDown:function(evt){evt.key===this.options.multiDragKey&&(this.multiDragKeyDown=!0)},_checkKeyUp:function(evt){evt.key===this.options.multiDragKey&&(this.multiDragKeyDown=!1)}},_extends(MultiDrag,{pluginName:"multiDrag",utils:{select:function(el){var sortable=el.parentNode[expando];sortable&&sortable.options.multiDrag&&!~multiDragElements.indexOf(el)&&(multiDragSortable&&multiDragSortable!==sortable&&(multiDragSortable.multiDrag._deselectMultiDrag(),multiDragSortable=sortable),toggleClass(el,sortable.options.selectedClass,!0),multiDragElements.push(el))},deselect:function(el){var sortable=el.parentNode[expando],index=multiDragElements.indexOf(el);sortable&&sortable.options.multiDrag&&~index&&(toggleClass(el,sortable.options.selectedClass,!1),multiDragElements.splice(index,1))}},eventProperties:function(){var _this3=this,oldIndicies=[],newIndicies=[];return multiDragElements.forEach((function(multiDragElement){var newIndex;oldIndicies.push({multiDragElement:multiDragElement,index:multiDragElement.sortableIndex}),newIndex=folding&&multiDragElement!==dragEl$1?-1:folding?index(multiDragElement,":not(."+_this3.options.selectedClass+")"):index(multiDragElement),newIndicies.push({multiDragElement:multiDragElement,index:newIndex})})),{items:_toConsumableArray(multiDragElements),clones:[].concat(multiDragClones),oldIndicies:oldIndicies,newIndicies:newIndicies}},optionListeners:{multiDragKey:function(key){return"ctrl"===(key=key.toLowerCase())?key="Control":key.length>1&&(key=key.charAt(0).toUpperCase()+key.substr(1)),key}}})});var _default=Sortable;return _exports.default=_default,_exports.default}));

//# sourceMappingURL=sortablejs.min.js.map