<?php

require_once(__DIR__ . '/../../config.php');
require_once(__DIR__ . '/lib.php');
require_login();

$paperid = required_param('paperid', PARAM_INT);
$id = required_param('id', PARAM_INT); 

$jwt = get_config("plagiarism_drillbit", "jwt");
$headers = array("Authorization: Bearer $jwt", "Accept: application/json");
$callback = "https://s1.drillbitplagiarismcheck.com/extreme/moodle/submission/$paperid";

$response = plagiarism_drillbit_call_external_api("GET", $callback, $false, $headers);

$updated_response = plagiarism_drillbit_update_submissions($response, $id, "called from manual action");

echo $OUTPUT->header();
echo $OUTPUT->heading("Manual Result update for paper ID: $paperid");
$type = gettype($updated_response);
echo $type;
echo $updated_response;
if ($updated_response){
    echo $OUTPUT->notification("The result for paper ID: $paperid has been updated successfully.", 'notifysuccess');
} else {
    echo $OUTPUT->notification("Waiting for the results for paper ID: $paperid. Please try again in a while.", 'notifymessage');
}

echo $OUTPUT->footer();