define("block_deft/janus-gateway",["exports"],(function(_exports){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=Janus,Janus.sessions=new Map,Janus.isExtensionEnabled=function(){if(navigator.mediaDevices&&navigator.mediaDevices.getDisplayMedia)return!0;if(window.navigator.userAgent.match("Chrome")){let chromever=parseInt(window.navigator.userAgent.match(/Chrome\/(.*) /)[1],10),maxver=33;return window.navigator.userAgent.match("Linux")&&(maxver=35),chromever>=26&&chromever<=maxver||Janus.extension.isInstalled()}return!0};var defaultExtension={extensionId:"hapfgfdkleiggjjpfpenajgdnfckjpaj",isInstalled:function(){return null!==document.querySelector("#janus-extension-installed")},getScreen:function(callback){let pending=window.setTimeout((function(){let error=new Error("NavigatorUserMediaError");return error.name='The required Chrome extension is not installed: click <a href="#">here</a> to install it. (NOTE: this will need you to refresh the page)',callback(error)}),1e3);this.cache[pending]=callback,window.postMessage({type:"janusGetScreen",id:pending},"*")},init:function(){let cache={};this.cache=cache,window.addEventListener("message",(function(event){if(event.origin==window.location.origin)if("janusGotScreen"==event.data.type&&cache[event.data.id]){let callback=cache[event.data.id];if(delete cache[event.data.id],""===event.data.sourceId){let error=new Error("NavigatorUserMediaError");error.name="You cancelled the request for permission, giving up...",callback(error)}else callback(null,event.data.sourceId)}else"janusGetScreenPending"==event.data.type&&window.clearTimeout(event.data.id)}))}};function Janus(gatewayCallbacks){if((gatewayCallbacks=gatewayCallbacks||{}).success="function"==typeof gatewayCallbacks.success?gatewayCallbacks.success:Janus.noop,gatewayCallbacks.error="function"==typeof gatewayCallbacks.error?gatewayCallbacks.error:Janus.noop,gatewayCallbacks.destroyed="function"==typeof gatewayCallbacks.destroyed?gatewayCallbacks.destroyed:Janus.noop,!Janus.initDone)return gatewayCallbacks.error("Library not initialized"),{};if(!Janus.isWebrtcSupported())return gatewayCallbacks.error("WebRTC not supported by this browser"),{};if(Janus.log("Library initialized: "+Janus.initDone),!gatewayCallbacks.server)return gatewayCallbacks.error("Invalid server url"),{};let websockets=!1,ws=null,wsHandlers={},wsKeepaliveTimeoutId=null,servers=null,serversIndex=0,server=gatewayCallbacks.server;Janus.isArray(server)?(Janus.log("Multiple servers provided ("+server.length+"), will use the first that works"),server=null,servers=gatewayCallbacks.server,Janus.debug(servers)):0===server.indexOf("ws")?(websockets=!0,Janus.log("Using WebSockets to contact Janus: "+server)):(websockets=!1,Janus.log("Using REST API to contact Janus: "+server));let iceServers=gatewayCallbacks.iceServers||[{urls:"stun:stun.l.google.com:19302"}],iceTransportPolicy=gatewayCallbacks.iceTransportPolicy,bundlePolicy=gatewayCallbacks.bundlePolicy,withCredentials=!1;void 0!==gatewayCallbacks.withCredentials&&null!==gatewayCallbacks.withCredentials&&(withCredentials=!0===gatewayCallbacks.withCredentials);let maxev=10;void 0!==gatewayCallbacks.max_poll_events&&null!==gatewayCallbacks.max_poll_events&&(maxev=gatewayCallbacks.max_poll_events),maxev<1&&(maxev=1);let token=null;void 0!==gatewayCallbacks.token&&null!==gatewayCallbacks.token&&(token=gatewayCallbacks.token);let apisecret=null;void 0!==gatewayCallbacks.apisecret&&null!==gatewayCallbacks.apisecret&&(apisecret=gatewayCallbacks.apisecret),this.destroyOnUnload=!0,void 0!==gatewayCallbacks.destroyOnUnload&&null!==gatewayCallbacks.destroyOnUnload&&(this.destroyOnUnload=!0===gatewayCallbacks.destroyOnUnload);let keepAlivePeriod=25e3;void 0!==gatewayCallbacks.keepAlivePeriod&&null!==gatewayCallbacks.keepAlivePeriod&&(keepAlivePeriod=gatewayCallbacks.keepAlivePeriod),isNaN(keepAlivePeriod)&&(keepAlivePeriod=25e3);let longPollTimeout=6e4;function getMaxBitrates(simulcastMaxBitrates){let maxBitrates={high:9e5,medium:3e5,low:1e5};return null!=simulcastMaxBitrates&&(simulcastMaxBitrates.high&&(maxBitrates.high=simulcastMaxBitrates.high),simulcastMaxBitrates.medium&&(maxBitrates.medium=simulcastMaxBitrates.medium),simulcastMaxBitrates.low&&(maxBitrates.low=simulcastMaxBitrates.low)),maxBitrates}void 0!==gatewayCallbacks.longPollTimeout&&null!==gatewayCallbacks.longPollTimeout&&(longPollTimeout=gatewayCallbacks.longPollTimeout),isNaN(longPollTimeout)&&(longPollTimeout=6e4);let connected=!1,sessionId=null,pluginHandles=new Map,that=this,retries=0,transactions=new Map;function eventHandler(){if(null==sessionId)return;if(Janus.debug("Long poll..."),!connected)return void Janus.warn("Is the server down? (connected=false)");let longpoll=server+"/"+sessionId+"?rid="+(new Date).getTime();maxev&&(longpoll=longpoll+"&maxev="+maxev),token&&(longpoll=longpoll+"&token="+encodeURIComponent(token)),apisecret&&(longpoll=longpoll+"&apisecret="+encodeURIComponent(apisecret)),Janus.httpAPICall(longpoll,{verb:"GET",withCredentials:withCredentials,success:handleEvent,timeout:longPollTimeout,error:function(textStatus,errorThrown){if(Janus.error(textStatus+":",errorThrown),retries++,retries>3)return connected=!1,void gatewayCallbacks.error("Lost connection to the server (is it down?)");eventHandler()}})}function handleEvent(json,skipTimeout){if(retries=0,websockets||null==sessionId||!0===skipTimeout||eventHandler(),websockets||!Janus.isArray(json))if("keepalive"!==json.janus)if("server_info"!==json.janus)if("ack"!==json.janus)if("success"!==json.janus)if("trickle"===json.janus){const sender=json.sender;if(!sender)return void Janus.warn("Missing sender...");const pluginHandle=pluginHandles.get(sender);if(!pluginHandle)return void Janus.debug("This handle is not attached to this session");let candidate=json.candidate;Janus.debug("Got a trickled candidate on session "+sessionId),Janus.debug(candidate);let config=pluginHandle.webrtcStuff;config.pc&&config.remoteSdp?(Janus.debug("Adding remote candidate:",candidate),candidate&&!0!==candidate.completed?config.pc.addIceCandidate(candidate):config.pc.addIceCandidate(Janus.endOfCandidates)):(Janus.debug("We didn't do setRemoteDescription (trickle got here before the offer?), caching candidate"),config.candidates||(config.candidates=[]),config.candidates.push(candidate),Janus.debug(config.candidates))}else{if("webrtcup"===json.janus){Janus.debug("Got a webrtcup event on session "+sessionId),Janus.debug(json);const sender=json.sender;if(!sender)return void Janus.warn("Missing sender...");const pluginHandle=pluginHandles.get(sender);return pluginHandle?void pluginHandle.webrtcState(!0):void Janus.debug("This handle is not attached to this session")}if("hangup"===json.janus){Janus.debug("Got a hangup event on session "+sessionId),Janus.debug(json);const sender=json.sender;if(!sender)return void Janus.warn("Missing sender...");const pluginHandle=pluginHandles.get(sender);if(!pluginHandle)return void Janus.debug("This handle is not attached to this session");pluginHandle.webrtcState(!1,json.reason),pluginHandle.hangup()}else if("detached"===json.janus){Janus.debug("Got a detached event on session "+sessionId),Janus.debug(json);const sender=json.sender;if(!sender)return void Janus.warn("Missing sender...");const pluginHandle=pluginHandles.get(sender);if(!pluginHandle)return;pluginHandle.ondetached(),pluginHandle.detach()}else if("media"===json.janus){Janus.debug("Got a media event on session "+sessionId),Janus.debug(json);const sender=json.sender;if(!sender)return void Janus.warn("Missing sender...");const pluginHandle=pluginHandles.get(sender);if(!pluginHandle)return void Janus.debug("This handle is not attached to this session");pluginHandle.mediaState(json.type,json.receiving,json.mid)}else if("slowlink"===json.janus){Janus.debug("Got a slowlink event on session "+sessionId),Janus.debug(json);const sender=json.sender;if(!sender)return void Janus.warn("Missing sender...");const pluginHandle=pluginHandles.get(sender);if(!pluginHandle)return void Janus.debug("This handle is not attached to this session");pluginHandle.slowLink(json.uplink,json.lost,json.mid)}else{if("error"===json.janus){Janus.error("Ooops: "+json.error.code+" "+json.error.reason),Janus.debug(json);let transaction=json.transaction;if(transaction){let reportSuccess=transactions.get(transaction);reportSuccess&&reportSuccess(json),transactions.delete(transaction)}return}if("event"===json.janus){Janus.debug("Got a plugin event on session "+sessionId),Janus.debug(json);const sender=json.sender;if(!sender)return void Janus.warn("Missing sender...");let plugindata=json.plugindata;if(!plugindata)return void Janus.warn("Missing plugindata...");Janus.debug("  -- Event is coming from "+sender+" ("+plugindata.plugin+")");let data=plugindata.data;Janus.debug(data);const pluginHandle=pluginHandles.get(sender);if(!pluginHandle)return void Janus.warn("This handle is not attached to this session");let jsep=json.jsep;jsep&&(Janus.debug("Handling SDP as well..."),Janus.debug(jsep));let callback=pluginHandle.onmessage;callback?(Janus.debug("Notifying application..."),callback(data,jsep)):Janus.debug("No provided notification callback")}else{if("timeout"===json.janus)return Janus.error("Timeout on session "+sessionId),Janus.debug(json),void(websockets&&ws.close(3504,"Gateway timeout"));Janus.warn("Unknown message/event  '"+json.janus+"' on session "+sessionId),Janus.debug(json)}}}else{Janus.debug("Got a success on session "+sessionId),Janus.debug(json);const transaction=json.transaction;if(transaction){const reportSuccess=transactions.get(transaction);reportSuccess&&reportSuccess(json),transactions.delete(transaction)}}else{Janus.debug("Got an ack on session "+sessionId),Janus.debug(json);const transaction=json.transaction;if(transaction){const reportSuccess=transactions.get(transaction);reportSuccess&&reportSuccess(json),transactions.delete(transaction)}}else{Janus.debug("Got info on the Janus instance"),Janus.debug(json);const transaction=json.transaction;if(transaction){const reportSuccess=transactions.get(transaction);reportSuccess&&reportSuccess(json),transactions.delete(transaction)}}else Janus.vdebug("Got a keepalive on session "+sessionId);else for(let i=0;i<json.length;i++)handleEvent(json[i],!0)}function keepAlive(){if(!server||!websockets||!connected)return;wsKeepaliveTimeoutId=setTimeout(keepAlive,keepAlivePeriod);let request={janus:"keepalive",session_id:sessionId,transaction:Janus.randomString(12)};token&&(request.token=token),apisecret&&(request.apisecret=apisecret),ws.send(JSON.stringify(request))}function createSession(callbacks){let transaction=Janus.randomString(12),request={janus:"create",transaction:transaction};if(callbacks.reconnect&&(connected=!1,request.janus="claim",request.session_id=sessionId,ws&&(ws.onopen=null,ws.onerror=null,ws.onclose=null,wsKeepaliveTimeoutId&&(clearTimeout(wsKeepaliveTimeoutId),wsKeepaliveTimeoutId=null))),token&&(request.token=token),apisecret&&(request.apisecret=apisecret),!server&&Janus.isArray(servers)&&(server=servers[serversIndex],0===server.indexOf("ws")?(websockets=!0,Janus.log("Server #"+(serversIndex+1)+": trying WebSockets to contact Janus ("+server+")")):(websockets=!1,Janus.log("Server #"+(serversIndex+1)+": trying REST API to contact Janus ("+server+")"))),websockets){ws=Janus.newWebSocket(server,"janus-protocol"),wsHandlers={error:function(){if(Janus.error("Error connecting to the Janus WebSockets server... "+server),Janus.isArray(servers)&&!callbacks.reconnect)return serversIndex++,serversIndex===servers.length?void callbacks.error("Error connecting to any of the provided Janus servers: Is the server down?"):(server=null,void setTimeout((function(){createSession(callbacks)}),200));callbacks.error("Error connecting to the Janus WebSockets server: Is the server down?")},open:function(){transactions.set(transaction,(function(json){if(Janus.debug(json),"success"!==json.janus)return Janus.error("Ooops: "+json.error.code+" "+json.error.reason),void callbacks.error(json.error.reason);wsKeepaliveTimeoutId=setTimeout(keepAlive,keepAlivePeriod),connected=!0,sessionId=json.session_id?json.session_id:json.data.id,callbacks.reconnect?Janus.log("Claimed session: "+sessionId):Janus.log("Created session: "+sessionId),Janus.sessions.set(sessionId,that),callbacks.success()})),ws.send(JSON.stringify(request))},message:function(event){handleEvent(JSON.parse(event.data))},close:function(){server&&connected&&(connected=!1,gatewayCallbacks.error("Lost connection to the server (is it down?)"))}};for(let eventName in wsHandlers)ws.addEventListener(eventName,wsHandlers[eventName])}else Janus.httpAPICall(server,{verb:"POST",withCredentials:withCredentials,body:request,success:function(json){if(Janus.debug(json),"success"!==json.janus)return Janus.error("Ooops: "+json.error.code+" "+json.error.reason),void callbacks.error(json.error.reason);connected=!0,sessionId=json.session_id?json.session_id:json.data.id,callbacks.reconnect?Janus.log("Claimed session: "+sessionId):Janus.log("Created session: "+sessionId),Janus.sessions.set(sessionId,that),eventHandler(),callbacks.success()},error:function(textStatus,errorThrown){if(Janus.error(textStatus+":",errorThrown),Janus.isArray(servers)&&!callbacks.reconnect)return serversIndex++,serversIndex===servers.length?void callbacks.error("Error connecting to any of the provided Janus servers: Is the server down?"):(server=null,void setTimeout((function(){createSession(callbacks)}),200));""===errorThrown?callbacks.error(textStatus+": Is the server down?"):errorThrown&&errorThrown.error?callbacks.error(textStatus+": "+errorThrown.error.message):callbacks.error(textStatus+": "+errorThrown)}})}function sendMessage(handleId,callbacks){if((callbacks=callbacks||{}).success="function"==typeof callbacks.success?callbacks.success:Janus.noop,callbacks.error="function"==typeof callbacks.error?callbacks.error:Janus.noop,!connected)return Janus.warn("Is the server down? (connected=false)"),void callbacks.error("Is the server down? (connected=false)");let pluginHandle=pluginHandles.get(handleId);if(!pluginHandle||!pluginHandle.webrtcStuff)return Janus.warn("Invalid handle"),void callbacks.error("Invalid handle");let message=callbacks.message,jsep=callbacks.jsep,transaction=Janus.randomString(12),request={janus:"message",body:message,transaction:transaction};if(pluginHandle.token&&(request.token=pluginHandle.token),apisecret&&(request.apisecret=apisecret),jsep){request.jsep={type:jsep.type,sdp:jsep.sdp},jsep.e2ee&&(request.jsep.e2ee=!0),"hml"!==jsep.rid_order&&"lmh"!==jsep.rid_order||(request.jsep.rid_order=jsep.rid_order),jsep.force_relay&&(request.jsep.force_relay=!0);let svc=null,config=pluginHandle.webrtcStuff;if(config.pc){let transceivers=config.pc.getTransceivers();if(transceivers&&transceivers.length>0)for(let mindex in transceivers){let tr=transceivers[mindex];if(tr&&tr.sender&&tr.sender.track&&"video"===tr.sender.track.kind){let params=tr.sender.getParameters();params&&params.encodings&&params.encodings[0]&&params.encodings[0].scalabilityMode&&(svc||(svc=[]),svc.push({mindex:parseInt(mindex),mid:tr.mid,svc:params.encodings[0].scalabilityMode}))}}}svc&&(request.jsep.svc=svc)}if(Janus.debug("Sending message to plugin (handle="+handleId+"):"),Janus.debug(request),websockets)return request.session_id=sessionId,request.handle_id=handleId,transactions.set(transaction,(function(json){if(Janus.debug("Message sent!"),Janus.debug(json),"success"===json.janus){let plugindata=json.plugindata;if(!plugindata)return Janus.warn("Request succeeded, but missing plugindata..."),void callbacks.success();Janus.log("Synchronous transaction successful ("+plugindata.plugin+")");let data=plugindata.data;return Janus.debug(data),void callbacks.success(data)}"ack"===json.janus?callbacks.success():json.error?(Janus.error("Ooops: "+json.error.code+" "+json.error.reason),callbacks.error(json.error.code+" "+json.error.reason)):(Janus.error("Unknown error"),callbacks.error("Unknown error"))})),void ws.send(JSON.stringify(request));Janus.httpAPICall(server+"/"+sessionId+"/"+handleId,{verb:"POST",withCredentials:withCredentials,body:request,success:function(json){if(Janus.debug("Message sent!"),Janus.debug(json),"success"===json.janus){let plugindata=json.plugindata;if(!plugindata)return Janus.warn("Request succeeded, but missing plugindata..."),void callbacks.success();Janus.log("Synchronous transaction successful ("+plugindata.plugin+")");let data=plugindata.data;return Janus.debug(data),void callbacks.success(data)}"ack"===json.janus?callbacks.success():json.error?(Janus.error("Ooops: "+json.error.code+" "+json.error.reason),callbacks.error(json.error.code+" "+json.error.reason)):(Janus.error("Unknown error"),callbacks.error("Unknown error"))},error:function(textStatus,errorThrown){Janus.error(textStatus+":",errorThrown),callbacks.error(textStatus+": "+errorThrown)}})}function sendTrickleCandidate(handleId,candidate){if(!connected)return void Janus.warn("Is the server down? (connected=false)");let pluginHandle=pluginHandles.get(handleId);if(!pluginHandle||!pluginHandle.webrtcStuff)return void Janus.warn("Invalid handle");let request={janus:"trickle",candidate:candidate,transaction:Janus.randomString(12)};if(pluginHandle.token&&(request.token=pluginHandle.token),apisecret&&(request.apisecret=apisecret),Janus.vdebug("Sending trickle candidate (handle="+handleId+"):"),Janus.vdebug(request),websockets)return request.session_id=sessionId,request.handle_id=handleId,void ws.send(JSON.stringify(request));Janus.httpAPICall(server+"/"+sessionId+"/"+handleId,{verb:"POST",withCredentials:withCredentials,body:request,success:function(json){Janus.vdebug("Candidate sent!"),Janus.vdebug(json),"ack"===json.janus||Janus.error("Ooops: "+json.error.code+" "+json.error.reason)},error:function(textStatus,errorThrown){Janus.error(textStatus+":",errorThrown)}})}function createDataChannel(handleId,dclabel,dcprotocol,incoming,pendingData){let pluginHandle=pluginHandles.get(handleId);if(!pluginHandle||!pluginHandle.webrtcStuff)return void Janus.warn("Invalid handle");let config=pluginHandle.webrtcStuff;if(!config.pc)return void Janus.warn("Invalid PeerConnection");let onDataChannelStateChange=function(event){Janus.log("Received state change on data channel:",event);let label=event.target.label,protocol=event.target.protocol,dcState=config.dataChannel[label]?config.dataChannel[label].readyState:"null";if(Janus.log("State change on <"+label+"> data channel: "+dcState),"open"===dcState){if(config.dataChannel[label].pending&&config.dataChannel[label].pending.length>0){Janus.log("Sending pending messages on <"+label+">:",config.dataChannel[label].pending.length);for(let data of config.dataChannel[label].pending)Janus.log("Sending data on data channel <"+label+">"),Janus.debug(data),config.dataChannel[label].send(data);config.dataChannel[label].pending=[]}pluginHandle.ondataopen(label,protocol)}};if(incoming)config.dataChannel[dclabel]=incoming;else{let dcoptions=config.dataChannelOptions;dcprotocol&&(dcoptions.protocol=dcprotocol),config.dataChannel[dclabel]=config.pc.createDataChannel(dclabel,dcoptions)}config.dataChannel[dclabel].onmessage=function(event){Janus.log("Received message on data channel:",event);let label=event.target.label;pluginHandle.ondata(event.data,label)},config.dataChannel[dclabel].onopen=onDataChannelStateChange,config.dataChannel[dclabel].onclose=onDataChannelStateChange,config.dataChannel[dclabel].onerror=function(error){Janus.error("Got error on data channel:",error)},config.dataChannel[dclabel].pending=[],pendingData&&config.dataChannel[dclabel].pending.push(pendingData)}function sendData(handleId,callbacks){(callbacks=callbacks||{}).success="function"==typeof callbacks.success?callbacks.success:Janus.noop,callbacks.error="function"==typeof callbacks.error?callbacks.error:Janus.noop;let pluginHandle=pluginHandles.get(handleId);if(!pluginHandle||!pluginHandle.webrtcStuff)return Janus.warn("Invalid handle"),void callbacks.error("Invalid handle");let config=pluginHandle.webrtcStuff,data=callbacks.text||callbacks.data;if(!data)return Janus.warn("Invalid data"),void callbacks.error("Invalid data");let label=callbacks.label?callbacks.label:Janus.dataChanDefaultLabel;return config.dataChannel[label]?"open"!==config.dataChannel[label].readyState?(config.dataChannel[label].pending.push(data),void callbacks.success()):(Janus.log("Sending data on data channel <"+label+">"),Janus.debug(data),config.dataChannel[label].send(data),void callbacks.success()):(createDataChannel(handleId,label,callbacks.protocol,!1,data,callbacks.protocol),void callbacks.success())}function sendDtmf(handleId,callbacks){(callbacks=callbacks||{}).success="function"==typeof callbacks.success?callbacks.success:Janus.noop,callbacks.error="function"==typeof callbacks.error?callbacks.error:Janus.noop;let pluginHandle=pluginHandles.get(handleId);if(!pluginHandle||!pluginHandle.webrtcStuff)return Janus.warn("Invalid handle"),void callbacks.error("Invalid handle");let config=pluginHandle.webrtcStuff;if(!config.dtmfSender){if(config.pc){let audioSender=config.pc.getSenders().find((function(sender){return sender.track&&"audio"===sender.track.kind}));if(!audioSender)return Janus.warn("Invalid DTMF configuration (no audio track)"),void callbacks.error("Invalid DTMF configuration (no audio track)");config.dtmfSender=audioSender.dtmf,config.dtmfSender&&(Janus.log("Created DTMF Sender"),config.dtmfSender.ontonechange=function(tone){Janus.debug("Sent DTMF tone: "+tone.tone)})}if(!config.dtmfSender)return Janus.warn("Invalid DTMF configuration"),void callbacks.error("Invalid DTMF configuration")}let dtmf=callbacks.dtmf;if(!dtmf)return Janus.warn("Invalid DTMF parameters"),void callbacks.error("Invalid DTMF parameters");let tones=dtmf.tones;if(!tones)return Janus.warn("Invalid DTMF string"),void callbacks.error("Invalid DTMF string");let duration="number"==typeof dtmf.duration?dtmf.duration:500,gap="number"==typeof dtmf.gap?dtmf.gap:50;Janus.debug("Sending DTMF string "+tones+" (duration "+duration+"ms, gap "+gap+"ms)"),config.dtmfSender.insertDTMF(tones,duration,gap),callbacks.success()}function destroyHandle(handleId,callbacks){(callbacks=callbacks||{}).success="function"==typeof callbacks.success?callbacks.success:Janus.noop,callbacks.error="function"==typeof callbacks.error?callbacks.error:Janus.noop;let noRequest=!0===callbacks.noRequest;Janus.log("Destroying handle "+handleId+" (only-locally="+noRequest+")"),cleanupWebrtc(handleId);let pluginHandle=pluginHandles.get(handleId);if(!pluginHandle||pluginHandle.detached)return pluginHandles.delete(handleId),void callbacks.success();if(pluginHandle.detached=!0,noRequest)return pluginHandles.delete(handleId),void callbacks.success();if(!connected)return Janus.warn("Is the server down? (connected=false)"),void callbacks.error("Is the server down? (connected=false)");let request={janus:"detach",transaction:Janus.randomString(12)};if(pluginHandle.token&&(request.token=pluginHandle.token),apisecret&&(request.apisecret=apisecret),websockets)return request.session_id=sessionId,request.handle_id=handleId,ws.send(JSON.stringify(request)),pluginHandles.delete(handleId),void callbacks.success();Janus.httpAPICall(server+"/"+sessionId+"/"+handleId,{verb:"POST",withCredentials:withCredentials,body:request,success:function(json){Janus.log("Destroyed handle:"),Janus.debug(json),"success"!==json.janus&&Janus.error("Ooops: "+json.error.code+" "+json.error.reason),pluginHandles.delete(handleId),callbacks.success()},error:function(textStatus,errorThrown){Janus.error(textStatus+":",errorThrown),pluginHandles.delete(handleId),callbacks.success()}})}function createPeerconnectionIfNeeded(handleId,callbacks){let pluginHandle=pluginHandles.get(handleId);if(!pluginHandle||!pluginHandle.webrtcStuff)throw Janus.warn("Invalid handle"),"Invalid handle";let config=pluginHandle.webrtcStuff;if(config.pc)return;let pc_config={iceServers:iceServers,iceTransportPolicy:iceTransportPolicy,bundlePolicy:bundlePolicy,sdpSemantics:"unified-plan"},insertableStreams=!1;if(callbacks.tracks)for(let track of callbacks.tracks)if(track.transforms&&(track.transforms.sender||track.transforms.receiver)){insertableStreams=!0;break}callbacks.externalEncryption&&(insertableStreams=!0,config.externalEncryption=!0),RTCRtpSender&&(RTCRtpSender.prototype.createEncodedStreams||RTCRtpSender.prototype.createEncodedAudioStreams&&RTCRtpSender.prototype.createEncodedVideoStreams)&&insertableStreams&&(config.insertableStreams=!0,pc_config.forceEncodedAudioInsertableStreams=!0,pc_config.forceEncodedVideoInsertableStreams=!0,pc_config.encodedInsertableStreams=!0),Janus.log("Creating PeerConnection"),config.pc=new RTCPeerConnection(pc_config),Janus.debug(config.pc),config.pc.getStats&&(config.volume={},config.bitrate.value="0 kbits/sec"),Janus.log("Preparing local SDP and gathering candidates (trickle="+config.trickle+")"),config.pc.oniceconnectionstatechange=function(){config.pc&&pluginHandle.iceState(config.pc.iceConnectionState)},config.pc.onicecandidate=function(event){if(!event.candidate||event.candidate.candidate&&event.candidate.candidate.indexOf("endOfCandidates")>0)Janus.log("End of candidates."),config.iceDone=!0,!0===config.trickle?sendTrickleCandidate(handleId,{completed:!0}):function(handleId,callbacks){(callbacks=callbacks||{}).success="function"==typeof callbacks.success?callbacks.success:Janus.noop,callbacks.error="function"==typeof callbacks.error?callbacks.error:Janus.noop;let pluginHandle=pluginHandles.get(handleId);if(!pluginHandle||!pluginHandle.webrtcStuff)return void Janus.warn("Invalid handle, not sending anything");let config=pluginHandle.webrtcStuff;if(Janus.log("Sending offer/answer SDP..."),!config.mySdp)return void Janus.warn("Local SDP instance is invalid, not sending anything...");config.mySdp={type:config.pc.localDescription.type,sdp:config.pc.localDescription.sdp},!1===config.trickle&&(config.mySdp.trickle=!1);Janus.debug(callbacks),config.sdpSent=!0,callbacks.success(config.mySdp)}(handleId,callbacks);else{let candidate={candidate:event.candidate.candidate,sdpMid:event.candidate.sdpMid,sdpMLineIndex:event.candidate.sdpMLineIndex};!0===config.trickle&&sendTrickleCandidate(handleId,candidate)}},config.pc.ontrack=function(event){if(Janus.log("Handling Remote Track",event),!event.streams)return;if(!event.track)return;let mid=event.transceiver?event.transceiver.mid:event.track.id;try{pluginHandle.onremotetrack(event.track,mid,!0,{reason:"created"})}catch(e){Janus.error("Error calling onremotetrack",e)}if(event.track.onended)return;let trackMutedTimeoutId=null;Janus.log("Adding onended callback to track:",event.track),event.track.onended=function(ev){Janus.log("Remote track removed:",ev),clearTimeout(trackMutedTimeoutId);let transceivers=config.pc?config.pc.getTransceivers():null,transceiver=transceivers?transceivers.find((t=>t.receiver.track===ev.target)):null,mid=transceiver?transceiver.mid:ev.target.id;try{pluginHandle.onremotetrack(ev.target,mid,!1,{reason:"ended"})}catch(e){Janus.error("Error calling onremotetrack on removal",e)}},event.track.onmute=function(ev){Janus.log("Remote track muted:",ev),trackMutedTimeoutId||(trackMutedTimeoutId=setTimeout((function(){Janus.log("Removing remote track");let transceivers=config.pc?config.pc.getTransceivers():null,transceiver=transceivers?transceivers.find((t=>t.receiver.track===ev.target)):null,mid=transceiver?transceiver.mid:ev.target.id;try{pluginHandle.onremotetrack(ev.target,mid,!1,{reason:"mute"})}catch(e){Janus.error("Error calling onremotetrack on mute",e)}trackMutedTimeoutId=null}),2520))},event.track.onunmute=function(ev){if(Janus.log("Remote track flowing again:",ev),null!=trackMutedTimeoutId)clearTimeout(trackMutedTimeoutId),trackMutedTimeoutId=null;else try{let transceivers=config.pc?config.pc.getTransceivers():null,transceiver=transceivers?transceivers.find((t=>t.receiver.track===ev.target)):null,mid=transceiver?transceiver.mid:ev.target.id;pluginHandle.onremotetrack(ev.target,mid,!0,{reason:"unmute"})}catch(e){Janus.error("Error calling onremotetrack on unmute",e)}}}}async function prepareWebrtc(handleId,offer,callbacks){(callbacks=callbacks||{}).success="function"==typeof callbacks.success?callbacks.success:Janus.noop,callbacks.error="function"==typeof callbacks.error?callbacks.error:webrtcError;let jsep=callbacks.jsep;if(offer&&jsep)return Janus.error("Provided a JSEP to a createOffer"),void callbacks.error("Provided a JSEP to a createOffer");if(!(offer||jsep&&jsep.type&&jsep.sdp))return Janus.error("A valid JSEP is required for createAnswer"),void callbacks.error("A valid JSEP is required for createAnswer");if(callbacks.media&&!callbacks.tracks){if(callbacks.tracks=Janus.mediaToTracks(callbacks.media),!0===callbacks.simulcast||!0===callbacks.simulcast2||callbacks.svc)for(let track of callbacks.tracks)if("video"===track.type){!0===callbacks.simulcast||!0===callbacks.simulcast2?track.simulcast=!0:callbacks.svc&&(track.svc=callbacks.svc);break}Janus.warn("Deprecated media object passed, use tracks instead. Automatically translated to:",callbacks.tracks)}if(callbacks.tracks&&!Array.isArray(callbacks.tracks))return Janus.error("Tracks must be an array"),void callbacks.error("Tracks must be an array");let pluginHandle=pluginHandles.get(handleId);if(!pluginHandle||!pluginHandle.webrtcStuff)return Janus.warn("Invalid handle"),void callbacks.error("Invalid handle");let config=pluginHandle.webrtcStuff;var trickle;config.trickle=(trickle=callbacks.trickle,Janus.debug("isTrickleEnabled:",trickle),!1!==trickle);try{if(createPeerconnectionIfNeeded(handleId,callbacks),offer&&await captureDevices(handleId,callbacks),jsep){if(await config.pc.setRemoteDescription(jsep),Janus.log("Remote description accepted!"),config.remoteSdp=jsep.sdp,config.candidates&&config.candidates.length>0){for(let i=0;i<config.candidates.length;i++){let candidate=config.candidates[i];Janus.debug("Adding remote candidate:",candidate),candidate&&!0!==candidate.completed?config.pc.addIceCandidate(candidate):config.pc.addIceCandidate(Janus.endOfCandidates)}config.candidates=[]}await captureDevices(handleId,callbacks);let answer=await async function(handleId,callbacks){(callbacks=callbacks||{}).customizeSdp="function"==typeof callbacks.customizeSdp?callbacks.customizeSdp:Janus.noop;let pluginHandle=pluginHandles.get(handleId);if(!pluginHandle||!pluginHandle.webrtcStuff)throw Janus.warn("Invalid handle"),"Invalid handle";let config=pluginHandle.webrtcStuff;Janus.log("Creating answer (iceDone="+config.iceDone+")");let answer=await config.pc.createAnswer();Janus.debug(answer);let jsep={type:"answer",sdp:answer.sdp};if(callbacks.customizeSdp(jsep),answer.sdp=jsep.sdp,Janus.log("Setting local description"),config.mySdp={type:"answer",sdp:answer.sdp},await config.pc.setLocalDescription(answer),!config.iceDone&&!config.trickle)return Janus.log("Waiting for all candidates..."),null;(config.insertableStreams||config.externalEncryption)&&(answer.e2ee=!0);return answer}(handleId,callbacks);callbacks.success(answer)}else{let offer=await async function(handleId,callbacks){(callbacks=callbacks||{}).customizeSdp="function"==typeof callbacks.customizeSdp?callbacks.customizeSdp:Janus.noop;let pluginHandle=pluginHandles.get(handleId);if(!pluginHandle||!pluginHandle.webrtcStuff)throw Janus.warn("Invalid handle"),"Invalid handle";let config=pluginHandle.webrtcStuff;Janus.log("Creating offer (iceDone="+config.iceDone+")");let mediaConstraints={};!0===callbacks.iceRestart&&(mediaConstraints.iceRestart=!0);Janus.debug(mediaConstraints);let offer=await config.pc.createOffer(mediaConstraints);Janus.debug(offer);let jsep={type:"offer",sdp:offer.sdp};if(callbacks.customizeSdp(jsep),offer.sdp=jsep.sdp,Janus.log("Setting local description"),config.mySdp={type:"offer",sdp:offer.sdp},await config.pc.setLocalDescription(offer),config.mediaConstraints=mediaConstraints,!config.iceDone&&!config.trickle)return Janus.log("Waiting for all candidates..."),null;(config.insertableStreams||config.externalEncryption)&&(offer.e2ee=!0);return offer}(handleId,callbacks);callbacks.success(offer)}}catch(err){Janus.error(err),callbacks.error(err)}}function prepareWebrtcPeer(handleId,callbacks){(callbacks=callbacks||{}).success="function"==typeof callbacks.success?callbacks.success:Janus.noop,callbacks.error="function"==typeof callbacks.error?callbacks.error:webrtcError,callbacks.customizeSdp="function"==typeof callbacks.customizeSdp?callbacks.customizeSdp:Janus.noop;let jsep=callbacks.jsep,pluginHandle=pluginHandles.get(handleId);if(!pluginHandle||!pluginHandle.webrtcStuff)return Janus.warn("Invalid handle"),void callbacks.error("Invalid handle");let config=pluginHandle.webrtcStuff;if(jsep){if(!config.pc)return Janus.warn("Wait, no PeerConnection?? if this is an answer, use createAnswer and not handleRemoteJsep"),void callbacks.error("No PeerConnection: if this is an answer, use createAnswer and not handleRemoteJsep");callbacks.customizeSdp(jsep),config.pc.setRemoteDescription(jsep).then((function(){if(Janus.log("Remote description accepted!"),config.remoteSdp=jsep.sdp,config.candidates&&config.candidates.length>0){for(let i=0;i<config.candidates.length;i++){let candidate=config.candidates[i];Janus.debug("Adding remote candidate:",candidate),candidate&&!0!==candidate.completed?config.pc.addIceCandidate(candidate):config.pc.addIceCandidate(Janus.endOfCandidates)}config.candidates=[]}callbacks.success()}),callbacks.error)}else callbacks.error("Invalid JSEP")}async function replaceTracks(handleId,callbacks){if((callbacks=callbacks||{}).success="function"==typeof callbacks.success?callbacks.success:Janus.noop,callbacks.error="function"==typeof callbacks.error?callbacks.error:Janus.noop,callbacks.tracks&&!Array.isArray(callbacks.tracks))return Janus.error("Tracks must be an array"),void callbacks.error("Tracks must be an array");for(let track of callbacks.tracks)(track.add||!track.replace&&!track.remove)&&(track.replace=!0);try{await captureDevices(handleId,callbacks),callbacks.success()}catch(err){Janus.error(err),callbacks.error(err)}}async function captureDevices(handleId,callbacks){let pluginHandle=pluginHandles.get(handleId);if(!pluginHandle||!pluginHandle.webrtcStuff)throw Janus.warn("Invalid handle, not sending anything"),"Invalid handle";let config=pluginHandle.webrtcStuff;if(!config.pc)throw Janus.warn("Invalid PeerConnection"),"Invalid PeerConnection";let tracks=callbacks.tracks;if(!tracks||!Array.isArray(tracks)||0===tracks.length)return;let openedConsentDialog=!1,groups={};for(let track of tracks){if(delete track.gumGroup,!track.type||!["audio","video"].includes(track.type))continue;if(!track.capture||track.capture instanceof MediaStreamTrack)continue;let group=track.group?track.group:"default";groups[group]||(groups[group]={}),groups[group][track.type]||(track.gumGroup=group,groups[group][track.type]=track)}let keys=Object.keys(groups);for(let key of keys){let group=groups[key];group.audio&&group.video||(group.audio&&delete group.audio.gumGroup,group.video&&delete group.video.gumGroup,delete groups[key])}let answer=!!callbacks.jsep;for(let track of tracks){if(!track.type){Janus.warn("Missing track type:",track);continue}if("data"===track.type){if(config.pc.ondatachannel){Janus.warn("Data channel exists already, not creating another one");continue}Janus.log("Creating default data channel"),createDataChannel(handleId,Janus.dataChanDefaultLabel,null,!1),config.pc.ondatachannel=function(event){Janus.log("Data channel created by Janus:",event),createDataChannel(handleId,event.channel.label,event.channel.protocol,event.channel)};continue}if(void 0!==track.add&&null!==track.add||void 0!==track.remove&&null!==track.remove||void 0!==track.replace&&null!==track.replace||(track.add=!0),track.add&&track.remove||track.add&&track.remove&&track.replace){Janus.warn("Conflicting actions for track, ignoring:",track);continue}track.add&&track.replace?(Janus.warn("Both add and replace provided, falling back to replace:",track),delete track.add):track.remove&&track.replace&&(Janus.warn("Both remove and replace provided, falling back to remove:",track),delete track.replace);let kind=track.type;"screen"===track.type&&(kind="video");let transceiver=null,sender=null;if(transceiver=track.mid?config.pc.getTransceivers().find((t=>t.mid===track.mid&&t.receiver.track.kind===kind)):config.pc.getTransceivers().find((t=>t.receiver.track.kind===kind)),track.replace||track.remove){if(!transceiver){Janus.warn("Couldn't find a transceiver for track:",track);continue}if(!transceiver.sender){Janus.warn("No sender in the transceiver for track:",track);continue}sender=transceiver.sender}if(answer&&!transceiver&&(transceiver=config.pc.getTransceivers().find((t=>t.receiver.track.kind===kind)),!transceiver)){Janus.warn("Couldn't find a transceiver for track:",track);continue}let nt=null,trackId=null;if((track.remove||track.replace)&&(Janus.log("Removing track from PeerConnection",track),trackId=sender.track?sender.track.id:null,await sender.replaceTrack(null),trackId&&config.myStream)){let rt=null;if("audio"===kind&&config.myStream.getAudioTracks()&&config.myStream.getAudioTracks().length)for(let t of config.myStream.getAudioTracks())t.id===trackId&&(rt=t,Janus.log("Removing audio track:",rt));else if("video"===kind&&config.myStream.getVideoTracks()&&config.myStream.getVideoTracks().length)for(let t of config.myStream.getVideoTracks())t.id===trackId&&(rt=t,Janus.log("Removing video track:",rt));if(rt){try{config.myStream.removeTrack(rt),pluginHandle.onlocaltrack(rt,!1)}catch(e){Janus.error("Error calling onlocaltrack on removal for renegotiation",e)}if(!0!==rt.dontStop)try{rt.stop()}catch(e){}}}if(track.capture){if(track.gumGroup&&groups[track.gumGroup]&&groups[track.gumGroup].stream){let stream=groups[track.gumGroup].stream;nt="audio"===track.type?stream.getAudioTracks()[0]:stream.getVideoTracks()[0],delete groups[track.gumGroup].stream,delete groups[track.gumGroup],delete track.gumGroup}else if(track.capture instanceof MediaStreamTrack)nt=track.capture;else{openedConsentDialog||(openedConsentDialog=!0,pluginHandle.consentDialog(!0));let constraints=Janus.trackConstraints(track),stream=null;if("audio"===track.type||"video"===track.type){if(track.gumGroup){let otherType="audio"===track.type?"video":"audio";if(groups[track.gumGroup]&&groups[track.gumGroup][otherType]){let otherTrack=groups[track.gumGroup][otherType],otherConstraints=Janus.trackConstraints(otherTrack);constraints[otherType]=otherConstraints[otherType]}}stream=await navigator.mediaDevices.getUserMedia(constraints),track.gumGroup&&constraints.audio&&constraints.video&&(groups[track.gumGroup].stream=stream,delete track.gumGroup)}else stream=await navigator.mediaDevices.getDisplayMedia(constraints);nt="audio"===track.type?stream.getAudioTracks()[0]:stream.getVideoTracks()[0]}if(track.replace){await sender.replaceTrack(nt);let newDirection="sendrecv";!1!==track.recv&&"inactive"!==transceiver.direction&&"sendonly"!==transceiver.direction||(newDirection="sendonly"),transceiver.setDirection?transceiver.setDirection(newDirection):transceiver.direction=newDirection}else{if(config.myStream||(config.myStream=new MediaStream),"audio"===kind||!track.simulcast&&!track.svc)sender=config.pc.addTrack(nt,config.myStream),transceiver=config.pc.getTransceivers().find((t=>t.sender===sender));else if(track.simulcast){if("firefox"!==Janus.webRTCAdapter.browserDetails.browser){Janus.log("Enabling rid-based simulcasting:",nt);let maxBitrates=getMaxBitrates(track.simulcastMaxBitrates);transceiver=config.pc.addTransceiver(nt,{direction:"sendrecv",streams:[config.myStream],sendEncodings:track.sendEncodings||[{rid:"h",active:!0,scalabilityMode:"L1T2",maxBitrate:maxBitrates.high},{rid:"m",active:!0,scalabilityMode:"L1T2",maxBitrate:maxBitrates.medium,scaleResolutionDownBy:2},{rid:"l",active:!0,scalabilityMode:"L1T2",maxBitrate:maxBitrates.low,scaleResolutionDownBy:4}]})}else if(Janus.log("Enabling Simulcasting for Firefox (RID)"),transceiver=config.pc.addTransceiver(nt,{direction:"sendrecv",streams:[config.myStream]}),sender=transceiver?transceiver.sender:null,sender){let parameters=sender.getParameters();parameters||(parameters={});let maxBitrates=getMaxBitrates(track.simulcastMaxBitrates);parameters.encodings=track.sendEncodings||[{rid:"h",active:!0,maxBitrate:maxBitrates.high},{rid:"m",active:!0,maxBitrate:maxBitrates.medium,scaleResolutionDownBy:2},{rid:"l",active:!0,maxBitrate:maxBitrates.low,scaleResolutionDownBy:4}],sender.setParameters(parameters)}}else Janus.log("Enabling SVC ("+track.svc+"):",nt),transceiver=config.pc.addTransceiver(nt,{direction:"sendrecv",streams:[config.myStream],sendEncodings:[{scalabilityMode:track.svc}]});if(sender||(sender=transceiver?transceiver.sender:null),track.codec)if("firefox"===Janus.webRTCAdapter.browserDetails.browser)Janus.warn("setCodecPreferences not supported in Firefox, ignoring codec for track:",track);else if("string"!=typeof track.codec)Janus.warn("Invalid codec value, ignoring for track:",track);else{let mimeType=kind+"/"+track.codec.toLowerCase(),codecs=RTCRtpReceiver.getCapabilities(kind).codecs.filter((function(codec){return codec.mimeType.toLowerCase()===mimeType}));if(codecs&&0!==codecs.length){if(transceiver)try{transceiver.setCodecPreferences(codecs)}catch(err){Janus.warn("Failed enforcing codec for this "+kind+" track:",err)}}else Janus.warn("Codec not supported in this browser for this track, ignoring:",track)}if(track.bitrate)if(track.simulcast||track.svc)Janus.warn("Ignoring bitrate for simulcast/SVC track, use sendEncodings for that");else if(isNaN(track.bitrate)||track.bitrate<0)Janus.warn("Ignoring invalid bitrate for track:",track);else if(sender){let params=sender.getParameters();params&&params.encodings&&0!==params.encodings.length?(params.encodings[0].maxBitrate=track.bitrate,await sender.setParameters(params)):Janus.warn("No encodings in the sender parameters, ignoring bitrate for track:",track)}if("video"===kind&&track.framerate)if(track.simulcast||track.svc)Janus.warn("Ignoring framerate for simulcast/SVC track, use sendEncodings for that");else if(isNaN(track.framerate)||track.framerate<0)Janus.warn("Ignoring invalid framerate for track:",track);else if(sender){let params=sender.getParameters();params&&params.encodings&&0!==params.encodings.length?(params.encodings[0].maxFramerate=track.framerate,await sender.setParameters(params)):Janus.warn("No encodings in the sender parameters, ignoring framerate for track:",track)}if(track.transforms){if(sender&&track.transforms.sender){let senderStreams=null;RTCRtpSender.prototype.createEncodedStreams?senderStreams=sender.createEncodedStreams():(RTCRtpSender.prototype.createAudioEncodedStreams||RTCRtpSender.prototype.createEncodedVideoStreams)&&("audio"===kind?senderStreams=sender.createEncodedAudioStreams():"video"===kind&&(senderStreams=sender.createEncodedVideoStreams())),senderStreams&&(senderStreams.readableStream&&senderStreams.writableStream?senderStreams.readableStream.pipeThrough(track.transforms.sender).pipeTo(senderStreams.writableStream):senderStreams.readable&&senderStreams.writable&&senderStreams.readable.pipeThrough(track.transforms.sender).pipeTo(senderStreams.writable))}if(transceiver&&transceiver.receiver&&track.transforms.receiver){let receiverStreams=null;RTCRtpReceiver.prototype.createEncodedStreams?receiverStreams=transceiver.receiver.createEncodedStreams():(RTCRtpReceiver.prototype.createAudioEncodedStreams||RTCRtpReceiver.prototype.createEncodedVideoStreams)&&("audio"===kind?receiverStreams=transceiver.receiver.createEncodedAudioStreams():"video"===kind&&(receiverStreams=transceiver.receiver.createEncodedVideoStreams())),receiverStreams&&(receiverStreams.readableStream&&receiverStreams.writableStream?receiverStreams.readableStream.pipeThrough(track.transforms.receiver).pipeTo(receiverStreams.writableStream):receiverStreams.readable&&receiverStreams.writable&&receiverStreams.readable.pipeThrough(track.transforms.receiver).pipeTo(receiverStreams.writable))}}}nt&&!0===track.dontStop&&(nt.dontStop=!0)}else if(track.recv&&(transceiver||(transceiver=config.pc.addTransceiver(kind)),transceiver)){if(track.codec)if("firefox"===Janus.webRTCAdapter.browserDetails.browser)Janus.warn("setCodecPreferences not supported in Firefox, ignoring codec for track:",track);else if("string"!=typeof track.codec)Janus.warn("Invalid codec value, ignoring for track:",track);else{let mimeType=kind+"/"+track.codec.toLowerCase(),codecs=RTCRtpReceiver.getCapabilities(kind).codecs.filter((function(codec){return codec.mimeType.toLowerCase()===mimeType}));if(codecs&&0!==codecs.length)try{transceiver.setCodecPreferences(codecs)}catch(err){Janus.warn("Failed enforcing codec for this "+kind+" track:",err)}else Janus.warn("Codec not supported in this browser for this track, ignoring:",track)}if(transceiver.receiver&&track.transforms&&track.transforms.receiver){let receiverStreams=null;RTCRtpReceiver.prototype.createEncodedStreams?receiverStreams=transceiver.receiver.createEncodedStreams():(RTCRtpReceiver.prototype.createAudioEncodedStreams||RTCRtpReceiver.prototype.createEncodedVideoStreams)&&("audio"===kind?receiverStreams=transceiver.receiver.createEncodedAudioStreams():"video"===kind&&(receiverStreams=transceiver.receiver.createEncodedVideoStreams())),receiverStreams&&(receiverStreams.readableStream&&receiverStreams.writableStream?receiverStreams.readableStream.pipeThrough(track.transforms.receiver).pipeTo(receiverStreams.writableStream):receiverStreams.readable&&receiverStreams.writable&&receiverStreams.readable.pipeThrough(track.transforms.receiver).pipeTo(receiverStreams.writable))}}if(nt){config.myStream.addTrack(nt),nt.onended=function(ev){Janus.log("Local track removed:",ev);try{pluginHandle.onlocaltrack(ev.target,!1)}catch(e){Janus.error("Error calling onlocaltrack following end",e)}};try{pluginHandle.onlocaltrack(nt,!0)}catch(e){Janus.error("Error calling onlocaltrack for track add",e)}}if(transceiver){let curdir=transceiver.direction,newdir=null,send=nt&&transceiver.sender.track,recv=!1!==track.recv&&transceiver.receiver.track;send&&recv?newdir="sendrecv":send&&!recv?newdir="sendonly":!send&&recv?newdir="recvonly":send||recv||(newdir="inactive"),newdir&&newdir!==curdir&&(Janus.warn("Changing direction of transceiver to "+newdir+" (was "+curdir+")",track),transceiver.setDirection?transceiver.setDirection(newdir):transceiver.direction=newdir)}}openedConsentDialog&&pluginHandle.consentDialog(!1)}function getLocalTracks(handleId){let pluginHandle=pluginHandles.get(handleId);if(!pluginHandle||!pluginHandle.webrtcStuff)return Janus.warn("Invalid handle"),null;let config=pluginHandle.webrtcStuff;if(!config.pc)return Janus.warn("Invalid PeerConnection"),null;let tracks=[],transceivers=config.pc.getTransceivers();for(let tr of transceivers){let track=null;tr.sender&&tr.sender.track&&(track={mid:tr.mid},track.type=tr.sender.track.kind,track.id=tr.sender.track.id,track.label=tr.sender.track.label),track&&tracks.push(track)}return tracks}function getRemoteTracks(handleId){let pluginHandle=pluginHandles.get(handleId);if(!pluginHandle||!pluginHandle.webrtcStuff)return Janus.warn("Invalid handle"),null;let config=pluginHandle.webrtcStuff;if(!config.pc)return Janus.warn("Invalid PeerConnection"),null;let tracks=[],transceivers=config.pc.getTransceivers();for(let tr of transceivers){let track=null;tr.receiver&&tr.receiver.track&&(track={mid:tr.mid},track.type=tr.receiver.track.kind,track.id=tr.receiver.track.id,track.label=tr.receiver.track.label),track&&tracks.push(track)}return tracks}function getVolume(handleId,mid,remote,result){result="function"==typeof result?result:Janus.noop;let pluginHandle=pluginHandles.get(handleId);if(!pluginHandle||!pluginHandle.webrtcStuff)return Janus.warn("Invalid handle"),void result(0);let stream=remote?"remote":"local",config=pluginHandle.webrtcStuff;if(config.volume[stream]||(config.volume[stream]={value:0}),config.pc&&config.pc.getStats&&("chrome"===Janus.webRTCAdapter.browserDetails.browser||"safari"===Janus.webRTCAdapter.browserDetails.browser)){let query=config.pc;if(mid){let transceiver=config.pc.getTransceivers().find((t=>t.mid===mid&&"audio"===t.receiver.track.kind));if(!transceiver)return Janus.warn("No audio transceiver with mid "+mid),void result(0);if(remote&&!transceiver.receiver)return Janus.warn("Remote transceiver track unavailable"),void result(0);if(!remote&&!transceiver.sender)return Janus.warn("Local transceiver track unavailable"),void result(0);query=remote?transceiver.receiver:transceiver.sender}return query.getStats().then((function(stats){stats.forEach((function(res){res&&"audio"===res.kind&&(remote&&!res.remoteSource||!remote&&"media-source"!==res.type||result(res.audioLevel?res.audioLevel:0))}))})),config.volume[stream].value}return Janus.warn("Getting the "+stream+" volume unsupported by browser"),void result(0)}function isMuted(handleId,mid,video){let pluginHandle=pluginHandles.get(handleId);if(!pluginHandle||!pluginHandle.webrtcStuff)return Janus.warn("Invalid handle"),!0;let config=pluginHandle.webrtcStuff;if(!config.pc)return Janus.warn("Invalid PeerConnection"),!0;if(!config.myStream)return Janus.warn("Invalid local MediaStream"),!0;if(video){if(!config.myStream.getVideoTracks()||0===config.myStream.getVideoTracks().length)return Janus.warn("No video track"),!0;if(mid){let transceiver=config.pc.getTransceivers().find((t=>t.mid===mid&&"video"===t.receiver.track.kind));return transceiver?transceiver.sender&&transceiver.sender.track?!transceiver.sender.track.enabled:(Janus.warn("No video sender with mid "+mid),!0):(Janus.warn("No video transceiver with mid "+mid),!0)}return!config.myStream.getVideoTracks()[0].enabled}if(!config.myStream.getAudioTracks()||0===config.myStream.getAudioTracks().length)return Janus.warn("No audio track"),!0;if(mid){let transceiver=config.pc.getTransceivers().find((t=>t.mid===mid&&"audio"===t.receiver.track.kind));return transceiver?transceiver.sender&&transceiver.sender.track?!transceiver.sender.track.enabled:(Janus.warn("No audio sender with mid "+mid),!0):(Janus.warn("No audio transceiver with mid "+mid),!0)}return!config.myStream.getAudioTracks()[0].enabled}function mute(handleId,mid,video,mute){let pluginHandle=pluginHandles.get(handleId);if(!pluginHandle||!pluginHandle.webrtcStuff)return Janus.warn("Invalid handle"),!1;let config=pluginHandle.webrtcStuff;if(!config.pc)return Janus.warn("Invalid PeerConnection"),!1;if(!config.myStream)return Janus.warn("Invalid local MediaStream"),!1;if(video){if(!config.myStream.getVideoTracks()||0===config.myStream.getVideoTracks().length)return Janus.warn("No video track"),!1;if(mid){let transceiver=config.pc.getTransceivers().find((t=>t.mid===mid&&"video"===t.receiver.track.kind));if(!transceiver)return Janus.warn("No video transceiver with mid "+mid),!1;if(!transceiver.sender||!transceiver.sender.track)return Janus.warn("No video sender with mid "+mid),!1;transceiver.sender.track.enabled=!mute}else for(const videostream of config.myStream.getVideoTracks())videostream.enabled=!mute}else{if(!config.myStream.getAudioTracks()||0===config.myStream.getAudioTracks().length)return Janus.warn("No audio track"),!1;if(mid){let transceiver=config.pc.getTransceivers().find((t=>t.mid===mid&&"audio"===t.receiver.track.kind));if(!transceiver)return Janus.warn("No audio transceiver with mid "+mid),!1;if(!transceiver.sender||!transceiver.sender.track)return Janus.warn("No audio sender with mid "+mid),!1;transceiver.sender.track.enabled=!mute}else for(const audiostream of config.myStream.getAudioTracks())audiostream.enabled=!mute}return!0}function getBitrate(handleId,mid){let pluginHandle=pluginHandles.get(handleId);if(!pluginHandle||!pluginHandle.webrtcStuff)return Janus.warn("Invalid handle"),"Invalid handle";let config=pluginHandle.webrtcStuff;if(!config.pc)return"Invalid PeerConnection";if(config.pc.getStats){let query=config.pc,target=mid||"default";if(mid){let transceiver=config.pc.getTransceivers().find((t=>t.mid===mid&&"video"===t.receiver.track.kind));if(!transceiver)return Janus.warn("No video transceiver with mid "+mid),"No video transceiver with mid "+mid;if(!transceiver.receiver)return Janus.warn("No video receiver with mid "+mid),"No video receiver with mid "+mid;query=transceiver.receiver}return config.bitrate[target]||(config.bitrate[target]={timer:null,bsnow:null,bsbefore:null,tsnow:null,tsbefore:null,value:"0 kbits/sec"}),config.bitrate[target].timer?config.bitrate[target].value:(Janus.log("Starting bitrate timer"+(mid?" for mid "+mid:"")+" (via getStats)"),config.bitrate[target].timer=setInterval((function(){query.getStats().then((function(stats){stats.forEach((function(res){if(!res)return;let inStats=!1;if(("video"===res.mediaType||res.id.toLowerCase().indexOf("video")>-1)&&"inbound-rtp"===res.type&&res.id.indexOf("rtcp")<0?inStats=!0:"ssrc"!=res.type||!res.bytesReceived||"VP8"!==res.googCodecName&&""!==res.googCodecName||(inStats=!0),inStats)if(config.bitrate[target].bsnow=res.bytesReceived,config.bitrate[target].tsnow=res.timestamp,null===config.bitrate[target].bsbefore||null===config.bitrate[target].tsbefore)config.bitrate[target].bsbefore=config.bitrate[target].bsnow,config.bitrate[target].tsbefore=config.bitrate[target].tsnow;else{let timePassed=config.bitrate[target].tsnow-config.bitrate[target].tsbefore;"safari"===Janus.webRTCAdapter.browserDetails.browser&&(timePassed/=1e3);let bitRate=Math.round(8*(config.bitrate[target].bsnow-config.bitrate[target].bsbefore)/timePassed);"safari"===Janus.webRTCAdapter.browserDetails.browser&&(bitRate=parseInt(bitRate/1e3)),config.bitrate[target].value=bitRate+" kbits/sec",config.bitrate[target].bsbefore=config.bitrate[target].bsnow,config.bitrate[target].tsbefore=config.bitrate[target].tsnow}}))}))}),1e3),"0 kbits/sec")}return Janus.warn("Getting the video bitrate unsupported by browser"),"Feature unsupported by browser"}function setBitrate(handleId,mid,bitrate){let pluginHandle=pluginHandles.get(handleId);if(!pluginHandle||!pluginHandle.webrtcStuff)return void Janus.warn("Invalid handle");let config=pluginHandle.webrtcStuff;if(!config.pc)return void Janus.warn("Invalid PeerConnection");let transceiver=config.pc.getTransceivers().find((t=>t.mid===mid));if(!transceiver)return void Janus.warn("No transceiver with mid",mid);if(!transceiver.sender)return void Janus.warn("No sender for transceiver with mid",mid);let params=transceiver.sender.getParameters();params&&params.encodings&&0!==params.encodings.length?params.encodings.length>1?Janus.warn("Ignoring bitrate for simulcast track, use sendEncodings for that"):isNaN(bitrate)||bitrate<0?Janus.warn("Invalid bitrate (must be a positive integer)"):(params.encodings[0].maxBitrate=bitrate,transceiver.sender.setParameters(params)):Janus.warn("No parameters encodings")}function webrtcError(error){Janus.error("WebRTC error:",error)}function cleanupWebrtc(handleId,hangupRequest){Janus.log("Cleaning WebRTC stuff");let pluginHandle=pluginHandles.get(handleId);if(!pluginHandle)return;let config=pluginHandle.webrtcStuff;if(config){if(!0===hangupRequest){let request={janus:"hangup",transaction:Janus.randomString(12)};pluginHandle.token&&(request.token=pluginHandle.token),apisecret&&(request.apisecret=apisecret),Janus.debug("Sending hangup request (handle="+handleId+"):"),Janus.debug(request),websockets?(request.session_id=sessionId,request.handle_id=handleId,ws.send(JSON.stringify(request))):Janus.httpAPICall(server+"/"+sessionId+"/"+handleId,{verb:"POST",withCredentials:withCredentials,body:request})}config.volume&&(config.volume.local&&config.volume.local.timer&&clearInterval(config.volume.local.timer),config.volume.remote&&config.volume.remote.timer&&clearInterval(config.volume.remote.timer));for(let i in config.bitrate)config.bitrate[i].timer&&clearInterval(config.bitrate[i].timer);config.bitrate={},!config.streamExternal&&config.myStream&&(Janus.log("Stopping local stream tracks"),Janus.stopAllTracks(config.myStream)),config.streamExternal=!1,config.myStream=null;try{config.pc.close()}catch(e){}config.pc=null,config.candidates=null,config.mySdp=null,config.remoteSdp=null,config.iceDone=!1,config.dataChannel={},config.dtmfSender=null,config.insertableStreams=!1,config.externalEncryption=!1}pluginHandle.oncleanup()}createSession(gatewayCallbacks),this.getServer=function(){return server},this.isConnected=function(){return connected},this.reconnect=function(callbacks){(callbacks=callbacks||{}).success="function"==typeof callbacks.success?callbacks.success:Janus.noop,callbacks.error="function"==typeof callbacks.error?callbacks.error:Janus.noop,callbacks.reconnect=!0,createSession(callbacks)},this.getSessionId=function(){return sessionId},this.getInfo=function(callbacks){!function(callbacks){if((callbacks=callbacks||{}).success="function"==typeof callbacks.success?callbacks.success:Janus.noop,callbacks.error="function"==typeof callbacks.error?callbacks.error:Janus.noop,Janus.log("Getting info on Janus instance"),!connected)return Janus.warn("Is the server down? (connected=false)"),void callbacks.error("Is the server down? (connected=false)");let transaction=Janus.randomString(12),request={janus:"info",transaction:transaction};token&&(request.token=token);apisecret&&(request.apisecret=apisecret);if(websockets)return transactions.set(transaction,(function(json){Janus.log("Server info:"),Janus.debug(json),"server_info"!==json.janus&&Janus.error("Ooops: "+json.error.code+" "+json.error.reason),callbacks.success(json)})),void ws.send(JSON.stringify(request));Janus.httpAPICall(server,{verb:"POST",withCredentials:withCredentials,body:request,success:function(json){Janus.log("Server info:"),Janus.debug(json),"server_info"!==json.janus&&Janus.error("Ooops: "+json.error.code+" "+json.error.reason),callbacks.success(json)},error:function(textStatus,errorThrown){Janus.error(textStatus+":",errorThrown),""===errorThrown?callbacks.error(textStatus+": Is the server down?"):callbacks.error(textStatus+": "+errorThrown)}})}(callbacks)},this.destroy=function(callbacks){!function(callbacks){(callbacks=callbacks||{}).success="function"==typeof callbacks.success?callbacks.success:Janus.noop,callbacks.error="function"==typeof callbacks.error?callbacks.error:Janus.noop;let unload=!0===callbacks.unload,notifyDestroyed=!0;void 0!==callbacks.notifyDestroyed&&null!==callbacks.notifyDestroyed&&(notifyDestroyed=!0===callbacks.notifyDestroyed);let cleanupHandles=!0===callbacks.cleanupHandles;if(Janus.log("Destroying session "+sessionId+" (unload="+unload+")"),!sessionId)return Janus.warn("No session to destroy"),callbacks.success(),void(notifyDestroyed&&gatewayCallbacks.destroyed());if(cleanupHandles)for(const handleId of pluginHandles.keys())destroyHandle(handleId,{noRequest:!0});if(!connected)return Janus.warn("Is the server down? (connected=false)"),sessionId=null,void callbacks.success();let request={janus:"destroy",transaction:Janus.randomString(12)};token&&(request.token=token);apisecret&&(request.apisecret=apisecret);if(unload)return websockets?(ws.onclose=null,ws.close(),ws=null):navigator.sendBeacon(server+"/"+sessionId,JSON.stringify(request)),Janus.log("Destroyed session:"),sessionId=null,connected=!1,callbacks.success(),void(notifyDestroyed&&gatewayCallbacks.destroyed());if(websockets){request.session_id=sessionId;let unbindWebSocket=function(){for(let eventName in wsHandlers)ws.removeEventListener(eventName,wsHandlers[eventName]);ws.removeEventListener("message",onUnbindMessage),ws.removeEventListener("error",onUnbindError),wsKeepaliveTimeoutId&&clearTimeout(wsKeepaliveTimeoutId),ws.close()},onUnbindMessage=function(event){let data=JSON.parse(event.data);data.session_id==request.session_id&&data.transaction==request.transaction&&(unbindWebSocket(),callbacks.success(),notifyDestroyed&&gatewayCallbacks.destroyed())},onUnbindError=function(){unbindWebSocket(),callbacks.error("Failed to destroy the server: Is the server down?"),notifyDestroyed&&gatewayCallbacks.destroyed()};return ws.addEventListener("message",onUnbindMessage),ws.addEventListener("error",onUnbindError),void(1===ws.readyState?ws.send(JSON.stringify(request)):onUnbindError())}Janus.httpAPICall(server+"/"+sessionId,{verb:"POST",withCredentials:withCredentials,body:request,success:function(json){Janus.log("Destroyed session:"),Janus.debug(json),sessionId=null,connected=!1,"success"!==json.janus&&Janus.error("Ooops: "+json.error.code+" "+json.error.reason),callbacks.success(),notifyDestroyed&&gatewayCallbacks.destroyed()},error:function(textStatus,errorThrown){Janus.error(textStatus+":",errorThrown),sessionId=null,connected=!1,callbacks.success(),notifyDestroyed&&gatewayCallbacks.destroyed()}})}(callbacks)},this.attach=function(callbacks){!function(callbacks){if((callbacks=callbacks||{}).success="function"==typeof callbacks.success?callbacks.success:Janus.noop,callbacks.error="function"==typeof callbacks.error?callbacks.error:Janus.noop,callbacks.dataChannelOptions=callbacks.dataChannelOptions||{ordered:!0},callbacks.consentDialog="function"==typeof callbacks.consentDialog?callbacks.consentDialog:Janus.noop,callbacks.iceState="function"==typeof callbacks.iceState?callbacks.iceState:Janus.noop,callbacks.mediaState="function"==typeof callbacks.mediaState?callbacks.mediaState:Janus.noop,callbacks.webrtcState="function"==typeof callbacks.webrtcState?callbacks.webrtcState:Janus.noop,callbacks.slowLink="function"==typeof callbacks.slowLink?callbacks.slowLink:Janus.noop,callbacks.onmessage="function"==typeof callbacks.onmessage?callbacks.onmessage:Janus.noop,callbacks.onlocaltrack="function"==typeof callbacks.onlocaltrack?callbacks.onlocaltrack:Janus.noop,callbacks.onremotetrack="function"==typeof callbacks.onremotetrack?callbacks.onremotetrack:Janus.noop,callbacks.ondata="function"==typeof callbacks.ondata?callbacks.ondata:Janus.noop,callbacks.ondataopen="function"==typeof callbacks.ondataopen?callbacks.ondataopen:Janus.noop,callbacks.oncleanup="function"==typeof callbacks.oncleanup?callbacks.oncleanup:Janus.noop,callbacks.ondetached="function"==typeof callbacks.ondetached?callbacks.ondetached:Janus.noop,!connected)return Janus.warn("Is the server down? (connected=false)"),void callbacks.error("Is the server down? (connected=false)");let plugin=callbacks.plugin;if(!plugin)return Janus.error("Invalid plugin"),void callbacks.error("Invalid plugin");let opaqueId=callbacks.opaqueId,loopIndex=callbacks.loopIndex,handleToken=callbacks.token?callbacks.token:token,transaction=Janus.randomString(12),request={janus:"attach",plugin:plugin,opaque_id:opaqueId,loop_index:loopIndex,transaction:transaction};handleToken&&(request.token=handleToken);apisecret&&(request.apisecret=apisecret);if(websockets)return transactions.set(transaction,(function(json){if(Janus.debug(json),"success"!==json.janus)return Janus.error("Ooops: "+json.error.code+" "+json.error.reason),void callbacks.error("Ooops: "+json.error.code+" "+json.error.reason);let handleId=json.data.id;Janus.log("Created handle: "+handleId);let pluginHandle={session:that,plugin:plugin,id:handleId,token:handleToken,detached:!1,webrtcStuff:{started:!1,myStream:null,streamExternal:!1,mySdp:null,mediaConstraints:null,pc:null,dataChannelOptions:callbacks.dataChannelOptions,dataChannel:{},dtmfSender:null,trickle:!0,iceDone:!1,bitrate:{}},getId:function(){return handleId},getPlugin:function(){return plugin},getVolume:function(mid,result){return getVolume(handleId,mid,!0,result)},getRemoteVolume:function(mid,result){return getVolume(handleId,mid,!0,result)},getLocalVolume:function(mid,result){return getVolume(handleId,mid,!1,result)},isAudioMuted:function(mid){return isMuted(handleId,mid,!1)},muteAudio:function(mid){return mute(handleId,mid,!1,!0)},unmuteAudio:function(mid){return mute(handleId,mid,!1,!1)},isVideoMuted:function(mid){return isMuted(handleId,mid,!0)},muteVideo:function(mid){return mute(handleId,mid,!0,!0)},unmuteVideo:function(mid){return mute(handleId,mid,!0,!1)},getBitrate:function(mid){return getBitrate(handleId,mid)},setMaxBitrate:function(mid,bitrate){return setBitrate(handleId,mid,bitrate)},send:function(callbacks){sendMessage(handleId,callbacks)},data:function(callbacks){sendData(handleId,callbacks)},dtmf:function(callbacks){sendDtmf(handleId,callbacks)},consentDialog:callbacks.consentDialog,iceState:callbacks.iceState,mediaState:callbacks.mediaState,webrtcState:callbacks.webrtcState,slowLink:callbacks.slowLink,onmessage:callbacks.onmessage,createOffer:function(callbacks){prepareWebrtc(handleId,!0,callbacks)},createAnswer:function(callbacks){prepareWebrtc(handleId,!1,callbacks)},handleRemoteJsep:function(callbacks){prepareWebrtcPeer(handleId,callbacks)},replaceTracks:function(callbacks){replaceTracks(handleId,callbacks)},getLocalTracks:function(){return getLocalTracks(handleId)},getRemoteTracks:function(){return getRemoteTracks(handleId)},onlocaltrack:callbacks.onlocaltrack,onremotetrack:callbacks.onremotetrack,ondata:callbacks.ondata,ondataopen:callbacks.ondataopen,oncleanup:callbacks.oncleanup,ondetached:callbacks.ondetached,hangup:function(sendRequest){cleanupWebrtc(handleId,!0===sendRequest)},detach:function(callbacks){destroyHandle(handleId,callbacks)}};pluginHandles.set(handleId,pluginHandle),callbacks.success(pluginHandle)})),request.session_id=sessionId,void ws.send(JSON.stringify(request));Janus.httpAPICall(server+"/"+sessionId,{verb:"POST",withCredentials:withCredentials,body:request,success:function(json){if(Janus.debug(json),"success"!==json.janus)return Janus.error("Ooops: "+json.error.code+" "+json.error.reason),void callbacks.error("Ooops: "+json.error.code+" "+json.error.reason);let handleId=json.data.id;Janus.log("Created handle: "+handleId);let pluginHandle={session:that,plugin:plugin,id:handleId,token:handleToken,detached:!1,webrtcStuff:{started:!1,myStream:null,streamExternal:!1,mySdp:null,mediaConstraints:null,pc:null,dataChannelOptions:callbacks.dataChannelOptions,dataChannel:{},dtmfSender:null,trickle:!0,iceDone:!1,bitrate:{}},getId:function(){return handleId},getPlugin:function(){return plugin},getVolume:function(mid,result){return getVolume(handleId,mid,!0,result)},getRemoteVolume:function(mid,result){return getVolume(handleId,mid,!0,result)},getLocalVolume:function(mid,result){return getVolume(handleId,mid,!1,result)},isAudioMuted:function(mid){return isMuted(handleId,mid,!1)},muteAudio:function(mid){return mute(handleId,mid,!1,!0)},unmuteAudio:function(mid){return mute(handleId,mid,!1,!1)},isVideoMuted:function(mid){return isMuted(handleId,mid,!0)},muteVideo:function(mid){return mute(handleId,mid,!0,!0)},unmuteVideo:function(mid){return mute(handleId,mid,!0,!1)},getBitrate:function(mid){return getBitrate(handleId,mid)},setMaxBitrate:function(mid,bitrate){return setBitrate(handleId,mid,bitrate)},send:function(callbacks){sendMessage(handleId,callbacks)},data:function(callbacks){sendData(handleId,callbacks)},dtmf:function(callbacks){sendDtmf(handleId,callbacks)},consentDialog:callbacks.consentDialog,iceState:callbacks.iceState,mediaState:callbacks.mediaState,webrtcState:callbacks.webrtcState,slowLink:callbacks.slowLink,onmessage:callbacks.onmessage,createOffer:function(callbacks){prepareWebrtc(handleId,!0,callbacks)},createAnswer:function(callbacks){prepareWebrtc(handleId,!1,callbacks)},handleRemoteJsep:function(callbacks){prepareWebrtcPeer(handleId,callbacks)},replaceTracks:function(callbacks){replaceTracks(handleId,callbacks)},getLocalTracks:function(){return getLocalTracks(handleId)},getRemoteTracks:function(){return getRemoteTracks(handleId)},onlocaltrack:callbacks.onlocaltrack,onremotetrack:callbacks.onremotetrack,ondata:callbacks.ondata,ondataopen:callbacks.ondataopen,oncleanup:callbacks.oncleanup,ondetached:callbacks.ondetached,hangup:function(sendRequest){cleanupWebrtc(handleId,!0===sendRequest)},detach:function(callbacks){destroyHandle(handleId,callbacks)}};pluginHandles.set(handleId,pluginHandle),callbacks.success(pluginHandle)},error:function(textStatus,errorThrown){Janus.error(textStatus+":",errorThrown),""===errorThrown?callbacks.error(textStatus+": Is the server down?"):callbacks.error(textStatus+": "+errorThrown)}})}(callbacks)}}return Janus.useDefaultDependencies=function(deps){let f=deps&&deps.fetch||fetch,p=deps&&deps.Promise||Promise,socketCls=deps&&deps.WebSocket||WebSocket;return{newWebSocket:function(server,proto){return new socketCls(server,proto)},extension:deps&&deps.extension||defaultExtension,isArray:function(arr){return Array.isArray(arr)},webRTCAdapter:deps&&deps.adapter||adapter,httpAPICall:function(url,options){let fetchOptions={method:options.verb,headers:{Accept:"application/json, text/plain, */*"},cache:"no-cache"};"POST"===options.verb&&(fetchOptions.headers["Content-Type"]="application/json"),void 0!==options.withCredentials&&(fetchOptions.credentials=!0===options.withCredentials?"include":options.withCredentials?options.withCredentials:"omit"),options.body&&(fetchOptions.body=JSON.stringify(options.body));let fetching=f(url,fetchOptions).catch((function(error){return p.reject({message:"Probably a network error, is the server down?",error:error})}));if(options.timeout){let timeout=new p((function(resolve,reject){let timerId=setTimeout((function(){return clearTimeout(timerId),reject({message:"Request timed out",timeout:options.timeout})}),options.timeout)}));fetching=p.race([fetching,timeout])}return fetching.then((function(response){return response.ok?typeof options.success==typeof Janus.noop?response.json().then((function(parsed){try{options.success(parsed)}catch(error){Janus.error("Unhandled httpAPICall success callback error",error)}}),(function(error){return p.reject({message:"Failed to parse response body",error:error,response:response})})):void 0:p.reject({message:"API call failed",response:response})})).catch((function(error){typeof options.error==typeof Janus.noop&&options.error(error.message||"<< internal error >>",error)})),fetching}}},Janus.useOldDependencies=function(deps){let jq=deps&&deps.jQuery||jQuery,socketCls=deps&&deps.WebSocket||WebSocket;return{newWebSocket:function(server,proto){return new socketCls(server,proto)},isArray:function(arr){return jq.isArray(arr)},extension:deps&&deps.extension||defaultExtension,webRTCAdapter:deps&&deps.adapter||adapter,httpAPICall:function(url,options){let payload=void 0!==options.body?{contentType:"application/json",data:JSON.stringify(options.body)}:{},credentials=void 0!==options.withCredentials?{xhrFields:{withCredentials:options.withCredentials}}:{};return jq.ajax(jq.extend(payload,credentials,{url:url,type:options.verb,cache:!1,dataType:"json",async:options.async,timeout:options.timeout,success:function(result){typeof options.success==typeof Janus.noop&&options.success(result)},error:function(xhr,status,err){typeof options.error==typeof Janus.noop&&options.error(status,err)}}))}}},Janus.mediaToTracks=function(media){let tracks=[];if(media){if(!media.keepAudio&&!1!==media.audio&&(void 0===media.audio||media.audio||media.audioSend||media.audioRecv||media.addAudio||media.replaceAudio||media.removeAudio)){let track={type:"audio"};media.removeAudio?track.remove=!0:(media.addAudio?track.add=!0:media.replaceAudio&&(track.replace=!0),!1!==media.audioSend&&(track.capture=media.audio||!0),!1!==media.audioRecv&&(track.recv=!0)),(track.remove||track.capture||track.recv)&&tracks.push(track)}if(!media.keepVideo&&!1!==media.video&&(void 0===media.video||media.video||media.videoSend||media.videoRecv||media.addVideo||media.replaceVideo||media.removeVideo)){let track={type:"video"};media.removeVideo?track.remove=!0:(media.addVideo?track.add=!0:media.replaceVideo&&(track.replace=!0),!1!==media.videoSend&&(track.capture=media.video||!0,["screen","window","desktop"].includes(track.capture)&&(track.type="screen",track.capture={video:{}},media.screenshareFrameRate&&(track.capture.frameRate=media.screenshareFrameRate),media.screenshareHeight&&(track.capture.height=media.screenshareHeight),media.screenshareWidth&&(track.capture.width=media.screenshareWidth))),!1!==media.videoRecv&&(track.recv=!0)),(track.remove||track.capture||track.recv)&&tracks.push(track)}media.data&&tracks.push({type:"data"})}else tracks.push({type:"audio",capture:!0,recv:!0}),tracks.push({type:"video",capture:!0,recv:!0});return tracks},Janus.trackConstraints=function(track){let constraints={};if(!track||!track.capture)return constraints;if("audio"===track.type)constraints.audio=track.capture;else if("video"===track.type)if((track.simulcast||track.svc)&&!0===track.capture&&(track.capture="hires"),!0===track.capture||"object"==typeof track.capture)constraints.video=track.capture;else{let width=0,height=0;"lowres"===track.capture?(width=320,height=240):"lowres-16:9"===track.capture?(width=320,height=180):"hires"===track.capture||"hires-16:9"===track.capture||"hdres"===track.capture?(width=1280,height=720):"fhdres"===track.capture?(width=1920,height=1080):"4kres"===track.capture?(width=3840,height=2160):"stdres"===track.capture?(width=640,height=480):"stdres-16:9"===track.capture?(width=640,height=360):(Janus.log("Default video setting is stdres 4:3"),width=640,height=480),constraints.video={width:{ideal:width},height:{ideal:height}}}else"screen"===track.type&&(constraints.video=track.capture);return constraints},Janus.noop=function(){},Janus.dataChanDefaultLabel="JanusDataChannel",Janus.endOfCandidates=null,Janus.stopAllTracks=function(stream){try{let tracks=stream.getTracks();for(let mst of tracks)Janus.log(mst),mst&&!0!==mst.dontStop&&mst.stop()}catch(e){}},Janus.init=function(options){if((options=options||{}).callback="function"==typeof options.callback?options.callback:Janus.noop,Janus.initDone)options.callback();else{if(void 0===console.log&&(console.log=function(){}),Janus.trace=Janus.noop,Janus.debug=Janus.noop,Janus.vdebug=Janus.noop,Janus.log=Janus.noop,Janus.warn=Janus.noop,Janus.error=Janus.noop,!0===options.debug||"all"===options.debug)Janus.trace=console.trace.bind(console),Janus.debug=console.debug.bind(console),Janus.vdebug=console.debug.bind(console),Janus.log=console.log.bind(console),Janus.warn=console.warn.bind(console),Janus.error=console.error.bind(console);else if(Array.isArray(options.debug))for(let d of options.debug)switch(d){case"trace":Janus.trace=console.trace.bind(console);break;case"debug":Janus.debug=console.debug.bind(console);break;case"vdebug":Janus.vdebug=console.debug.bind(console);break;case"log":Janus.log=console.log.bind(console);break;case"warn":Janus.warn=console.warn.bind(console);break;case"error":Janus.error=console.error.bind(console)}Janus.log("Initializing library");let usedDependencies=options.dependencies||Janus.useDefaultDependencies();Janus.isArray=usedDependencies.isArray,Janus.webRTCAdapter=usedDependencies.webRTCAdapter,Janus.httpAPICall=usedDependencies.httpAPICall,Janus.newWebSocket=usedDependencies.newWebSocket,Janus.extension=usedDependencies.extension,Janus.extension.init(),Janus.listDevices=function(callback,config){callback="function"==typeof callback?callback:Janus.noop,config||(config={audio:!0,video:!0}),Janus.isGetUserMediaAvailable()?navigator.mediaDevices.getUserMedia(config).then((function(stream){navigator.mediaDevices.enumerateDevices().then((function(devices){Janus.debug(devices),callback(devices),Janus.stopAllTracks(stream)}))})).catch((function(err){Janus.error(err),callback([])})):(Janus.warn("navigator.mediaDevices unavailable"),callback([]))},Janus.attachMediaStream=function(element,stream){try{element.srcObject=stream}catch(e){try{element.src=URL.createObjectURL(stream)}catch(e){Janus.error("Error attaching stream to element",e)}}},Janus.reattachMediaStream=function(to,from){try{to.srcObject=from.srcObject}catch(e){try{to.src=from.src}catch(e){Janus.error("Error reattaching stream to element",e)}}};let eventName=["iPad","iPhone","iPod"].indexOf(navigator.platform)>=0?"pagehide":"beforeunload",oldOBF=window["on"+eventName];if(window.addEventListener(eventName,(function(){Janus.log("Closing window");for(const[sessionId,session]of Janus.sessions)session&&session.destroyOnUnload&&(Janus.log("Destroying session "+sessionId),session.destroy({unload:!0,notifyDestroyed:!1}));oldOBF&&"function"==typeof oldOBF&&oldOBF()})),Janus.safariVp8=!1,Janus.safariVp9=!1,"safari"===Janus.webRTCAdapter.browserDetails.browser&&Janus.webRTCAdapter.browserDetails.version>=605)if(RTCRtpSender&&RTCRtpSender.getCapabilities&&RTCRtpSender.getCapabilities("video")&&RTCRtpSender.getCapabilities("video").codecs&&RTCRtpSender.getCapabilities("video").codecs.length){for(let codec of RTCRtpSender.getCapabilities("video").codecs)codec&&codec.mimeType&&"video/vp8"===codec.mimeType.toLowerCase()?Janus.safariVp8=!0:codec&&codec.mimeType&&"video/vp9"===codec.mimeType.toLowerCase()&&(Janus.safariVp9=!0);Janus.safariVp8?Janus.log("This version of Safari supports VP8"):Janus.warn("This version of Safari does NOT support VP8: if you're using a Technology Preview, try enabling the 'WebRTC VP8 codec' setting in the 'Experimental Features' Develop menu")}else{let testpc=new RTCPeerConnection({});testpc.createOffer({offerToReceiveVideo:!0}).then((function(offer){Janus.safariVp8=-1!==offer.sdp.indexOf("VP8"),Janus.safariVp9=-1!==offer.sdp.indexOf("VP9"),Janus.safariVp8?Janus.log("This version of Safari supports VP8"):Janus.warn("This version of Safari does NOT support VP8: if you're using a Technology Preview, try enabling the 'WebRTC VP8 codec' setting in the 'Experimental Features' Develop menu"),testpc.close(),testpc=null}))}Janus.initDone=!0,options.callback()}},Janus.isWebrtcSupported=function(){return!!window.RTCPeerConnection},Janus.isGetUserMediaAvailable=function(){return navigator.mediaDevices&&navigator.mediaDevices.getUserMedia},Janus.randomString=function(len){let charSet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789",randomString="";for(let i=0;i<len;i++){let randomPoz=Math.floor(Math.random()*charSet.length);randomString+=charSet.charAt(randomPoz)}return randomString},_exports.default}));

//# sourceMappingURL=janus-gateway.min.js.map