define("block_deft/venue_manager",["exports","core/ajax","core/fragment","core/str","block_deft/jitsi/lib-jitsi-meet.min","core/modal_events","core/notification","core/log","block_deft/socket","block_deft/jitsi/socket","core/adapter"],(function(_exports,_ajax,_fragment,_str,_libJitsiMeet,_modal_events,_notification,_log,_socket,_socket2,_adapter){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/*
   * Manage venue connections
   *
   * @package    block_deft
   * @module     block_deft/venue_manager
   * @copyright  2022 Daniel Thies <dethies@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_ajax=_interopRequireDefault(_ajax),_fragment=_interopRequireDefault(_fragment),_libJitsiMeet=_interopRequireDefault(_libJitsiMeet),_modal_events=_interopRequireDefault(_modal_events),_notification=_interopRequireDefault(_notification),_log=_interopRequireDefault(_log),_socket=_interopRequireDefault(_socket),_socket2=_interopRequireDefault(_socket2),_adapter=_interopRequireDefault(_adapter);return _exports.default=class{constructor(contextid,token,peers,peerid,iceServers,autogaincontrol,echocancellation,noisesuppression,samplerate,roomid,server){if(this.contextid=contextid,this.token=token,this.peerid=peerid,this.iceServers=iceServers,this.autogaincontrol=autogaincontrol,this.echocancellation=echocancellation,this.noisesuppression=noisesuppression,this.roomid=roomid,this.samplerate=samplerate,this.lastSignal=0,this.lastUpdate=0,this.dataChannels=[],this.peerConnections={},this.queueout=[],this.ignoreOffer=new Set,this.makingOffer=new Set,this.peers=peers,this.server=server,window.adapter=_adapter.default,!window.RTCPeerConnection)return document.querySelectorAll('.venue_manager, [data-region="block_deft_venue_static"]').forEach((venue=>{const e=new Event("venueclosed",{bubbles:!0});venue.dispatchEvent(e)})),void _notification.default.alert((0,_str.get_string)("unsupportedbrowser","block_deft"),(0,_str.get_string)("unsupportedbrowsermessage","block_deft")).then((notice=>(notice.getRoot().on(_modal_events.default.cancel,(()=>_ajax.default.call([{args:{mute:!1,status:!0},done:status=>(window.close(),status),fail:_notification.default.exception,methodname:"block_deft_venue_settings"}]))),notice))).fail(_notification.default.exception);this.addListeners(),this.startConnection()}addListeners(){if(document.querySelector("body").removeEventListener("click",this.handleMuteButtons.bind(this)),document.querySelector("body").addEventListener("click",this.handleMuteButtons.bind(this)),document.querySelector("body").removeEventListener("click",this.handleRaiseHand.bind(this)),document.querySelector("body").addEventListener("click",this.handleRaiseHand.bind(this)),document.querySelector("body").removeEventListener("click",this.closeConnections.bind(this)),document.querySelector("body").addEventListener("click",this.closeConnections.bind(this)),window.onbeforeunload=this.closeConnections.bind(this),document.body.dispatchEvent(new CustomEvent("deftaction",{})),this.audioInput=navigator.mediaDevices.getUserMedia({audio:{autoGainControl:this.autogaincontrol,echoCancellation:this.echocancellation,noiseSuppression:this.noisesuppression,sampleRate:this.samplerate},video:!1}).catch((()=>(_ajax.default.call([{args:{mute:!0,status:!1},fail:_notification.default.exception,methodname:"block_deft_venue_settings"}]),!1))),this.audioInput.then(this.monitorVolume.bind(this)).catch(_log.default.debug),!this.token)return;if(!this.server||"wss://deftly.us/janus/ws"==this.server)return this.socket=new _socket.default(this.contextid,this.token),void this.socket.subscribe((()=>{this.sendSignals()}));const domain=this.server;_libJitsiMeet.default.init(),_libJitsiMeet.default.setLogLevel(_libJitsiMeet.default.logLevels.DEBUG),this.connection=new _libJitsiMeet.default.JitsiConnection(null,this.token,{serviceUrl:"https://".concat(domain,"/http-bind"),hosts:{domain:domain,muc:"conference.".concat(domain)}}),this.connection.addEventListener(_libJitsiMeet.default.events.connection.CONNECTION_ESTABLISHED,(()=>{this.room=this.connection.initJitsiConference(this.roomid,{disableSimulcast:!0}),this.socket=new _socket2.default(this.room),this.socket.subscribe((()=>{this.sendSignals()})),document.body.addEventListener("deftaction",(()=>{this.socket.notify()})),this.room.join()})),this.connection.connect()}startConnection(){this.peers.forEach((peerid=>{const pc=new RTCPeerConnection({iceServers:this.iceServers}),dataChannel=pc.createDataChannel("Events");this.dataChannels.push(dataChannel),this.ignoreOffer.delete(String(peerid)),dataChannel.onmessage=this.handleMessage.bind(this,peerid),pc.onnegotiationneeded=this.negotiate.bind(this,this.contextid,pc,peerid),pc.onicecandidate=this.handleICECandidate.bind(this,this.contextid,peerid),pc.ontrack=this.handleTrackEvent.bind(this,peerid),pc.onconnectionstatechange=this.handleStateChange.bind(this,peerid),pc.oniceconnectionstatechange=()=>{"failed"===pc.iceConnectionState&&pc.restartIce()},this.peerConnections[String(peerid)]=pc}))}handleICECandidate(contextid,peerid,e){e.candidate&&this.sendSignal(peerid,"new-ice-candidate",e.candidate)}sendSignal(peerid,type,message){this.queueout.push({message:JSON.stringify(message),peerid:peerid,type:type}),this.sendSignals()}sendSignals(){if(this.throttled||!navigator.onLine)return;const time=Date.now();if(this.lastUpdate+200>time)return this.throttled=!0,setTimeout((()=>{this.throttled=!1}),this.lastUpdate+250-time),void this.sendSignals();this.lastUpdate=time;const messages=[];for(;this.queueout.length;)messages.push(this.queueout.shift());_ajax.default.call([{args:{contextid:this.contextid,lastsignal:this.lastSignal,messages:messages},contextid:this.contextid,done:response=>{if(response.settings.forEach((peer=>{if(peer.id==Number(this.peerid)){if(peer.status)return clearInterval(this.meterId),this.audioInput.then((audioStream=>(audioStream&&audioStream.getAudioTracks().forEach((track=>{track.stop()})),audioStream))).catch(_notification.default.exception),Object.values(this.peerConnections).forEach((pc=>{pc.close()})),document.querySelectorAll('[data-region="deft-venue"] [data-peerid="'+this.peerid+'"]').forEach((venue=>{const e=new Event("venueclosed",{bubbles:!0});venue.dispatchEvent(e)})),this.socket.disconnect(),void window.close();this.mute(peer.mute)}document.querySelectorAll('[data-peerid="'+peer.id+'"] [data-action="mute"], [data-peerid="'+peer.id+'"] [data-action="unmute"]').forEach((button=>{peer.mute==("mute"==button.getAttribute("data-action"))?button.classList.add("hidden"):button.classList.remove("hidden")}))})),response.peers.includes(Number(this.peerid))){response.messages.forEach((signal=>{signal.id>this.lastSignal&&(this.lastSignal=signal.id,this.processSignal(signal))}));for(const key in Object.keys(this.peerConnections))if(!response.peers.includes(Number(key))&&this.peerConnections[key]){this.peerConnections[key].close()}}},fail:_notification.default.exception,methodname:"block_deft_send_signal"}])}negotiate(contextid,pc,peerid){return this.makingOffer.add(String(peerid)),pc.setLocalDescription().then((()=>pc.setLocalDescription())).then((()=>this.sendSignal(peerid,"audio-offer",pc.localDescription))).catch(_log.default.debug).finally((()=>{this.makingOffer.delete(String(peerid))}))}processSignal(signal){if("audio-offer"===signal.type||"audio-answer"===signal.type){const pc=this.peerConnections[String(signal.frompeer)]||new RTCPeerConnection({iceServers:this.iceServers}),description=JSON.parse(signal.message),polite=Number(signal.frompeer)<Number(this.peerid);if(this.peerConnections[String(signal.frompeer)]||(this.peerConnections[String(signal.frompeer)]=pc,pc.onnegotiationneeded=this.negotiate.bind(this,this.contextid,pc,signal.frompeer),pc.oniceconnectionstatechange=()=>{"failed"===pc.iceConnectionState&&pc.restartIce()},pc.onicecandidate=this.handleICECandidate.bind(this,this.contextid,signal.frompeer),pc.ontrack=this.handleTrackEvent.bind(this,signal.frompeer),pc.onconnectionstatechange=this.handleStateChange.bind(this,signal.frompeer),pc.ondatachannel=e=>{this.peerAudioPlayer(signal.frompeer),this.dataChannels.push(e.channel),e.channel.onmessage=this.handleMessage.bind(this,signal.frompeer),e.channel.onopen=()=>{window.setTimeout((()=>{e.channel.send(JSON.stringify({raisehand:!!document.querySelector('[data-peerid="'+this.peerid+'"] a.hidden[data-action="raisehand"]')}))}),3e3)}}),!polite&&"offer"===description.type&&(this.makingOffer.has(String(signal.frompeer))||"stable"!==pc.signalingState))return void this.ignoreOffer.add(String(signal.frompeer));this.ignoreOffer.delete(String(signal.frompeer)),pc.setRemoteDescription(description).then((()=>this.audioInput)).then((audioStream=>(audioStream&&pc.getTransceivers().length<2&&audioStream.getAudioTracks().forEach((track=>{pc.addTransceiver(track,{streams:[audioStream]})})),"offer"==description.type?pc.setLocalDescription():audioStream))).then((()=>"offer"==description.type?this.sendSignal(signal.frompeer,"audio-answer",pc.localDescription):pc)).catch(_log.default.debug)}else if("new-ice-candidate"===signal.type){const pc=this.peerConnections[String(signal.frompeer)]||null;pc&&pc.currentRemoteDescription&&pc.addIceCandidate(JSON.parse(signal.message)).catch((e=>{this.ignoreOffer.has(String(signal.frompeer))||_log.default.debug(e)}))}}handleTrackEvent(peerid,e){e&&e.streams&&document.querySelector("#deft_audio")&&this.peerAudioPlayer(peerid).then((player=>{player.srcObject||(player.srcObject=e.streams[0])})).catch(_notification.default.exception)}mute(state){this.audioInput.then((audioStream=>audioStream?(audioStream.getAudioTracks().forEach((track=>{track.enabled==state&&(track.enabled=!state)})),!0):this.audioInput)).catch(_notification.default.exception)}handleMessage(peerid,e){const message=JSON.parse(e.data);message.hasOwnProperty("raisehand")&&(document.querySelectorAll('[data-peerid="'+peerid+'"] [data-action="raisehand"]').forEach((button=>{message.raisehand?button.classList.add("hidden"):button.classList.remove("hidden")})),document.querySelectorAll('[data-peerid="'+peerid+'"] [data-action="lowerhand"]').forEach((button=>{message.raisehand?button.classList.remove("hidden"):button.classList.add("hidden")}))),message.hasOwnProperty("volume")&&document.querySelectorAll('.volume_indicator[data-peerid="'+peerid+'"]').forEach((indicator=>{indicator.querySelector(".low").style.opacity=message.volume.low,indicator.querySelector(".mid").style.opacity=message.volume.mid,indicator.querySelector(".high").style.opacity=message.volume.high,indicator.setAttribute("data-volume",message.volume.smooth)}))}handleStateChange(peerid){const pc=this.peerConnections[String(peerid)];document.querySelectorAll('#deft_audio div[data-peerid="'+peerid+'"]').forEach((userinfo=>{switch(pc.connectionState){case"connected":userinfo.classList.remove("hidden");break;case"closed":userinfo.remove();break;case"disconnected":userinfo.classList.add("hidden")}}))}closeConnections(e){if(e&&"click"==e.type){if(!e.target.closest('[data-region="deft-venue"] a[data-action="close"]'))return;e.stopPropagation(),e.preventDefault()}document.querySelectorAll('[data-region="deft-venue"] a[data-action="close"] i').forEach((button=>{button.classList.add("bg-danger")})),document.querySelector("body").classList.remove("block_deft_raisehand"),_ajax.default.call([{args:{mute:!1,status:!0},fail:_notification.default.exception,methodname:"block_deft_venue_settings"}]),clearInterval(this.meterId),this.audioInput.then((audioStream=>(audioStream&&audioStream.getAudioTracks().forEach((track=>{track.stop()})),!0))).catch(_notification.default.exception),Object.values(this.peerConnections).forEach((pc=>{pc.close()})),document.querySelectorAll('[data-region="deft-venue"] [data-peerid="'+this.peerid+'"]').forEach((venue=>{const event=new Event("venueclosed");venue.dispatchEvent(event)})),document.body.dispatchEvent(new CustomEvent("deftaction",{})),window.beforeunload=null,window.close(),this.sockect.disconnect()}shareAudio(){this.audioInput=navigator.mediaDevices.getUserMedia({audio:{autoGainControl:this.autogaincontrol,echoCancellation:this.echocancellation,noiseSuppression:this.noisesuppression,sampleRate:this.samplerate},video:!1}).then((audioStream=>(_ajax.default.call([{args:{mute:!1,status:!1},fail:_notification.default.exception,methodname:"block_deft_venue_settings"}]),this.monitorVolume(audioStream),audioStream))).catch(_log.default.debug)}handleMuteButtons(e){const button=e.target.closest('a[data-action="mute"], a[data-action="unmute"]');if(button){const action=button.getAttribute("data-action"),peerid=button.closest("[data-peerid]").getAttribute("data-peerid");e.stopPropagation(),e.preventDefault(),button.closest("#deft_audio")?_ajax.default.call([{args:{mute:!0,peerid:peerid,status:!1},fail:_notification.default.exception,methodname:"block_deft_venue_settings"}]):this.audioInput.then((audioStream=>(audioStream?_ajax.default.call([{args:{mute:"mute"==action,status:!1},fail:_notification.default.exception,methodname:"block_deft_venue_settings"}]):"unmute"==action&&this.shareAudio(),audioStream))).catch(_notification.default.exception),button.closest("[data-peerid]").querySelectorAll('[data-action="mute"], [data-action="unmute"]').forEach((option=>{option.getAttribute("data-action")==action?option.classList.add("hidden"):option.classList.remove("hidden")})),document.body.dispatchEvent(new CustomEvent("deftaction",{}))}}handleRaiseHand(e){const button=e.target.closest('[data-action="raisehand"], [data-action="lowerhand"]');if(button&&!button.closest("#deft_audio")){const action=button.getAttribute("data-action");e.stopPropagation(),e.preventDefault(),"raisehand"==action?document.querySelector("body").classList.add("block_deft_raisehand"):document.querySelector("body").classList.remove("block_deft_raisehand"),document.querySelectorAll('a[data-action="raisehand"], a[data-action="lowerhand"]').forEach((button=>{button.getAttribute("data-action")==action?button.classList.add("hidden"):button.classList.remove("hidden")})),_ajax.default.call([{args:{status:"raisehand"==action},fail:_notification.default.exception,methodname:"block_deft_raise_hand"}]),this.sendMessage(JSON.stringify({raisehand:"raisehand"==action}))}}sendMessage(message){this.dataChannels.forEach((dataChannel=>{"open"==dataChannel.readyState&&dataChannel.send(message)}))}monitorVolume(audioStream){if(audioStream){const audioContext=new AudioContext,source=audioContext.createMediaStreamSource(audioStream),analyser=new AnalyserNode(audioContext,{maxDecibels:-50,minDecibels:-90,fftSize:2048,smoothingTimeConstant:.3}),smoothanalyser=new AnalyserNode(audioContext,{maxDecibels:-50,minDecibels:-90,fftSize:2048,smoothingTimeConstant:.6}),bufferLength=analyser.frequencyBinCount,data=new Uint8Array(bufferLength),smootheddata=new Uint8Array(bufferLength);source.connect(analyser),source.connect(smoothanalyser),clearInterval(this.meterId),this.meterId=setInterval((()=>{analyser.getByteFrequencyData(data),smoothanalyser.getByteFrequencyData(smootheddata);const volume={low:Math.min(1,data.slice(0,16).reduce(((a,b)=>a+b),0)/2e3),mid:Math.min(1,data.slice(17,31).reduce(((a,b)=>a+b),0)/1e3),high:Math.min(1,data.slice(32).reduce(((a,b)=>a+b),0)/4e3),smooth:Math.min(1,smootheddata.slice(0,16).reduce(((a,b)=>a+b),0)/2e3)+Math.min(1,smootheddata.slice(17,31).reduce(((a,b)=>a+b),0)/1e3)+Math.min(1,smootheddata.slice(32).reduce(((a,b)=>a+b),0)/4e3)},message=JSON.stringify({volume:volume}),peers=[];document.querySelectorAll('.volume_indicator[data-peerid="'+this.peerid+'"]').forEach((indicator=>{indicator.querySelectorAll(".low").forEach((low=>{low.style.opacity=volume.low})),indicator.querySelectorAll(".mid").forEach((mid=>{mid.style.opacity=volume.mid})),indicator.querySelectorAll(".high").forEach((high=>{high.style.opacity=volume.high}))})),this.sendMessage(message),document.querySelectorAll("#deft_audio > div").forEach((peer=>{peers.push(peer)})),peers.sort(((a,b)=>{let volume=0;return a.querySelectorAll("[data-volume]").forEach((indicator=>{volume+=-Number(indicator.getAttribute("data-volume"))})),b.querySelectorAll("[data-volume]").forEach((indicator=>{volume+=Number(indicator.getAttribute("data-volume"))})),volume})),peers.forEach((peer=>{document.querySelector("#deft_audio").appendChild(peer)}))}),500)}return audioStream}peerAudioPlayer(peerid){const usernode=document.querySelector('#deft_audio div[data-peerid="'+peerid+'"] audio');if(usernode)return Promise.resolve(usernode);{const node=document.createElement("div");return node.setAttribute("data-peerid",peerid),document.querySelector("body#page-blocks-deft-venue")?node.setAttribute("class","col col-12 col-sm-6 col-md-4 col-lg-3 p-2"):node.setAttribute("class","col col-12 col-sm-6 col-md-4 p-2"),window.setTimeout((()=>{node.querySelectorAll("img.card-img-top").forEach((image=>{image.setAttribute("height",null),image.setAttribute("width",null)}))})),_fragment.default.loadFragment("block_deft","venue",this.contextid,{peerid:peerid}).done((userinfo=>{document.querySelector('#deft_audio div[data-peerid="'+peerid+'"] audio')||(document.querySelector("#deft_audio").appendChild(node),node.innerHTML=userinfo)})).then((()=>document.querySelector('#deft_audio div[data-peerid="'+peerid+'"] audio'))).catch(_notification.default.exception)}}},_exports.default}));

//# sourceMappingURL=venue_manager.min.js.map