define("block_deft/janus_venue",["exports","core/ajax","core/str","block_deft/janus-gateway","core/log","core/notification","block_deft/publish","block_deft/subscribe","core/templates","core/toast","block_deft/venue_manager"],(function(_exports,_ajax,_str,_janusGateway,_log,_notification,_publish,_subscribe,_templates,Toast,_venue_manager){function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Manage venue connections
   *
   * @module     block_deft/venue_manager
   * @copyright  2022 Daniel Thies <dethies@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_ajax=_interopRequireDefault(_ajax),_janusGateway=_interopRequireDefault(_janusGateway),_log=_interopRequireDefault(_log),_notification=_interopRequireDefault(_notification),_publish=_interopRequireDefault(_publish),_subscribe=_interopRequireDefault(_subscribe),_templates=_interopRequireDefault(_templates),Toast=function(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!=typeof obj&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}newObj.default=obj,cache&&cache.set(obj,newObj);return newObj}(Toast),_venue_manager=_interopRequireDefault(_venue_manager);var venue=null,publish=null,contextid=0,iceServers="",roomid=0,peerid=0,server="";class JanusManager extends _venue_manager.default{startConnection(){this.transactions={},roomid=this.roomid,peerid=this.peerid,server=this.server,contextid=this.contextid,iceServers=this.iceServers,_janusGateway.default.init({debug:"none",callback:()=>{this.janus=new _janusGateway.default({server:this.server,iceServers:this.iceServers,success:()=>{this.janus.attach({plugin:"janus.plugin.audiobridge",opaqueId:"audioroom-"+_janusGateway.default.randomString(12),success:pluginHandle=>{this.audioBridge=pluginHandle,_log.default.debug(pluginHandle.session.getSessionId()),this.register(pluginHandle)},error:function(error){_janusGateway.default.error("  -- Error attaching plugin...",error),_notification.default.alert("","Error attaching audiobridege plugin... "+error)},onmessage:this.onMessage.bind(this),onremotetrack:(track,mid,on,metadata)=>{_janusGateway.default.debug("Remote track (mid="+mid+") "+(on?"added":"removed")+(metadata?" ("+metadata.reason+") ":"")+":",track),this.remoteStream||"audio"!==track.kind||(on?(this.remoteStream=new MediaStream([track]),_janusGateway.default.attachMediaStream(document.getElementById("roomaudio"),this.remoteStream)):this.remoteStream=null)}}),this.janus.attach({plugin:"janus.plugin.textroom",opaqueId:"textroom-"+_janusGateway.default.randomString(12),success:pluginHandle=>{this.textroom=pluginHandle,_janusGateway.default.log("Plugin attached! ("+this.textroom.getPlugin()+", id="+this.textroom.getId()+")");const body={request:"setup"};_janusGateway.default.debug("Sending message:",body),this.textroom.send({message:body})},error:function(error){_notification.default.alert("",error),_janusGateway.default.error("  -- Error attaching plugin...",error)},onmessage:(msg,jsep)=>{_janusGateway.default.debug(" ::: Got a message :::",msg),msg.error&&_notification.default.alert(msg.error_code,msg.error),jsep&&this.textroom.createAnswer({jsep:jsep,tracks:[{type:"data"}],success:jsep=>{_janusGateway.default.debug("Got SDP!",jsep);this.textroom.send({message:{request:"ack"},jsep:jsep})},error:function(error){_janusGateway.default.error("WebRTC error:",error)}})},ondataopen:(label,protocol)=>{const register={textroom:"join",transaction:_janusGateway.default.randomString(12),room:this.roomid,username:String(this.peerid),display:""};this.textroom.data({text:JSON.stringify(register),error:function(reason){_notification.default.alert("Error",reason)}})},ondata:data=>{_janusGateway.default.debug("We got data from the DataChannel!",data);const message=JSON.parse(data),event=message.textroom,transaction=message.transaction;transaction&&this.transactions[transaction]&&(this.transactions[transaction](message),delete this.transactions[transaction]),"message"===event&&message.from!=this.peerid&&this.handleMessage(message.from,{data:message.text}),"join"===event&&this.sendMessage(JSON.stringify({raisehand:!!document.querySelector('[data-peerid="'+this.peerid+'"] a.hidden[data-action="raisehand"]')}))}})},error:error=>{(0,_str.get_string)("serverlost","block_deft").done((message=>{Toast.add(message,{type:"info"})})),_log.default.debug(error),this.restart=!0,publish&&(publish.handleClose(),publish=null),this.remoteFeed&&(this.remoteFeed.handleClose(),this.remoteFeed=null),document.querySelectorAll('[data-region="deft-venue"] video').forEach((video=>{const newfeed=document.createElement("video");video.classList.add("hidden"),video.srcObject=null,video.parentNode.insertBefore(newfeed,video),video.remove(),newfeed.classList.add("w-100"),newfeed.id="deft_venue_remote_video",newfeed.setAttribute("controls",!0),newfeed.setAttribute("autoplay",!0)})),document.querySelectorAll('[data-region="deft-venue"] [data-action="publish"],[data-region="deft-venue"] [data-action="unpublish"]').forEach((button=>{"publish"==button.getAttribute("data-action")?button.classList.remove("hidden"):button.classList.add("hidden")}))},destroyed:function(){window.close()}})}}),document.querySelector("body").removeEventListener("venueclosed",this.handleClose.bind(this)),document.querySelector("body").addEventListener("venueclosed",this.handleClose.bind(this)),document.querySelector("body").removeEventListener("click",handleClick),document.querySelector("body").addEventListener("click",handleClick),venue=this}register(pluginHandle){return _ajax.default.call([{args:{handle:pluginHandle.getId(),id:Number(this.peerid),plugin:pluginHandle.plugin,room:this.roomid,session:pluginHandle.session.getSessionId()},contextid:this.contextid,fail:_notification.default.exception,methodname:"block_deft_join_room"}])[0]}onMessage(msg,jsep){const event=msg.audiobridge;if(event)if("joined"===event)msg.id&&(_janusGateway.default.log("Successfully joined room "+msg.room+" with ID "+this.peerid),this.webrtcUp||(this.webrtcUp=!0,this.audioInput.then((audioStream=>{const tracks=[];return audioStream?audioStream.getAudioTracks().forEach((track=>{tracks.push({type:"audio",capture:track,recv:!0})})):tracks.push({type:"audio",capture:!0,recv:!0}),this.audioBridge.createOffer({tracks:tracks,customizeSdp:function(jsep){false},success:jsep=>{_janusGateway.default.debug("Got SDP!",jsep);this.audioBridge.send({message:{request:"configure",muted:!1},jsep:jsep})},error:function(error){_janusGateway.default.error("WebRTC error:",error),_notification.default.alert("WebRTC error... ",error.message)}}),audioStream})).catch(_notification.default.exception))),msg.participants&&this.updateParticipants(msg.participants);else if("destroyed"===event)_janusGateway.default.warn("The room has been destroyed!"),_notification.default.alert("","The room has been destroyed");else if("event"===event){if(msg.participants)this.updateParticipants(msg.participants);else if(msg.error)return void(485===msg.error_code?_notification.default.alert("<p>Room <code>"+this.roomid+"</code> is not configured."):489===msg.error_code?this.handleClose():_notification.default.alert(msg.error_code,msg.error));if(msg.leaving){const leaving=msg.leaving;_janusGateway.default.log("Participant left: "+leaving),document.querySelectorAll('#deft_audio [peerid="'+leaving+'"]').forEach((peer=>{peer.remove()}))}}jsep&&(_janusGateway.default.debug("Handling SDP as well...",jsep),this.audioBridge.handleRemoteJsep({jsep:jsep}))}processSignal(){}updateParticipants(list){_janusGateway.default.debug("Got a list of participants:",list);for(const f in list){const id=list[f].id,display=list[f].display,setup=list[f].setup,muted=list[f].muted;_janusGateway.default.debug("  >> ["+id+"] "+display+" (setup="+setup+", muted="+muted+")"),document.querySelector('#deft_audio [peerid="'+id+'"]')||Number(this.peerid)==Number(id)||(_log.default.debug(this.peerid),_log.default.debug(id),this.peerAudioPlayer(id))}}sendSignals(){if(this.throttled||!navigator.onLine)return;const time=Date.now();if(this.lastUpdate+200>time)return this.throttled=!0,setTimeout((()=>{this.throttled=!1}),this.lastUpdate+250-time),void this.sendSignals();this.lastUpdate=time,_ajax.default.call([{args:{contextid:this.contextid,lastsignal:0,messages:[]},contextid:this.contextid,done:response=>{if(response.settings.forEach((peer=>{if(peer.id==Number(this.peerid)){if(peer.status)return clearInterval(this.meterId),this.audioInput.then((audioStream=>(audioStream&&audioStream.getAudioTracks().forEach((track=>{track.stop()})),audioStream))).catch(_log.default.debug),this.janus.destroy(),document.querySelectorAll('[data-region="deft-venue"] [data-peerid="'+this.peerid+'"], [data-region="deft-venue"] [data-action="publish"]').forEach((venue=>{const e=new Event("venueclosed",{bubbles:!0});venue.dispatchEvent(e)})),this.socket.disconnect(),void window.close();this.mute(peer.mute)}document.querySelectorAll('[data-peerid="'+peer.id+'"] [data-action="mute"], [data-peerid="'+peer.id+'"] [data-action="unmute"]').forEach((button=>{peer.mute==("mute"==button.getAttribute("data-action"))?button.classList.add("hidden"):button.classList.remove("hidden")})),!response.peers.includes(Number(peer.id))&&document.querySelector('#deft_audio [data-peerid="'+peer.id+'"]')&&document.querySelector('#deft_audio [data-peerid="'+peer.id+'"]').remove()})),response.peers.includes(Number(this.peerid))){for(const key in Object.keys(this.peerConnections))if(!response.peers.includes(Number(key))&&this.peerConnections[key]){this.peerConnections[key].close()}response.peers.includes(Number(response.feed))?this.subscribeTo(response.feed):(this.subscribeTo(0),document.querySelectorAll('[data-region="deft-venue"] video').forEach((video=>{video.classList.add("hidden")}))),this.restart&&((0,_str.get_string)("reconnecting","block_deft").done((message=>{Toast.add(message,{type:"info"})})),_ajax.default.call([{args:{id:Number(this.peerid),publish:!1,room:this.roomid},contextid:this.contextid,fail:_notification.default.exception,methodname:"block_deft_publish_feed"}]),this.restart=!1,publish=null,this.startConnection())}},fail:_notification.default.exception,methodname:"block_deft_send_signal"}])}sendMessage(text){if(text&&""!==text&&this.textroom){const message={textroom:"message",transaction:_janusGateway.default.randomString(12),room:this.roomid,text:text};this.textroom.data({text:JSON.stringify(message),error:_log.default.debug})}}subscribeTo(source){if(!this.remoteFeed||this.remoteFeed.creatingSubscription||this.remoteFeed.restart)this.remoteFeed&&this.remoteFeed.restart?this.remoteFeed.current!=source&&(this.remoteFeed=null,this.subscribeTo(source)):this.remoteFeed?setTimeout((()=>{this.subscribeTo(source)}),500):source&&(this.remoteFeed=new _subscribe.default(this.contextid,this.iceservers,this.roomid,this.server,this.peerid),this.remoteFeed.startConnection(source));else{const update={request:"update",subscribe:[{feed:Number(source)}],unsubscribe:[{feed:Number(this.remoteFeed.current)}]};!source&&this.remoteFeed.current?(delete update.subscribe,document.querySelectorAll('[data-region="deft-venue"] video').forEach((video=>{video.classList.add("hidden")}))):source&&!this.remoteFeed.current&&(document.querySelectorAll('[data-region="deft-venue"] video').forEach((video=>{video.classList.remove("hidden")})),delete update.unsubscribe),this.remoteFeed.current!=source&&(this.remoteFeed.videoroom.send({message:update}),this.remoteFeed.current==publish.feed&&(publish.handleClose(),publish=null),this.remoteFeed.current=source)}}handleClose(){this.janus&&(this.janus.destroy(),this.janus=null),publish&&(publish.handleClose(),publish.unpublish(),publish=null),document.querySelector("body").removeEventListener("click",handleClick),this.remoteFeed&&this.remoteFeed.janus&&(this.remoteFeed.janus.destroy(),this.remoteFeed=null),_templates.default.replaceNodeContents('[data-region="block_deft_venue_static"]',"")}}_exports.default=JanusManager;const handleClick=function(e){const button=e.target.closest('[data-region="deft-venue"] [data-action="publish"], [data-region="deft-venue"] [data-action="unpublish"]');if(publish)publish.handleClick(e),button&&"publish"===button.getAttribute("data-action")&&(publish.audioBridge?publish.processAudioStream():publish.janus.attach({plugin:"janus.plugin.audiobridge",opaqueId:"audiobridge-"+_janusGateway.default.randomString(12),success:pluginHandle=>{publish.audioBridge=pluginHandle,publish.register(pluginHandle).then((response=>(publish.processAudioStream(),response))).catch(_notification.default.exception)},error:function(error){_janusGateway.default.error("  -- Error attaching plugin...",error),_notification.default.alert("","Error attaching plugin... "+error)},onmessage:publish.onAudioMessage.bind(publish)}));else if(button){const action=button.getAttribute("data-action"),type=button.getAttribute("data-type");publish=new Publish(contextid,iceServers,roomid,server,peerid),e.stopPropagation(),e.preventDefault(),document.querySelectorAll('[data-region="deft-venue"] [data-action="publish"],  [data-region="deft-venue"] [data-action="unpublish"]').forEach((button=>{button.getAttribute("data-action")==action&&button.getAttribute("data-type")==type?button.classList.add("hidden"):button.classList.remove("hidden")})),"display"==type?publish.shareDisplay():publish.shareCamera(),publish.startConnection()}if(button){"publish"===button.getAttribute("data-action")&&venue.webrtcUp&&publish.videoInput.then((audioStream=>{const tracks=[];return audioStream&&(audioStream.getAudioTracks().forEach((track=>{tracks.push({type:"audio",capture:track,recv:!0})})),tracks.length&&venue.audioBridge.createOffer({tracks:tracks,customizeSdp:function(jsep){false},success:jsep=>{_janusGateway.default.debug("Got SDP!",jsep);venue.audioBridge.send({message:{request:"configure",muted:!1},jsep:jsep})},error:function(error){_janusGateway.default.error("WebRTC error:",error),_notification.default.alert("WebRTC error... ",error.message)}})),audioStream})).catch(_notification.default.exception)}};class Publish extends _publish.default{register(pluginHandle){return super.register(pluginHandle).then((result=>("janus.plugin.audiobridge"==pluginHandle.plugin||(this.peerid=this.feed,this.janus.attach({plugin:"janus.plugin.audiobridge",opaqueId:"audiobridge-"+_janusGateway.default.randomString(12),success:pluginHandle=>{this.audioBridge=pluginHandle,this.register(pluginHandle)},error:function(error){_janusGateway.default.error("  -- Error attaching plugin...",error),_notification.default.alert("","Error attaching plugin... "+error)},onmessage:this.onAudioMessage.bind(this)})),result)))}onAudioMessage(msg,jsep){const event=msg.audiobridge;if(_log.default.debug(event),event)if("joined"===event)msg.id&&(_log.default.debug("Successfully joined room "+msg.room+" with ID "+msg.id),this.audioWebrtcUp||(this.audioWebrtcUp=!0,this.processAudioStream()));else if("destroyed"===event)_janusGateway.default.warn("The room has been destroyed!"),_notification.default.alert("","The room has been destroyed");else if("event"===event&&msg.error)return void(485===msg.error_code?_notification.default.alert("<p>Room <code>"+this.roomid+"</code> is not configured."):489===msg.error_code?window.close():_notification.default.alert(msg.error_code,msg.error));jsep&&(_janusGateway.default.debug("Handling SDP as well...",jsep),this.audioBridge.handleRemoteJsep({jsep:jsep}))}processAudioStream(){this.videoInput.then((audioStream=>{const tracks=[];let transceiver=null;return this.audioBridge.webrtcStuff.pc&&"connected"==this.audioBridge.webrtcStuff.pc.iceConnectionState&&this.audioBridge.webrtcStuff.pc.getTransceivers().forEach((x=>{const sender=x.sender;sender.track&&sender.track.id&&"audio"==sender.track.kind&&(transceiver=x)})),!transceiver||audioStream&&audioStream.getAudioTracks().length?(audioStream&&audioStream.getAudioTracks().forEach((track=>{if(transceiver)return this.videoroom.replaceTracks({tracks:[{type:"audio",mid:transceiver.mid,capture:track}],error:_notification.default.exception}),void(track.enabled=!0);tracks.push({type:"audio",capture:track,recv:!0})})),tracks.length?(this.audioBridge.createOffer({tracks:tracks,customizeSdp:function(jsep){false},success:jsep=>{if(transceiver)return;_janusGateway.default.debug("Got SDP!",jsep);this.audioBridge.send({message:{request:"configure",muted:!1},jsep:jsep})},error:function(error){_janusGateway.default.error("WebRTC error:",error),_notification.default.alert("WebRTC error... ",error.message)}}),audioStream):audioStream):(this.audioBridge.detach(),this.audioBridge=null,audioStream)})).catch(_notification.default.exception)}}return _exports.default}));

//# sourceMappingURL=janus_venue.min.js.map