define("block_deft/publish",["exports","core/adapter","core/ajax","block_deft/janus-gateway","core/log","core/notification"],(function(_exports,_adapter,_ajax,_janusGateway,_log,_notification){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Manage venue connections
   *
   * @module     block_deft/venue_manager
   * @copyright  2022 Daniel Thies <dethies@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_adapter=_interopRequireDefault(_adapter),_ajax=_interopRequireDefault(_ajax),_janusGateway=_interopRequireDefault(_janusGateway),_log=_interopRequireDefault(_log),_notification=_interopRequireDefault(_notification);return _exports.default=class{constructor(contextid,iceServers,roomid,server,peerid){this.contextid=contextid,this.iceServers=iceServers,this.roomid=roomid,this.server=server,this.peerid=peerid,window.adapter=_adapter.default,this.ptype="publish",document.querySelector("body").removeEventListener("venueclosed",this.handleClose.bind(this)),document.querySelector("body").addEventListener("venueclosed",this.handleClose.bind(this))}startConnection(){_janusGateway.default.init({debug:"all",callback:()=>{this.janus=new _janusGateway.default({server:this.server,iceServers:this.iceServers,success:()=>{this.attach()},error:error=>{this.restart=!0,_log.default.debug(error)}}),document.querySelector("body").addEventListener("venueclosed",this.janus.destroy)}})}register(pluginHandle){return _ajax.default.call([{args:{handle:pluginHandle.getId(),id:Number(this.peerid),plugin:pluginHandle.plugin,room:this.roomid,ptype:"publish"==this.ptype,session:pluginHandle.session.getSessionId()},contextid:this.contextid,fail:_notification.default.exception,methodname:"block_deft_join_room"}])[0].then((response=>("janus.plugin.videoroom"==pluginHandle.plugin&&(this.feed=response.id),response))).catch(_notification.default.exception)}onLocalTrack(track,on){_log.default.debug(on)}onRemoteTrack(){}onAttached(publishers){_log.default.debug(publishers)}onMessage(msg,jsep){_janusGateway.default.debug(" ::: Got a message :::",msg);const event=msg.videoroom;switch(_janusGateway.default.debug("Event: "+event),event){case"joined":msg.id&&(_log.default.debug("Successfully joined room "+msg.room+" with ID "+this.feed),this.webrtcUp||(this.webrtcUp=!0,this.processStream([{type:"data"}])));break;case"destroyed":_janusGateway.default.warn("The room has been destroyed!"),_notification.default.alert("","The room has been destroyed");break;case"event":if(msg.configured)this.videoroom.webrtcStuff.pc.removeEventListener("iceconnectionstatechange",this.publishFeed.bind(this)),this.videoroom.webrtcStuff.pc.addEventListener("iceconnectionstatechange",this.publishFeed.bind(this)),setTimeout(this.publishFeed.bind(this));else{if(msg.error)return void(485===msg.error_code?_notification.default.alert("<p>Apparently room <code>"+this.roomid+"</code> (the one this demo uses as a test room) does not exist...</p><p>Do you have an updated <code>janus.plugin.audiobridge.jcfg</code> configuration file? If not, make sure you copy the details of room <code>"+this.roomid+"</code> from that sample in your current configuration file, then restart Janus and try again."):435===msg.error_code?_log.default.debug(msg.error):_notification.default.alert(msg.error_code,msg.error));_log.default.debug(Object.keys(msg))}}jsep&&(_janusGateway.default.debug("Handling SDP as well...",jsep),this.videoroom.handleRemoteJsep({jsep:jsep}))}handleClick(e){const button=e.target.closest('[data-contextid="'+this.contextid+'"][data-action="publish"],  [data-contextid="'+this.contextid+'"][data-action="unpublish"]');if(button){const action=button.getAttribute("data-action"),type=button.getAttribute("data-type");switch(e.stopPropagation(),e.preventDefault(),document.querySelectorAll('[data-region="deft-venue"] [data-action="publish"],  [data-region="deft-venue"] [data-action="unpublish"]').forEach((button=>{button.getAttribute("data-action")==action&&button.getAttribute("data-type")==type?button.classList.add("hidden"):button.classList.remove("hidden")})),action){case"publish":"display"==type?this.shareDisplay():this.shareCamera(),this.processStream([]);break;case"unpublish":this.videoInput&&this.videoInput.then((videoStream=>(videoStream&&videoStream.getTracks().forEach((track=>{track.stop()})),this.videoInput=null,videoStream))).catch(_notification.default.exception),this.unpublish()}}return!0}handleClose(){this.videoInput&&this.videoInput.then((videoStream=>(videoStream&&videoStream.getTracks().forEach((track=>{track.stop()})),videoStream))).catch(_notification.default.exception),this.janus.destroy(),document.querySelectorAll('[data-region="deft-venue"] [data-action="publish"]').forEach((button=>{button.classList.remove("hidden")})),document.querySelectorAll('[data-region="deft-venue"] [data-action="unpublish"]').forEach((button=>{button.classList.add("hidden")}))}stopStream(input){input&&input.then((videoStream=>(videoStream&&videoStream.getTracks().forEach((track=>{track.stop()})),videoStream))).catch(_notification.default.exception)}shareCamera(){const videoInput=this.videoInput;this.videoInput=navigator.mediaDevices.getUserMedia({video:!0,audio:!1}).then((videoStream=>(this.stopStream(videoInput),this.deviceType="camera",videoStream))).catch((e=>(_log.default.debug(e),videoInput)))}shareDisplay(){const videoInput=this.videoInput||Promise.resolve(null);this.videoInput=navigator.mediaDevices.getDisplayMedia({video:!0,audio:!0}).then((videoStream=>(this.stopStream(videoInput),this.deviceType="display",videoStream))).catch((()=>videoInput))}publishFeed(){return this.videoroom.webrtcStuff.pc&&"connected"==this.videoroom.webrtcStuff.pc.iceConnectionState?_ajax.default.call([{args:{id:Number(this.peerid),room:this.roomid},contextid:this.contextid,fail:_notification.default.exception,methodname:"block_deft_publish_feed"}])[0].then((result=>(setTimeout((()=>{this.videoroom.webrtcStuff.pc.getTransceivers().forEach((transceiver=>{const sender=transceiver.sender;if(sender.track&&this.selectedTrack&&sender.track.id==this.selectedTrack.id){const message=JSON.stringify({feed:this.feed,mid:transceiver.mid});this.videoroom.data({text:message,error:_log.default.debug})}}))})),result))).catch(_notification.default.exception):Promise.resolve(null)}getTransceiver(kind){let result=null;return this.videoroom.webrtcStuff.pc&&"connected"==this.videoroom.webrtcStuff.pc.iceConnectionState&&this.videoroom.webrtcStuff.pc.getTransceivers().forEach((transceiver=>{const sender=transceiver.sender;sender.track&&sender.track.id&&sender.track.kind==(kind||"video")&&(result=transceiver)})),result}unpublish(){return document.querySelectorAll('[data-region="deft-venue"] [data-action="publish"]').forEach((button=>{button.classList.remove("hidden")})),document.querySelectorAll('[data-region="deft-venue"] [data-action="unpublish"]').forEach((button=>{button.classList.add("hidden")})),_ajax.default.call([{args:{id:Number(this.feed),publish:!1,room:this.roomid},contextid:this.contextid,fail:_notification.default.exception,methodname:"block_deft_publish_feed"}])[0]}attach(){this.janus.attach({plugin:"janus.plugin.videoroom",opaqueId:"videoroom-"+_janusGateway.default.randomString(12),success:pluginHandle=>{this.videoroom=pluginHandle,this.register(pluginHandle)},error:function(error){_janusGateway.default.error("  -- Error attaching plugin...",error),_notification.default.alert("","Error attaching plugin... "+error)},ondata:data=>{const message=JSON.parse(data);if(message&&message.feed){const publish={request:"update",subscribe:[{feed:message.feed,mid:message.mid}]};this.videoroom.send({message:publish})}},onlocaltrack:this.onLocalTrack.bind(this),onremotetrack:this.onRemoteTrack.bind(this),onmessage:this.onMessage.bind(this)})}processStream(tracks){this.videoInput.then((videoStream=>{if(document.querySelectorAll('[data-region="deft-venue"] [data-action="publish"],  [data-region="deft-venue"] [data-action="unpublish"]').forEach((button=>{this.deviceType?"unpublish"==button.getAttribute("data-action")||button.getAttribute("data-type")!==this.deviceType?button.classList.remove("hidden"):button.classList.add("hidden"):"unpublish"==button.getAttribute("data-action")?button.classList.add("hidden"):button.classList.remove("hidden")})),videoStream&&this.currentStream!==videoStream){const transceiver=this.getTransceiver();if(this.currentStream=videoStream,videoStream.getVideoTracks().forEach((track=>{if(track.addEventListener("ended",(()=>{this.selectedTrack.id==track.id&&this.unpublish()})),transceiver)return this.videoroom.replaceTracks({tracks:[{type:"video",mid:transceiver.mid,capture:track}],error:_notification.default.exception}),void(this.selectedTrack=track);tracks.push({type:"video",capture:track,recv:!1}),this.selectedTrack=track})),!tracks.length)return videoStream;this.videoroom.createOffer({tracks:tracks,success:jsep=>{_janusGateway.default.debug("Got SDP!",jsep);this.videoroom.send({message:{request:"configure",video:!0,audio:!1},jsep:jsep})},error:function(error){_janusGateway.default.error("WebRTC error:",error),_notification.default.alert("WebRTC error... ",error.message)}})}return videoStream})).catch(_notification.default.exception)}},_exports.default}));

//# sourceMappingURL=publish.min.js.map