define("block_deft/subscribe",["exports","core/ajax","block_deft/janus-gateway","block_deft/publish","core/log","core/notification"],(function(_exports,_ajax,_janusGateway,_publish,_log,_notification){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Manage venue connections
   *
   * @module     block_deft/venue_manager
   * @copyright  2022 Daniel Thies <dethies@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_ajax=_interopRequireDefault(_ajax),_janusGateway=_interopRequireDefault(_janusGateway),_publish=_interopRequireDefault(_publish),_log=_interopRequireDefault(_log),_notification=_interopRequireDefault(_notification);class Subscribe extends _publish.default{startConnection(feed){this.feed=feed,this.current=feed,this.transactions={},this.creatingSubscription=!0,this.remoteStreams={},_janusGateway.default.init({debug:"all",callback:()=>{this.janus=new _janusGateway.default({server:this.server,iceServers:this.iceServers,success:()=>{this.janus.attach({plugin:"janus.plugin.videoroom",opaqueId:"videoroom-"+_janusGateway.default.randomString(12),success:pluginHandle=>{this.videoroom=pluginHandle,this.register(pluginHandle)},error:error=>{this.restart=!0,_janusGateway.default.error("  -- Error attaching plugin...",error),_notification.default.alert("","Error attaching plugin... "+error)},ondata:data=>{const message=JSON.parse(data);if(message&&message.feed){const publish={request:"update",subscribe:[{feed:message.feed,mid:message.mid}]};this.videoroom.send({message:publish})}},onlocaltrack:this.onLocalTrack.bind(this),onmessage:this.onMessage.bind(this),onremotetrack:(track,mid,on,metadata)=>{if(_janusGateway.default.debug("Remote track (mid="+mid+") "+(on?"added":"removed")+(metadata?" ("+metadata.reason+") ":"")+":",track),on)if(this.remoteStreams.hasOwnProperty(mid)||"video"!==track.kind){if(!this.remoteStreams.hasOwnProperty(mid)&&"audio"===track.kind){if(this.remoteStreams[mid]=track,this.remoteAudioStream)return;this.remoteAudioStream=new MediaStream([track]),this.remoteAudioStream.mid=mid,_log.default.debug(this.remoteAudioStream),this.attachAudio(this.remoteAudioStream)}}else{if(this.remoteStreams[mid]=track,this.remoteStream)return;this.remoteStream=new MediaStream([track]),this.remoteStream.mid=mid,_log.default.debug(this.remoteStream),this.attachVideo(this.remoteStream)}else delete this.remoteStreams[mid]}})},error:function(error){this.restart=!0,_log.default.debug(error)}})}})}register(pluginHandle){return _ajax.default.call([{args:{handle:pluginHandle.getId(),id:Number(this.peerid),plugin:pluginHandle.plugin,room:this.roomid,ptype:!1,feed:this.feed,session:pluginHandle.session.getSessionId()},contextid:this.contextid,fail:_notification.default.exception,methodname:"block_deft_join_room"}])[0]}onLocalTrack(){}onMessage(msg,jsep){_log.default.debug(msg);const pluginHandle=this.videoroom;_janusGateway.default.debug(" ::: Got a message :::",msg);const event=msg.videoroom;switch(_janusGateway.default.debug("Event: "+event),event){case"joined":if(msg.id&&(this.peerid=msg.id,_janusGateway.default.log("Successfully joined room "+msg.room+" with ID "+this.peerid),!this.webrtcUp)){const tracks=[{type:"video",capture:!0,recv:!1}];this.webrtcUp=!0,pluginHandle.createOffer({tracks:tracks,success:jsep=>{_janusGateway.default.debug("Got SDP!",jsep);pluginHandle.send({message:{request:"configure",video:!0,audio:!1},jsep:jsep})},error:function(error){_janusGateway.default.error("WebRTC error:",error),_notification.default.alert("WebRTC error... ",error.message)}})}break;case"destroyed":_janusGateway.default.warn("The room has been destroyed!"),_notification.default.alert("","The room has been destroyed",(function(){window.close()}));break;case"attached":this.creatingSubscription=!1;break;case"event":if(msg.error)return void(485===msg.error_code?_notification.default.alert("<p>Apparently room <code>"+this.roomid+"</code> is not configured</p>"):428===msg.error_code?this.restart=!0:_notification.default.alert(msg.error_code,msg.error))}jsep&&(_janusGateway.default.debug("Handling SDP as well...",jsep),pluginHandle.createAnswer({jsep:jsep,tracks:[{type:"data"}],success:function(jsep){_janusGateway.default.debug("Got SDP!"),_janusGateway.default.debug(jsep);let body={request:"start",room:this.roomid};pluginHandle.send({message:body,jsep:jsep})},error:function(error){_janusGateway.default.error("WebRTC error:",error),_notification.default.alert("WebRTC error... ",error.message)}}))}attachAudio(audioStream){_janusGateway.default.attachMediaStream(this.remoteVideo||document.getElementById("deft_venue_remote_audio"),audioStream)}attachVideo(videoStream){document.querySelectorAll('[data-region="deft-venue"] video').forEach((video=>{video.classList.remove("hidden")})),_janusGateway.default.attachMediaStream(this.remoteVideo||document.getElementById("deft_venue_remote_video"),videoStream)}}return _exports.default=Subscribe,_exports.default}));

//# sourceMappingURL=subscribe.min.js.map