define("plenumform_deft/media_manager",["exports","core/ajax","core/templates","block_deft/janus-gateway","core/log","core/notification","block_deft/publish","block_deft/subscribe","plenumform_deft/socket"],(function(_exports,_ajax,_templates,_janusGateway,_log,_notification,_publish,_subscribe,_socket){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/*
   * Plenary meeting Deft integration media manager
   *
   * @package    plenumform_deft
   * @module     plenumform_deft/media_manager
   * @copyright  2023 Daniel Thies
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */var room;Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_ajax=_interopRequireDefault(_ajax),_templates=_interopRequireDefault(_templates),_janusGateway=_interopRequireDefault(_janusGateway),_log=_interopRequireDefault(_log),_notification=_interopRequireDefault(_notification),_publish=_interopRequireDefault(_publish),_subscribe=_interopRequireDefault(_subscribe),_socket=_interopRequireDefault(_socket);_exports.default=class{constructor(contextid,token){this.remoteFeeds={},this.contextid=contextid;const socket=new _socket.default(contextid,token);socket.subscribe((()=>{this.updateMotions(contextid)})),this.initializeRoom(socket,contextid)}async initializeRoom(socket,contextid){try{const response=await this.getRoom();return this.iceservers=JSON.parse(response.iceservers),room={contextid:contextid,roomid:response.roomid,server:response.server,autogaincontrol:response.autogaincontrol,echocancellation:response.echocancellation,noisesuppression:response.noisesuppression,iceServers:JSON.parse(response.iceservers)},this.roomid=response.roomid,this.server=response.server,document.querySelectorAll('[data-contextid="'+this.contextid+'"] .plenum-control').forEach((control=>{control.classList.remove("hidden")})),this.addListeners(),response}catch(e){_notification.default.exception(e)}return!1}async updateMotions(contextid){const selector='[data-contextid="'.concat(contextid,'"][data-region="plenum-motions"]'),content=document.querySelector(selector);if(content){const response=await _ajax.default.call([{args:{contextid:contextid},contextid:contextid,fail:_notification.default.exception,methodname:"plenumform_deft_update_content"}])[0];if(response.motions&&_templates.default.replaceNodeContents(content,response.motions,response.javascript),response.controls){const selector='[data-contextid="'.concat(contextid,'"][data-region="plenum-deft-controls"]');_templates.default.replaceNodeContents(selector,response.controls,"")}response.userinfo.forEach((speaker=>{document.querySelectorAll('[data-region="slot-'.concat(speaker.slot,'"] .card-header')).forEach((function(h){h.innerHTML=speaker.name})),document.querySelectorAll('[data-region="slot-'.concat(speaker.slot,'"] img')).forEach((function(img){img.src=speaker.pictureurl})),setTimeout((()=>{this.subscribeTo(speaker.id,speaker.slot),document.querySelectorAll('[data-region="slot-'.concat(speaker.slot,'"] audio')).forEach((audio=>{audio.setAttribute("data-speakerid",speaker.id),audio.volume=room.localFeed&&Number(room.localFeed.feed)==Number(speaker.id)?0:1}))}),1e3)}))}}getRoom(){return _ajax.default.call([{methodname:"plenumform_deft_get_room",args:{contextid:this.contextid},fail:_notification.default.exception}])[0]}addListeners(){document.querySelector("body").removeEventListener("click",handleClick),document.querySelector("body").addEventListener("click",handleClick),document.body.removeEventListener("click",this.muteAudio),document.body.addEventListener("click",this.muteAudio)}updateSubscription(source,slot,remoteFeed){const update={request:"update",subscribe:[{feed:Number(source)}],unsubscribe:[{feed:Number(remoteFeed.current)}]};!source&&remoteFeed.current?delete update.subscribe:source&&!remoteFeed.current&&delete update.unsubscribe,remoteFeed.current!=source&&(remoteFeed.muteAudio=!!room.localFeed&&room.localFeed.feed==source,remoteFeed.videoroom.send({message:update}),room.localFeed&&remoteFeed.current==Number(room.localFeed.feed)&&(room.localFeed.handleClose(),room.localFeed=null),remoteFeed.audioTrack&&(remoteFeed.audioTrack.enabled=!remoteFeed.muteAudio),room.publish&&remoteFeed.current==room.publish.feed&&(room.publish.handleClose(),room.publish=null),remoteFeed.current=source,!source&&remoteFeed&&(remoteFeed.handleClose(),this.remoteFeeds[slot]=null,document.querySelector('[data-region="slot-'.concat(slot,'"] video')).srcObject=null),Number(source)?(document.querySelectorAll('[data-contextid="'.concat(this.contextid,'"] [data-region="slot-').concat(slot,'"] img.card-img-top')).forEach((img=>{img.classList.add("hidden")})),document.querySelectorAll('[data-contextid="'.concat(this.contextid,'"] [data-region="slot-').concat(slot,'"] video')).forEach((video=>{video.classList.remove("hidden")}))):(document.querySelectorAll('[data-contextid="'.concat(this.contextid,'"] [data-region="slot-').concat(slot,'"] img.card-img-top')).forEach((img=>{img.classList.remove("hidden")})),document.querySelectorAll('[data-contextid="'.concat(this.contextid,'"] [data-region="slot-').concat(slot,'"] video')).forEach((video=>{video.classList.add("hidden")}))))}subscribeTo(source,slot){const remoteFeed=this.remoteFeeds[slot];if(!remoteFeed||remoteFeed.creatingSubscription||remoteFeed.restart){if(remoteFeed&&remoteFeed.restart)remoteFeed.current!=source&&(this.remoteFeeds[slot]=null,this.subscribeTo(source,slot));else if(remoteFeed)setTimeout((()=>{this.subscribeTo(source,slot)}),500);else if(source){const remoteFeed=new Subscribe(this.contextid,this.iceservers,this.roomid,this.server,this.contextid);remoteFeed.remoteVideo=document.querySelector('[data-contextid="'.concat(this.contextid,'"] [data-region="slot-').concat(slot,'"] video')),remoteFeed.remoteAudio=remoteFeed.remoteVideo.parentNode.querySelector("audio"),remoteFeed.muteAudio=!!room.localFeed&&room.localFeed.feed==source,remoteFeed.startConnection(source),this.remoteFeeds[slot]=remoteFeed}}else this.updateSubscription(source,slot,remoteFeed)}muteAudio(e){const input=e.target.closest('[data-region="audio-control"] input');input&&setTimeout((()=>{input.checked?document.querySelectorAll('[data-region="plenum-deft-media"] audio').forEach((audio=>{const speakerid=Number(audio.getAttribute("data-speakerid"));audio.muted="",audio.setAttribute("data-active","true"),audio.volume=room.localFeed&&Number(room.localFeed.feed)==speakerid?0:1,audio.play()})):document.querySelectorAll("audio").forEach((audio=>{audio.muted=!0,audio.removeAttribute("data-active")}))}))}};const handleClick=function(e){const button=e.target.closest('[data-region="plenum-motions"] [data-action], [data-region="plenum-deft-controls"] [data-action]');button&&("publish"==button.getAttribute("data-action")?(room.localFeed&&room.localFeed.janus.destroy(),room.localFeed=new Publish(room.contextid,room.iceServers,room.roomid,room.server,room.contextid),window.onbeforeunload=room.localFeed.handleClose.bind(room.localFeed),room.localFeed.videoInput=room.localFeed.shareCamera(room),room.localFeed.startConnection()):"unpublish"==button.getAttribute("data-action")&&(room.localFeed?(room.localFeed.handleClose(),room.localFeed=null):_ajax.default.call([{args:{id:0,publish:!1,room:room.roomid},contextid:room.contextid,fail:_notification.default.exception,methodname:"plenumform_deft_publish_feed"}])))};class Subscribe extends _subscribe.default{register(pluginHandle){return _ajax.default.call([{args:{handle:pluginHandle.getId(),id:Number(this.contextid),plugin:pluginHandle.plugin,room:this.roomid,ptype:!1,feed:this.feed,session:pluginHandle.session.getSessionId()},contextid:this.contextid,fail:_notification.default.exception,methodname:"plenumform_deft_join_room"}])[0]}attachAudio(audioStream){_janusGateway.default.attachMediaStream(this.remoteVideo.parentNode.querySelector("audio"),audioStream),audioStream.getTracks().forEach((track=>{this.audioTrack=track,track.enabled=!this.muteAudio}))}attachVideo(videoStream){this.remoteVideo.closest("[data-region]").querySelectorAll("img.card-img-top").forEach((img=>{img.classList.add("hidden")})),this.remoteVideo.classList.remove("hidden"),_janusGateway.default.attachMediaStream(this.remoteVideo,videoStream)}}class Publish extends _publish.default{async register(pluginHandle){try{const response=await _ajax.default.call([{args:{handle:pluginHandle.getId(),id:Number(this.contextid),plugin:pluginHandle.plugin,room:this.roomid,ptype:"publish"==this.ptype,session:pluginHandle.session.getSessionId()},contextid:this.contextid,fail:_notification.default.exception,methodname:"plenumform_deft_join_room"}])[0];return this.feed=response.id,response}catch(e){_notification.default.exception(e)}return!1}publishFeed(){return _ajax.default.call([{args:{id:Number(this.feed),room:this.roomid},contextid:this.contextid,fail:_notification.default.exception,methodname:"plenumform_deft_publish_feed"}])[0]}onLocalTrack(){}async shareCamera(room){if(this.videoInput)try{const videoStream=await this.videoInput;if(videoStream)return videoStream}catch(e){_log.default.debug(e)}try{const videoStream=await navigator.mediaDevices.getUserMedia({video:{aspectRatio:1,width:{max:160}},audio:{autoGainControl:room.autogaincontrol,echoCancellation:room.echocancellation,noiseSuppression:room.noisesuppression}});return this.tracks=this.tracks||{},videoStream.getTracks().forEach((track=>{this.tracks[track.id]="camera"})),videoStream}catch(e){_log.default.debug(e)}return null}async processStream(tracks){try{const videoStream=await this.videoInput;if(this.tracks=this.tracks||{},videoStream){const audiotransceiver=this.getTransceiver("audio"),videotransceiver=this.getTransceiver("video");if(videoStream.getVideoTracks().forEach((track=>{track.addEventListener("ended",(()=>{this.selectedTrack.id==track.id?this.unpublish():document.getElementById("video-controls-"+this.tracks[track.id]).parentNode.classList.add("hidden")})),this.selectedTrack=track,videotransceiver?this.videoroom.replaceTracks({tracks:[{type:"video",mid:videotransceiver.mid,capture:track}],error:_notification.default.exception}):tracks.push({type:"video",capture:track,recv:!1})})),videoStream.getAudioTracks().forEach((track=>{document.querySelector('.hidden[data-action="mute"][data-contextid="'+this.contextid+'"][data-type="'+this.tracks[this.selectedTrack.id]+'"]')&&(track.enabled=!1),audiotransceiver?this.videoroom.replaceTracks({tracks:[{type:"audio",mid:audiotransceiver.mid,capture:track}],error:_notification.default.exception}):tracks.push({type:"audio",capture:track,recv:!1})})),!tracks.length)return videoStream;this.videoroom.createOffer({tracks:tracks,success:jsep=>{this.videoroom.send({message:{request:"configure",video:!0,audio:!0},jsep:jsep})},error:function(error){_notification.default.alert("WebRTC error... ",error.message)}})}return videoStream}catch(e){_notification.default.exception(e)}return null}async handleClose(){if(this.janus.destroy(),_ajax.default.call([{args:{id:Number(this.feed),publish:!1,room:this.roomid},contextid:this.contextid,fail:_notification.default.exception,methodname:"plenumform_deft_publish_feed"}]),this.videoInput)try{const videoStream=await this.videoInput;videoStream&&videoStream.getTracks().forEach((track=>{track.stop()}))}catch(e){_notification.default.exception(e)}window.onbeforeunload=null}}return _exports.default}));

//# sourceMappingURL=media_manager.min.js.map