define("plenumform_jitsi2/media_manager",["exports","core/ajax","plenumform_jitsi2/lib-jitsi-meet.min","core/notification","core/templates"],(function(_exports,_ajax,_libJitsiMeet,_notification,_templates){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/*
   * Plenary meeting Jitsi integration media manager
   *
   * @package    plenumform_jitsi2
   * @module     plenumform_jitsi2/media_manager
   * @copyright  2025 Daniel Thies
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */var domain,connection;Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_ajax=_interopRequireDefault(_ajax),_libJitsiMeet=_interopRequireDefault(_libJitsiMeet),_notification=_interopRequireDefault(_notification),_templates=_interopRequireDefault(_templates);return _exports.default=class{constructor(contextid,delay,server,room,userinfo,jwt){return this.contextid=contextid,domain=server,this.userinfo=[],this.displayedTracks=[],this.videoTracks={},this.audioTracks={},delay&&setInterval((()=>{this.updateMotions(contextid)}),delay),_libJitsiMeet.default.init(),_libJitsiMeet.default.setLogLevel(_libJitsiMeet.default.logLevels.DEBUG),connection&&connection.disconnect(),(connection=new _libJitsiMeet.default.JitsiConnection(null,jwt,{serviceUrl:"https://".concat(domain,"/http-bind"),hosts:{domain:domain,muc:"conference.".concat(domain)}})).addEventListener(_libJitsiMeet.default.events.connection.CONNECTION_ESTABLISHED,(()=>{this.room=connection.initJitsiConference(room,{disableSimulcast:!0}),this.room.addEventListener(_libJitsiMeet.default.events.conference.TRACK_ADDED,(track=>{this.onRemoteTrack(track)})),this.room.addEventListener(_libJitsiMeet.default.events.conference.TRACK_REMOVED,(track=>{track.dispose()})),this.room.addCommandListener("updatecontent",(()=>{this.updateMotions(contextid)})),this.room.on(_libJitsiMeet.default.events.conference.CONFERENCE_JOINED,(()=>{this.updateMotions(contextid)})),document.body.addEventListener("motioncreated",(()=>{this.room.sendCommandOnce("updatecontent",{value:"updatecontent",attributes:{},children:[]})})),document.body.addEventListener("motionupdated",(()=>{this.room.sendCommandOnce("updatecontent",{value:"updatecontent",attributes:{},children:[]})})),this.room.join()})),connection.connect(),document.addEventListener("click",(e=>{this.handleClick(e)})),document.body.addEventListener("click",(e=>{this.muteAudio(e)})),!0}async updateMotions(contextid){const selector='[data-contextid="'.concat(contextid,'"][data-region="plenum-motions"]'),content=document.querySelector(selector);if(content){const response=await _ajax.default.call([{args:{contextid:contextid},contextid:contextid,fail:_notification.default.exception,methodname:"plenumform_jitsi2_update_content"}])[0];if(response.motions&&(_templates.default.replaceNodeContents(content,response.motions,response.javascript),this.userinfo=response.userinfo,this.updateMedia()),response.controls){const selector='[data-contextid="'.concat(contextid,'"][data-region="plenum-deft-controls"]');_templates.default.replaceNodeContents(selector,response.controls,"")}response.sharevideo||this.room.getLocalTracks().forEach((track=>{track.dispose()}))}}updateMedia(){this.displayedTracks.forEach((async track=>{this.userinfo.find((speaker=>speaker.id==track.getParticipantId()))||(document.querySelectorAll('[data-region="slot-'.concat(track.role,'"] ').concat(track.getType())).forEach((player=>{track.detach(player)})),delete this.displayedTracks[this.displayedTracks.indexOf(track)])})),this.userinfo.forEach((speaker=>{if(this.videoTracks[speaker.id]){const track=this.videoTracks[speaker.id];this.displayedTracks.includes(track)||(track.role=speaker.role,track.attach(document.querySelector('[data-region="slot-'.concat(speaker.role,'"] ').concat(track.getType()))),this.displayedTracks.push(track))}if(this.audioTracks[speaker.id]){const track=this.audioTracks[speaker.id];this.displayedTracks.includes(track)||(track.role=speaker.role,track.attach(document.querySelector('[data-region="slot-'.concat(speaker.role,'"] ').concat(track.getType()))),this.displayedTracks.push(track))}document.querySelectorAll('[data-region="slot-'.concat(speaker.role,'"] .card-header')).forEach((function(h){h.innerHTML=speaker.name})),document.querySelectorAll('[data-region="slot-'.concat(speaker.role,'"] video')).forEach((function(video){video.poster=speaker.pictureurl}))}))}onRemoteTrack(track){"video"==track.getType()?this.videoTracks[track.getParticipantId()]=track:this.audioTracks[track.getParticipantId()]=track,this.updateMedia()}async publish(publish){await _ajax.default.call([{args:{contextid:this.contextid,id:this.room.myUserId(),publish:publish},contextid:this.contextid,fail:_notification.default.exception,methodname:"plenumform_jitsi2_publish_feed"}])[0],this.room.sendCommandOnce("updatecontent",{value:"updatecontent",attributes:{},children:[]})}async handleClick(e){const button=e.target.closest('button[data-action="publish"], button[data-action="unpublish"]');if(button)if(e.stopPropagation(),e.preventDefault(),this.room.getLocalTracks().forEach((track=>{track.dispose()})),"publish"==button.dataset.action){(await _libJitsiMeet.default.createLocalTracks({devices:["video","audio"],constraints:{aspectRatio:{exact:1},height:{ideal:360},width:{ideal:360}}})).forEach((track=>{this["".concat(track.getType(),"Track")]?this.room.replaceTrack(this["".concat(track.getType(),"Track")],track):this.room.addTrack(track),this["".concat(track.getType(),"Track")]=track})),this.publish(!0)}else this.publish(!1)}muteAudio(e){const input=e.target.closest('[data-region="audio-control"] input');input&&setTimeout((()=>{input.checked?document.querySelectorAll('[data-region="plenum-deft-media"] audio').forEach((audio=>{this.room.getLocalTracks().length&&this.userinfo.find((speaker=>speaker.id==this.room.myUserId()&&audio.closest('[data-region="slot-'.concat(speaker.role,'"]'))))?(audio.volume=0,audio.muted=!0):(audio.volume=1,audio.muted="",audio.setAttribute("data-active","true")),audio.play()})):document.querySelectorAll("audio").forEach((audio=>{audio.muted=!0,audio.removeAttribute("data-active")}))}))}},_exports.default}));

//# sourceMappingURL=media_manager.min.js.map