<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package   mod_plenum
 * @category  string
 * @copyright 2023 Daniel Thies <dethies@gmail.com>
 * @license   https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['adoptmotion'] = 'Adopt motion';
$string['allowmotion'] = 'Allow motion';
$string['attachments'] = 'Attachments';
$string['automaticqueuing'] = 'Automatic queuing';
$string['cachedef_offeredmotions'] = 'Offered motions';
$string['cachedef_pendingmotions'] = 'Pending motions';
$string['closemotion'] = 'Yield';
$string['completiondetail:motions'] = 'Make motions: {$a}';
$string['completionmotions'] = 'Offer motions';
$string['confirmmessage'] = 'Do you wish to do the following action?';
$string['content'] = 'Content';
$string['createmotion'] = 'Create motion';
$string['declinemotion'] = 'Decline motion';
$string['defaultgradescale'] = 'Grading scale';
$string['defaultgradescale_help'] = 'The default grading scale for new meetings. Only standard scales are available.';
$string['defaultgradetype'] = 'Grade type';
$string['defaultgradetype_help'] = 'The default grade type for new meetings.';
$string['defaultsettings'] = 'Default settings';
$string['deleteallsessions'] = 'Delete all sessions';
$string['denymotion'] = 'Deny motion';
$string['feedback'] = 'Feedback';
$string['formdisabled'] = 'A valid meeting form is not selected';
$string['grade_motion_name'] = 'Grade motion';
$string['grade_plenum_name'] = 'Grade meeting';
$string['gradeitem:plenum'] = 'Grade meeting';
$string['gradeitemnameformotion'] = '{$a->name} motion';
$string['gradeitemnameforplenum'] = '{$a->name} plenum';
$string['grouprequired'] = 'This activity uses groups. You must select a group to which you have access.';
$string['indicator:cognitivedepth'] = 'Plenary meeting cognitive';
$string['indicator:cognitivedepth_help'] = 'This indicator is based on the cognitive depth reached by the student in a Plenary meeting activity.';
$string['indicator:cognitivedepthdef'] = 'Plenary meeting cognitive';
$string['indicator:cognitivedepthdef_help'] = 'The participant has reached this percentage of the cognitive engagement offered by the Plenary meeting activities during this analysis interval (Levels = No view, View, Submit)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Plenary meeting social';
$string['indicator:socialbreadth_help'] = 'This indicator is based on the social breadth reached by the student in a Plenary meeting activity.';
$string['indicator:socialbreadthdef'] = 'Plenary meeting social';
$string['indicator:socialbreadthdef_help'] = 'The participant has reached this percentage of the social engagement offered by the Plenary meeting activities during this analysis interval (Levels = No participation, Participant alone, Participant with others)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['manageplenumformplugins'] = 'Manage meeting form plugins';
$string['manageplenumtypeplugins'] = 'Manage motion plugins';
$string['manual'] = 'Manual';
$string['meetingform'] = 'Meeting form';
$string['meetingform_help'] = 'Choose a form to use for meeting. These options determine some of the rules to be used and how discussion takes place (e.g. in person or video assisted).';
$string['messageprovider:motions'] = 'Motion update';
$string['missingidandcmid'] = 'Plenary meeting';
$string['moderate'] = 'Moderate meeting';
$string['moderate_help'] = 'If set to manual, the president will have to approve motions and speakers, otherwise motions are queued in order received.';
$string['modulename'] = 'Plenary meeting';
$string['modulename_help'] = 'The Plenary meeting activity module
organizes online and in person meetings following traditional rules
of parliamentary procedure. It may be used as a tool to teach skills
to conduct a meeting or to structure and administer faculty, staff,
student or other organizational meetings.

Users are granted the privileges to speak, make motions, vote or chair
meetings through Moodle capabilities and roles. The activity maintains
a record of motions to provide meeting minutes. User actions are logged
in Moodle log system.';
$string['modulename_link'] = 'mod/plenum/view';
$string['modulenameplural'] = 'Plenary meetings';
$string['motion_created'] = 'Motion created';
$string['motion_deleted'] = 'Motion deleted';
$string['motion_updated'] = 'Motion updated';
$string['motion_viewed'] = 'Motion viewed';
$string['motionattachments'] = 'Motion attachments';
$string['motioncreated'] = 'Motion successfully created';
$string['motions'] = 'Motions';
$string['motiontype'] = 'Motion type';
$string['move'] = 'Move';
$string['needssecond'] = 'Needs second';
$string['nomotionoffered'] = 'No motion offered';
$string['noopensession'] = 'There is not currently a meeting open. Someone must first open the meeting before others can offer motions.';
$string['noplenuminstances'] = 'No plenary meetings';
$string['nopossiblemotions'] = 'There are currently no motions that you can offer.';
$string['offeredby'] = 'Offered by: {$a}';
$string['offeredmotions'] = 'Offered motions';
$string['page-mod-plenum-view'] = 'Plenary meeting view page';
$string['page-mod-plenum-x'] = 'Any Plenary meeting module page';
$string['pendingmotions'] = 'Pending motions';
$string['plenum:addinstance'] = 'Add plenary meeting';
$string['plenum:grade'] = 'Grade meeting';
$string['plenum:meet'] = 'Meet';
$string['plenum:preside'] = 'Preside';
$string['plenum:view'] = 'View';
$string['plenum_graded'] = 'Plenary meeting graded';
$string['plenumfieldset'] = 'Plenary';
$string['plenumname'] = 'Plenary meeting';
$string['plenumsettings'] = 'Plenary settings';
$string['pluginadministration'] = 'Plenary admin';
$string['pluginname'] = 'Plenary meeting';
$string['potentialmotions'] = 'Potential motions';
$string['precedingmotion'] = 'Preceding motion';
$string['privacy:metadata:core_files'] = 'Files attached to motions';
$string['privacy:metadata:plenum_grades'] = 'Plenary meeting grades';
$string['privacy:metadata:plenum_grades:feedback'] = 'Feedback text for gradebook.';
$string['privacy:metadata:plenum_grades:feedbackformat'] = 'Feedback text format for gradebook.';
$string['privacy:metadata:plenum_grades:grade'] = 'Grade';
$string['privacy:metadata:plenum_grades:grader'] = 'Grader';
$string['privacy:metadata:plenum_grades:plenum'] = 'Plenary meeting';
$string['privacy:metadata:plenum_grades:timecreated'] = 'Time when created.';
$string['privacy:metadata:plenum_grades:timemodified'] = 'Time that when last modified.';
$string['privacy:metadata:plenum_grades:userid'] = 'User id';
$string['privacy:metadata:plenum_motion'] = 'Motions belonging to user';
$string['privacy:metadata:plenum_motion:plugindata'] = 'Submitted motion data';
$string['privacy:metadata:plenum_motion:status'] = 'Current motion status';
$string['privacy:metadata:plenum_motion:timecreated'] = 'Time when created.';
$string['privacy:metadata:plenum_motion:timemodified'] = 'Time that when last modified.';
$string['privacy:metadata:plenum_motion:type'] = 'Motion type';
$string['privacy:metadata:plenum_motion:usercreated'] = 'Id of user that created motion';
$string['privacy:metadata:plenum_motion:usermodified'] = 'Id of user that last modified  motion';
$string['privacy:motions'] = 'Motions';
$string['recordings'] = 'Recordings';
$string['replacemotion'] = 'Replace motion';
$string['replacemotionwarning'] = 'You are offering a motion already, and you can only offer on at a time. Check box to replace that motion with this one.';
$string['search:activity'] = 'Plenary meeting - activity information';
$string['search:motion'] = 'Plenary meeting - motion information';
$string['sessions'] = 'Sessions';
$string['statusadopted'] = 'Adopted';
$string['statusclosed'] = 'Closed';
$string['statusdeclined'] = 'Declined';
$string['statusopen'] = 'Open';
$string['statuspending'] = 'Pending';
$string['subplugin_plenumform_plural'] = 'Meeting form plugins';
$string['subplugin_plenumtype_plural'] = 'Motions';
$string['subplugintype_plenumform'] = 'Plenary meeting forms';
$string['subplugintype_plenumform_plural'] = 'Meeting forms';
$string['subplugintype_plenumtype'] = 'Plenary motion';
$string['subplugintype_plenumtype_plural'] = 'Motions';
$string['subsidiarymotions'] = 'Subsidiary motions';
$string['timecreated'] = 'Time created: {$a}';
$string['timemodified'] = 'Time modified';
$string['type'] = 'Motion type';
$string['viewmotion'] = 'View motion';
