/**
 * Javascript Module to handle browser storage for format_tiles for student view.
 * (Can also be used by staff when they view the student view).
 * Stores and retrieves course content and settings
 * e.g. which filter button do I have pressed
 *
 * @module format_tiles/browser_storage
 * @copyright 2018 David Watson {@link http://evolutioncode.uk}
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since Moodle 3.3
 */
define("format_tiles/browser_storage",["jquery","format_tiles/browser_storage_set_up"],(function($,storageSetUp){var courseId,userId,localStorageKeyElements_course="mdl-tiles-course-",localStorageKeyElements_lastSection="-lastSecId",localStorageKeyElements_collapseSecZero="-collapsesec0",localStorageKeyElements_user="-user-",encodeLastVistedSectionKeyName=function(){return localStorageKeyElements_course+courseId+localStorageKeyElements_user+userId+localStorageKeyElements_lastSection},collapseSecZeroKey=function(){return localStorageKeyElements_course+courseId+localStorageKeyElements_user+userId+localStorageKeyElements_collapseSecZero},setLastVisitedSection=function(sectionNum){sectionNum&&storageSetUp.Enabled.local?localStorage.setItem(encodeLastVistedSectionKeyName(),sectionNum.toString()):localStorage.removeItem(encodeLastVistedSectionKeyName())};return{init:function(course,isEditing,sectionNum,assumeDataStoreConsent,user){courseId=course.toString(),userId=user.toString(),storageSetUp.init(userId,assumeDataStoreConsent),$(document).ready((function(){isEditing&&setLastVisitedSection(sectionNum)}))},storageEnabledSession:function(){return storageSetUp.Enabled.session},storageEnabledLocal:function(){return storageSetUp.Enabled.local},getLastVisitedSection:function(){return storageSetUp.Enabled.local&&localStorage.getItem(encodeLastVistedSectionKeyName())},setSecZeroCollapseStatus:function(status){storageSetUp.Enabled.local&&storageSetUp.storageAllowed()&&("collapsed"===status?localStorage.removeItem(collapseSecZeroKey()):localStorage.setItem(collapseSecZeroKey(),"1"))},getSecZeroCollapseStatus:function(){return!!localStorage.getItem(collapseSecZeroKey())},setLastVisitedSection:function(sectionNum){storageSetUp.storageAllowed()?setLastVisitedSection(sectionNum):setLastVisitedSection(null)}}}));

//# sourceMappingURL=browser_storage.min.js.map