define("mod_otopo/items/components/item",["mod_otopo/items/store","mod_otopo/items/ajax","mod_otopo/items/components/degree","mod_otopo/color","mod_otopo/utils","core/log"],(function(e,t,n,i,d,r){return{components:{Degree:n,ColorPicker:i},props:{otopo:{type:Number},item:{type:Object},index:{type:Number}},mounted:function(){this.$refs.name.focus()},data:function(){return{nbr:this.item.degrees.length,strings:this.$root.$data.strings,hasOtopo:this.$root.$data.hasOtopo,cmid:this.$root.$data.cmid,processChange:d.debounce((()=>this.saveItem())),validated:!1,creationPending:!1,collapsed:!1,state:this.$root.$data.state}},methods:{deleteItem(){!this.hasOtopo&&(t.deleteItem(this.item.id,this.cmid),e.deleteItem(this.index).forEach((e=>{if(e.id){var n={...e};delete n.degrees,t.editItem(n,this.cmid)}})))},duplicateItem(n){if(n.preventDefault(),!this.hasOtopo){const n={...this.item};delete n.id,n.degrees=[],e.addItemAfter(this.index,n).forEach((e=>{if(e.id){var n={...e};delete n.degrees,t.editItem(n,this.cmid)}}));var i={...n};delete i.degrees,t.createItem(this.otopo,i,this.cmid).then((e=>(n.id=e,this.item.degrees.forEach((e=>{var i={...e};delete i.id,t.createDegree(n.id,i,this.cmid).then((e=>(i.id=e,!0))).catch(r.error),n.degrees.push(i)})),!0))).catch(r.error)}},addDegree(t){t.preventDefault(),!this.hasOtopo&&(e.addDegreeToItem(this.item,{id:null,name:"",description:"",grade:this.nbr+1,ord:this.item.degrees.length>0?this.item.degrees[this.item.degrees.length-1].ord+1:0}),++this.nbr)},saveItem(){if(this.validated=!0,this.$refs.formItem.checkValidity()){const e={...this.item};delete e.degrees,e.id?t.editItem(e,this.cmid):!this.creationPending&&(this.creationPending=!0,delete e.id,t.createItem(this.otopo,e,this.cmid).then((e=>(this.item.id=e,this.creationPending=!1,!0))).catch(r.error))}},startDrag(t,n){!this.hasOtopo&&(t.dataTransfer.dropEffect="move",t.dataTransfer.effectAllowed="move",t.dataTransfer.setData("itemIndex",n),e.startDraggingItem())},endDrag(){e.stopDraggingItem()},onDrop(n,i){if(n.preventDefault(),!this.hasOtopo){const d=parseInt(n.dataTransfer.getData("itemIndex")),r=i?this.index:this.index+1;e.moveItem(d,r).forEach((e=>{if(e.id){var n={...e};delete n.degrees,t.editItem(n,this.cmid)}}))}},onDropDegree(n){if(n.preventDefault(),!this.hasOtopo){const o=parseInt(n.dataTransfer.getData("degreeIndex")),s=parseInt(n.dataTransfer.getData("itemIndex"));var i=e.deleteDegreeFromItem(this.$root.$data.state.items[s],o);if(i.ord=0,e.addDegreeToItem(this.item,i),i.id){t.deleteDegree(i.id,this.cmid);var d={...i};delete d.id,t.createDegree(this.item.id,d,this.cmid).then((t=>(e.degreeCreated(i,t),!0))).catch(r.error)}}},collapse(e){e.preventDefault(),this.collapsed=!this.collapsed}},computed:{isDragging(){return this.state.draggingItem},isDraggingDegree(){return this.state.draggingDegree}},template:'\n            <div class="item">\n                <div\n                    class="drop-zone"\n                    v-bind:class="{\'bg-otopo-light\': isDragging}"\n                    @dragover.prevent\n                    @dragenter.prevent\n                    @drop="onDrop($event, true)">\n                </div>\n                <div\n                    class="row border rounded bg-light pt-2"\n                >\n                    <div\n                        class="col-md-12"\n                        draggable\n                        @dragstart="startDrag($event, index)"\n                        @dragend="endDrag"\n                    >\n                        <a class="dropdown-toggle nav-link drag-title" href="#" v-on:click="collapse">\n                            <i class="icon fa fa-arrows"></i>\n                            <label\n                                class="font-weight-bold text-dark"\n                                :for="\'item_name_\' + index"\n                            >\n                                {{strings.item}} {{index+1}}\n                            </label>\n                        </a>\n                    </div>\n                    <div class="col-md-5" v-if="!collapsed">\n                        <form ref="formItem" v-bind:class="{ \'was-validated\': validated }">\n                        <div class="input-group mb-3">\n                            <input\n                                v-model="item.name"\n                                ref="name"\n                                class="form-control"\n                                type="text"\n                                maxlength="255"\n                                :title="strings.stringlimit255"\n                                :id="\'item_name_\' + index"\n                                :disabled="creationPending"\n                                @input="processChange()"\n                                required\n                            >\n                        </div>\n                        <label\n                            class="font-weight-bold text-dark"\n                            :for="\'item_color_\' + index"\n                        >\n                            {{strings.chooseitemcolor}}\n                        </label>\n                        <div class="input-group mb-3" :id="\'item_color_colorpicker_\' + index">\n                            <ColorPicker\n                                :color="item.color"\n                                v-model="item.color"\n                                :id="\'item_color_\' + index"\n                                @input="processChange()"\n                                :disabled="creationPending"\n                                required\n                            />\n                        </div>\n                        <button\n                            v-on:click="duplicateItem"\n                            :disabled="creationPending || hasOtopo"\n                            class="btn btn-primary mt-2 mb-3"\n                        >\n                            {{ strings.duplicateitem }}\n                        </button>\n                        <button\n                            v-on:click="deleteItem"\n                            :disabled="creationPending || hasOtopo"\n                            class="btn btn-danger mt-2 mb-3"\n                        >\n                            {{ strings.deleteitem }}\n                        </button>\n                        </form>\n                    </div>\n                    <div class="col-md-7" v-if="!collapsed">\n                        <Degree\n                        v-for="(degree, degreeIndex) in item.degrees"\n                        :key="degree.id ? degree.id : \'new_degree\' + degreeIndex"\n                        :item="item"\n                        :degree="degree"\n                        :index="degreeIndex"\n                        :itemIndex="index"\n                        />\n                        <a\n                            v-on:click="addDegree"\n                            :disabled="creationPending"\n                            class="mt-2 mb-3 d-inline-block"\n                            v-bind:class="{\'disabled\': hasOtopo}"\n                            href="#"\n                        >\n                            + {{ strings.adddegree }}\n                        </a>\n                        <div\n                            v-if="item.degrees.length === 0"\n                            class="drop-zone"\n                            v-bind:class="{\'bg-otopo-light\': isDraggingDegree}"\n                            @dropover.prevent\n                            @dragenter.prevent\n                            @drop="onDropDegree($event)">\n                        </div>\n                    </div>\n                </div>\n                <div\n                    class="drop-zone"\n                    v-bind:class="{\'bg-otopo-light\': isDragging}"\n                    @dragover.prevent\n                    @dragenter.prevent\n                    @drop="onDrop($event, false)">\n                </div>\n            </div>\n        '}}));

//# sourceMappingURL=item.min.js.map