define(["mod_otopo/otopo/components/degree-modal"],(function(e){return{components:{DegreeModalHelp:e},props:{degrees:{type:Array},itemName:{type:String},color:{type:String},degree:{type:Number,default:null},disabled:{type:Boolean,default:!1}},data:function(){return{images:this.$root.$data.images,strings:this.$root.$data.strings,selected:this.computeSelectedFromDegree(this.degree),showModal:!1}},watch:{degree:function(e){console.log("degrees.js: degree prop changed to",e),this.selected=this.computeSelectedFromDegree(e)}},methods:{computeSelectedFromDegree:function(e){if(null==e)return null;const t=Object.keys(this.degrees).find((t=>this.degrees[t].id===e));return void 0!==t?parseInt(t):null},selectNext(){this.disabled||(null===this.selected?this.selected=0:++this.selected,this.$emit("changed",this.degrees[this.selected].id))},selectPrevious(){this.disabled||(this.selected>0?(--this.selected,this.$emit("changed",this.degrees[this.selected].id)):(this.selected=null,this.$emit("changed",null)))}},computed:{starWidth:function(){return null===this.selected?0:100*(this.selected+1)/this.degrees.length},degreeName:function(){return null===this.selected?this.strings.autoeval:this.strings.degree+" "+(this.selected+1)},name:function(){return null===this.selected?this.strings.desc:this.degrees[this.selected].name},description:function(){return null===this.selected?"":this.degrees[this.selected].description.replace(/\n/g,"<br />")}},template:'\n            <div class="row" v-if="this.degrees.length > 0">\n                <div class="col-xl-6 no-print">\n                    <div class="d-flex flex-column justify-content-center degree-star-container">\n                        <div class="d-flex flex-row align-items-center justify-content-center">\n                            <div class="d-flex align-items-center justify-content-center degree-action degree-action-left">\n                                <img :src="images.minus" class="img-responsive invisible" />\n                            </div>\n                            <div class="d-flex align-items-center justify-content-center degree-container">\n                                <div\n                                    class="degree-star-mask"\n                                    :style="\'width: \' + starWidth + \'%;                                        -webkit-mask-image: url(\' + images.star + \');                                        mask-image: url(\' + images.star + \');\'"\n                                >\n                                    <div\n                                        :style="\'background-color: \' + color + \';                                            background: rgb(255,255,255);                                            background: linear-gradient(90deg, rgba(255,255,255,1) 0%, \' + color + \' 100%);\'"\n                                    >\n                                        <img :src="images.starContainer" class="img-responsive invisible" />\n                                    </div>\n                                </div>\n                            </div>\n                            <div class="d-flex align-items-center justify-content-center degree-action degree-action-right">\n                                <img :src="images.plus" class="img-responsive invisible" />\n                            </div>\n                        </div>\n                    </div>\n                    <div class="d-flex flex-row justify-content-center degree-background-container">\n                        <div class="d-flex align-items-center justify-content-center degree-action degree-action-left">\n                            <img :src="images.minus" class="img-responsive" v-if="selected != null" v-on:click="selectPrevious" />\n                        </div>\n                        <div class="d-flex align-items-center justify-content-center degree-container">\n                            <img :src="images.starContainer" class="img-responsive" />\n                        </div>\n                        <div class="d-flex align-items-center justify-content-center degree-action degree-action-right">\n                            <img :src="images.plus" class="img-responsive"\n                                v-if="selected == null || selected < this.degrees.length - 1" v-on:click="selectNext"\n                            />\n                        </div>\n                    </div>\n                    <div class="d-flex align-items-center justify-content-center">\n                        <div class="degree-action degree-action-bottom">\n                            <img :src="images.help" class="img-responsive" v-if="selected != null" @click="showModal = true" />\n                        </div>\n                    </div>\n                </div>\n                <div class="col-xl-6 degree-desc">\n                    <h3>{{ degreeName }}</h3>\n                    <p>{{ name }}</p>\n                </div>\n                <DegreeModalHelp v-if="showModal" @close="showModal = false" :itemName="itemName" :color="color"\n                    :degreeName="degreeName" :name="name" :description="description"\n                />\n            </div>\n        '}}));
