define("mod_edflex/browsercomponent",["exports","core/reactive","core/notification","core/ajax","core/templates","core/form-autocomplete"],(function(_exports,_reactive,_notification,_ajax,_templates,_formAutocomplete){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _defineProperty(obj,key,value){return key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_ajax=_interopRequireDefault(_ajax),_templates=_interopRequireDefault(_templates),_formAutocomplete=_interopRequireDefault(_formAutocomplete);class BrowserComponent extends _reactive.BaseComponent{constructor(data){super(data),_defineProperty(this,"showselectedcontents",!1),_defineProperty(this,"coursedata",{}),_defineProperty(this,"contentscache",{}),_defineProperty(this,"selectedcontents",[]),_defineProperty(this,"searchresult",[]),this.coursedata=data.coursedata||{}}create(){const self=this;self.selectors={PAGE:"[data-page]",RESULTS:".edflex-results",RESULTS_LOADING:".edflex-loading-results",RESULTS_EMPTY:".edflex-no-results",RESULTS_ERROR:".edflex-errors",RESULTS_LIST:".edflex-results-list",RESULTS_ACTIONS:".edflex-results-actions",RESULT_CHECKBOX:".edflex-id",IMPORT_BUTTON:".edflex-import-activities",SEARCH_BUTTON:"#edflexsearchactivities",SHOW_SEARCH_RESULT_BUTTON:".show-search-result",SHOW_SELECTED_CONTENTS_BUTTON:".show-selected-contents",SELECTED_CONTENTS_LIST:".selected-contents",QUERY:"#edflex_query",TYPE:"#edflex_content_type",LANGUAGE:"#edflex_content_language",CATEGORY:"#edflex_content_category"},self.loadBrowserContent().then((()=>{self.initElements(),self.initEventListeners(),self.elements.searchButton.disabled=!0,self.elements.importButton.classList.add("d-none");const modalElement=self.element.closest(".modal-dialog");if(modalElement){modalElement.querySelector(".modal-footer").appendChild(self.elements.actions)}return self.element.querySelectorAll(".select-multiple").forEach((sel=>{_formAutocomplete.default.enhance(sel,!1,!1,"",!1,!0,void 0,!0),sel.addEventListener("change",(()=>{const wrapper=sel.closest('.form-autocomplete, div.position-relative, div[id^="yui_"]'),input=null==wrapper?void 0:wrapper.querySelector('input.form-control[data-fieldtype="autocomplete"]');input&&(input.value="",input.dispatchEvent(new Event("input",{bubbles:!0})))}))})),!0})).catch(_notification.exception)}initElements(){this.elements={loading:this.element.querySelector(this.selectors.RESULTS_LOADING),empty:this.element.querySelector(this.selectors.RESULTS_EMPTY),errors:this.element.querySelector(this.selectors.RESULTS_ERROR),list:this.element.querySelector(this.selectors.RESULTS_LIST),selectedList:this.element.querySelector(this.selectors.SELECTED_CONTENTS_LIST),actions:this.element.querySelector(this.selectors.RESULTS_ACTIONS),query:this.element.querySelector(this.selectors.QUERY),type:this.element.querySelector(this.selectors.TYPE),language:this.element.querySelector(this.selectors.LANGUAGE),category:this.element.querySelector(this.selectors.CATEGORY),searchButton:this.element.querySelector(this.selectors.SEARCH_BUTTON),importButton:this.element.querySelector(this.selectors.IMPORT_BUTTON),showSearchResultButton:this.element.querySelector(this.selectors.SHOW_SEARCH_RESULT_BUTTON),showSelectedContentsButton:this.element.querySelector(this.selectors.SHOW_SELECTED_CONTENTS_BUTTON)}}initEventListeners(){const self=this;[self.elements.query,self.elements.type,self.elements.language,self.elements.category].forEach((element=>{let events=["change"];"text"===element.type&&events.push("input"),events.forEach((eventname=>{element.addEventListener(eventname,(()=>{self.elements.searchButton.disabled=self.filtersAreEmpty()}))}))})),self.elements.query.addEventListener("keydown",(e=>{"Enter"===e.key&&self.search()})),self.element.addEventListener("change",(e=>{if(e.target.matches(self.selectors.RESULT_CHECKBOX)){const checkbox=e.target;if(checkbox.checked&&checkbox.classList.contains("confirm")){confirm(M.util.get_string("confirmsameactivitymultipletimesinthecourse","mod_edflex"))||(checkbox.checked=!1)}const contentid=checkbox.value;checkbox.checked?self.selectContent(contentid):self.unselectContent(contentid)}})),self.element.addEventListener("click",(e=>{if(e.target.matches(self.selectors.PAGE)){const page=e.target.getAttribute("data-page");self.search(page)}})),self.elements.searchButton.addEventListener("click",(e=>{e.preventDefault(),self.search()})),self.elements.showSelectedContentsButton.addEventListener("click",(e=>{e.preventDefault(),self.showselectedcontents=!0,self.resetDisplay(),self.showSelectedContents(),self.refreshActionButtons()})),self.elements.showSearchResultButton.addEventListener("click",(e=>{e.preventDefault(),self.showselectedcontents=!1,self.resetDisplay(),self.showSearchResult(),self.refreshActionButtons()})),self.elements.importButton.addEventListener("click",(e=>{e.preventDefault();const ids=self.selectedcontents.map((item=>item.edflexid));if(!ids.length)return!0;const args={edflexid:ids,course:self.coursedata.course,section:self.coursedata.section};return _ajax.default.call([{methodname:"mod_edflex_import_activity",args:args}])[0].then((_ref=>{let redirecturl,{activities:activities,course:course}=_ref;return activities&&1===activities.length&&(redirecturl=activities[0].url),redirecturl||(redirecturl=course.url),window.location.assign(redirecturl),!0})).catch((error=>{self.showError(error.message||error)}))}))}refreshActionButtons(){const{importButton:importButton,showSearchResultButton:showSearchResultButton,showSelectedContentsButton:showSelectedContentsButton}=this.elements;this.selectedcontents.length?importButton.classList.remove("d-none"):importButton.classList.add("d-none"),showSelectedContentsButton.classList.add("d-none"),showSearchResultButton.classList.add("d-none"),this.showselectedcontents?showSearchResultButton.classList.remove("d-none"):this.selectedcontents.length&&showSelectedContentsButton.classList.remove("d-none")}getFilters(){var _self$elements$query;return{query:((null===(_self$elements$query=this.elements.query)||void 0===_self$elements$query?void 0:_self$elements$query.value)||"").trim(),type:Array.from(this.elements.type.selectedOptions).map((opt=>opt.value)).join(","),language:Array.from(this.elements.language.selectedOptions).map((opt=>opt.value)).join(","),category:Array.from(this.elements.category.selectedOptions).map((opt=>opt.value)).join(",")}}filtersAreEmpty(){const filters=this.getFilters();for(const filter in filters)if(filters[filter])return!1;return!0}search(){let page=arguments.length>0&&void 0!==arguments[0]?arguments[0]:1;const self=this,filters=self.getFilters(),course=self.coursedata.course,{empty:empty}=self.elements;self.resetDisplay();const promise=_ajax.default.call([{methodname:"mod_edflex_browser_search",args:{filters:filters,course:course,page:page}}])[0].then((result=>(self.searchresult=result,self.showSearchResult(),self.elements.searchButton.disabled=!0,result))).catch((error=>{empty.classList.remove("d-none"),self.showError(error.message||error)}));return self.showLoader(promise),promise}showLoader(promise){const{loading:loading}=this.elements;loading.classList.remove("d-none"),promise.then((data=>(loading.classList.add("d-none"),data))).catch((err=>(loading.classList.add("d-none"),err)))}showSearchResult(){const self=this;let{contents:contents,pages:pages}=self.searchresult;const selectedcontents=Object.fromEntries(self.selectedcontents.map((item=>[item.edflexid,!0]))),{empty:empty,list:list}=self.elements;contents&&0!==contents.length?(contents=contents.map((item=>(item.is_selected=selectedcontents[item.edflexid]||!1,item))),_templates.default.render("mod_edflex/content_search_result",{contents:contents,pages:pages}).then((html=>(list.innerHTML=html,html))).catch((error=>{self.showError(error.message||error)})),list.classList.remove("d-none")):empty.classList.remove("d-none")}showSelectedContents(){const self=this;self.showselectedcontents=!0;const{empty:empty,selectedList:selectedList}=self.elements;self.selectedcontents.length?(self.selectedcontents.map((item=>(item.is_selected=!0,item))),_templates.default.render("mod_edflex/content_search_result",{contents:self.selectedcontents}).then((html=>(selectedList.innerHTML=html,html))).catch((error=>{self.showError(error.message||error)})),selectedList.classList.remove("d-none")):empty.classList.remove("d-none")}loadBrowserContent(){const self=this;return _ajax.default.call([{methodname:"mod_edflex_browser_html",args:{}}])[0].then((response=>(self.element.innerHTML=response.html,response)))}resetDisplay(){const{empty:empty,list:list,selectedList:selectedList,errors:errors}=this.elements;this.showselectedcontents=!1,empty.classList.add("d-none"),list.classList.add("d-none"),selectedList.classList.add("d-none"),errors.classList.add("d-none"),this.refreshActionButtons()}showError(error){const self=this;self.elements.errors&&(self.elements.errors.classList.remove("d-none"),self.elements.errors.innerHTML=error)}selectContent(contentid){var _self$searchresult;const self=this,contents=(null===(_self$searchresult=self.searchresult)||void 0===_self$searchresult?void 0:_self$searchresult.contents)||[];if(self.selectedcontents.find((item=>item.edflexid===contentid)))return;const content=self.contentscache[contentid]||contents.find((item=>item.edflexid===contentid));content&&(self.contentscache[content.edflexid]=content,self.selectedcontents.push(content)),self.refreshActionButtons()}unselectContent(contentid){this.selectedcontents=this.selectedcontents.filter((item=>item.edflexid!==contentid)),this.refreshActionButtons()}}return _exports.default=BrowserComponent,_exports.default}));

//# sourceMappingURL=browsercomponent.min.js.map