<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     mod_edflex
 * @category    string
 * @copyright   2025 Edflex <support@edflex.com>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['apiconnectionerror'] = '❌ Connection failed';
$string['apiconnectionsuccess'] = '✅ Connection successful';
$string['apiurl'] = 'API url';
$string['apiurl_desc'] = 'Edflex API url';
$string['apiurlinvalid'] = 'Edflex API url is invalid. Please review Edflex plugin settings';
$string['author'] = 'Author';
$string['cachedef_api'] = 'API';
$string['catalogid'] = 'Catalog ID';
$string['catalogid_desc'] = 'Catalog ID inside Edflex';
$string['category'] = 'Category';
$string['clientid'] = 'Client ID';
$string['clientid_desc'] = 'Edflex client ID';
$string['clientidinvalid'] = 'Edflex client ID is invalid. Please review Edflex plugin settings';
$string['clientsecret'] = 'Client secret';
$string['clientsecret_desc'] = 'Edflex client secret';
$string['clientsecretinvalid'] = 'Edflex client secret is invalid. Please review Edflex plugin settings';
$string['confirmsameactivitymultipletimesinthecourse'] = 'Are you sure you want to include the same activity several times in the course?';
$string['contenttype'] = 'Content type';
$string['contenttypearticle'] = 'Article';
$string['contenttypeassessment'] = 'Assessment';
$string['contenttypecourse'] = 'Course';
$string['contenttypeinteractive'] = 'Interactive';
$string['contenttypepodcast'] = 'Podcast';
$string['contenttypeprogram'] = 'Program';
$string['contenttyperoleplay'] = 'Roleplay';
$string['contenttypetopvoice'] = 'Top Voice';
$string['contenttypevideo'] = 'Video';
$string['couldnotidentifycatalogid'] = 'Could not identify Edflex catalog ID';
$string['difficulty'] = 'Difficulty';
$string['difficultyadvanced'] = 'Advanced';
$string['difficultyintermediate'] = 'Intermediate';
$string['difficultyintroductive'] = 'Introductive';
$string['downloadscormzipmissing'] = 'Scorm download URL is missing';
$string['duration'] = 'Duration';
$string['edflex:addinstance'] = 'Add a new Edflex activity';
$string['edflexbrowserloading'] = 'Loading...';
$string['edflexbrowsertitle'] = 'Browse Edflex Contents';
$string['edflexcontentidinvalid'] = 'Edflex content ID invalid';
$string['edflexidcannotbechanged'] = 'You cannot change the linked Edflex activity';
$string['edflexidisinthecourse'] = 'Already in this course';
$string['errorfetchingandmappingactivity'] = 'An error occurred while trying to fetch and map the activity from Edflex API';
$string['failedtofetchedflexcontents'] = 'Failed to load Edflex contents from the API';
$string['filesize'] = 'Size';
$string['importcontents'] = 'Import contents';
$string['importedflexactivity'] = 'Import Edflex activity';
$string['invalidaccesstoken'] = 'Invalid access token received from Edflex API';
$string['invalidapicategoryid'] = 'Invalid API category ID';
$string['invalidapiresponse'] = 'Invalid API Response';
$string['invalidcontentid'] = 'Invalid content ID';
$string['invalidcourseid'] = 'Invalid course ID';
$string['invalidscormurlprovided'] = 'Invalid SCORM URL provided';
$string['keywordssearch'] = 'Keywords search';
$string['language'] = 'Language';
$string['level'] = 'Level';
$string['missingcourse'] = 'Course ID is missing from the request';
$string['missingedflexid'] = 'Edflex ID is missing from the request';
$string['modulename'] = 'Edflex';
$string['modulenameplural'] = 'Edflex Activities';
$string['noedflexinstances'] = 'No Edflex Activities';
$string['noresults'] = 'No results';
$string['noscormpackage'] = 'No SCORM package is attached.';
$string['noscormpackageyet'] = 'No SCORM package yet. It will appear here after the first sync.';
$string['openedflexbrowser'] = 'Browse Edflex Contents';
$string['outputheading'] = 'Edflex is just a wrapper for SCORM activities!';
$string['pluginadministration'] = 'Edflex admin';
$string['pluginname'] = 'Edflex';
$string['privacy:metadata'] = 'The Edflex activity module does not store any personal data.';
$string['searcherror'] = 'An error occurred while searching for contents';
$string['synchronizecategoriestask'] = 'Edflex categories synchronization';
$string['synchronizecontentstask'] = 'Edflex contents synchronization';
$string['testconnection'] = 'Test API connection';
$string['viewsearchresult'] = 'View search result';
$string['viewselectedcontents'] = 'View selected contents';
