<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * The assignsubmission_edusharing submission_created event.
 *
 * @package    assignsubmission_edusharing
 * @copyright  metaVentis GmbH — http://metaventis.com
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace assignsubmission_edusharing\event;

use coding_exception;
use core\event\base;

/**
 * Class submission_created
 */
class submission_created extends \mod_assign\event\submission_created {

    /**
     * Init method.
     */
    protected function init(): void {
        parent::init();
        $this->data['objecttable'] = 'assignsubmission_edusharing';
    }

    /**
     * Returns non-localised description of what happened.
     *
     * @return string
     */
    public function get_description(): string {
        $descriptionstring = "The user with id '$this->userid' created a file submission and uploaded " .
            "'{$this->other['filesubmissioncount']}' edu-sharing file in the assignment with course module id " .
            "'$this->contextinstanceid'";
        if (!empty($this->other['groupid'])) {
            $descriptionstring .= " for the group with id '{$this->other['groupid']}'.";
        } else {
            $descriptionstring .= ".";
        }

        return $descriptionstring;
    }

    /**
     * Custom validation.
     *
     * @throws coding_exception
     * @return void
     */
    protected function validate_data(): void {
        parent::validate_data();
        if (!isset($this->other['filesubmissioncount'])) {
            throw new coding_exception('The \'filesubmissioncount\' value must be set in other.');
        }
    }

    /**
     * Function get_objectid_mapping
     *
     * @return array
     */
    public static function get_objectid_mapping(): array {
        // No mapping available for 'assignsubmission_file'.
        return ['db' => 'assignsubmission_edusharing', 'restore' => base::NOT_MAPPED];
    }
}
