<?php
// This file is part of Moodle - http://moodle.org/
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

use mod_edusharing\IdpHelper;

/**
 * Provide a block to link directly to an user's workspace on repository.
 *
 * @package    block_edusharing_workspace
 * @copyright  metaVentis GmbH — http://metaventis.com
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

/**
 * Provide a block to link directly to an user's workspace on repository.
 *
 * @copyright  metaVentis GmbH — http://metaventis.com
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class block_edusharing_workspace extends block_base {
    /**
     * @var IdpHelper|null
     */
    private ?IdpHelper $idphelper = null;

    /**
     * Retrieves the IdP helper instance.
     *
     * @return IdpHelper The instance of the IdP helper.
     */
    private function get_idp_helper(): IdpHelper {
        if ($this->idphelper === null) {
            $this->idphelper = new IdpHelper();
        }
        return $this->idphelper;
    }

    /**
     * Initialize this block
     */
    public function init() {
        $this->title = '';

        if (!$this->get_idp_helper()->check_edu_access()) {
            return;
        }
        $this->title = get_string('block_title', 'block_edusharing_workspace');
        // phpcs:disable -- Just messy svg
        $eduicon = '<svg  version="1.1" id="Layer_1" xmlns="&ns_svg;" xmlns:xlink="&ns_xlink;" width="19.938" height="19.771"
                         viewBox="0 0 19.938 19.771" overflow="visible" enable-background="new 0 0 19.938 19.771" xml:space="preserve">
                        <polygon fill="#3162A7" points="2.748,19.771 0.027,15.06 2.748,10.348 8.188,10.348 10.908,15.06 8.188,19.771 "/>
                        <polygon fill="#7F91C3" points="11.776,14.54 9.056,9.829 11.776,5.117 17.218,5.117 19.938,9.829 17.218,14.54 "/>
                        <polygon fill="#C1C6E3" points="2.721,9.423 0,4.712 2.721,0 8.161,0 10.882,4.712 8.161,9.423 "/>
                    </svg>';
        // phpcs:enable
        $this->title = $eduicon . ' ' . get_string('block_title', 'block_edusharing_workspace');
    }

    /**
     * get block content
     *
     * @see blocks/block_base::get_content()
     */
    public function get_content() {
        if ($this->content !== null || !$this->get_idp_helper()->check_edu_access()) {
            return $this->content;
        }

        $repourl = rtrim(get_config('edusharing', 'application_cc_gui_url'), '/');
        $this->page->requires->js_call_amd('block_edusharing_workspace/main', 'main', [$repourl]);

        global $COURSE;

        $this->content = new stdClass();

        // phpcs:disable -- Just messy html
        $this->content->text = '
<form>
    <input type="hidden" id="eduCourseId" name="eduCourseId" value="' . $COURSE->id . '" />

    <div class="btn-group-vertical" role="group">
        <button id="workspace"
                name="action"
                value="default"
                class="btn btn-primary edu-workspace-button">
            ' . htmlentities(get_string('button_text', 'block_edusharing_workspace'), ENT_COMPAT) . '
        </button>
        <div class="bg-secondary" style="height: 2px;"></div>
        <button
                id="search"
                name="action"
                value="search"
                class="btn btn-primary edu-workspace-button">
            ' . htmlentities(get_string('button_text_secondary', 'block_edusharing_workspace'), ENT_COMPAT) . '
        </button>
    </div>
</form>';
        // phpcs:enable
        return $this->content;
    }
}
