define("tiny_edusharing/ui",["exports","./common","./options","core/templates","tiny_edusharing/modal","core/modal_events","core/modal_factory","./repository","core/config"],(function(_exports,_common,_options,_templates,_modal,_modal_events,_modal_factory,_repository,_config){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Script ui.js
   *
   * Contains all logic for the modal
   * - Insert form (opening repo, settings for object, inserting into editor)
   * - Edit form (changing settings, detecting, handling and converting old atto objects)
   *
   * On edit, old atto es objects will be converted to the format used by tinyMCE in order to ensure backwards
   * compatibility. Subsequently, they can no longer be edited using atto.
   *
   * @module      tiny_edusharing/ui
   * @copyright   2024 metaVentis GmbH <http://metaventis.com>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.initInstructionGif=_exports.handleAction=void 0,_modal=_interopRequireDefault(_modal),_modal_events=_interopRequireDefault(_modal_events),_modal_factory=_interopRequireDefault(_modal_factory),_config=_interopRequireDefault(_config);let openingSelection=null;_exports.handleAction=editor=>{openingSelection=editor.selection.getBookmark(),displayDialogue(editor)};_exports.initInstructionGif=()=>{const gif=window.document.getElementById("eduInstructionGif");if(null===gif)return;const relativePath=gif.getAttribute("src"),absolutePath=_config.default.wwwroot+relativePath;gif.setAttribute("src",absolutePath)};const displayDialogue=async editor=>{const selection=editor.selection.getNode();let currentEdusharing=selection.closest(".edusharing-placeholder"),isOldAttoElement=!1;if(null===currentEdusharing)if("IMG"===selection.nodeName&&selection.classList.contains("edusharing_atto")){const parent=selection.parentNode;"P"===parent.nodeName&&(currentEdusharing=parent,isOldAttoElement=!0)}else if("P"===selection.nodeName){const firstChild=selection.firstChild;"IMG"===firstChild.nodeName&&firstChild.classList.contains("edusharing_atto")&&(currentEdusharing=selection,isOldAttoElement=!0)}const isEditMode=null!==currentEdusharing,modal=await _modal_factory.default.create({type:_modal.default.TYPE,large:!0,removeOnClose:!0});modal.show();const $root=modal.getRoot(),root=$root[0];isEditMode?(()=>{let existingCaption=null;const nodeOptionsForm=window.document.getElementById("nodeOptionsForm"),existingCaptionParagraph=currentEdusharing.querySelector(".edusharing_caption");let paragraphToRemove=null;if(isOldAttoElement){const nextSibling=currentEdusharing.nextSibling;null!==nextSibling&&"P"===nextSibling.nodeName&&""!==nextSibling.innerText.trim()?(window.document.getElementById("eduCaptionText").innerHTML=nextSibling.innerText,window.document.getElementById("eduAttoCaptionPrompt").classList.remove("d-none"),window.document.getElementById("eduCaptionContinueButton").classList.remove("d-none"),window.document.getElementById("eduSubmitButton").classList.add("d-none"),nodeOptionsForm.classList.add("d-none"),window.document.getElementById("eduCaptionContinueButton").addEventListener("click",(()=>{const useExistingCaption="0"===window.document.querySelector('input[name="eduCaption"]:checked').value;paragraphToRemove=useExistingCaption?nextSibling:null,useExistingCaption&&(window.document.getElementById("captionInput").value=nextSibling.innerText,existingCaption=nextSibling.innerText),nodeOptionsForm.classList.remove("d-none"),window.document.getElementById("eduAttoCaptionPrompt").classList.add("d-none"),window.document.getElementById("eduCaptionContinueButton").classList.add("d-none"),window.document.getElementById("eduSubmitButton").classList.remove("d-none")}))):nodeOptionsForm.classList.remove("d-none")}else null!==existingCaptionParagraph&&(window.document.getElementById("captionInput").value=existingCaptionParagraph.innerHTML,existingCaption=existingCaptionParagraph.innerHTML),nodeOptionsForm.classList.remove("d-none");const submitButton=window.document.getElementById("eduSubmitButton");submitButton.disabled=!1,submitButton.innerHTML=submitButton.getAttribute("data-secondary-title");let isSizeEditable=!0;const modalTitle=root.querySelector(".modal-title");modalTitle.innerHTML=modalTitle.querySelector("input").value,window.document.getElementById("repoButtonContainer").classList.add("d-none");const eduImage=currentEdusharing.querySelector("img.edusharing_atto");if(null==eduImage)return root.querySelector(".mform").classList.add("d-none"),root.getElementById("eduNoEditInfo").classList.remove("d-none"),void root.getElementById("eduSubmitButton").classList.add("d-none");const objectUrl=eduImage.getAttribute("src");window.document.getElementById("eduPreviewImage").setAttribute("src",objectUrl);let url=new URL(objectUrl);const mediaType=url.searchParams.get("mediatype");let width=400,height=600;var _eduImage$getAttribut,_eduImage$getAttribut2;hideSizeOptions(mediaType)?isSizeEditable=!1:(width=parseInt(null!==(_eduImage$getAttribut=eduImage.getAttribute("width"))&&void 0!==_eduImage$getAttribut?_eduImage$getAttribut:400),height=parseInt(null!==(_eduImage$getAttribut2=eduImage.getAttribute("height"))&&void 0!==_eduImage$getAttribut2?_eduImage$getAttribut2:600),initSizeCalculation(width,height),hideHeightInput(mediaType)),window.document.getElementById("objectVersioningContainer").classList.add("d-none"),window.document.getElementById("eduContentTitle").innerHTML=url.searchParams.get("title");let alignment=""===currentEdusharing.style.float?"none":currentEdusharing.style.float;"none"===alignment&&isOldAttoElement&&(alignment=""===currentEdusharing.style.textAlign?"none":currentEdusharing.style.textAlign),"none"!==alignment&&(window.document.getElementById("eduAlignment"+("right"===alignment?"2":"1")).checked=!0),$root.on(_modal_events.default.save,(()=>{const newCaption=window.document.getElementById("captionInput").value,inputAlignment=window.document.querySelector('input[name="eduAlignment"]:checked').value,hasAlignmentChanged=inputAlignment!==alignment,inputWidth=parseInt(window.document.getElementById("eduWidth").value),inputHeight=parseInt(window.document.getElementById("eduHeight").value);let hasSizeChanged=inputHeight!==height||inputWidth!==width;if(isSizeEditable&&hasSizeChanged&&(url.searchParams.set("width",inputWidth),url.searchParams.set("height",inputHeight)),isOldAttoElement){let style="";"none"!==inputAlignment&&(style="float:"+inputAlignment+";"),"folder"===url.searchParams.get("mediatype")&&(style="display:block;"),(0,_templates.renderForPromise)("".concat(_common.component,"/content"),{edusharingImg:!0,edusharingRef:!1,edusharingPreviewSrc:url.toString(),edusharingTitle:url.searchParams.get("title"),edusharingInsertCaption:""!==window.document.getElementById("captionInput").value,edusharingCaption:window.document.getElementById("captionInput").value,edusharingWidth:inputWidth.toString(),edusharingHeight:inputHeight.toString(),edusharingStyle:style,dataEdited:hasAlignmentChanged||hasSizeChanged}).then((result=>{if(currentEdusharing.remove(),null!==paragraphToRemove){paragraphToRemove.remove();const nextParagraph=paragraphToRemove.nextSibling;null!==nextParagraph&&"P"===nextParagraph.nodeName&&nextParagraph.hasChildNodes()&&"BR"===nextParagraph.firstChild.nodeName&&""===nextParagraph.innerText&&nextParagraph.remove()}return editor.selection.moveToBookmark(openingSelection),editor.insertContent(result.html),editor.selection.moveToBookmark(openingSelection),!1})).catch((error=>window.console.log(error)))}else{if(null===existingCaption&&""!==newCaption){const newCaptionParagraph=document.createElement("p");newCaptionParagraph.classList.add("edusharing_caption"),newCaptionParagraph.innerHTML=newCaption,currentEdusharing.appendChild(newCaptionParagraph)}else null!==existingCaption&&""!==newCaption?existingCaptionParagraph.remove():null!==existingCaption&&(existingCaption.innerHTML=newCaption);hasAlignmentChanged&&("none"===inputAlignment?(currentEdusharing.style.removeProperty("float"),currentEdusharing.setAttribute("data-mce-style","")):(currentEdusharing.style.float=inputAlignment,currentEdusharing.setAttribute("data-mce-style","float: "+inputAlignment+";"))),isSizeEditable&&hasSizeChanged&&(eduImage.setAttribute("width",inputWidth),eduImage.setAttribute("height",inputHeight)),(hasAlignmentChanged||hasSizeChanged)&&(eduImage.setAttribute("src",url.toString()),eduImage.setAttribute("data-edited",1))}}))})():((()=>{root.addEventListener("click",(e=>{if(e.target.closest('[data-target="edusharing"]')){const repoUrl=(0,_options.getRepoUrl)(editor);openRepo(repoUrl,(0,_options.getRepoTarget)(editor),(0,_options.getCourseId)(editor)),window.addEventListener("message",applyNodeListener)}}));const applyNodeListener=event=>{if("APPLY_NODE"===event.data.event){var _node$name;const prepareModal=()=>{if(hideSizeOptions(node.mediatype))window.document.getElementById("edusharingNoWidth").value="true";else{const width=void 0!==node.properties["ccm:width"]?Math.round(node.properties["ccm:width"][0]):400,height=void 0!==node.properties["ccm:height"]?Math.round(node.properties["ccm:height"][0]):600;initSizeCalculation(width,height),hideHeightInput(node.mediatype)}hideCaptionInput(node.mediatype),setNodeData(node),window.document.getElementById("eduSubmitButton").disabled=!1},node=event.data.data,previewImage=window.document.getElementById("eduPreviewImage");window.win.close(),checkVersioning(node),window.document.getElementById("repoButtonContainer").classList.add("d-none"),window.document.getElementById("nodeOptionsForm").classList.remove("d-none"),window.document.getElementById("eduContentTitle").innerHTML=null!==(_node$name=node.name)&&void 0!==_node$name?_node$name:node.title;const ajaxParams={eduTicketStructure:{courseId:(0,_options.getCourseId)(editor)}};(0,_repository.getTicket)(ajaxParams).then((response=>{const previewUrl=new URL(node.preview.url),queryData=new URLSearchParams(previewUrl.search.slice(1));queryData.set("ticket",response.ticket);const newUrl=new URL(node.preview.url);return newUrl.search=queryData.toString(),previewImage.setAttribute("src",newUrl.toString()),prepareModal(),null})).fail((()=>{previewImage.setAttribute("src",node.preview.url),prepareModal()}))}}})(),$root.on(_modal_events.default.save,(()=>{(async editor=>{const nodeJson=window.document.getElementById("edusharing_node").value,node=JSON.parse(nodeJson),version=window.document.querySelector('input[name="eduVersion"]:checked').value,caption=window.document.getElementById("captionInput").value,alignment=window.document.querySelector('input[name="eduAlignment"]:checked').value;let width,height;if("true"===window.document.getElementById("edusharingNoWidth").value){const previewHeight=window.document.getElementById("eduPreviewImage").height;width=400,height=400/(window.document.getElementById("eduPreviewImage").width/previewHeight)}else width=window.document.getElementById("eduWidth").value,height=checkIfHeightApplicable(node.mediatype)?window.document.getElementById("eduHeight").value:"auto";let style="";"none"!==alignment&&(style="float:"+alignment+";"),"folder"===node.mediatype&&(style="display:block;");let title=node.title||node.name;const ajaxParams={eduTicketStructure:{courseId:(0,_options.getCourseId)(editor)}},ticket=await(0,_repository.getTicket)(ajaxParams).catch((error=>(window.console.error(error),"")));let url=new URL(node.previewUrl);url.searchParams.set("caption",caption),url.searchParams.set("object_url",node.objectUrl),url.searchParams.set("mediatype",node.mediatype),url.searchParams.set("mimetype",node.mimetype),url.searchParams.set("window_version",version),url.searchParams.set("title",title),""!==ticket&&url.searchParams.set("ticket",ticket.ticket);let img=!1,ref=!1;"ref"===node.mediatype?ref=!0:(img=!0,url.searchParams.set("width",width.toString()),url.searchParams.set("height",height.toString()));const content=await(0,_templates.renderForPromise)("".concat(_common.component,"/content"),{edusharingImg:img,edusharingRef:ref,edusharingPreviewSrc:url.toString(),edusharingTitle:title.toString(),edusharingInsertCaption:""!==caption.toString(),edusharingCaption:caption.toString(),edusharingWidth:width.toString(),edusharingHeight:height.toString(),edusharingStyle:style,dataEdited:!1});editor.selection.moveToBookmark(openingSelection),editor.execCommand("mceInsertContent",!1,content.html),editor.selection.moveToBookmark(openingSelection)})(editor)})))},hideSizeOptions=mediaType=>!!["file-word","file-pdf","file-odt","file-audio","file-pdf","link"].includes(mediaType)&&(window.document.getElementById("eduWidthContainer").classList.add("d-none"),!0),hideHeightInput=mediaType=>{if(!checkIfHeightApplicable(mediaType)){const heightInput=window.document.getElementById("eduHeight");heightInput.classList.add("d-none"),heightInput.labels&&heightInput.labels.forEach((label=>label.classList.add("d-none")))}},checkIfHeightApplicable=mediaType=>"file-video"!==mediaType,hideCaptionInput=mediaType=>{"ref"===mediaType&&window.document.getElementById("eduCaptionContainer").classList.add("d-none")},initSizeCalculation=(width,height)=>{if(0===width||0===height)return;const aspectRatio=width/height,heightInput=window.document.getElementById("eduHeight"),widthInput=window.document.getElementById("eduWidth");widthInput.value=width,heightInput.value=height,widthInput.addEventListener("keyup",(event=>recalculateDimensions(event))),widthInput.addEventListener("change",(event=>recalculateDimensions(event))),heightInput.addEventListener("keyup",(event=>recalculateDimensions(event))),heightInput.addEventListener("change",(event=>recalculateDimensions(event)));const recalculateDimensions=event=>{"eduHeight"===event.target.id?widthInput.value=Math.round(heightInput.value*aspectRatio):heightInput.value=Math.round(widthInput.value/aspectRatio)}},checkVersioning=node=>{const hasVersion=void 0!==node.properties["cclom:version"];(node.aspects.includes("ccm:published")||node.aspects.includes("ccm:collection_io_reference")||!hasVersion)&&window.document.querySelectorAll(".eduVersionRadio").forEach((item=>item.classList.add("d-none"))),hasVersion&&(window.document.getElementById("eduVersion2").value=node.properties["cclom:version"][0])},setNodeData=node=>{const nodeData={mimetype:node.mimetype,mediatype:node.mediatype,title:node.title,objectUrl:node.objectUrl,name:node.name,previewUrl:node.preview.url};window.document.getElementById("edusharing_node").value=JSON.stringify(nodeData)},openRepo=(repoUrl,repoTarget,courseId)=>{switch(window.win=window.open(),window.win.document.write("Loading edu-sharing ticket..."),repoTarget){case"collections":repoTarget="/components/collections";break;case"workspace":repoTarget="/components/workspace/files";break;default:repoTarget="/components/search"}const ajaxParams={eduTicketStructure:{courseId:courseId}};(0,_repository.getTicket)(ajaxParams).then((response=>(repoUrl+=repoTarget+"?reurl=WINDOW&applyDirectories=false&ticket="+response.ticket,window.win.location.href=repoUrl,null))).fail((()=>window.document.write("Error loading ticket.")))}}));

//# sourceMappingURL=ui.min.js.map