define("tiny_edusharing/eduSubmit",["exports","./options","./repository","core/config"],(function(_exports,_options,_repository,_config){var obj;
/**
   * Script eduSubmit.js
   *
   * @module      tiny_edusharing/eduSubmit
   * @copyright   2024 metaVentis GmbH <http://metaventis.com>
   * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   *
   * This script contains all logic to be executed when the user saves the changes they made in the editor
   * by clicking the "save changes" button.
   * It also contains the logic for keeping score of es elements already present in the section opened.
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.initExistingElements=_exports.initEventHandler=void 0,_config=(obj=_config)&&obj.__esModule?obj:{default:obj};_exports.initEventHandler=editor=>{const form=editor.getContainer().closest("form");null!==form&&"function"==typeof form.submit&&form.addEventListener("submit",(async event=>{"id_submitbutton"!==event.submitter.id&&"id_submitbutton2"!==event.submitter.id||(event.preventDefault(),await convertForSubmit(editor),form.submit())}))};let initialElements=[];const convertForSubmit=async editor=>{const iterateAsync=async domNode=>{if(domNode.hasChildNodes())for(const node of domNode.childNodes)await iterateAsync(node);if(void 0!==domNode.classList&&domNode.classList.contains("edusharing_atto")){let link=domNode.getAttribute("img"===domNode.nodeName.toLowerCase()?"src":"href"),searchParams=new URL(link).searchParams,indexOfElement=initialElements.indexOf(parseInt(searchParams.get("resourceId")));if(indexOfElement>=0){if(initialElements.splice(indexOfElement,1),null!==domNode.getAttribute("data-edited")&&""!==domNode.getAttribute("data-edited")){let ajaxParams={eduStructure:{id:parseInt(searchParams.get("resourceId")),courseId:parseInt((0,_options.getCourseId)(editor)),objectUrl:searchParams.get("object_url")}};void 0===(await(0,_repository.updateInstance)(ajaxParams)).id&&window.console.log("Error updating instance"),domNode.removeAttribute("data-edited")}}else{let ajaxParams={eduStructure:{name:searchParams.get("title"),objectUrl:searchParams.get("object_url"),courseId:parseInt((0,_options.getCourseId)(editor)),objectVersion:searchParams.get("window_version")}},response=await(0,_repository.addEduSharingInstance)(ajaxParams);if(void 0!==response.id){let isImage="img"===domNode.nodeName.toLowerCase(),previewUrl="".concat(_config.default.wwwroot,"/mod/edusharing/preview.php")+"?resourceId="+response.id+"&"+searchParams.toString();domNode.setAttribute(isImage?"src":"href",previewUrl)}}}},container=window.document.createElement("div");container.innerHTML=editor.getContent(),await iterateAsync(container),editor.setContent(container.innerHTML);for(const resourceId of initialElements)await(0,_repository.deleteEduSharingInstance)({eduDeleteStructure:{id:resourceId,courseId:parseInt((0,_options.getCourseId)(editor))}})};_exports.initExistingElements=editor=>{const iterate=domNode=>{if(domNode.hasChildNodes())for(const node of domNode.childNodes)iterate(node);if(void 0!==domNode.classList&&domNode.classList.contains("edusharing_atto")){let link=domNode.getAttribute("img"===domNode.nodeName.toLowerCase()?"src":"href"),uri=new URL(link);initialElements.push(parseInt(uri.searchParams.get("resourceId")))}},container=window.document.createElement("div");container.innerHTML=editor.getContent(),iterate(container)}}));

//# sourceMappingURL=eduSubmit.min.js.map