<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * import_user_created file
 *
 * introduced  10/08/17 09:12
 *
 * @package   local_kopere_dashboard
 * @copyright 2017 Eduardo Kraus {@link https://eduardokraus.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_kopere_dashboard\event;

use core\event\base;
use Exception;

/**
 * Class import_user_created
 *
 * @package local_kopere_dashboard\event
 */
class import_user_created extends base {

    /**
     * Function init
     */
    protected function init() {
        $this->data["crud"] = "c";
        $this->data["action"] = "created";
        $this->data["edulevel"] = self::LEVEL_OTHER;
        $this->data["objecttable"] = "user";
    }

    /**
     * Function get_name
     *
     * @return string
     * @throws Exception
     */
    public static function get_name() {
        return get_string("userimport_import_user_created_name", "local_kopere_dashboard");
    }
}
