<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * input_checkbox_select file
 *
 * introduced 10/06/17 23:33
 *
 * @package   local_kopere_dashboard
 * @copyright 2017 Eduardo Kraus {@link https://eduardokraus.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_kopere_dashboard\html\inputs;

use Exception;
use local_kopere_dashboard\util\config;

/**
 * Class input_checkbox_select
 *
 * @package local_kopere_dashboard\html\inputs
 */
class input_checkbox_select extends input_select {
    /** @var bool */
    private $checked = false;

    /**
     * input_checkbox_select constructor.
     * @throws Exception
     */
    public function __construct() {
        $this->set_value("false");
        $this->set_values([
            ["key" => 0, "value" => get_string("no")],
            ["key" => 1, "value" => get_string("yes")],
        ]);
    }

    /**
     * Function new_instance
     *
     * @return input_checkbox_select|input_select
     * @throws Exception
     */
    public static function new_instance() {
        return new input_checkbox_select();
    }

    /**
     * Function is_checked
     *
     * @return bool
     */
    public function is_checked() {
        return $this->checked;
    }

    /**
     * Function set_checked
     *
     * @param $checked
     *
     * @return $this
     * @throws Exception
     */
    public function set_checked($checked) {
        $this->checked = $checked;

        if ($this->checked) {
            $this->set_value(1);
        } else {
            $this->set_value(0);
        }

        return $this;
    }

    /**
     * Function set_checked_by_config
     *
     * @param $configname
     *
     * @return $this
     * @throws Exception
     */
    public function set_checked_by_config($configname) {
        $this->set_name($configname);

        $this->checked = config::get_key_int($configname);
        if ($this->checked) {
            $this->set_value(1, PARAM_INT);
        } else {
            $this->set_value(0, PARAM_INT);
        }

        return $this;
    }
}
