<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Profile image for datatable
 *
 * introduced 18/05/2023 22:00
 *
 * @package   local_kopere_dashboard
 * @copyright 2017 Eduardo Kraus {@link https://eduardokraus.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use local_kopere_dashboard\util\photo;

require_once("../../config.php");

require_login();
$context = context_system::instance();
require_capability("local/kopere_dashboard:view", $context);
require_capability("local/kopere_dashboard:manage", $context);

$type = required_param("type", PARAM_TEXT);
$id = required_param("id", PARAM_TEXT);

switch ($type) {
    case "photo_user":
        photo::get_photo_user($id);
        break;
}
