<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Export templates JSON for environment migration.
 *
 * @package   message_kopereemail
 * @copyright 2026 Eduardo Kraus {@link https://eduardokraus.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use message_kopereemail\import_export\manager;

require_once(__DIR__ . "/../../../config.php");

require_login();
$context = context_system::instance();
require_capability("moodle/site:config", $context);
require_sesskey();

$payload = manager::build_payload();
$json = manager::encode_json($payload);

$filename = "kopereemail-config-" . date("Ymd-His") . ".json";

header("Content-Type: application/json; charset=utf-8");
header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
header("X-Content-Type-Options: nosniff");

echo $json;
exit;
