<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Editor for certificatebeautiful.
 *
 * @package   mod_certificatebeautiful
 * @copyright 2025 Eduardo Kraus https://eduardokraus.com/
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$languser = $CFG->lang;
if (isset($USER->lang)) {
    $languser = $USER->lang;
}
if (isset($SESSION->lang)) {
    $languser = $SESSION->lang;
}

$langs = [
    "en" => [
        "assetmanager-addbutton" => "Add image",
        "assetmanager-modaltitle" => "Select image",
        "assetmanager-uploadtitle" => "Drop files here or click to upload",
        "attachment" => "Attachment",
        "certificate_confirm_clear" => "Are you sure you want to clear the canvas?",
        "certificate_page_save" => "Save certificate page",
        "certificate_page_test" => "Test PDF",
        "clear" => "Clear canvas",
        "decoration" => "Decorations",
        "devicemanager-device" => "Device",
        "devicemanager-devices-desktop" => "Desktop",
        "devicemanager-devices-mobilelandscape" => "Mobile, landscape mode",
        "devicemanager-devices-mobileportrait" => "Mobile, portrait mode",
        "devicemanager-devices-tablet" => "Tablet",
        "dimensions" => "Dimensions",
        "domcomponents-names-" => "Box",
        "domcomponents-names-body" => "Body",
        "domcomponents-names-cell" => "Table Cell",
        "domcomponents-names-comment" => "Comment",
        "domcomponents-names-image" => "Image",
        "domcomponents-names-label" => "Label",
        "domcomponents-names-link" => "Link",
        "domcomponents-names-map" => "Map",
        "domcomponents-names-row" => "Table Row",
        "domcomponents-names-section" => "Section",
        "domcomponents-names-table" => "Table",
        "domcomponents-names-tbody" => "Table Body",
        "domcomponents-names-text" => "Text",
        "domcomponents-names-tfoot" => "Table Footer",
        "domcomponents-names-thead" => "Table Header",
        "domcomponents-names-video" => "Video",
        "domcomponents-names-wrapper" => "Body",
        "edit_code" => "Edit code",
        "edit_code_paste_here_html" => "Paste your HTML/CSS here and click Import",
        "fullscreen" => "Full Screen",
        "general" => "General",
        "open_block" => "Blocks",
        "open_layers" => "Layers",
        "open_sm" => "Style Manager",
        "panels-buttons-titles-export-template" => "View Code",
        "panels-buttons-titles-fullscreen" => "Fullscreen",
        "panels-buttons-titles-open-blocks" => "Open Blocks",
        "panels-buttons-titles-open-layers" => "Open Layer Manager",
        "panels-buttons-titles-open-sm" => "Open Style Manager",
        "panels-buttons-titles-open-tm" => "Settings",
        "panels-buttons-titles-preview" => "Preview",
        "panels-buttons-titles-sw-visibility" => "Show Components",
        "position" => "Position",
        "preview" => "Preview",
        "redo" => "Redo",
        "repeat" => "Repeat",
        "selectormanager-emptystate" => "- State -",
        "selectormanager-label" => "Classes",
        "selectormanager-selected" => "Selected",
        "selectormanager-states-active" => "Click",
        "selectormanager-states-hover" => "Hover",
        "selectormanager-states-nth-of-type-2n" => "Even/Odd",
        "settings" => "Settings",
        "show_border" => "Show Borders",
        "size" => "Size",
        "stylemanager-empty" => "Select an element to use the style manager",
        "stylemanager-filebutton" => "Images",
        "stylemanager-layer" => "Layer",
        "stylemanager-align-content" => "Align Content",
        "stylemanager-align-items" => "Align Items",
        "stylemanager-align-self" => "Align Self",
        "stylemanager-background" => "Background",
        "stylemanager-background-attachment" => "Background Attachment",
        "stylemanager-background-color" => "Background Color",
        "stylemanager-background-image" => "Background Image",
        "stylemanager-background-position" => "Background Position",
        "stylemanager-background-repeat" => "Background Repeat",
        "stylemanager-background-size" => "Background Size",
        "stylemanager-border" => "Border",
        "stylemanager-border-bottom-left" => "Border Bottom Left",
        "stylemanager-border-bottom-right" => "Border Bottom Right",
        "stylemanager-border-color" => "Border Color",
        "stylemanager-border-radius" => "Border Radius",
        "stylemanager-border-radius-bottom-left" => "Border Radius Bottom Left",
        "stylemanager-border-radius-bottom-right" => "Border Radius Bottom Right",
        "stylemanager-border-radius-top-left" => "Border Radius Top Left",
        "stylemanager-border-radius-top-right" => "Border Radius Top Right",
        "stylemanager-border-style" => "Border Style",
        "stylemanager-border-top-left" => "Border Top Left",
        "stylemanager-border-top-right" => "Border Top Right",
        "stylemanager-border-width" => "Border Width",
        "stylemanager-bottom" => "Bottom",
        "stylemanager-box-shadow" => "Box Shadow",
        "stylemanager-box-shadow-blur" => "Box Shadow Blur",
        "stylemanager-box-shadow-color" => "Box Shadow Color",
        "stylemanager-box-shadow-h" => "Box Shadow: Horizontal",
        "stylemanager-box-shadow-spread" => "Box Shadow Spread",
        "stylemanager-box-shadow-type" => "Box Shadow Type",
        "stylemanager-box-shadow-v" => "Box Shadow: Vertical",
        "stylemanager-color" => "Color",
        "stylemanager-display" => "Display",
        "stylemanager-flex-basis" => "Flex Basis",
        "stylemanager-flex-direction" => "Flex Direction",
        "stylemanager-flex-grow" => "Flex Grow",
        "stylemanager-flex-shrink" => "Flex Shrink",
        "stylemanager-flex-wrap" => "Flex Wrap",
        "stylemanager-float" => "Float",
        "stylemanager-font-family" => "Font Family",
        "stylemanager-font-size" => "Font Size",
        "stylemanager-font-weight" => "Font Weight",
        "stylemanager-height" => "Height",
        "stylemanager-justify-content" => "Justify Content",
        "stylemanager-left" => "Left",
        "stylemanager-letter-spacing" => "Letter Spacing",
        "stylemanager-line-height" => "Line Height",
        "stylemanager-margin" => "Margin",
        "stylemanager-margin-bottom" => "Margin Bottom",
        "stylemanager-margin-left" => "Margin Left",
        "stylemanager-margin-right" => "Margin Right",
        "stylemanager-margin-top" => "Margin Top",
        "stylemanager-max-height" => "Max Height",
        "stylemanager-max-width" => "Max Width",
        "stylemanager-order" => "Order",
        "stylemanager-padding" => "Padding",
        "stylemanager-padding-bottom" => "Padding Bottom",
        "stylemanager-padding-left" => "Padding Left",
        "stylemanager-padding-right" => "Padding Right",
        "stylemanager-padding-top" => "Padding Top",
        "stylemanager-perspective" => "Perspective",
        "stylemanager-position" => "Position",
        "stylemanager-right" => "Right",
        "stylemanager-text-align" => "Text Alignment",
        "stylemanager-text-shadow" => "Text Shadow",
        "stylemanager-text-shadow-blur" => "Text Shadow Blur",
        "stylemanager-text-shadow-color" => "Text Shadow Color",
        "stylemanager-text-shadow-h" => "Text Shadow: Horizontal",
        "stylemanager-text-shadow-v" => "Text Shadow: Vertical",
        "stylemanager-top" => "Top",
        "stylemanager-transform" => "Transform",
        "stylemanager-transform-rotate-x" => "Transform Rotate X",
        "stylemanager-transform-rotate-y" => "Transform Rotate Y",
        "stylemanager-transform-rotate-z" => "Transform Rotate Z",
        "stylemanager-transform-scale-x" => "Transform Scale X",
        "stylemanager-transform-scale-y" => "Transform Scale Y",
        "stylemanager-transform-scale-z" => "Transform Scale Z",
        "stylemanager-transition" => "Transition",
        "stylemanager-transition-duration" => "Transition Duration",
        "stylemanager-transition-property" => "Transition Property",
        "stylemanager-transition-timing-function" => "Transition Timing Function",
        "stylemanager-width" => "Width",
        "none" => "None",
        "underline" => "Underline",
        "linethrough" => "Strikethrough",
        "stylemanager-sectors-decorations" => "Decorations",
        "stylemanager-sectors-dimension" => "Dimension",
        "stylemanager-sectors-extra" => "Extra",
        "stylemanager-sectors-flex" => "Flex",
        "stylemanager-sectors-general" => "General",
        "stylemanager-sectors-layout" => "Layout",
        "stylemanager-sectors-typography" => "Typography",
        "typography" => "Typography",
        "traitmanager-empty" => "Select an element to use the trait manager",
        "traitmanager-label" => "Component Settings",
        "traitmanager-traits-options-target-_blank" => "New window",
        "traitmanager-traits-options-target-false" => "This window",
        "undo" => "Undo",
        "width" => "Width",
    ],
    "pt_br" => [
        "assetmanager-addbutton" => "Adicionar imagem",
        "assetmanager-modaltitle" => "Selecionar imagem",
        "assetmanager-uploadtitle" => "Arraste os arquivos aqui ou clique para fazer o upload",
        "attachment" => "Anexo",
        "certificate_confirm_clear" => "Você tem certeza de que deseja limpar a tela?",
        "certificate_page_save" => "Salvar página do certificado",
        "certificate_page_test" => "Testar PDF",
        "clear" => "Limpar tela",
        "decoration" => "Decorações",
        "devicemanager-device" => "Dispositivo",
        "devicemanager-devices-desktop" => "Desktop",
        "devicemanager-devices-mobilelandscape" => "Celular, modo paisagem",
        "devicemanager-devices-mobileportrait" => "Celular, modo retrato",
        "devicemanager-devices-tablet" => "Tablet",
        "dimensions" => "Dimensões",
        "domcomponents-names-" => "Caixa",
        "domcomponents-names-body" => "Corpo",
        "domcomponents-names-cell" => "Célula da tabela",
        "domcomponents-names-comment" => "Comentário",
        "domcomponents-names-image" => "Imagem",
        "domcomponents-names-label" => "Rótulo",
        "domcomponents-names-link" => "Link",
        "domcomponents-names-map" => "Mapa",
        "domcomponents-names-row" => "Linha da tabela",
        "domcomponents-names-section" => "Seção",
        "domcomponents-names-table" => "Tabela",
        "domcomponents-names-tbody" => "Corpo da tabela",
        "domcomponents-names-text" => "Texto",
        "domcomponents-names-tfoot" => "Rodapé da tabela",
        "domcomponents-names-thead" => "Cabeçalho da tabela",
        "domcomponents-names-video" => "Vídeo",
        "domcomponents-names-wrapper" => "Corpo",
        "edit_code" => "Editar código",
        "edit_code_paste_here_html" => "Cole seu HTML/CSS aqui e clique em Importar",
        "fullscreen" => "Tela cheia",
        "general" => "Geral",
        "open_block" => "Blocos",
        "open_layers" => "Camadas",
        "open_sm" => "Gerenciador de Estilos",
        "panels-buttons-titles-export-template" => "Ver código",
        "panels-buttons-titles-fullscreen" => "Tela cheia",
        "panels-buttons-titles-open-blocks" => "Abrir blocos",
        "panels-buttons-titles-open-layers" => "Abrir gerenciador de camadas",
        "panels-buttons-titles-open-sm" => "Abrir gerenciador de estilos",
        "panels-buttons-titles-open-tm" => "Configurações",
        "panels-buttons-titles-preview" => "Pré-visualizar",
        "panels-buttons-titles-sw-visibility" => "Mostrar componentes",
        "position" => "Posição",
        "preview" => "Pré-visualizar",
        "redo" => "Refazer",
        "repeat" => "Repetir",
        "selectormanager-emptystate" => "- Estado -",
        "selectormanager-label" => "Classes",
        "selectormanager-selected" => "Selecionado",
        "selectormanager-states-active" => "Clique",
        "selectormanager-states-hover" => "Passe o mouse",
        "selectormanager-states-nth-of-type-2n" => "Par/Ímpar",
        "settings" => "Configurações",
        "show_border" => "Mostrar bordas",
        "size" => "Tamanho",
        "stylemanager-empty" => "Selecione um elemento para usar o gerenciador de estilos",
        "stylemanager-filebutton" => "Imagens",
        "stylemanager-layer" => "Camada",
        "stylemanager-align-content" => "Alinhar conteúdo",
        "stylemanager-align-items" => "Alinhar itens",
        "stylemanager-align-self" => "Alinhar auto",
        "stylemanager-background" => "Plano de fundo",
        "stylemanager-background-attachment" => "Anexo de fundo",
        "stylemanager-background-color" => "Cor de fundo",
        "stylemanager-background-image" => "Imagem de fundo",
        "stylemanager-background-position" => "Posição do fundo",
        "stylemanager-background-repeat" => "Repetir fundo",
        "stylemanager-background-size" => "Tamanho do fundo",
        "stylemanager-border" => "Borda",
        "stylemanager-border-bottom-left" => "Borda inferior esquerda",
        "stylemanager-border-bottom-right" => "Borda inferior direita",
        "stylemanager-border-color" => "Cor da borda",
        "stylemanager-border-radius" => "Raio da borda",
        "stylemanager-border-radius-bottom-left" => "Raio da borda inferior esquerda",
        "stylemanager-border-radius-bottom-right" => "Raio da borda inferior direita",
        "stylemanager-border-radius-top-left" => "Raio da borda superior esquerda",
        "stylemanager-border-radius-top-right" => "Raio da borda superior direita",
        "stylemanager-border-style" => "Estilo da borda",
        "stylemanager-border-top-left" => "Borda superior esquerda",
        "stylemanager-border-top-right" => "Borda superior direita",
        "stylemanager-border-width" => "Largura da borda",
        "stylemanager-bottom" => "Inferior",
        "stylemanager-box-shadow" => "Sombra da caixa",
        "stylemanager-box-shadow-blur" => "Desfoque da sombra da caixa",
        "stylemanager-box-shadow-color" => "Cor da sombra da caixa",
        "stylemanager-box-shadow-h" => "Sombra da caixa: Horizontal",
        "stylemanager-box-shadow-spread" => "Espalhamento da sombra da caixa",
        "stylemanager-box-shadow-type" => "Tipo de sombra da caixa",
        "stylemanager-box-shadow-v" => "Sombra da caixa: Vertical",
        "stylemanager-color" => "Cor",
        "stylemanager-display" => "Exibição",
        "stylemanager-flex-basis" => "Base do Flex",
        "stylemanager-flex-direction" => "Direção do Flex",
        "stylemanager-flex-grow" => "Crescer Flex",
        "stylemanager-flex-shrink" => "Encolher Flex",
        "stylemanager-flex-wrap" => "Quebra Flex",
        "stylemanager-float" => "Flutuar",
        "stylemanager-font-family" => "Família de fontes",
        "stylemanager-font-size" => "Tamanho da fonte",
        "stylemanager-font-weight" => "Peso da fonte",
        "stylemanager-height" => "Altura",
        "stylemanager-justify-content" => "Justificar conteúdo",
        "stylemanager-left" => "Esquerda",
        "stylemanager-letter-spacing" => "Espaçamento entre letras",
        "stylemanager-line-height" => "Altura da linha",
        "stylemanager-margin" => "Margem",
        "stylemanager-margin-bottom" => "Margem inferior",
        "stylemanager-margin-left" => "Margem esquerda",
        "stylemanager-margin-right" => "Margem direita",
        "stylemanager-margin-top" => "Margem superior",
        "stylemanager-max-height" => "Altura máxima",
        "stylemanager-max-width" => "Largura máxima",
        "stylemanager-order" => "Ordem",
        "stylemanager-padding" => "Preenchimento",
        "stylemanager-padding-bottom" => "Preenchimento inferior",
        "stylemanager-padding-left" => "Preenchimento esquerdo",
        "stylemanager-padding-right" => "Preenchimento direito",
        "stylemanager-padding-top" => "Preenchimento superior",
        "stylemanager-perspective" => "Perspectiva",
        "stylemanager-position" => "Posição",
        "stylemanager-right" => "Direita",
        "stylemanager-text-align" => "Alinhamento do texto",
        "stylemanager-text-shadow" => "Sombra do texto",
        "stylemanager-text-shadow-blur" => "Desfoque da sombra do texto",
        "stylemanager-text-shadow-color" => "Cor da sombra do texto",
        "stylemanager-text-shadow-h" => "Sombra do texto: Horizontal",
        "stylemanager-text-shadow-v" => "Sombra do texto: Vertical",
        "stylemanager-top" => "Topo",
        "stylemanager-transform" => "Transformar",
        "stylemanager-transform-rotate-x" => "Transformar Rotação X",
        "stylemanager-transform-rotate-y" => "Transformar Rotação Y",
        "stylemanager-transform-rotate-z" => "Transformar Rotação Z",
        "stylemanager-transform-scale-x" => "Transformar Escala X",
        "stylemanager-transform-scale-y" => "Transformar Escala Y",
        "stylemanager-transform-scale-z" => "Transformar Escala Z",
        "stylemanager-transition" => "Transição",
        "stylemanager-transition-duration" => "Duração da transição",
        "stylemanager-transition-property" => "Propriedade da transição",
        "stylemanager-transition-timing-function" => "Função de tempo da transição",
        "stylemanager-width" => "Largura",
        "none" => "Nenhum",
        "underline" => "Sublinhado",
        "linethrough" => "Tachado",
        "stylemanager-sectors-decorations" => "Decorações",
        "stylemanager-sectors-dimension" => "Dimensão",
        "stylemanager-sectors-extra" => "Extra",
        "stylemanager-sectors-flex" => "Flex",
        "stylemanager-sectors-general" => "Geral",
        "stylemanager-sectors-layout" => "Layout",
        "stylemanager-sectors-typography" => "Tipografia",
        "typography" => "Tipografia",
        "traitmanager-empty" => "Selecione um elemento para usar o gerenciador de características",
        "traitmanager-label" => "Configurações do componente",
        "traitmanager-traits-options-target-_blank" => "Nova janela",
        "traitmanager-traits-options-target-false" => "Esta janela",
        "undo" => "Desfazer",
        "width" => "Largura",
    ],
    "es" => [
        "assetmanager-addbutton" => "Añadir imagen",
        "assetmanager-modaltitle" => "Seleccionar imagen",
        "assetmanager-uploadtitle" => "Suelte los archivos aquí o haga clic para subir",
        "attachment" => "Adjunto",
        "certificate_confirm_clear" => "¿Está seguro de que quiere limpiar el lienzo?",
        "certificate_page_save" => "Guardar página del certificado",
        "certificate_page_test" => "Probar PDF",
        "clear" => "Limpiar lienzo",
        "decoration" => "Decoraciones",
        "devicemanager-device" => "Dispositivo",
        "devicemanager-devices-desktop" => "Escritorio",
        "devicemanager-devices-mobilelandscape" => "Móvil, modo apaisado",
        "devicemanager-devices-mobileportrait" => "Móvil, modo retrato",
        "devicemanager-devices-tablet" => "Tableta",
        "dimensions" => "Dimensiones",
        "domcomponents-names-" => "Caja",
        "domcomponents-names-body" => "Cuerpo",
        "domcomponents-names-cell" => "Celda de tabla",
        "domcomponents-names-comment" => "Comentario",
        "domcomponents-names-image" => "Imagen",
        "domcomponents-names-label" => "Etiqueta",
        "domcomponents-names-link" => "Enlace",
        "domcomponents-names-map" => "Mapa",
        "domcomponents-names-row" => "Fila de tabla",
        "domcomponents-names-section" => "Sección",
        "domcomponents-names-table" => "Tabla",
        "domcomponents-names-tbody" => "Cuerpo de tabla",
        "domcomponents-names-text" => "Texto",
        "domcomponents-names-tfoot" => "Pie de tabla",
        "domcomponents-names-thead" => "Encabezado de tabla",
        "domcomponents-names-video" => "Vídeo",
        "domcomponents-names-wrapper" => "Cuerpo",
        "edit_code" => "Editar código",
        "edit_code_paste_here_html" => "Pega tu HTML/CSS aquí y haz clic en Importar",
        "fullscreen" => "Pantalla completa",
        "general" => "General",
        "open_block" => "Bloques",
        "open_layers" => "Capas",
        "open_sm" => "Gestor de estilo",
        "panels-buttons-titles-export-template" => "Ver código",
        "panels-buttons-titles-fullscreen" => "Pantalla completa",
        "panels-buttons-titles-open-blocks" => "Abrir bloques",
        "panels-buttons-titles-open-layers" => "Abrir gestor de capas",
        "panels-buttons-titles-open-sm" => "Abrir gestor de estilo",
        "panels-buttons-titles-open-tm" => "Configuraciones",
        "panels-buttons-titles-preview" => "Vista previa",
        "panels-buttons-titles-sw-visibility" => "Mostrar componentes",
        "position" => "Posición",
        "preview" => "Vista previa",
        "redo" => "Rehacer",
        "repeat" => "Repetir",
        "selectormanager-emptystate" => "- Estado -",
        "selectormanager-label" => "Clases",
        "selectormanager-selected" => "Seleccionado",
        "selectormanager-states-active" => "Hacer clic",
        "selectormanager-states-hover" => "Pasar el ratón",
        "selectormanager-states-nth-of-type-2n" => "Par/Impar",
        "settings" => "Configuraciones",
        "show_border" => "Mostrar bordes",
        "size" => "Tamaño",
        "stylemanager-empty" => "Selecciona un elemento para usar el gestor de estilo",
        "stylemanager-filebutton" => "Imágenes",
        "stylemanager-layer" => "Capa",
        "stylemanager-align-content" => "Alinear contenido",
        "stylemanager-align-items" => "Alinear elementos",
        "stylemanager-align-self" => "Alinear a sí mismo",
        "stylemanager-background" => "Fondo",
        "stylemanager-background-attachment" => "Adjunto de fondo",
        "stylemanager-background-color" => "Color de fondo",
        "stylemanager-background-image" => "Imagen de fondo",
        "stylemanager-background-position" => "Posición de fondo",
        "stylemanager-background-repeat" => "Repetir fondo",
        "stylemanager-background-size" => "Tamaño de fondo",
        "stylemanager-border" => "Borde",
        "stylemanager-border-bottom-left" => "Borde inferior izquierdo",
        "stylemanager-border-bottom-right" => "Borde inferior derecho",
        "stylemanager-border-color" => "Color de borde",
        "stylemanager-border-radius" => "Radio de borde",
        "stylemanager-border-radius-bottom-left" => "Radio de borde inferior izquierdo",
        "stylemanager-border-radius-bottom-right" => "Radio de borde inferior derecho",
        "stylemanager-border-radius-top-left" => "Radio de borde superior izquierdo",
        "stylemanager-border-radius-top-right" => "Radio de borde superior derecho",
        "stylemanager-border-style" => "Estilo de borde",
        "stylemanager-border-top-left" => "Borde superior izquierdo",
        "stylemanager-border-top-right" => "Borde superior derecho",
        "stylemanager-border-width" => "Ancho de borde",
        "stylemanager-bottom" => "Abajo",
        "stylemanager-box-shadow" => "Sombra de caja",
        "stylemanager-box-shadow-blur" => "Desenfoque de sombra de caja",
        "stylemanager-box-shadow-color" => "Color de sombra de caja",
        "stylemanager-box-shadow-h" => "Sombra de caja: Horizontal",
        "stylemanager-box-shadow-spread" => "Expansión de sombra de caja",
        "stylemanager-box-shadow-type" => "Tipo de sombra de caja",
        "stylemanager-box-shadow-v" => "Sombra de caja: Vertical",
        "stylemanager-color" => "Color",
        "stylemanager-display" => "Visualización",
        "stylemanager-flex-basis" => "Flexión básica",
        "stylemanager-flex-direction" => "Dirección flexible",
        "stylemanager-flex-grow" => "Crecimiento flexible",
        "stylemanager-flex-shrink" => "Encogimiento flexible",
        "stylemanager-flex-wrap" => "Envuelto flexible",
        "stylemanager-float" => "Flotante",
        "stylemanager-font-family" => "Familia de fuentes",
        "stylemanager-font-size" => "Tamaño de fuente",
        "stylemanager-font-weight" => "Peso de fuente",
        "stylemanager-height" => "Altura",
        "stylemanager-justify-content" => "Justificar contenido",
        "stylemanager-left" => "Izquierda",
        "stylemanager-letter-spacing" => "Espaciado de letras",
        "stylemanager-line-height" => "Altura de línea",
        "stylemanager-margin" => "Margen",
        "stylemanager-margin-bottom" => "Margen inferior",
        "stylemanager-margin-left" => "Margen izquierdo",
        "stylemanager-margin-right" => "Margen derecho",
        "stylemanager-margin-top" => "Margen superior",
        "stylemanager-max-height" => "Altura máxima",
        "stylemanager-max-width" => "Ancho máximo",
        "stylemanager-order" => "Orden",
        "stylemanager-padding" => "Relleno",
        "stylemanager-padding-bottom" => "Relleno inferior",
        "stylemanager-padding-left" => "Relleno izquierdo",
        "stylemanager-padding-right" => "Relleno derecho",
        "stylemanager-padding-top" => "Relleno superior",
        "stylemanager-perspective" => "Perspectiva",
        "stylemanager-position" => "Posición",
        "stylemanager-right" => "Derecha",
        "stylemanager-text-align" => "Alineación de texto",
        "stylemanager-text-shadow" => "Sombra de texto",
        "stylemanager-text-shadow-blur" => "Desenfoque de sombra de texto",
        "stylemanager-text-shadow-color" => "Color de sombra de texto",
        "stylemanager-text-shadow-h" => "Sombra de texto: Horizontal",
        "stylemanager-text-shadow-v" => "Sombra de texto: Vertical",
        "stylemanager-top" => "Arriba",
        "stylemanager-transform" => "Transformar",
        "stylemanager-transform-rotate-x" => "Transformar Rotar X",
        "stylemanager-transform-rotate-y" => "Transformar Rotar Y",
        "stylemanager-transform-rotate-z" => "Transformar Rotar Z",
        "stylemanager-transform-scale-x" => "Transformar Escala X",
        "stylemanager-transform-scale-y" => "Transformar Escala Y",
        "stylemanager-transform-scale-z" => "Transformar Escala Z",
        "stylemanager-transition" => "Transición",
        "stylemanager-transition-duration" => "Duración de transición",
        "stylemanager-transition-property" => "Propiedad de transición",
        "stylemanager-transition-timing-function" => "Función de tiempo de transición",
        "stylemanager-width" => "Ancho",
        "none" => "Ninguno",
        "underline" => "Subrayado",
        "linethrough" => "Tachado",
        "stylemanager-sectors-decorations" => "Decoraciones",
        "stylemanager-sectors-dimension" => "Dimensión",
        "stylemanager-sectors-extra" => "Extra",
        "stylemanager-sectors-flex" => "Flex",
        "stylemanager-sectors-general" => "General",
        "stylemanager-sectors-layout" => "Diseño",
        "stylemanager-sectors-typography" => "Tipografía",
        "typography" => "Tipografía",
        "traitmanager-empty" => "Selecciona un elemento para usar el gestor de atributos",
        "traitmanager-label" => "Configuraciones del componente",
        "traitmanager-traits-options-target-_blank" => "Nueva ventana",
        "traitmanager-traits-options-target-false" => "Esta ventana",
        "undo" => "Deshacer",
        "width" => "Ancho",
    ],
    "es_mx" => [
        "assetmanager-addbutton" => "Agregar imagen",
        "assetmanager-modaltitle" => "Seleccionar imagen",
        "assetmanager-uploadtitle" => "Suelta los archivos aquí o haz clic para subir",
        "attachment" => "Adjunto",
        "certificate_confirm_clear" => "¿Estás seguro de que quieres borrar el lienzo?",
        "certificate_page_save" => "Guardar página del certificado",
        "certificate_page_test" => "Probar PDF",
        "clear" => "Borrar lienzo",
        "decoration" => "Decoraciones",
        "devicemanager-device" => "Dispositivo",
        "devicemanager-devices-desktop" => "Escritorio",
        "devicemanager-devices-mobilelandscape" => "Móvil, modo paisaje",
        "devicemanager-devices-mobileportrait" => "Móvil, modo retrato",
        "devicemanager-devices-tablet" => "Tableta",
        "dimensions" => "Dimensiones",
        "domcomponents-names-" => "Caja",
        "domcomponents-names-body" => "Cuerpo",
        "domcomponents-names-cell" => "Celda de la tabla",
        "domcomponents-names-comment" => "Comentario",
        "domcomponents-names-image" => "Imagen",
        "domcomponents-names-label" => "Etiqueta",
        "domcomponents-names-link" => "Enlace",
        "domcomponents-names-map" => "Mapa",
        "domcomponents-names-row" => "Fila de la tabla",
        "domcomponents-names-section" => "Sección",
        "domcomponents-names-table" => "Tabla",
        "domcomponents-names-tbody" => "Cuerpo de la tabla",
        "domcomponents-names-text" => "Texto",
        "domcomponents-names-tfoot" => "Pie de la tabla",
        "domcomponents-names-thead" => "Encabezado de la tabla",
        "domcomponents-names-video" => "Video",
        "domcomponents-names-wrapper" => "Cuerpo",
        "edit_code" => "Editar código",
        "edit_code_paste_here_html" => "Pega tu HTML/CSS aquí y haz clic en Importar",
        "fullscreen" => "Pantalla completa",
        "general" => "General",
        "open_block" => "Bloques",
        "open_layers" => "Capas",
        "open_sm" => "Administrador de estilos",
        "panels-buttons-titles-export-template" => "Ver código",
        "panels-buttons-titles-fullscreen" => "Pantalla completa",
        "panels-buttons-titles-open-blocks" => "Abrir bloques",
        "panels-buttons-titles-open-layers" => "Abrir Administrador de capas",
        "panels-buttons-titles-open-sm" => "Abrir Administrador de estilos",
        "panels-buttons-titles-open-tm" => "Configuraciones",
        "panels-buttons-titles-preview" => "Vista previa",
        "panels-buttons-titles-sw-visibility" => "Mostrar componentes",
        "position" => "Posición",
        "preview" => "Vista previa",
        "redo" => "Rehacer",
        "repeat" => "Repetir",
        "selectormanager-emptystate" => "- Estado -",
        "selectormanager-label" => "Clases",
        "selectormanager-selected" => "Seleccionado",
        "selectormanager-states-active" => "Hacer clic",
        "selectormanager-states-hover" => "Pasar el mouse",
        "selectormanager-states-nth-of-type-2n" => "Par/Impar",
        "settings" => "Configuraciones",
        "show_border" => "Mostrar bordes",
        "size" => "Tamaño",
        "stylemanager-empty" => "Selecciona un elemento para usar el administrador de estilos",
        "stylemanager-filebutton" => "Imágenes",
        "stylemanager-layer" => "Capa",
        "stylemanager-align-content" => "Alinear contenido",
        "stylemanager-align-items" => "Alinear elementos",
        "stylemanager-align-self" => "Alinearse",
        "stylemanager-background" => "Fondo",
        "stylemanager-background-attachment" => "Adjuntar fondo",
        "stylemanager-background-color" => "Color de fondo",
        "stylemanager-background-image" => "Imagen de fondo",
        "stylemanager-background-position" => "Posición de fondo",
        "stylemanager-background-repeat" => "Repetir fondo",
        "stylemanager-background-size" => "Tamaño de fondo",
        "stylemanager-border" => "Borde",
        "stylemanager-border-bottom-left" => "Borde inferior izquierdo",
        "stylemanager-border-bottom-right" => "Borde inferior derecho",
        "stylemanager-border-color" => "Color del borde",
        "stylemanager-border-radius" => "Radio del borde",
        "stylemanager-border-radius-bottom-left" => "Radio del borde inferior izquierdo",
        "stylemanager-border-radius-bottom-right" => "Radio del borde inferior derecho",
        "stylemanager-border-radius-top-left" => "Radio del borde superior izquierdo",
        "stylemanager-border-radius-top-right" => "Radio del borde superior derecho",
        "stylemanager-border-style" => "Estilo del borde",
        "stylemanager-border-top-left" => "Borde superior izquierdo",
        "stylemanager-border-top-right" => "Borde superior derecho",
        "stylemanager-border-width" => "Ancho del borde",
        "stylemanager-bottom" => "Fondo",
        "stylemanager-box-shadow" => "Sombra de caja",
        "stylemanager-box-shadow-blur" => "Desenfoque de sombra de caja",
        "stylemanager-box-shadow-color" => "Color de sombra de caja",
        "stylemanager-box-shadow-h" => "Sombra de caja: Horizontal",
        "stylemanager-box-shadow-spread" => "Difusión de sombra de caja",
        "stylemanager-box-shadow-type" => "Tipo de sombra de caja",
        "stylemanager-box-shadow-v" => "Sombra de caja: Vertical",
        "stylemanager-color" => "Color",
        "stylemanager-display" => "Mostrar",
        "stylemanager-flex-basis" => "Flex Basis",
        "stylemanager-flex-direction" => "Dirección de Flex",
        "stylemanager-flex-grow" => "Flex Grow",
        "stylemanager-flex-shrink" => "Flex Shrink",
        "stylemanager-flex-wrap" => "Flex Wrap",
        "stylemanager-float" => "Flotar",
        "stylemanager-font-family" => "Familia de fuente",
        "stylemanager-font-size" => "Tamaño de fuente",
        "stylemanager-font-weight" => "Peso de fuente",
        "stylemanager-height" => "Altura",
        "stylemanager-justify-content" => "Justificar contenido",
        "stylemanager-left" => "Izquierda",
        "stylemanager-letter-spacing" => "Espaciado de letras",
        "stylemanager-line-height" => "Altura de línea",
        "stylemanager-margin" => "Margen",
        "stylemanager-margin-bottom" => "Margen inferior",
        "stylemanager-margin-left" => "Margen izquierdo",
        "stylemanager-margin-right" => "Margen derecho",
        "stylemanager-margin-top" => "Margen superior",
        "stylemanager-max-height" => "Altura máxima",
        "stylemanager-max-width" => "Ancho máximo",
        "stylemanager-order" => "Orden",
        "stylemanager-padding" => "Relleno",
        "stylemanager-padding-bottom" => "Relleno inferior",
        "stylemanager-padding-left" => "Relleno izquierdo",
        "stylemanager-padding-right" => "Relleno derecho",
        "stylemanager-padding-top" => "Relleno superior",
        "stylemanager-perspective" => "Perspectiva",
        "stylemanager-position" => "Posición",
        "stylemanager-right" => "Derecha",
        "stylemanager-text-align" => "Alineación de texto",
        "stylemanager-text-shadow" => "Sombra de texto",
        "stylemanager-text-shadow-blur" => "Desenfoque de sombra de texto",
        "stylemanager-text-shadow-color" => "Color de sombra de texto",
        "stylemanager-text-shadow-h" => "Sombra de texto: Horizontal",
        "stylemanager-text-shadow-v" => "Sombra de texto: Vertical",
        "stylemanager-top" => "Superior",
        "stylemanager-transform" => "Transformar",
        "stylemanager-transform-rotate-x" => "Transformar rotación X",
        "stylemanager-transform-rotate-y" => "Transformar rotación Y",
        "stylemanager-transform-rotate-z" => "Transformar rotación Z",
        "stylemanager-transform-scale-x" => "Transformar escala X",
        "stylemanager-transform-scale-y" => "Transformar escala Y",
        "stylemanager-transform-scale-z" => "Transformar escala Z",
        "stylemanager-transition" => "Transición",
        "stylemanager-transition-duration" => "Duración de transición",
        "stylemanager-transition-property" => "Propiedad de transición",
        "stylemanager-transition-timing-function" => "Función de tiempo de transición",
        "stylemanager-width" => "Ancho",
        "none" => "Ninguno",
        "underline" => "Subrayado",
        "linethrough" => "Tachado",
        "stylemanager-sectors-decorations" => "Decoraciones",
        "stylemanager-sectors-dimension" => "Dimensión",
        "stylemanager-sectors-extra" => "Extra",
        "stylemanager-sectors-flex" => "Flex",
        "stylemanager-sectors-general" => "General",
        "stylemanager-sectors-layout" => "Diseño",
        "stylemanager-sectors-typography" => "Tipografía",
        "tipografia" => "Tipografía",
        "traitmanager-empty" => "Selecciona un elemento para usar el administrador de características",
        "traitmanager-label" => "Configuraciones del componente",
        "traitmanager-traits-options-target-_blank" => "Nueva ventana",
        "traitmanager-traits-options-target-false" => "Esta ventana",
        "undo" => "Deshacer",
        "width" => "Ancho",
    ],
    "ar" => [
        "assetmanager-addbutton" => "إضافة صورة",
        "assetmanager-modaltitle" => "اختر صورة",
        "assetmanager-uploadtitle" => "اسحب الملفات هنا أو انقر للتحميل",
        "attachment" => "مرفق",
        "certificate_confirm_clear" => "هل أنت متأكد أنك تريد مسح اللوحة؟",
        "certificate_page_save" => "حفظ صفحة الشهادة",
        "certificate_page_test" => "اختبار PDF",
        "clear" => "مسح اللوحة",
        "decoration" => "زخارف",
        "devicemanager-device" => "جهاز",
        "devicemanager-devices-desktop" => "سطح المكتب",
        "devicemanager-devices-mobilelandscape" => "هاتف محمول، وضع أفقي",
        "devicemanager-devices-mobileportrait" => "هاتف محمول، وضع عمودي",
        "devicemanager-devices-tablet" => "جهاز لوحي",
        "dimensions" => "الأبعاد",
        "domcomponents-names-" => "صندوق",
        "domcomponents-names-body" => "جسم",
        "domcomponents-names-cell" => "خلية جدول",
        "domcomponents-names-comment" => "تعليق",
        "domcomponents-names-image" => "صورة",
        "domcomponents-names-label" => "تسمية",
        "domcomponents-names-link" => "رابط",
        "domcomponents-names-map" => "خريطة",
        "domcomponents-names-row" => "صف جدول",
        "domcomponents-names-section" => "قسم",
        "domcomponents-names-table" => "جدول",
        "domcomponents-names-tbody" => "جسم الجدول",
        "domcomponents-names-text" => "نص",
        "domcomponents-names-tfoot" => "تذييل جدول",
        "domcomponents-names-thead" => "رأس جدول",
        "domcomponents-names-video" => "فيديو",
        "domcomponents-names-wrapper" => "جسم",
        "edit_code" => "تعديل الكود",
        "edit_code_paste_here_html" => "الصق HTML/CSS هنا واضغط استيراد",
        "fullscreen" => "شاشة كاملة",
        "general" => "عام",
        "open_block" => "كتل",
        "open_layers" => "الطبقات",
        "open_sm" => "مدير الأنماط",
        "panels-buttons-titles-export-template" => "عرض الكود",
        "panels-buttons-titles-fullscreen" => "شاشة كاملة",
        "panels-buttons-titles-open-blocks" => "فتح الكتل",
        "panels-buttons-titles-open-layers" => "فتح مدير الطبقات",
        "panels-buttons-titles-open-sm" => "فتح مدير الأنماط",
        "panels-buttons-titles-open-tm" => "الإعدادات",
        "panels-buttons-titles-preview" => "معاينة",
        "panels-buttons-titles-sw-visibility" => "عرض المكونات",
        "position" => "الموضع",
        "preview" => "معاينة",
        "redo" => "إعادة",
        "repeat" => "إعادة",
        "selectormanager-emptystate" => "- حالة -",
        "selectormanager-label" => "الفئات",
        "selectormanager-selected" => "محدد",
        "selectormanager-states-active" => "انقر",
        "selectormanager-states-hover" => "التنقل",
        "selectormanager-states-nth-of-type-2n" => "زوجي/فردي",
        "settings" => "الإعدادات",
        "show_border" => "عرض الحدود",
        "size" => "الحجم",
        "stylemanager-empty" => "اختر عنصرًا لاستخدام مدير الأنماط",
        "stylemanager-filebutton" => "الصور",
        "stylemanager-layer" => "طبقة",
        "stylemanager-align-content" => "محاذاة المحتوى",
        "stylemanager-align-items" => "محاذاة العناصر",
        "stylemanager-align-self" => "محاذاة الذات",
        "stylemanager-background" => "خلفية",
        "stylemanager-background-attachment" => "إرفاق الخلفية",
        "stylemanager-background-color" => "لون الخلفية",
        "stylemanager-background-image" => "صورة الخلفية",
        "stylemanager-background-position" => "موضع الخلفية",
        "stylemanager-background-repeat" => "تكرار الخلفية",
        "stylemanager-background-size" => "حجم الخلفية",
        "stylemanager-border" => "حدود",
        "stylemanager-border-bottom-left" => "حدود أسفل اليسار",
        "stylemanager-border-bottom-right" => "حدود أسفل اليمين",
        "stylemanager-border-color" => "لون الحدود",
        "stylemanager-border-radius" => "نصف قطر الحدود",
        "stylemanager-border-radius-bottom-left" => "نصف قطر الحدود أسفل اليسار",
        "stylemanager-border-radius-bottom-right" => "نصف قطر الحدود أسفل اليمين",
        "stylemanager-border-radius-top-left" => "نصف قطر الحدود أعلى اليسار",
        "stylemanager-border-radius-top-right" => "نصف قطر الحدود أعلى اليمين",
        "stylemanager-border-style" => "أسلوب الحدود",
        "stylemanager-border-top-left" => "حدود أعلى اليسار",
        "stylemanager-border-top-right" => "حدود أعلى اليمين",
        "stylemanager-border-width" => "عرض الحدود",
        "stylemanager-bottom" => "أسفل",
        "stylemanager-box-shadow" => "ظل الصندوق",
        "stylemanager-box-shadow-blur" => "ضبابية ظل الصندوق",
        "stylemanager-box-shadow-color" => "لون ظل الصندوق",
        "stylemanager-box-shadow-h" => "ظل الصندوق: أفقي",
        "stylemanager-box-shadow-spread" => "انتشار ظل الصندوق",
        "stylemanager-box-shadow-type" => "نوع ظل الصندوق",
        "stylemanager-box-shadow-v" => "ظل الصندوق: عمودي",
        "stylemanager-color" => "اللون",
        "stylemanager-display" => "العرض",
        "stylemanager-flex-basis" => "أساس المرونة",
        "stylemanager-flex-direction" => "اتجاه المرونة",
        "stylemanager-flex-grow" => "نمو المرونة",
        "stylemanager-flex-shrink" => "تقلص المرونة",
        "stylemanager-flex-wrap" => "لف المرونة",
        "stylemanager-float" => "عائم",
        "stylemanager-font-family" => "عائلة الخط",
        "stylemanager-font-size" => "حجم الخط",
        "stylemanager-font-weight" => "سمك الخط",
        "stylemanager-height" => "الارتفاع",
        "stylemanager-justify-content" => "مساواة المحتوى",
        "stylemanager-left" => "اليسار",
        "stylemanager-letter-spacing" => "تباعد الحروف",
        "stylemanager-line-height" => "ارتفاع السطر",
        "stylemanager-margin" => "الهوامش",
        "stylemanager-margin-bottom" => "هامش أسفل",
        "stylemanager-margin-left" => "هامش يسار",
        "stylemanager-margin-right" => "هامش يمين",
        "stylemanager-margin-top" => "هامش أعلى",
        "stylemanager-max-height" => "الحد الأقصى للارتفاع",
        "stylemanager-max-width" => "الحد الأقصى للعرض",
        "stylemanager-order" => "الترتيب",
        "stylemanager-padding" => "الحشو",
        "stylemanager-padding-bottom" => "حشو أسفل",
        "stylemanager-padding-left" => "حشو يسار",
        "stylemanager-padding-right" => "حشو يمين",
        "stylemanager-padding-top" => "حشو أعلى",
        "stylemanager-perspective" => "منظور",
        "stylemanager-position" => "الموضع",
        "stylemanager-right" => "اليمين",
        "stylemanager-text-align" => "محاذاة النص",
        "stylemanager-text-shadow" => "ظل النص",
        "stylemanager-text-shadow-blur" => "ضبابية ظل النص",
        "stylemanager-text-shadow-color" => "لون ظل النص",
        "stylemanager-text-shadow-h" => "ظل النص: أفقي",
        "stylemanager-text-shadow-v" => "ظل النص: عمودي",
        "stylemanager-top" => "أعلى",
        "stylemanager-transform" => "تحويل",
        "stylemanager-transform-rotate-x" => "تحويل تدوير X",
        "stylemanager-transform-rotate-y" => "تحويل تدوير Y",
        "stylemanager-transform-rotate-z" => "تحويل تدوير Z",
        "stylemanager-transform-scale-x" => "تحويل مقياس X",
        "stylemanager-transform-scale-y" => "تحويل مقياس Y",
        "stylemanager-transform-scale-z" => "تحويل مقياس Z",
        "stylemanager-transition" => "انتقال",
        "stylemanager-transition-duration" => "مدة الانتقال",
        "stylemanager-transition-property" => "خاصية الانتقال",
        "stylemanager-transition-timing-function" => "دالة توقيت الانتقال",
        "stylemanager-width" => "العرض",
        "none" => "لا شيء",
        "underline" => "تحت الخط",
        "linethrough" => "شطب",
        "stylemanager-sectors-decorations" => "زخارف",
        "stylemanager-sectors-dimension" => "الأبعاد",
        "stylemanager-sectors-extra" => "إضافي",
        "stylemanager-sectors-flex" => "مرن",
        "stylemanager-sectors-general" => "عام",
        "stylemanager-sectors-layout" => "التخطيط",
        "stylemanager-sectors-typography" => "الطباعة",
        "tipografia" => "الطباعة",
        "traitmanager-empty" => "اختر عنصرًا لاستخدام مدير الخصائص",
        "traitmanager-label" => "إعدادات المكون",
        "traitmanager-traits-options-target-_blank" => "نافذة جديدة",
        "traitmanager-traits-options-target-false" => "هذه النافذة",
        "undo" => "تراجع",
        "width" => "العرض",
    ],
    "es_ar" => [
        "assetmanager-addbutton" => "Agregar imagen",
        "assetmanager-modaltitle" => "Seleccionar imagen",
        "assetmanager-uploadtitle" => "Arrastra los archivos aquí o haz clic para cargar",
        "attachment" => "Adjunto",
        "certificate_confirm_clear" => "¿Estás seguro de que deseas borrar el lienzo?",
        "certificate_page_save" => "Guardar página de certificado",
        "certificate_page_test" => "Probar PDF",
        "clear" => "Borrar lienzo",
        "decoration" => "Decoraciones",
        "devicemanager-device" => "Dispositivo",
        "devicemanager-devices-desktop" => "Escritorio",
        "devicemanager-devices-mobilelandscape" => "Móvil, modo paisaje",
        "devicemanager-devices-mobileportrait" => "Móvil, modo retrato",
        "devicemanager-devices-tablet" => "Tablet",
        "dimensions" => "Dimensiones",
        "domcomponents-names-" => "Caja",
        "domcomponents-names-body" => "Cuerpo",
        "domcomponents-names-cell" => "Celda de tabla",
        "domcomponents-names-comment" => "Comentario",
        "domcomponents-names-image" => "Imagen",
        "domcomponents-names-label" => "Etiqueta",
        "domcomponents-names-link" => "Enlace",
        "domcomponents-names-map" => "Mapa",
        "domcomponents-names-row" => "Fila de tabla",
        "domcomponents-names-section" => "Sección",
        "domcomponents-names-table" => "Tabla",
        "domcomponents-names-tbody" => "Cuerpo de la tabla",
        "domcomponents-names-text" => "Texto",
        "domcomponents-names-tfoot" => "Pie de tabla",
        "domcomponents-names-thead" => "Encabezado de tabla",
        "domcomponents-names-video" => "Vídeo",
        "domcomponents-names-wrapper" => "Cuerpo",
        "edit_code" => "Editar código",
        "edit_code_paste_here_html" => "Pega tu HTML/CSS aquí y haz clic en Importar",
        "fullscreen" => "Pantalla completa",
        "general" => "General",
        "open_block" => "Bloques",
        "open_layers" => "Capas",
        "open_sm" => "Administrador de Estilos",
        "panels-buttons-titles-export-template" => "Ver código",
        "panels-buttons-titles-fullscreen" => "Pantalla completa",
        "panels-buttons-titles-open-blocks" => "Abrir bloques",
        "panels-buttons-titles-open-layers" => "Abrir Administrador de Capas",
        "panels-buttons-titles-open-sm" => "Abrir Administrador de Estilos",
        "panels-buttons-titles-open-tm" => "Configuraciones",
        "panels-buttons-titles-preview" => "Vista previa",
        "panels-buttons-titles-sw-visibility" => "Mostrar componentes",
        "position" => "Posición",
        "preview" => "Vista previa",
        "redo" => "Rehacer",
        "repeat" => "Repetir",
        "selectormanager-emptystate" => "- Estado -",
        "selectormanager-label" => "Clases",
        "selectormanager-selected" => "Seleccionado",
        "selectormanager-states-active" => "Clic",
        "selectormanager-states-hover" => "Desplazamiento",
        "selectormanager-states-nth-of-type-2n" => "Par/impar",
        "settings" => "Configuraciones",
        "show_border" => "Mostrar bordes",
        "size" => "Tamaño",
        "stylemanager-empty" => "Selecciona un elemento para usar el administrador de estilos",
        "stylemanager-filebutton" => "Imágenes",
        "stylemanager-layer" => "Capa",
        "stylemanager-align-content" => "Alinear contenido",
        "stylemanager-align-items" => "Alinear elementos",
        "stylemanager-align-self" => "Alinear a sí mismo",
        "stylemanager-background" => "Fondo",
        "stylemanager-background-attachment" => "Adjunto de fondo",
        "stylemanager-background-color" => "Color de fondo",
        "stylemanager-background-image" => "Imagen de fondo",
        "stylemanager-background-position" => "Posición de fondo",
        "stylemanager-background-repeat" => "Repetir fondo",
        "stylemanager-background-size" => "Tamaño de fondo",
        "stylemanager-border" => "Borde",
        "stylemanager-border-bottom-left" => "Borde inferior izquierdo",
        "stylemanager-border-bottom-right" => "Borde inferior derecho",
        "stylemanager-border-color" => "Color del borde",
        "stylemanager-border-radius" => "Radio del borde",
        "stylemanager-border-radius-bottom-left" => "Radio del borde inferior izquierdo",
        "stylemanager-border-radius-bottom-right" => "Radio del borde inferior derecho",
        "stylemanager-border-radius-top-left" => "Radio del borde superior izquierdo",
        "stylemanager-border-radius-top-right" => "Radio del borde superior derecho",
        "stylemanager-border-style" => "Estilo del borde",
        "stylemanager-border-top-left" => "Borde superior izquierdo",
        "stylemanager-border-top-right" => "Borde superior derecho",
        "stylemanager-border-width" => "Ancho del borde",
        "stylemanager-bottom" => "Abajo",
        "stylemanager-box-shadow" => "Sombra de caja",
        "stylemanager-box-shadow-blur" => "Desenfoque de sombra de caja",
        "stylemanager-box-shadow-color" => "Color de sombra de caja",
        "stylemanager-box-shadow-h" => "Sombra de caja: Horizontal",
        "stylemanager-box-shadow-spread" => "Expansión de sombra de caja",
        "stylemanager-box-shadow-type" => "Tipo de sombra de caja",
        "stylemanager-box-shadow-v" => "Sombra de caja: Vertical",
        "stylemanager-color" => "Color",
        "stylemanager-display" => "Visualizar",
        "stylemanager-flex-basis" => "Base del flex",
        "stylemanager-flex-direction" => "Dirección del flex",
        "stylemanager-flex-grow" => "Crecimiento del flex",
        "stylemanager-flex-shrink" => "Reducción del flex",
        "stylemanager-flex-wrap" => "Ajuste del flex",
        "stylemanager-float" => "Flotante",
        "stylemanager-font-family" => "Familia tipográfica",
        "stylemanager-font-size" => "Tamaño de fuente",
        "stylemanager-font-weight" => "Peso de fuente",
        "stylemanager-height" => "Altura",
        "stylemanager-justify-content" => "Justificar contenido",
        "stylemanager-left" => "Izquierda",
        "stylemanager-letter-spacing" => "Espaciado entre letras",
        "stylemanager-line-height" => "Altura de línea",
        "stylemanager-margin" => "Margen",
        "stylemanager-margin-bottom" => "Margen inferior",
        "stylemanager-margin-left" => "Margen izquierdo",
        "stylemanager-margin-right" => "Margen derecho",
        "stylemanager-margin-top" => "Margen superior",
        "stylemanager-max-height" => "Altura máxima",
        "stylemanager-max-width" => "Anchura máxima",
        "stylemanager-order" => "Orden",
        "stylemanager-padding" => "Relleno",
        "stylemanager-padding-bottom" => "Relleno inferior",
        "stylemanager-padding-left" => "Relleno izquierdo",
        "stylemanager-padding-right" => "Relleno derecho",
        "stylemanager-padding-top" => "Relleno superior",
        "stylemanager-perspective" => "Perspectiva",
        "stylemanager-position" => "Posición",
        "stylemanager-right" => "Derecha",
        "stylemanager-text-align" => "Alineación de texto",
        "stylemanager-text-shadow" => "Sombra de texto",
        "stylemanager-text-shadow-blur" => "Desenfoque de sombra de texto",
        "stylemanager-text-shadow-color" => "Color de sombra de texto",
        "stylemanager-text-shadow-h" => "Sombra de texto: Horizontal",
        "stylemanager-text-shadow-v" => "Sombra de texto: Vertical",
        "stylemanager-top" => "Arriba",
        "stylemanager-transform" => "Transformar",
        "stylemanager-transform-rotate-x" => "Transformar Rotar X",
        "stylemanager-transform-rotate-y" => "Transformar Rotar Y",
        "stylemanager-transform-rotate-z" => "Transformar Rotar Z",
        "stylemanager-transform-scale-x" => "Transformar Escalar X",
        "stylemanager-transform-scale-y" => "Transformar Escalar Y",
        "stylemanager-transform-scale-z" => "Transformar Escalar Z",
        "stylemanager-transition" => "Transición",
        "stylemanager-transition-duration" => "Duración de transición",
        "stylemanager-transition-property" => "Propiedad de transición",
        "stylemanager-transition-timing-function" => "Función de tiempo de transición",
        "stylemanager-width" => "Anchura",
        "none" => "Ninguno",
        "underline" => "Subrayado",
        "linethrough" => "Tachado",
        "stylemanager-sectors-decorations" => "Decoraciones",
        "stylemanager-sectors-dimension" => "Dimensión",
        "stylemanager-sectors-extra" => "Extra",
        "stylemanager-sectors-flex" => "Flex",
        "stylemanager-sectors-general" => "General",
        "stylemanager-sectors-layout" => "Diseño",
        "stylemanager-sectors-typography" => "Tipografía",
        "tipografia" => "Tipografía",
        "traitmanager-empty" => "Selecciona un elemento para usar el administrador de características",
        "traitmanager-label" => "Configuraciones del componente",
        "traitmanager-traits-options-target-_blank" => "Nueva ventana",
        "traitmanager-traits-options-target-false" => "Esta ventana",
        "undo" => "Deshacer",
        "width" => "Anchura",
    ],
    "et" => [
        "assetmanager-addbutton" => "Lisa pilt",
        "assetmanager-modaltitle" => "Valige pilt",
        "assetmanager-uploadtitle" => "Koputage failide üleslaadimiseks või klõpsake üleslaadimiseks",
        "attachment" => "Manus",
        "certificate_confirm_clear" => "Kas olete kindel, et soovite lõuendi tühjendada?",
        "certificate_page_save" => "Salvesta sertifikaadi leht",
        "certificate_page_test" => "Testi PDF-i",
        "clear" => "Tühjenda lõuend",
        "decoration" => "Kaunistused",
        "devicemanager-device" => "Seade",
        "devicemanager-devices-desktop" => "Arvuti",
        "devicemanager-devices-mobilelandscape" => "Mobiil, maastiku režiim",
        "devicemanager-devices-mobileportrait" => "Mobiil, portree režiim",
        "devicemanager-devices-tablet" => "Tahvelarvuti",
        "dimensions" => "Mõõtmed",
        "domcomponents-names-" => "Kast",
        "domcomponents-names-body" => "Keha",
        "domcomponents-names-cell" => "Tabeli rakk",
        "domcomponents-names-comment" => "Kommentaar",
        "domcomponents-names-image" => "Pilt",
        "domcomponents-names-label" => "Märkus",
        "domcomponents-names-link" => "Link",
        "domcomponents-names-map" => "Kaart",
        "domcomponents-names-row" => "Tabeli rida",
        "domcomponents-names-section" => "Sektsioon",
        "domcomponents-names-table" => "Tabel",
        "domcomponents-names-tbody" => "Tabeli keha",
        "domcomponents-names-text" => "Tekst",
        "domcomponents-names-tfoot" => "Tabeli jalus",
        "domcomponents-names-thead" => "Tabeli päis",
        "domcomponents-names-video" => "Video",
        "domcomponents-names-wrapper" => "Keha",
        "edit_code" => "Redigeeri koodi",
        "edit_code_paste_here_html" => "Kleebi oma HTML/CSS siia ja klõpsa impordi jaoks",
        "fullscreen" => "Täisekraan",
        "general" => "Üldine",
        "open_block" => "Plokid",
        "open_layers" => "Kihtide haldur",
        "open_sm" => "Stiili haldur",
        "panels-buttons-titles-export-template" => "Vaata koodi",
        "panels-buttons-titles-fullscreen" => "Täisekraan",
        "panels-buttons-titles-open-blocks" => "Avatud plokid",
        "panels-buttons-titles-open-layers" => "Ava kihtide haldur",
        "panels-buttons-titles-open-sm" => "Ava stiili haldur",
        "panels-buttons-titles-open-tm" => "Seaded",
        "panels-buttons-titles-preview" => "Eelvaade",
        "panels-buttons-titles-sw-visibility" => "Kuva komponendid",
        "position" => "Positsioon",
        "preview" => "Eelvaade",
        "redo" => "Tee uuesti",
        "repeat" => "Korda",
        "selectormanager-emptystate" => "- Olek -",
        "selectormanager-label" => "Klassid",
        "selectormanager-selected" => "Valitud",
        "selectormanager-states-active" => "Klõpsake",
        "selectormanager-states-hover" => "Hover",
        "selectormanager-states-nth-of-type-2n" => "Paaris/õõnes",
        "settings" => "Seaded",
        "show_border" => "Kuva piirjooned",
        "size" => "Suurus",
        "stylemanager-empty" => "Valige element, et kasutada stiili haldurit",
        "stylemanager-filebutton" => "Pildid",
        "stylemanager-layer" => "Kiht",
        "stylemanager-align-content" => "Joonda sisu",
        "stylemanager-align-items" => "Joonda esemed",
        "stylemanager-align-self" => "Joonda end",
        "stylemanager-background" => "Taust",
        "stylemanager-background-attachment" => "Tausta kinnitus",
        "stylemanager-background-color" => "Tausta värv",
        "stylemanager-background-image" => "Tausta pilt",
        "stylemanager-background-position" => "Tausta positsioon",
        "stylemanager-background-repeat" => "Tausta kordamine",
        "stylemanager-background-size" => "Tausta suurus",
        "stylemanager-border" => "Piir",
        "stylemanager-border-bottom-left" => "Piir vasakult alt",
        "stylemanager-border-bottom-right" => "Piir paremal alt",
        "stylemanager-border-color" => "Piiri värv",
        "stylemanager-border-radius" => "Piiri raadius",
        "stylemanager-border-radius-bottom-left" => "Piiri raadius vasakult alt",
        "stylemanager-border-radius-bottom-right" => "Piiri raadius paremal alt",
        "stylemanager-border-radius-top-left" => "Piiri raadius vasakult ülevalt",
        "stylemanager-border-radius-top-right" => "Piiri raadius paremal ülevalt",
        "stylemanager-border-style" => "Piiri stiil",
        "stylemanager-border-top-left" => "Piir vasakult ülevalt",
        "stylemanager-border-top-right" => "Piir paremal ülevalt",
        "stylemanager-border-width" => "Piiri laius",
        "stylemanager-bottom" => "All",
        "stylemanager-box-shadow" => "Kast vari",
        "stylemanager-box-shadow-blur" => "Kast vari hägusust",
        "stylemanager-box-shadow-color" => "Kast vari värv",
        "stylemanager-box-shadow-h" => "Kast vari: Horisontaalne",
        "stylemanager-box-shadow-spread" => "Kast vari hajutamine",
        "stylemanager-box-shadow-type" => "Kast vari tüüp",
        "stylemanager-box-shadow-v" => "Kast vari: Vertikaalne",
        "stylemanager-color" => "Värv",
        "stylemanager-display" => "Kuvamine",
        "stylemanager-flex-basis" => "Flex baasi",
        "stylemanager-flex-direction" => "Flex suund",
        "stylemanager-flex-grow" => "Flex kasvu",
        "stylemanager-flex-shrink" => "Flex kokkutõmbumine",
        "stylemanager-flex-wrap" => "Flex mähis",
        "stylemanager-float" => "Floats",
        "stylemanager-font-family" => "Fondipere",
        "stylemanager-font-size" => "Fondisuurus",
        "stylemanager-font-weight" => "Fondipaksus",
        "stylemanager-height" => "Kõrgus",
        "stylemanager-justify-content" => "Põhjenda sisu",
        "stylemanager-left" => "Vasak",
        "stylemanager-letter-spacing" => "Tähevahe",
        "stylemanager-line-height" => "Rea kõrgus",
        "stylemanager-margin" => "Serv",
        "stylemanager-margin-bottom" => "Alumise serva vahe",
        "stylemanager-margin-left" => "Vasak serv",
        "stylemanager-margin-right" => "Parem serv",
        "stylemanager-margin-top" => "Ülemine serv",
        "stylemanager-max-height" => "Maksimaalne kõrgus",
        "stylemanager-max-width" => "Maksimaalne laius",
        "stylemanager-order" => "Tellimus",
        "stylemanager-padding" => "Padding",
        "stylemanager-padding-bottom" => "Padding alt",
        "stylemanager-padding-left" => "Padding vasakult",
        "stylemanager-padding-right" => "Padding paremalt",
        "stylemanager-padding-top" => "Padding ülevalt",
        "stylemanager-perspective" => "Perspektiiv",
        "stylemanager-position" => "Positsioon",
        "stylemanager-right" => "Parem",
        "stylemanager-text-align" => "Teksti joondus",
        "stylemanager-text-shadow" => "Teksti vari",
        "stylemanager-text-shadow-blur" => "Teksti vari hägusus",
        "stylemanager-text-shadow-color" => "Teksti vari värv",
        "stylemanager-text-shadow-h" => "Teksti vari: Horisontaalne",
        "stylemanager-text-shadow-v" => "Teksti vari: Vertikaalne",
        "stylemanager-top" => "Üles",
        "stylemanager-transform" => "Muuda",
        "stylemanager-transform-rotate-x" => "Muuda Pööra X",
        "stylemanager-transform-rotate-y" => "Muuda Pööra Y",
        "stylemanager-transform-rotate-z" => "Muuda Pööra Z",
        "stylemanager-transform-scale-x" => "Muuda Skaala X",
        "stylemanager-transform-scale-y" => "Muuda Skaala Y",
        "stylemanager-transform-scale-z" => "Muuda Skaala Z",
        "stylemanager-transition" => "Üleminek",
        "stylemanager-transition-duration" => "Ülemineku kestus",
        "stylemanager-transition-property" => "Ülemineku omadus",
        "stylemanager-transition-timing-function" => "Ülemineku ajastusfunktsioon",
        "stylemanager-width" => "Laius",
        "none" => "Puudub",
        "underline" => "Allajoonimine",
        "linethrough" => "Läbikriipsutus",
        "stylemanager-sectors-decorations" => "Kaunistused",
        "stylemanager-sectors-dimension" => "Mõõtmed",
        "stylemanager-sectors-extra" => "Lisad",
        "stylemanager-sectors-flex" => "Flex",
        "stylemanager-sectors-general" => "Üldine",
        "stylemanager-sectors-layout" => "Paigutus",
        "stylemanager-sectors-typography" => "Tüpograafia",
        "tipografia" => "Tüpograafia",
        "traitmanager-empty" => "Valige element, et kasutada omaduste haldurit",
        "traitmanager-label" => "Komponendi seaded",
        "traitmanager-traits-options-target-_blank" => "Uus aken",
        "traitmanager-traits-options-target-false" => "See aken",
        "undo" => "Tühista",
        "width" => "Laius",
    ],
];
function get_lang_string($item) {
    global $langs, $languser;

    $langstranslate = $langs["en"];
    if (isset($langs[$languser])) {
        $langstranslate = $langs[$languser];
    } else {
        list($ln, $ln2) = explode("_", $languser);
        if (isset($langs[$ln])) {
            $langstranslate = $langs[$ln];
        }
    }

    if (isset($langstranslate[$item])) {
        return $langstranslate[$item];
    } else if (isset($langs["en"][$item])) {
        return $langs["en"][$item];
    } else {
        return $item;
    }
}

?>

<script type="text/javascript">

    var editor = grapesjs.init({
        "dragMode": "absolute",
        "height": "100%",
        "container": "#gjs",
        "fromElement": true,
        "showOffsets": true,
        "storageManager": false,
        "assetManager": {
            "embedAsBase64": true,
            "assets": [],
        },
        "selectorManager": {"componentFirst": true},
        "styleManager": {
            "sectors": [
                {
                    "name": "<?php echo get_lang_string("general") ?>",
                    "properties": [
                        "display",
                        {"extend": "position", "type": "select"},
                        "top",
                        "right",
                        "left",
                        "bottom",
                    ],
                },
                {
                    "name": "<?php echo get_lang_string("dimensions") ?>",
                    "open": false,
                    "properties": [
                        "width",
                        "height",
                        "max-width",
                        "min-width",
                        "max-height",
                        "min-height",
                        "margin",
                        "padding"
                    ],
                },
                {
                    "name": "<?php echo get_lang_string("typography") ?>",
                    "open": false,
                    "properties": [
                        {
                            "property": "font-family",
                            "type": "select",
                            "name": "<?php echo get_lang_string("stylemanager-font-family") ?>",
                            "options": [
                                {"id": "Arial", "label": "Arial", "value": "Arial, Helvetica, sans-serif"},
                                <?php echo $fontList["options"] ?>
                            ]
                        },
                        "font-size",
                        "font-weight",
                        "letter-spacing",
                        "color",
                        "line-height",
                        {
                            "extend": "text-align",
                            "options": [
                                {
                                    "id": "left",
                                    "label": "<?php echo get_lang_string("stylemanager-left");?>",
                                    "className": "fa fa-align-left",
                                },
                                {
                                    "id": "center",
                                    "label": "<?php echo get_lang_string("stylemanager-center");?>",
                                    "className": "fa fa-align-center",
                                },
                                {
                                    "id": "right",
                                    "label": "<?php echo get_lang_string("stylemanager-right");?>",
                                    "className": "fa fa-align-right",
                                },
                                {
                                    "id": "justify",
                                    "label": "<?php echo get_lang_string("stylemanager-justify");?>",
                                    "className": "fa fa-align-justify",
                                }
                            ],
                        },
                        {
                            "property": "text-decoration",
                            "type": "radio",
                            "default": "none",
                            "options": [
                                {
                                    "id": "none",
                                    "label": "<?php echo get_lang_string("none") ?>",
                                    "className": "fa fa-times",
                                },
                                {
                                    "id": "underline",
                                    "label": "<?php echo get_lang_string("underline") ?>",
                                    "className": "fa fa-underline",
                                },
                                {
                                    "id": "line-through",
                                    "label": "<?php echo get_lang_string("linethrough") ?>",
                                    "className": "fa fa-strikethrough",
                                }
                            ],
                        },
                        {
                            "property": "text-transform",
                            "type": "radio",
                            "default": "none",
                            "options": [
                                {"id": "none", "label": "x"},
                                {"id": "capitalize", "label": "Tt"},
                                {"id": "lowercase", "label": "tt"},
                                {"id": "uppercase", "label": "TT"}
                            ]
                        }
                    ]
                },
                {
                    "name": "<?php echo get_lang_string("stylemanager-background") ?>",
                    "open": false,
                    "properties": [
                        "background",
                    ],
                },
                {
                    "name": "<?php echo get_lang_string("decoration") ?>",
                    "open": false,
                    "properties": [
                        "opacity",
                        "border-radius",
                        "border",
                    ],
                }
            ],
        },
        "plugins": [
            "grapesjs-blocks-basic",
            "grapesjs-custom-code",
            "grapesjs-parser-postcss",
            "grapesjs-tui-image-editor",
            "grapesjs-style-bg",
            "grapesjs-preset-webpage",
            "grapesjs-blocks-table",
            "grapesjs-style-border"
        ],
        "pluginsOpts": {
            "grapesjs-blocks-basic": {
                "flexGrid": false,
                "blocks": ["column1", "text", "link", "image"]
            },
            "grapesjs-tui-image-editor": {
                "script": [
                    "./js/tui/tui-code-snippet.js",
                    "./js/tui/tui-color-picker.js",
                    "./js/tui/tui-image-editor.js"
                ],
                "style": [
                    "./stylesheets/tui/tui-color-picker.css",
                    "./stylesheets/tui/tui-image-editor.css",
                ],
            },
            "grapesjs-blocks-table": {
                "containerId": "#gjs"
            },
            "grapesjs-preset-webpage": {
                "modalImportTitle": "<?php echo get_lang_string("edit_code") ?>",
                "modalImportLabel": '<div style="margin-bottom: 10px; font-size: 13px;"><?php echo get_lang_string("edit_code_paste_here_html") ?></div>',
                "modalImportContent": function(editor) {
                    var html = editor.getHtml();
                    html = html.split(/<body.*?>/).join("");
                    html = html.split("</body>").join("");

                    var css = editor.getCss();
                    css = css.split(/body.*?}/s).join("");
                    css = css.split(/\[data-gjs-type=wrapper]\s?>\s?div\s?\*.*?}/s).join("");
                    css = css.split(/\[data-gjs-type="?wrapper"?]\s?>\s?#/).join("#");
                    css = css.split(/\[data-gjs-type="?wrapper"?]\s?>\s/).join("");

                    return `${html}\n<style>\n${css}</style>`;
                },
            },
        },
        "i18n": {
            "locale": "<?php echo $languser ?>",
            "detectLocale": false,
            "localeFallback": "<?php echo $languser ?>",
            "messages": {
                "<?php echo $languser ?>": {
                    "assetManager": {
                        "addButton": "<?php echo get_lang_string("assetmanager-addbutton") ?>",
                        "modalTitle": "<?php echo get_lang_string("assetmanager-modaltitle") ?>",
                        "uploadTitle": "<?php echo get_lang_string("assetmanager-uploadtitle") ?>"
                    },
                    "domComponents": {
                        "names": {
                            "": "<?php echo get_lang_string("domcomponents-names-") ?>",
                            "wrapper": "<?php echo get_lang_string("domcomponents-names-wrapper") ?>",
                            "text": "<?php echo get_lang_string("domcomponents-names-text") ?>",
                            "comment": "<?php echo get_lang_string("domcomponents-names-comment") ?>",
                            "image": "<?php echo get_lang_string("domcomponents-names-image") ?>",
                            "video": "<?php echo get_lang_string("domcomponents-names-video") ?>",
                            "label": "<?php echo get_lang_string("domcomponents-names-label") ?>",
                            "link": "<?php echo get_lang_string("domcomponents-names-link") ?>",
                            "map": "<?php echo get_lang_string("domcomponents-names-map") ?>",
                            "tfoot": "<?php echo get_lang_string("domcomponents-names-tfoot") ?>",
                            "tbody": "<?php echo get_lang_string("domcomponents-names-tbody") ?>",
                            "thead": "<?php echo get_lang_string("domcomponents-names-thead") ?>",
                            "table": "<?php echo get_lang_string("domcomponents-names-table") ?>",
                            "row": "<?php echo get_lang_string("domcomponents-names-row") ?>",
                            "cell": "<?php echo get_lang_string("domcomponents-names-cell") ?>",
                            "section": "<?php echo get_lang_string("domcomponents-names-section") ?>",
                            "body": "<?php echo get_lang_string("domcomponents-names-wrapper") ?>"
                        }
                    },
                    "deviceManager": {
                        "device": "<?php echo get_lang_string("devicemanager-device") ?>",
                        "devices": {
                            "desktop": "<?php echo get_lang_string("devicemanager-devices-desktop") ?>",
                            "tablet": "<?php echo get_lang_string("devicemanager-devices-tablet") ?>",
                            "mobileLandscape": "<?php echo get_lang_string("devicemanager-devices-mobilelandscape") ?>",
                            "mobilePortrait": "<?php echo get_lang_string("devicemanager-devices-mobileportrait") ?>"
                        }
                    },
                    "panels": {
                        "buttons": {
                            "titles": {
                                "preview": "<?php echo get_lang_string("panels-buttons-titles-preview") ?>",
                                "fullscreen": "<?php echo get_lang_string("panels-buttons-titles-fullscreen") ?>",
                                "sw-visibility": "<?php echo get_lang_string("panels-buttons-titles-sw-visibility") ?>",
                                "export-template": "<?php echo get_lang_string("panels-buttons-titles-export-template") ?>",
                                "open-sm": "<?php echo get_lang_string("panels-buttons-titles-open-sm") ?>",
                                "open-tm": "<?php echo get_lang_string("panels-buttons-titles-open-tm") ?>",
                                "open-layers": "<?php echo get_lang_string("panels-buttons-titles-open-layers") ?>",
                                "open-blocks": "<?php echo get_lang_string("panels-buttons-titles-open-blocks") ?>"
                            }
                        }
                    },
                    "selectorManager": {
                        "label": "<?php echo get_lang_string("selectormanager-label") ?>",
                        "selected": "<?php echo get_lang_string("selectormanager-selected") ?>",
                        "emptyState": "<?php echo get_lang_string("selectormanager-emptystate") ?>",
                        "states": {
                            "hover": "<?php echo get_lang_string("selectormanager-states-hover") ?>",
                            "active": "<?php echo get_lang_string("selectormanager-states-active") ?>",
                            "nth-of-type(2n)": "<?php echo get_lang_string("selectormanager-states-nth-of-type-2n") ?>"
                        }
                    },
                    "styleManager": {
                        "empty": "<?php echo get_lang_string("stylemanager-empty") ?>",
                        "layer": "<?php echo get_lang_string("stylemanager-layer") ?>",
                        "fileButton": "<?php echo get_lang_string("stylemanager-filebutton") ?>",
                        "sectors": {
                            "general": "<?php echo get_lang_string("stylemanager-sectors-general") ?>",
                            "layout": "<?php echo get_lang_string("stylemanager-sectors-layout") ?>",
                            "typography": "<?php echo get_lang_string("stylemanager-sectors-typography") ?>",
                            "decorations": "<?php echo get_lang_string("stylemanager-sectors-decorations") ?>",
                            "extra": "<?php echo get_lang_string("stylemanager-sectors-extra") ?>",
                            "flex": "<?php echo get_lang_string("stylemanager-sectors-flex") ?>",
                            "dimension": "<?php echo get_lang_string("stylemanager-sectors-dimension") ?>"
                        },
                        "properties": {
                            "float": "<?php echo get_lang_string("stylemanager-float") ?>",
                            "display": "<?php echo get_lang_string("stylemanager-display") ?>",
                            "position": "<?php echo get_lang_string("stylemanager-position") ?>",
                            "top": "<?php echo get_lang_string("stylemanager-top") ?>",
                            "right": "<?php echo get_lang_string("stylemanager-right") ?>",
                            "left": "<?php echo get_lang_string("stylemanager-left") ?>",
                            "bottom": "<?php echo get_lang_string("stylemanager-bottom") ?>",
                            "width": "<?php echo get_lang_string("stylemanager-width") ?>",
                            "height": "<?php echo get_lang_string("stylemanager-height") ?>",
                            "max-width": "<?php echo get_lang_string("stylemanager-max-width") ?>",
                            "max-height": "<?php echo get_lang_string("stylemanager-max-height") ?>",
                            "margin": "<?php echo get_lang_string("stylemanager-margin") ?>",
                            "margin-top": "<?php echo get_lang_string("stylemanager-margin-top") ?>",
                            "margin-right": "<?php echo get_lang_string("stylemanager-margin-right") ?>",
                            "margin-left": "<?php echo get_lang_string("stylemanager-margin-left") ?>",
                            "margin-bottom": "<?php echo get_lang_string("stylemanager-margin-bottom") ?>",
                            "padding": "<?php echo get_lang_string("stylemanager-padding") ?>",
                            "padding-top": "<?php echo get_lang_string("stylemanager-padding-top") ?>",
                            "padding-left": "<?php echo get_lang_string("stylemanager-padding-left") ?>",
                            "padding-right": "<?php echo get_lang_string("stylemanager-padding-right") ?>",
                            "padding-bottom": "<?php echo get_lang_string("stylemanager-padding-bottom") ?>",
                            "font-family": "<?php echo get_lang_string("stylemanager-font-family") ?>",
                            "font-size": "<?php echo get_lang_string("stylemanager-font-size") ?>",
                            "font-weight": "<?php echo get_lang_string("stylemanager-font-weight") ?>",
                            "letter-spacing": "<?php echo get_lang_string("stylemanager-letter-spacing") ?>",
                            "color": "<?php echo get_lang_string("stylemanager-color") ?>",
                            "line-height": "<?php echo get_lang_string("stylemanager-line-height") ?>",
                            "text-align": "<?php echo get_lang_string("stylemanager-text-align") ?>",
                            "text-shadow": "<?php echo get_lang_string("stylemanager-text-shadow") ?>",
                            "text-shadow-h": "<?php echo get_lang_string("stylemanager-text-shadow-h") ?>",
                            "text-shadow-v": "<?php echo get_lang_string("stylemanager-text-shadow-v") ?>",
                            "text-shadow-blur": "<?php echo get_lang_string("stylemanager-text-shadow-blur") ?>",
                            "text-shadow-color": "<?php echo get_lang_string("stylemanager-text-shadow-color") ?>",
                            "border-top-left": "<?php echo get_lang_string("stylemanager-border-top-left") ?>",
                            "border-top-right": "<?php echo get_lang_string("stylemanager-border-top-right") ?>",
                            "border-bottom-left": "<?php echo get_lang_string("stylemanager-border-bottom-left") ?>",
                            "border-bottom-right": "<?php echo get_lang_string("stylemanager-border-bottom-right") ?>",
                            "border-radius-top-left": "<?php echo get_lang_string("stylemanager-border-radius-top-left") ?>",
                            "border-radius-top-right": "<?php echo get_lang_string("stylemanager-border-radius-top-right") ?>",
                            "border-radius-bottom-left": "<?php echo get_lang_string("stylemanager-border-radius-bottom-left") ?>",
                            "border-radius-bottom-right": "<?php echo get_lang_string("stylemanager-border-radius-bottom-right") ?>",
                            "border-radius": "<?php echo get_lang_string("stylemanager-border-radius") ?>",
                            "border": "<?php echo get_lang_string("stylemanager-border") ?>",
                            "border-width": "<?php echo get_lang_string("stylemanager-border-width") ?>",
                            "border-style": "<?php echo get_lang_string("stylemanager-border-style") ?>",
                            "border-color": "<?php echo get_lang_string("stylemanager-border-color") ?>",
                            "box-shadow": "<?php echo get_lang_string("stylemanager-box-shadow") ?>",
                            "box-shadow-h": "<?php echo get_lang_string("stylemanager-box-shadow-h") ?>",
                            "box-shadow-v": "<?php echo get_lang_string("stylemanager-box-shadow-v") ?>",
                            "box-shadow-blur": "<?php echo get_lang_string("stylemanager-box-shadow-blur") ?>",
                            "box-shadow-spread": "<?php echo get_lang_string("stylemanager-box-shadow-spread") ?>",
                            "box-shadow-color": "<?php echo get_lang_string("stylemanager-box-shadow-color") ?>",
                            "box-shadow-type": "<?php echo get_lang_string("stylemanager-box-shadow-type") ?>",
                            "background": "<?php echo get_lang_string("stylemanager-background") ?>",
                            "background-color": "<?php echo get_lang_string("stylemanager-background-color") ?>",
                            "background-image": "<?php echo get_lang_string("stylemanager-background-image") ?>",
                            "background-repeat": "<?php echo get_lang_string("stylemanager-background-repeat") ?>",
                            "background-position": "<?php echo get_lang_string("stylemanager-background-position") ?>",
                            "background-attachment": "<?php echo get_lang_string("stylemanager-background-attachment") ?>",
                            "background-size": "<?php echo get_lang_string("stylemanager-background-size") ?>",
                            "transition": "<?php echo get_lang_string("stylemanager-transition") ?>",
                            "transition-property": "<?php echo get_lang_string("stylemanager-transition-property") ?>",
                            "transition-duration": "<?php echo get_lang_string("stylemanager-transition-duration") ?>",
                            "transition-timing-function": "<?php echo get_lang_string("stylemanager-transition-timing-function") ?>",
                            "perspective": "<?php echo get_lang_string("stylemanager-perspective") ?>",
                            "transform": "<?php echo get_lang_string("stylemanager-transform") ?>",
                            "transform-rotate-x": "<?php echo get_lang_string("stylemanager-transform-rotate-x") ?>",
                            "transform-rotate-y": "<?php echo get_lang_string("stylemanager-transform-rotate-y") ?>",
                            "transform-rotate-z": "<?php echo get_lang_string("stylemanager-transform-rotate-z") ?>",
                            "transform-scale-x": "<?php echo get_lang_string("stylemanager-transform-scale-x") ?>",
                            "transform-scale-y": "<?php echo get_lang_string("stylemanager-transform-scale-y") ?>",
                            "transform-scale-z": "<?php echo get_lang_string("stylemanager-transform-scale-z") ?>",
                            "flex-direction": "<?php echo get_lang_string("stylemanager-flex-direction") ?>",
                            "flex-wrap": "<?php echo get_lang_string("stylemanager-flex-wrap") ?>",
                            "justify-content": "<?php echo get_lang_string("stylemanager-justify-content") ?>",
                            "align-items": "<?php echo get_lang_string("stylemanager-align-items") ?>",
                            "align-content": "<?php echo get_lang_string("stylemanager-align-content") ?>",
                            "order": "<?php echo get_lang_string("stylemanager-order") ?>",
                            "flex-basis": "<?php echo get_lang_string("stylemanager-flex-basis") ?>",
                            "flex-grow": "<?php echo get_lang_string("stylemanager-flex-grow") ?>",
                            "flex-shrink": "<?php echo get_lang_string("stylemanager-flex-shrink") ?>",
                            "align-self": "<?php echo get_lang_string("stylemanager-align-self") ?>"
                        }
                    },
                    "traitManager": {
                        "empty": "<?php echo get_lang_string("traitmanager-empty") ?>",
                        "label": "<?php echo get_lang_string("traitmanager-label") ?>",
                        "traits": {
                            "options": {
                                "target": {
                                    "false": "<?php echo get_lang_string("traitmanager-traits-options-target-false") ?>",
                                    "_blank": "<?php echo get_lang_string("traitmanager-traits-options-target-_blank") ?>"
                                }
                            }
                        }
                    }
                }
            }
        }
    });

    editor.getConfig().showDevices = 0;
    editor.Panels.addPanel({"id": "devices-c"}).get("buttons").add([
        {
            "id": "block-save",
            "className": "btn-salvar padding-0",
            "label": `<form id="form-save" method="post" target="_top" style="display:none;"
                               action="<?php echo $CFG->wwwroot ?>/mod/certificatebeautiful/manage-model-editpage.php?id=<?php echo $id ?>&page=<?php echo $page ?>">
                             <input type="hidden" name="sesskey" value="<?php echo sesskey() ?>">
                             <input type="hidden" name="htmldata" id="form-htmldata">
                             <input type="hidden" name="cssdata" id="form-cssdata">
                             <button type="submit" class="btn-salvar gjs-pn-btn gjs-pn-active gjs-four-color">
                                 <i class="fa fa-save"></i>&nbsp;
                                 <?php echo get_lang_string("certificate_page_save") ?>
                            </button>
                         </form>
                         <form id="form-testpdf" method="post" target="testpdf" style="display:none;"
                               action="test-pdf.php?id=<?php echo $id ?>">
                             <input type="hidden" name="sesskey" value="<?php echo sesskey() ?>">
                             <input type="hidden" name="htmldata" id="testpdf-htmldata">
                             <input type="hidden" name="cssdata" id="testpdf-cssdata">
                             <button type="submit" class="btn-salvar gjs-pn-btn gjs-pn-active gjs-four-color">
                                 <i class="fa fa-file-pdf-o"></i>&nbsp;
                                 <?php echo get_lang_string("certificate_page_test") ?>
                            </button>
                         </form>`,
        }
    ]);

    function updateForm() {
        var html = editor.getHtml();
        html = html.split(/<body.*?>/).join("");
        html = html.split("</body>").join("");

        var css = editor.getCss();
        css = css.split(/\*.*?}/s).join("");
        css = css.split(/body.*?}/s).join("");
        css = css.split(/\[data-gjs-type="?wrapper"?]\s?>\s?#/).join("#");
        css = css.split(/\[data-gjs-type="?wrapper"?]\s?>\s/).join("");

        $("#form-htmldata").val(html);
        $("#form-cssdata").val(css);
        $("#form-save").show(300);

        $("#testpdf-htmldata").val(html);
        $("#testpdf-cssdata").val(css);
        $("#form-testpdf").show(300);
    };
    editor.on("update", updateForm);

    // A block for the custom component
    editor.BlockManager.add("qr-code", {
        // https://grapesjs.com/docs/api/components.html#iscomponent
        "label": "QR Code",
        "content": `
              <div class="qr-code-block"
                   data-gjs-type="text"
                   draggable="false"
                   data-gjs-copyable="false"
                   style="position:absolute;top:0;left:0;width:100px;">
                  <img src="<?php echo $CFG->wwwroot ?>/mod/certificatebeautiful/_editor/img/qr-code.svg" width="100%"
                       data-gjs-selectable="false"
                       data-gjs-highlightable="false"
                       data-gjs-hoverable="false"
                       data-gjs-editable="false"/>
                  <div data-gjs-selectable="false"
                       data-gjs-highlightable="false"
                       data-gjs-hoverable="false"
                       data-gjs-editable="false"
                       style="font-size:12px;text-align:center">{$CERTIFICATE->codelink}</div>
              </div>`,
        "media": `<svg class="svg-item-replace" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                        <path d="m0 8h8v-8h-8zm1.334-6.667h5.332v5.333h-5.332zm1.332 1.334h2.668v2.667h-2.668zm13.334 5.333h8v-8h-8zm1.332-6.667h5.334v5.333h-5.334zm1.334 1.334h2.666v2.667h-2.666zm-18.666 21.333h8v-8h-8zm1.334-6.667h5.332v5.334h-5.332zm1.332 1.334h2.668v2.666h-2.668zm20 2.666h1.334v2.667h-2.668v-4h1.334zm0-4h1.334v1.334h-1.334zm0-1.333v1.333h-1.334v-1.333zm-13.332 2.667h1.332v5.333h-1.332zm-5.334-9.334v2.667h-2.668v-1.333h-1.332v-1.333zm5.334-4h1.332v1.333h-1.332zm3.998-4v2.667h-1.332v-4h2.666v1.333zm-3.998 0h1.332v1.333h-1.332zm13.332 10.667h1.334v2.667h-2.668v-1.334h1.334zm-1.334-2.667v1.333h-2.666v2.667h-2.666v-1.333h1.332v-2.667zm-9.332 5.334h-1.334v-1.334h-1.332v-1.333h2.666zm8 2.666h1.332v1.334h-1.332zm2.666-6.666v1.333h-1.334v-1.333zm-12 4v1.333h-1.332v-1.333zm8 6.666h1.334v2.667h-2.668v-2.667zm-4 0h1.334v1.334h-1.334v1.333h-2.666v-1.333h1.332v-1.334zm0-1.333v-1.333h2.666v1.333zm0-6.667h1.334v4h-1.334v1.334h-1.334v1.333h-1.332v-2.667h-1.334v-1.333h4v-1.333h-1.334v-1.334zm-12 0v1.334h-1.332v-1.334zm16 5.334h-1.334v-1.334h1.334zm1.334-2.667h-2.668v-1.333h2.668zm-13.334-6.667h1.334v1.333h-1.334v1.334h1.334v2.667h-1.334v-1.334h-1.332v1.334h-1.334v-2.667h1.332v-2.667zm4 0v-2.667h4v4h-2.666v-1.333h1.332v-1.333h-1.332v1.333zm0-5.333h1.334v1.333h-1.334zm-1.332 5.333h1.332v1.333h-1.332zm3.998-4v-1.333h1.334v1.333z"/>
                    </svg>`,
        "category": "Basic",
    });

    editor.on("component:selected", function(component) {
        component.set("resizable", true);
    });

    <?php echo \mod_certificatebeautiful\datainfo\help_base::get_editor_components(); ?>

    var pn = editor.Panels;

    // Update canvas-clear command
    editor.Commands.add("canvas-clear", function() {
        if (confirm("<?php echo get_lang_string("certificate_confirm_clear") ?>")) {
            editor.runCommand("core:canvas-clear");
            setTimeout(function() {
                localStorage.clear()
            }, 0)
        }
    });

    // Simple warn notifier
    var origWarn = console.warn;
    toastr.options = {
        "closeButton": true,
        "preventDuplicates": true,
        "showDuration": 250,
        "hideDuration": 150
    };
    console.warn = function(msg) {
        if (msg.indexOf("[undefined]") == -1) {
            toastr.warning(msg);
        }
        origWarn(msg);
    };

    // Add and beautify tooltips
    [
        ["sw-visibility", "<?php echo get_lang_string("show_border") ?>"],
        ["preview", "<?php echo get_lang_string("preview") ?>"],
        ["fullscreen", "<?php echo get_lang_string("fullscreen") ?>"],
        ["undo", "<?php echo get_lang_string("undo") ?>"],
        ["redo", "<?php echo get_lang_string("redo") ?>"],
        ["canvas-clear", "<?php echo get_lang_string("clear") ?>"]
    ].forEach(function(item) {
        pn.getButton("options", item[0]).set("attributes", {"title": item[1], "data-tooltip-pos": "bottom"});
    });
    [
        ["open-sm", "<?php echo get_lang_string("open_sm") ?>"],
        ["open-layers", "<?php echo get_lang_string("open_layers") ?>"],
        ["open-blocks", "<?php echo get_lang_string("open_block") ?>"]
    ].forEach(function(item) {
        pn.getButton("views", item[0]).set("attributes", {"title": item[1], "data-tooltip-pos": "bottom"});
    });
    var titles = document.querySelectorAll("*[title]");

    for (var i = 0; i < titles.length; i++) {
        var el = titles[i];
        var title = el.getAttribute("title");
        title = title ? title.trim() : "";
        if (!title)
            break;
        el.setAttribute("data-tooltip", title);
        el.setAttribute("title", "");
    }

    editor.on("load", function() {
        var $ = grapesjs.$;

        // Show borders by default
        pn.getButton("options", "sw-visibility").set("active", 1);

        // Load and show settings and style manager
        var openTmBtn = pn.getButton("views", "open-tm");
        openTmBtn && openTmBtn.set("active", 1);
        var openSm = pn.getButton("views", "open-sm");
        openSm && openSm.set("active", 1);

        // Remove trait view
        pn.removeButton("views", "open-tm");

        // Add Settings Sector
        var traitsSector = $(`<div class="gjs-sm-sector no-select">
                <div class="gjs-sm-sector-title">
                    <span class="icon-settings fa fa-cog"></span>
                    <span class="gjs-sm-sector-label"><?php echo get_lang_string("settings") ?></span>
                </div>
                <div class="gjs-sm-properties" style="display: none;"></div>
            </div>`);
        var traitsProps = traitsSector.find(".gjs-sm-properties");
        // traitsProps.append($(".gjs-trt-traits"));
        $(".gjs-sm-sectors").before(traitsSector);
        traitsSector.find(".gjs-sm-sector-title").on("click", function() {
            var traitStyle = traitsProps.get(0).style;
            var hidden = traitStyle.display == "none";
            if (hidden) {
                traitStyle.display = "block";
            } else {
                traitStyle.display = "none";
            }
        });

        // Open block manager
        var openBlocksBtn = editor.Panels.getButton("views", "open-blocks");
        openBlocksBtn && openBlocksBtn.set("active", 1);

        updateForm();
    });

</script>
