"use strict";(function(root,factory){if(typeof define==="function"&&define.amd){define("pdfjs-web/preferences",["exports"],factory)}else if(typeof exports!=="undefined"){factory(exports)}else{factory(root.pdfjsWebPreferences={})}})(this,function(exports){var defaultPreferences=new Promise(function(resolve){if(DEFAULT_PREFERENCES){resolve(DEFAULT_PREFERENCES);return}document.addEventListener("defaultpreferencesloaded",function loaded(){resolve(DEFAULT_PREFERENCES);document.removeEventListener("defaultpreferencesloaded",loaded)})});function cloneObj(obj){var result={};for(var i in obj){if(Object.prototype.hasOwnProperty.call(obj,i)){result[i]=obj[i]}}return result}var Preferences={prefs:null,isInitializedPromiseResolved:false,initializedPromise:null,initialize:function preferencesInitialize(){return this.initializedPromise=defaultPreferences.then(function(defaults){Object.defineProperty(this,"defaults",{value:Object.freeze(defaults),writable:false,enumerable:true,configurable:false});this.prefs=cloneObj(defaults);return this._readFromStorage(defaults)}.bind(this)).then(function(prefObj){this.isInitializedPromiseResolved=true;if(prefObj){this.prefs=prefObj}}.bind(this))},_writeToStorage:function preferences_writeToStorage(prefObj){return Promise.resolve()},_readFromStorage:function preferences_readFromStorage(prefObj){return Promise.resolve()},reset:function preferencesReset(){return this.initializedPromise.then(function(){this.prefs=cloneObj(this.defaults);return this._writeToStorage(this.defaults)}.bind(this))},reload:function preferencesReload(){return this.initializedPromise.then(function(){this._readFromStorage(this.defaults).then(function(prefObj){if(prefObj){this.prefs=prefObj}}.bind(this))}.bind(this))},set:function preferencesSet(name,value){return this.initializedPromise.then(function(){if(this.defaults[name]===undefined){throw new Error("preferencesSet: '"+name+"' is undefined.")}else if(value===undefined){throw new Error("preferencesSet: no value is specified.")}var valueType=typeof value;var defaultType=typeof this.defaults[name];if(valueType!==defaultType){if(valueType==="number"&&defaultType==="string"){value=value.toString()}else{throw new Error("Preferences_set: '"+value+"' is a \""+valueType+'", expected "'+defaultType+'".')}}else{if(valueType==="number"&&(value|0)!==value){throw new Error("Preferences_set: '"+value+'\' must be an "integer".')}}this.prefs[name]=value;return this._writeToStorage(this.prefs)}.bind(this))},get:function preferencesGet(name){return this.initializedPromise.then(function(){var defaultValue=this.defaults[name];if(defaultValue===undefined){throw new Error("preferencesGet: '"+name+"' is undefined.")}else{var prefValue=this.prefs[name];if(prefValue!==undefined){return prefValue}}return defaultValue}.bind(this))}};Preferences._writeToStorage=function(prefObj){return new Promise(function(resolve){localStorage.setItem("pdfjs.preferences",JSON.stringify(prefObj));resolve()})};Preferences._readFromStorage=function(prefObj){return new Promise(function(resolve){var readPrefs=JSON.parse(localStorage.getItem("pdfjs.preferences"));resolve(readPrefs)})};exports.Preferences=Preferences});