"use strict";(function(root,factory){if(typeof define==="function"&&define.amd){define("pdfjs/core/parser",["exports","pdfjs/shared/util","pdfjs/core/primitives","pdfjs/core/stream"],factory)}else if(typeof exports!=="undefined"){factory(exports,require("../shared/util.js"),require("./primitives.js"),require("./stream.js"))}else{factory(root.pdfjsCoreParser={},root.pdfjsSharedUtil,root.pdfjsCorePrimitives,root.pdfjsCoreStream)}})(this,function(exports,sharedUtil,corePrimitives,coreStream){var MissingDataException=sharedUtil.MissingDataException;var StreamType=sharedUtil.StreamType;var assert=sharedUtil.assert;var error=sharedUtil.error;var info=sharedUtil.info;var isArray=sharedUtil.isArray;var isInt=sharedUtil.isInt;var isNum=sharedUtil.isNum;var isString=sharedUtil.isString;var warn=sharedUtil.warn;var Cmd=corePrimitives.Cmd;var Dict=corePrimitives.Dict;var Name=corePrimitives.Name;var Ref=corePrimitives.Ref;var isCmd=corePrimitives.isCmd;var isDict=corePrimitives.isDict;var isName=corePrimitives.isName;var Ascii85Stream=coreStream.Ascii85Stream;var AsciiHexStream=coreStream.AsciiHexStream;var CCITTFaxStream=coreStream.CCITTFaxStream;var FlateStream=coreStream.FlateStream;var Jbig2Stream=coreStream.Jbig2Stream;var JpegStream=coreStream.JpegStream;var JpxStream=coreStream.JpxStream;var LZWStream=coreStream.LZWStream;var NullStream=coreStream.NullStream;var PredictorStream=coreStream.PredictorStream;var RunLengthStream=coreStream.RunLengthStream;var EOF={};function isEOF(v){return v===EOF}var MAX_LENGTH_TO_CACHE=1e3;var Parser=function ParserClosure(){function Parser(lexer,allowStreams,xref){this.lexer=lexer;this.allowStreams=allowStreams;this.xref=xref;this.imageCache=Object.create(null);this.refill()}Parser.prototype={refill:function Parser_refill(){this.buf1=this.lexer.getObj();this.buf2=this.lexer.getObj()},shift:function Parser_shift(){if(isCmd(this.buf2,"ID")){this.buf1=this.buf2;this.buf2=null}else{this.buf1=this.buf2;this.buf2=this.lexer.getObj()}},tryShift:function Parser_tryShift(){try{this.shift();return true}catch(e){if(e instanceof MissingDataException){throw e}return false}},getObj:function Parser_getObj(cipherTransform){var buf1=this.buf1;this.shift();if(buf1 instanceof Cmd){switch(buf1.cmd){case"BI":return this.makeInlineImage(cipherTransform);case"[":var array=[];while(!isCmd(this.buf1,"]")&&!isEOF(this.buf1)){array.push(this.getObj(cipherTransform))}if(isEOF(this.buf1)){error("End of file inside array")}this.shift();return array;case"<<":var dict=new Dict(this.xref);while(!isCmd(this.buf1,">>")&&!isEOF(this.buf1)){if(!isName(this.buf1)){info("Malformed dictionary: key must be a name object");this.shift();continue}var key=this.buf1.name;this.shift();if(isEOF(this.buf1)){break}dict.set(key,this.getObj(cipherTransform))}if(isEOF(this.buf1)){error("End of file inside dictionary")}if(isCmd(this.buf2,"stream")){return this.allowStreams?this.makeStream(dict,cipherTransform):dict}this.shift();return dict;default:return buf1}}if(isInt(buf1)){var num=buf1;if(isInt(this.buf1)&&isCmd(this.buf2,"R")){var ref=new Ref(num,this.buf1);this.shift();this.shift();return ref}return num}if(isString(buf1)){var str=buf1;if(cipherTransform){str=cipherTransform.decryptString(str)}return str}return buf1},findDefaultInlineStreamEnd:function Parser_findDefaultInlineStreamEnd(stream){var E=69,I=73,SPACE=32,LF=10,CR=13;var startPos=stream.pos,state=0,ch,i,n,followingBytes;while((ch=stream.getByte())!==-1){if(state===0){state=ch===E?1:0}else if(state===1){state=ch===I?2:0}else{assert(state===2);if(ch===SPACE||ch===LF||ch===CR){n=5;followingBytes=stream.peekBytes(n);for(i=0;i<n;i++){ch=followingBytes[i];if(ch!==LF&&ch!==CR&&(ch<SPACE||ch>127)){state=0;break}}if(state===2){break}}else{state=0}}}return stream.pos-4-startPos},findDCTDecodeInlineStreamEnd:function Parser_findDCTDecodeInlineStreamEnd(stream){var startPos=stream.pos,foundEOI=false,b,markerLength,length;while((b=stream.getByte())!==-1){if(b!==255){continue}switch(stream.getByte()){case 0:break;case 255:stream.skip(-1);break;case 217:foundEOI=true;break;case 192:case 193:case 194:case 195:case 197:case 198:case 199:case 201:case 202:case 203:case 205:case 206:case 207:case 196:case 204:case 218:case 219:case 220:case 221:case 222:case 223:case 224:case 225:case 226:case 227:case 228:case 229:case 230:case 231:case 232:case 233:case 234:case 235:case 236:case 237:case 238:case 239:case 254:markerLength=stream.getUint16();if(markerLength>2){stream.skip(markerLength-2)}else{stream.skip(-2)}break}if(foundEOI){break}}length=stream.pos-startPos;if(b===-1){warn("Inline DCTDecode image stream: "+"EOI marker not found, searching for /EI/ instead.");stream.skip(-length);return this.findDefaultInlineStreamEnd(stream)}this.inlineStreamSkipEI(stream);return length},findASCII85DecodeInlineStreamEnd:function Parser_findASCII85DecodeInlineStreamEnd(stream){var TILDE=126,GT=62;var startPos=stream.pos,ch,length;while((ch=stream.getByte())!==-1){if(ch===TILDE&&stream.peekByte()===GT){stream.skip();break}}length=stream.pos-startPos;if(ch===-1){warn("Inline ASCII85Decode image stream: "+"EOD marker not found, searching for /EI/ instead.");stream.skip(-length);return this.findDefaultInlineStreamEnd(stream)}this.inlineStreamSkipEI(stream);return length},findASCIIHexDecodeInlineStreamEnd:function Parser_findASCIIHexDecodeInlineStreamEnd(stream){var GT=62;var startPos=stream.pos,ch,length;while((ch=stream.getByte())!==-1){if(ch===GT){break}}length=stream.pos-startPos;if(ch===-1){warn("Inline ASCIIHexDecode image stream: "+"EOD marker not found, searching for /EI/ instead.");stream.skip(-length);return this.findDefaultInlineStreamEnd(stream)}this.inlineStreamSkipEI(stream);return length},inlineStreamSkipEI:function Parser_inlineStreamSkipEI(stream){var E=69,I=73;var state=0,ch;while((ch=stream.getByte())!==-1){if(state===0){state=ch===E?1:0}else if(state===1){state=ch===I?2:0}else if(state===2){break}}},makeInlineImage:function Parser_makeInlineImage(cipherTransform){var lexer=this.lexer;var stream=lexer.stream;var dict=new Dict(this.xref);while(!isCmd(this.buf1,"ID")&&!isEOF(this.buf1)){if(!isName(this.buf1)){error("Dictionary key must be a name object")}var key=this.buf1.name;this.shift();if(isEOF(this.buf1)){break}dict.set(key,this.getObj(cipherTransform))}var filter=dict.get("Filter","F"),filterName;if(isName(filter)){filterName=filter.name}else if(isArray(filter)&&isName(filter[0])){filterName=filter[0].name}var startPos=stream.pos,length,i,ii;if(filterName==="DCTDecode"||filterName==="DCT"){length=this.findDCTDecodeInlineStreamEnd(stream)}else if(filterName==="ASCII85Decide"||filterName==="A85"){length=this.findASCII85DecodeInlineStreamEnd(stream)}else if(filterName==="ASCIIHexDecode"||filterName==="AHx"){length=this.findASCIIHexDecodeInlineStreamEnd(stream)}else{length=this.findDefaultInlineStreamEnd(stream)}var imageStream=stream.makeSubStream(startPos,length,dict);var adler32;if(length<MAX_LENGTH_TO_CACHE){var imageBytes=imageStream.getBytes();imageStream.reset();var a=1;var b=0;for(i=0,ii=imageBytes.length;i<ii;++i){a+=imageBytes[i]&255;b+=a}adler32=b%65521<<16|a%65521;if(this.imageCache.adler32===adler32){this.buf2=Cmd.get("EI");this.shift();this.imageCache[adler32].reset();return this.imageCache[adler32]}}if(cipherTransform){imageStream=cipherTransform.createStream(imageStream,length)}imageStream=this.filter(imageStream,dict,length);imageStream.dict=dict;if(adler32!==undefined){imageStream.cacheKey="inline_"+length+"_"+adler32;this.imageCache[adler32]=imageStream}this.buf2=Cmd.get("EI");this.shift();return imageStream},makeStream:function Parser_makeStream(dict,cipherTransform){var lexer=this.lexer;var stream=lexer.stream;lexer.skipToNextLine();var pos=stream.pos-1;var length=dict.get("Length");if(!isInt(length)){info("Bad "+length+" attribute in stream");length=0}stream.pos=pos+length;lexer.nextChar();if(this.tryShift()&&isCmd(this.buf2,"endstream")){this.shift()}else{stream.pos=pos;var SCAN_BLOCK_SIZE=2048;var ENDSTREAM_SIGNATURE_LENGTH=9;var ENDSTREAM_SIGNATURE=[101,110,100,115,116,114,101,97,109];var skipped=0,found=false,i,j;while(stream.pos<stream.end){var scanBytes=stream.peekBytes(SCAN_BLOCK_SIZE);var scanLength=scanBytes.length-ENDSTREAM_SIGNATURE_LENGTH;if(scanLength<=0){break}found=false;i=0;while(i<scanLength){j=0;while(j<ENDSTREAM_SIGNATURE_LENGTH&&scanBytes[i+j]===ENDSTREAM_SIGNATURE[j]){j++}if(j>=ENDSTREAM_SIGNATURE_LENGTH){found=true;break}i++}if(found){skipped+=i;stream.pos+=i;break}skipped+=scanLength;stream.pos+=scanLength}if(!found){error("Missing endstream")}length=skipped;lexer.nextChar();this.shift();this.shift()}this.shift();stream=stream.makeSubStream(pos,length,dict);if(cipherTransform){stream=cipherTransform.createStream(stream,length)}stream=this.filter(stream,dict,length);stream.dict=dict;return stream},filter:function Parser_filter(stream,dict,length){var filter=dict.get("Filter","F");var params=dict.get("DecodeParms","DP");if(isName(filter)){return this.makeFilter(stream,filter.name,length,params)}var maybeLength=length;if(isArray(filter)){var filterArray=filter;var paramsArray=params;for(var i=0,ii=filterArray.length;i<ii;++i){filter=filterArray[i];if(!isName(filter)){error("Bad filter name: "+filter)}params=null;if(isArray(paramsArray)&&i in paramsArray){params=paramsArray[i]}stream=this.makeFilter(stream,filter.name,maybeLength,params);maybeLength=null}}return stream},makeFilter:function Parser_makeFilter(stream,name,maybeLength,params){if(stream.dict.get("Length")===0&&!maybeLength){warn('Empty "'+name+'" stream.');return new NullStream(stream)}try{if(params&&this.xref){params=this.xref.fetchIfRef(params)}var xrefStreamStats=this.xref.stats.streamTypes;if(name==="FlateDecode"||name==="Fl"){xrefStreamStats[StreamType.FLATE]=true;if(params){return new PredictorStream(new FlateStream(stream,maybeLength),maybeLength,params)}return new FlateStream(stream,maybeLength)}if(name==="LZWDecode"||name==="LZW"){xrefStreamStats[StreamType.LZW]=true;var earlyChange=1;if(params){if(params.has("EarlyChange")){earlyChange=params.get("EarlyChange")}return new PredictorStream(new LZWStream(stream,maybeLength,earlyChange),maybeLength,params)}return new LZWStream(stream,maybeLength,earlyChange)}if(name==="DCTDecode"||name==="DCT"){xrefStreamStats[StreamType.DCT]=true;return new JpegStream(stream,maybeLength,stream.dict,this.xref)}if(name==="JPXDecode"||name==="JPX"){xrefStreamStats[StreamType.JPX]=true;return new JpxStream(stream,maybeLength,stream.dict)}if(name==="ASCII85Decode"||name==="A85"){xrefStreamStats[StreamType.A85]=true;return new Ascii85Stream(stream,maybeLength)}if(name==="ASCIIHexDecode"||name==="AHx"){xrefStreamStats[StreamType.AHX]=true;return new AsciiHexStream(stream,maybeLength)}if(name==="CCITTFaxDecode"||name==="CCF"){xrefStreamStats[StreamType.CCF]=true;return new CCITTFaxStream(stream,maybeLength,params)}if(name==="RunLengthDecode"||name==="RL"){xrefStreamStats[StreamType.RL]=true;return new RunLengthStream(stream,maybeLength)}if(name==="JBIG2Decode"){xrefStreamStats[StreamType.JBIG]=true;return new Jbig2Stream(stream,maybeLength,stream.dict)}warn('filter "'+name+'" not supported yet');return stream}catch(ex){if(ex instanceof MissingDataException){throw ex}warn('Invalid stream: "'+ex+'"');return new NullStream(stream)}}};return Parser}();var Lexer=function LexerClosure(){function Lexer(stream,knownCommands){this.stream=stream;this.nextChar();this.strBuf=[];this.knownCommands=knownCommands}Lexer.isSpace=function Lexer_isSpace(ch){return ch===32||ch===9||ch===13||ch===10};var specialChars=[1,0,0,0,0,0,0,0,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,2,0,0,2,2,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];function toHexDigit(ch){if(ch>=48&&ch<=57){return ch&15}if(ch>=65&&ch<=70||ch>=97&&ch<=102){return(ch&15)+9}return-1}Lexer.prototype={nextChar:function Lexer_nextChar(){return this.currentChar=this.stream.getByte()},peekChar:function Lexer_peekChar(){return this.stream.peekByte()},getNumber:function Lexer_getNumber(){var ch=this.currentChar;var eNotation=false;var divideBy=0;var sign=1;if(ch===45){sign=-1;ch=this.nextChar();if(ch===45){ch=this.nextChar()}}else if(ch===43){ch=this.nextChar()}if(ch===46){divideBy=10;ch=this.nextChar()}if(ch<48||ch>57){error("Invalid number: "+String.fromCharCode(ch));return 0}var baseValue=ch-48;var powerValue=0;var powerValueSign=1;while((ch=this.nextChar())>=0){if(48<=ch&&ch<=57){var currentDigit=ch-48;if(eNotation){powerValue=powerValue*10+currentDigit}else{if(divideBy!==0){divideBy*=10}baseValue=baseValue*10+currentDigit}}else if(ch===46){if(divideBy===0){divideBy=1}else{break}}else if(ch===45){warn("Badly formated number")}else if(ch===69||ch===101){ch=this.peekChar();if(ch===43||ch===45){powerValueSign=ch===45?-1:1;this.nextChar()}else if(ch<48||ch>57){break}eNotation=true}else{break}}if(divideBy!==0){baseValue/=divideBy}if(eNotation){baseValue*=Math.pow(10,powerValueSign*powerValue)}return sign*baseValue},getString:function Lexer_getString(){var numParen=1;var done=false;var strBuf=this.strBuf;strBuf.length=0;var ch=this.nextChar();while(true){var charBuffered=false;switch(ch|0){case-1:warn("Unterminated string");done=true;break;case 40:++numParen;strBuf.push("(");break;case 41:if(--numParen===0){this.nextChar();done=true}else{strBuf.push(")")}break;case 92:ch=this.nextChar();switch(ch){case-1:warn("Unterminated string");done=true;break;case 110:strBuf.push("\n");break;case 114:strBuf.push("\r");break;case 116:strBuf.push("\t");break;case 98:strBuf.push("\b");break;case 102:strBuf.push("\f");break;case 92:case 40:case 41:strBuf.push(String.fromCharCode(ch));break;case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:var x=ch&15;ch=this.nextChar();charBuffered=true;if(ch>=48&&ch<=55){x=(x<<3)+(ch&15);ch=this.nextChar();if(ch>=48&&ch<=55){charBuffered=false;x=(x<<3)+(ch&15)}}strBuf.push(String.fromCharCode(x));break;case 13:if(this.peekChar()===10){this.nextChar()}break;case 10:break;default:strBuf.push(String.fromCharCode(ch));break}break;default:strBuf.push(String.fromCharCode(ch));break}if(done){break}if(!charBuffered){ch=this.nextChar()}}return strBuf.join("")},getName:function Lexer_getName(){var ch,previousCh;var strBuf=this.strBuf;strBuf.length=0;while((ch=this.nextChar())>=0&&!specialChars[ch]){if(ch===35){ch=this.nextChar();if(specialChars[ch]){warn("Lexer_getName: "+"NUMBER SIGN (#) should be followed by a hexadecimal number.");strBuf.push("#");break}var x=toHexDigit(ch);if(x!==-1){previousCh=ch;ch=this.nextChar();var x2=toHexDigit(ch);if(x2===-1){warn("Lexer_getName: Illegal digit ("+String.fromCharCode(ch)+") in hexadecimal number.");strBuf.push("#",String.fromCharCode(previousCh));if(specialChars[ch]){break}strBuf.push(String.fromCharCode(ch));continue}strBuf.push(String.fromCharCode(x<<4|x2))}else{strBuf.push("#",String.fromCharCode(ch))}}else{strBuf.push(String.fromCharCode(ch))}}if(strBuf.length>127){warn("name token is longer than allowed by the spec: "+strBuf.length)}return Name.get(strBuf.join(""))},getHexString:function Lexer_getHexString(){var strBuf=this.strBuf;strBuf.length=0;var ch=this.currentChar;var isFirstHex=true;var firstDigit;var secondDigit;while(true){if(ch<0){warn("Unterminated hex string");break}else if(ch===62){this.nextChar();break}else if(specialChars[ch]===1){ch=this.nextChar();continue}else{if(isFirstHex){firstDigit=toHexDigit(ch);if(firstDigit===-1){warn('Ignoring invalid character "'+ch+'" in hex string');ch=this.nextChar();continue}}else{secondDigit=toHexDigit(ch);if(secondDigit===-1){warn('Ignoring invalid character "'+ch+'" in hex string');ch=this.nextChar();continue}strBuf.push(String.fromCharCode(firstDigit<<4|secondDigit))}isFirstHex=!isFirstHex;ch=this.nextChar()}}return strBuf.join("")},getObj:function Lexer_getObj(){var comment=false;var ch=this.currentChar;while(true){if(ch<0){return EOF}if(comment){if(ch===10||ch===13){comment=false}}else if(ch===37){comment=true}else if(specialChars[ch]!==1){break}ch=this.nextChar()}switch(ch|0){case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:case 43:case 45:case 46:return this.getNumber();case 40:return this.getString();case 47:return this.getName();case 91:this.nextChar();return Cmd.get("[");case 93:this.nextChar();return Cmd.get("]");case 60:ch=this.nextChar();if(ch===60){this.nextChar();return Cmd.get("<<")}return this.getHexString();case 62:ch=this.nextChar();if(ch===62){this.nextChar();return Cmd.get(">>")}return Cmd.get(">");case 123:this.nextChar();return Cmd.get("{");case 125:this.nextChar();return Cmd.get("}");case 41:error("Illegal character: "+ch);break}var str=String.fromCharCode(ch);var knownCommands=this.knownCommands;var knownCommandFound=knownCommands&&knownCommands[str]!==undefined;while((ch=this.nextChar())>=0&&!specialChars[ch]){var possibleCommand=str+String.fromCharCode(ch);if(knownCommandFound&&knownCommands[possibleCommand]===undefined){break}if(str.length===128){error("Command token too long: "+str.length)}str=possibleCommand;knownCommandFound=knownCommands&&knownCommands[str]!==undefined}if(str==="true"){return true}if(str==="false"){return false}if(str==="null"){return null}return Cmd.get(str)},skipToNextLine:function Lexer_skipToNextLine(){var ch=this.currentChar;while(ch>=0){if(ch===13){ch=this.nextChar();if(ch===10){this.nextChar()}break}else if(ch===10){this.nextChar();break}ch=this.nextChar()}}};return Lexer}();var Linearization={create:function LinearizationCreate(stream){function getInt(name,allowZeroValue){var obj=linDict.get(name);if(isInt(obj)&&(allowZeroValue?obj>=0:obj>0)){return obj}throw new Error('The "'+name+'" parameter in the linearization '+"dictionary is invalid.")}function getHints(){var hints=linDict.get("H"),hintsLength,item;if(isArray(hints)&&((hintsLength=hints.length)===2||hintsLength===4)){for(var index=0;index<hintsLength;index++){if(!(isInt(item=hints[index])&&item>0)){throw new Error("Hint ("+index+") in the linearization dictionary is invalid.")}}return hints}throw new Error("Hint array in the linearization dictionary is invalid.")}var parser=new Parser(new Lexer(stream),false,null);var obj1=parser.getObj();var obj2=parser.getObj();var obj3=parser.getObj();var linDict=parser.getObj();var obj,length;if(!(isInt(obj1)&&isInt(obj2)&&isCmd(obj3,"obj")&&isDict(linDict)&&isNum(obj=linDict.get("Linearized"))&&obj>0)){return null}else if((length=getInt("L"))!==stream.length){throw new Error('The "L" parameter in the linearization dictionary '+"does not equal the stream length.")}return{length:length,hints:getHints(),objectNumberFirst:getInt("O"),endFirst:getInt("E"),numPages:getInt("N"),mainXRefEntriesOffset:getInt("T"),pageFirst:linDict.has("P")?getInt("P",true):0}}};exports.EOF=EOF;exports.Lexer=Lexer;exports.Linearization=Linearization;exports.Parser=Parser;exports.isEOF=isEOF});