# Moodle Plugin: PDFProtect

This is a Moodle module developed to provide an extra layer of security for PDF files, preventing users from downloading, printing, or copying the content of the PDF. It is ideal for protecting sensitive material and preventing unauthorized sharing of documents.

## Features

- **Download Protection**: Prevents downloading the PDF file.
- **Print Block**: Disables the print option for the PDF.
- **Prevent Text Copying**: Blocks copying content from the PDF, ensuring that the content cannot be easily copied.

## Requirements

- Moodle 2.7 or higher.
- Proper permissions to install and manage plugins on your Moodle site.

## How to Use

1. Access the course where you want to add the protected PDF file.
2. Add the **PDFProtect** module as a resource.
3. Upload your PDF file.
4. Save the settings.

Now, users will have access to the PDF directly in the browser, with no option to download, print, or copy the content.

## Contributions

If you have suggestions or improvements for the plugin, feel free to create a *pull request* or open an *issue*.

## Contact

Eduardo Kraus  
Professor / Programmer / Passionate about Moodle / Innovation and new products  
[www.eduardokraus.com.br](https://www.eduardokraus.com.br)
