"use strict";(function(root,factory){if(typeof define==="function"&&define.amd){define("pdfjs-web/pdf_document_properties",["exports","pdfjs-web/ui_utils","pdfjs-web/overlay_manager"],factory)}else if(typeof exports!=="undefined"){factory(exports,require("./ui_utils.js"),require("./overlay_manager.js"))}else{factory(root.pdfjsWebPDFDocumentProperties={},root.pdfjsWebUIUtils,root.pdfjsWebOverlayManager)}})(this,function(exports,uiUtils,overlayManager){var getPDFFileNameFromURL=uiUtils.getPDFFileNameFromURL;var mozL10n=uiUtils.mozL10n;var OverlayManager=overlayManager.OverlayManager;var PDFDocumentProperties=function PDFDocumentPropertiesClosure(){function PDFDocumentProperties(options){this.fields=options.fields;this.overlayName=options.overlayName;this.container=options.container;this.rawFileSize=0;this.url=null;this.pdfDocument=null;if(options.closeButton){options.closeButton.addEventListener("click",this.close.bind(this))}this.dataAvailablePromise=new Promise(function(resolve){this.resolveDataAvailable=resolve}.bind(this));OverlayManager.register(this.overlayName,this.container,this.close.bind(this))}PDFDocumentProperties.prototype={open:function PDFDocumentProperties_open(){Promise.all([OverlayManager.open(this.overlayName),this.dataAvailablePromise]).then(function(){this._getProperties()}.bind(this))},close:function PDFDocumentProperties_close(){OverlayManager.close(this.overlayName)},setFileSize:function PDFDocumentProperties_setFileSize(fileSize){if(fileSize>0){this.rawFileSize=fileSize}},setDocumentAndUrl:function PDFDocumentProperties_setDocumentAndUrl(pdfDocument,url){this.pdfDocument=pdfDocument;this.url=url;this.resolveDataAvailable()},_getProperties:function PDFDocumentProperties_getProperties(){if(!OverlayManager.active){return}this.pdfDocument.getDownloadInfo().then(function(data){if(data.length===this.rawFileSize){return}this.setFileSize(data.length);this._updateUI(this.fields["fileSize"],this._parseFileSize())}.bind(this));this.pdfDocument.getMetadata().then(function(data){var content={fileName:getPDFFileNameFromURL(this.url),fileSize:this._parseFileSize(),title:data.info.Title,author:data.info.Author,subject:data.info.Subject,keywords:data.info.Keywords,creationDate:this._parseDate(data.info.CreationDate),modificationDate:this._parseDate(data.info.ModDate),creator:data.info.Creator,producer:data.info.Producer,version:data.info.PDFFormatVersion,pageCount:this.pdfDocument.numPages};for(var identifier in content){this._updateUI(this.fields[identifier],content[identifier])}}.bind(this))},_updateUI:function PDFDocumentProperties_updateUI(field,content){if(field&&content!==undefined&&content!==""){field.textContent=content}},_parseFileSize:function PDFDocumentProperties_parseFileSize(){var fileSize=this.rawFileSize,kb=fileSize/1024;if(!kb){return}else if(kb<1024){return mozL10n.get("document_properties_kb",{size_kb:(+kb.toPrecision(3)).toLocaleString(),size_b:fileSize.toLocaleString()},"{{size_kb}} KB ({{size_b}} bytes)")}else{return mozL10n.get("document_properties_mb",{size_mb:(+(kb/1024).toPrecision(3)).toLocaleString(),size_b:fileSize.toLocaleString()},"{{size_mb}} MB ({{size_b}} bytes)")}},_parseDate:function PDFDocumentProperties_parseDate(inputDate){var dateToParse=inputDate;if(dateToParse===undefined){return""}if(dateToParse.substring(0,2)==="D:"){dateToParse=dateToParse.substring(2)}var year=parseInt(dateToParse.substring(0,4),10);var month=parseInt(dateToParse.substring(4,6),10)-1;var day=parseInt(dateToParse.substring(6,8),10);var hours=parseInt(dateToParse.substring(8,10),10);var minutes=parseInt(dateToParse.substring(10,12),10);var seconds=parseInt(dateToParse.substring(12,14),10);var utRel=dateToParse.substring(14,15);var offsetHours=parseInt(dateToParse.substring(15,17),10);var offsetMinutes=parseInt(dateToParse.substring(18,20),10);if(utRel==="-"){hours+=offsetHours;minutes+=offsetMinutes}else if(utRel==="+"){hours-=offsetHours;minutes-=offsetMinutes}var date=new Date(Date.UTC(year,month,day,hours,minutes,seconds));var dateString=date.toLocaleDateString();var timeString=date.toLocaleTimeString();return mozL10n.get("document_properties_date_string",{date:dateString,time:timeString},"{{date}}, {{time}}")}};return PDFDocumentProperties}();exports.PDFDocumentProperties=PDFDocumentProperties});