"use strict";(function(root,factory){if(typeof define==="function"&&define.amd){define("pdfjs-web/pdf_outline_viewer",["exports","pdfjs-web/pdfjs"],factory)}else if(typeof exports!=="undefined"){factory(exports,require("./pdfjs.js"))}else{factory(root.pdfjsWebPDFOutlineViewer={},root.pdfjsWebPDFJS)}})(this,function(exports,pdfjsLib){var DEFAULT_TITLE="–";var PDFOutlineViewer=function PDFOutlineViewerClosure(){function PDFOutlineViewer(options){this.outline=null;this.lastToggleIsShow=true;this.container=options.container;this.linkService=options.linkService;this.eventBus=options.eventBus}PDFOutlineViewer.prototype={reset:function PDFOutlineViewer_reset(){this.outline=null;this.lastToggleIsShow=true;var container=this.container;while(container.firstChild){container.removeChild(container.firstChild)}},_dispatchEvent:function PDFOutlineViewer_dispatchEvent(outlineCount){this.eventBus.dispatch("outlineloaded",{source:this,outlineCount:outlineCount})},_bindLink:function PDFOutlineViewer_bindLink(element,item){if(item.url){pdfjsLib.addLinkAttributes(element,{url:item.url});return}var linkService=this.linkService;element.href=linkService.getDestinationHash(item.dest);element.onclick=function goToDestination(e){linkService.navigateTo(item.dest);return false}},_setStyles:function PDFOutlineViewer_setStyles(element,item){var styleStr="";if(item.bold){styleStr+="font-weight: bold;"}if(item.italic){styleStr+="font-style: italic;"}if(styleStr){element.setAttribute("style",styleStr)}},_addToggleButton:function PDFOutlineViewer_addToggleButton(div){var toggler=document.createElement("div");toggler.className="outlineItemToggler";toggler.onclick=function(event){event.stopPropagation();toggler.classList.toggle("outlineItemsHidden");if(event.shiftKey){var shouldShowAll=!toggler.classList.contains("outlineItemsHidden");this._toggleOutlineItem(div,shouldShowAll)}}.bind(this);div.insertBefore(toggler,div.firstChild)},_toggleOutlineItem:function PDFOutlineViewer_toggleOutlineItem(root,show){this.lastToggleIsShow=show;var togglers=root.querySelectorAll(".outlineItemToggler");for(var i=0,ii=togglers.length;i<ii;++i){togglers[i].classList[show?"remove":"add"]("outlineItemsHidden")}},toggleOutlineTree:function PDFOutlineViewer_toggleOutlineTree(){if(!this.outline){return}this._toggleOutlineItem(this.container,!this.lastToggleIsShow)},render:function PDFOutlineViewer_render(params){var outline=params&&params.outline||null;var outlineCount=0;if(this.outline){this.reset()}this.outline=outline;if(!outline){this._dispatchEvent(outlineCount);return}var fragment=document.createDocumentFragment();var queue=[{parent:fragment,items:this.outline}];var hasAnyNesting=false;while(queue.length>0){var levelData=queue.shift();for(var i=0,len=levelData.items.length;i<len;i++){var item=levelData.items[i];var div=document.createElement("div");div.className="outlineItem";var element=document.createElement("a");this._bindLink(element,item);this._setStyles(element,item);element.textContent=pdfjsLib.removeNullCharacters(item.title)||DEFAULT_TITLE;div.appendChild(element);if(item.items.length>0){hasAnyNesting=true;this._addToggleButton(div);var itemsDiv=document.createElement("div");itemsDiv.className="outlineItems";div.appendChild(itemsDiv);queue.push({parent:itemsDiv,items:item.items})}levelData.parent.appendChild(div);outlineCount++}}if(hasAnyNesting){this.container.classList.add("outlineWithDeepNesting")}this.container.appendChild(fragment);this._dispatchEvent(outlineCount)}};return PDFOutlineViewer}();exports.PDFOutlineViewer=PDFOutlineViewer});