"use strict";(function(root,factory){if(typeof define==="function"&&define.amd){define("pdfjs/display/text_layer",["exports","pdfjs/shared/util","pdfjs/display/dom_utils"],factory)}else if(typeof exports!=="undefined"){factory(exports,require("../shared/util.js"),require("./dom_utils.js"))}else{factory(root.pdfjsDisplayTextLayer={},root.pdfjsSharedUtil,root.pdfjsDisplayDOMUtils)}})(this,function(exports,sharedUtil,displayDOMUtils){var Util=sharedUtil.Util;var createPromiseCapability=sharedUtil.createPromiseCapability;var CustomStyle=displayDOMUtils.CustomStyle;var getDefaultSetting=displayDOMUtils.getDefaultSetting;var renderTextLayer=function renderTextLayerClosure(){var MAX_TEXT_DIVS_TO_RENDER=1e5;var NonWhitespaceRegexp=/\S/;function isAllWhitespace(str){return!NonWhitespaceRegexp.test(str)}function appendText(textDivs,viewport,geom,styles){var style=styles[geom.fontName];var textDiv=document.createElement("div");textDivs.push(textDiv);if(isAllWhitespace(geom.str)){textDiv.dataset.isWhitespace=true;return}var tx=Util.transform(viewport.transform,geom.transform);var angle=Math.atan2(tx[1],tx[0]);if(style.vertical){angle+=Math.PI/2}var fontHeight=Math.sqrt(tx[2]*tx[2]+tx[3]*tx[3]);var fontAscent=fontHeight;if(style.ascent){fontAscent=style.ascent*fontAscent}else if(style.descent){fontAscent=(1+style.descent)*fontAscent}var left;var top;if(angle===0){left=tx[4];top=tx[5]-fontAscent}else{left=tx[4]+fontAscent*Math.sin(angle);top=tx[5]-fontAscent*Math.cos(angle)}textDiv.style.left=left+"px";textDiv.style.top=top+"px";textDiv.style.fontSize=fontHeight+"px";textDiv.style.fontFamily=style.fontFamily;textDiv.textContent=geom.str;if(getDefaultSetting("pdfBug")){textDiv.dataset.fontName=geom.fontName}if(angle!==0){textDiv.dataset.angle=angle*(180/Math.PI)}if(geom.str.length>1){if(style.vertical){textDiv.dataset.canvasWidth=geom.height*viewport.scale}else{textDiv.dataset.canvasWidth=geom.width*viewport.scale}}}function render(task){if(task._canceled){return}var textLayerFrag=task._container;var textDivs=task._textDivs;var capability=task._capability;var textDivsLength=textDivs.length;if(textDivsLength>MAX_TEXT_DIVS_TO_RENDER){capability.resolve();return}var canvas=document.createElement("canvas");canvas.mozOpaque=true;var ctx=canvas.getContext("2d",{alpha:false});var lastFontSize;var lastFontFamily;for(var i=0;i<textDivsLength;i++){var textDiv=textDivs[i];if(textDiv.dataset.isWhitespace!==undefined){continue}var fontSize=textDiv.style.fontSize;var fontFamily=textDiv.style.fontFamily;if(fontSize!==lastFontSize||fontFamily!==lastFontFamily){ctx.font=fontSize+" "+fontFamily;lastFontSize=fontSize;lastFontFamily=fontFamily}var width=ctx.measureText(textDiv.textContent).width;textLayerFrag.appendChild(textDiv);var transform;if(textDiv.dataset.canvasWidth!==undefined&&width>0){var textScale=textDiv.dataset.canvasWidth/width;transform="scaleX("+textScale+")"}else{transform=""}var rotation=textDiv.dataset.angle;if(rotation){transform="rotate("+rotation+"deg) "+transform}if(transform){CustomStyle.setProp("transform",textDiv,transform)}}capability.resolve()}function TextLayerRenderTask(textContent,container,viewport,textDivs){this._textContent=textContent;this._container=container;this._viewport=viewport;textDivs=textDivs||[];this._textDivs=textDivs;this._canceled=false;this._capability=createPromiseCapability();this._renderTimer=null}TextLayerRenderTask.prototype={get promise(){return this._capability.promise},cancel:function TextLayer_cancel(){this._canceled=true;if(this._renderTimer!==null){clearTimeout(this._renderTimer);this._renderTimer=null}this._capability.reject("canceled")},_render:function TextLayer_render(timeout){var textItems=this._textContent.items;var styles=this._textContent.styles;var textDivs=this._textDivs;var viewport=this._viewport;for(var i=0,len=textItems.length;i<len;i++){appendText(textDivs,viewport,textItems[i],styles)}if(!timeout){render(this)}else{var self=this;this._renderTimer=setTimeout(function(){render(self);self._renderTimer=null},timeout)}}};function renderTextLayer(renderParameters){var task=new TextLayerRenderTask(renderParameters.textContent,renderParameters.container,renderParameters.viewport,renderParameters.textDivs);task._render(renderParameters.timeout);return task}return renderTextLayer}();exports.renderTextLayer=renderTextLayer});