<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package   profilefield_database
 * @copyright 2025 Eduardo Kraus https://eduardokraus.com/
 * @license   https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add-new-category'] = 'Add new category';
$string['add-new-data'] = 'Add new record';
$string['all_category'] = 'All categories';
$string['category-save-error'] = 'Fields 1 and 2 are required';
$string['category_field'] = 'Field name';
$string['category_field-delete'] = 'Leave blank to delete this field.';
$string['category_field-empty'] = 'Leave blank to ignore this field.';
$string['category_field-error'] = 'Field name is required';
$string['category_field-info'] = 'Enter the name of the field that will be displayed on the form';
$string['category_field-placeholder'] = 'Field name';
$string['category_field-title'] = 'New field';
$string['category_name'] = 'Category name';
$string['category_name-error'] = 'Category name is required';
$string['category_name-info'] = 'Enter the name of the category you want to use';
$string['category_name-placeholder'] = 'Category name';
$string['category_none'] = 'No categories registered!';
$string['confirm-delete-category'] = 'Are you sure you want to delete the category <strong>{$a}</strong>?';
$string['confirm-delete-data'] = 'Are you sure you want to delete the record <strong>{$a}</strong>?';
$string['data_none'] = 'No data registered!';
$string['database:addinstance'] = 'Add Instance';
$string['database:viewreport'] = 'View Report';
$string['delete-category'] = 'Delete the category';
$string['delete-category-usedata'] = 'This category is being used in the field <a href="{$a->wwwroot}/user/profile/index.php" target="_blank">{$a->name}</a>';
$string['delete-data'] = 'Delete the record';
$string['delete-data-usedata'] = 'This record is being used by user <a href="{$a->wwwroot}/user/profile.php?id=?id={$a->id}" target="_blank">{$a->name}</a>';
$string['delete-success'] = 'Category successfully deleted';
$string['edit_values_fields'] = 'Edit values ​​of these Fields';
$string['field_type'] = 'Field type';
$string['field_type-date'] = 'Data will be Date';
$string['field_type-info'] = 'Select the field type to be used';
$string['field_type-int'] = 'Data will be Number';
$string['field_type-text'] = 'Data will be text';
$string['manage-category-link'] = '<div class="alert alert-warning">To select a category, you must first create and manage categories. You can do this by accessing the area <a href="{$a}/user/profile/field/database/category.php">All categories</a>.</div>';
$string['missing-value-link'] = 'Field "Select category" needs to be a valid value in <a href="{$a}/user/profile/field/database/category.php">All categories</a>.';
$string['new-category'] = 'New category';
$string['new-data'] = 'New record';
$string['pluginname'] = 'User Field DB';
$string['privacy:metadata'] = 'The database plugin does not store personal data and does not send data to external sites.';
$string['report_category_description'] = 'This report displays detailed information about the students linked to the profile "{$a}".';
$string['report_category_title'] = 'Report of students in the profile "{$a}"';
$string['select-category'] = 'Select category';
