# Training

At Training, we believe in free education that is accessible to everyone, visually appealing in both content and design.

## 🔧 Accessibility Features

- Integration with [VLibras](https://www.gov.br/governodigital/pt-br/acessibilidade-e-usuario/vlibras) for automatic translation into Brazilian Sign Language (only for Brazilian Portuguese)
- Text resizing and contrast options
- Adjustable letter and line spacing
- Virtual keyboard for navigation
- Highlighting of links and headings
- Text-to-speech content reading (when available in the browser)
- Customizable color schemes

![Accessibility Illustration](https://eduardokraus.com/logos/theme_eadflix/acessibilidade.png)

## 🏠 Frontpage

Training offers two homepage options: the default Moodle layout and a customized version with editable blocks featuring the following elements:

- Four Netflix-style slideshows
- Three types of banners
- Price list
- Four resource lists
- Four lists of key differentiators
- Customizable FAQs

![Frontpage](https://eduardokraus.com/logos/theme_eadflix/frontpage.png)

## 🎓 Course Page

Training features a modern course page with an optional information banner, enabled via settings.

Activity block system: when an image is uploaded, the activity is transformed into a block. This works for both Topics and Weekly formats.

![Course Page](https://eduardokraus.com/logos/theme_eadtraining/curso.png)

## 🧱 Changes to Moodle Structure

- Many changes have been made to the structure and order of items, especially on the **Course Category** page.
- Selected courses now appear **above** the categories instead of below.
- Buttons are now displayed **inline** rather than stacked vertically.

### 📚 "My Courses" Page:

- The order has been adjusted so the search field is now at the **end of the list**.
- The search field starts small and **expands when focused**, saving space when not in use.

![Admin Screenshot](https://eduardokraus.com/logos/theme_eadtraining/admin.png)

## 👤 Modern Popup Profile

Popup-style display with a customizable top section and fully customizable background.  
Includes quick-access menus for:

- View and edit profile
- Grades
- Calendar
- Reports
- Preferences
- Switch profiles
- Log out

![Profile Area](https://eduardokraus.com/logos/theme_eadtraining/perfil.png)

## 🔻 Footer Block

The footer supports 0 to 4 fully customizable blocks. Use your creativity to design any content you want, with no limitations from rigid link or icon settings.

Even better: the "Made by" text can be removed directly in the settings at no additional cost.

![Footer Example 1](https://eduardokraus.com/logos/theme_eadtraining/rodape-1.png)  
![Footer Example 2](https://eduardokraus.com/logos/theme_eadtraining/rodape-2.png)

## 🙏 Acknowledgments and Sponsorship

Special thanks to Diego from [EadSuporte](https://www.eadsuporte.com.br/) for the essential partnership and support.

## 📧 Contact

- **Author:** Eduardo Kraus
- **Website:** [eduardokraus.com/contato](https://eduardokraus.com/contato)
- If you encounter any issues or have suggestions, feel free to **open an issue**! 😊
