define(["jquery", "core/modal", "core/notification"], function ($, Modal, Notification) {
    var frontpage = {
        add_block: function (lang) {
            $("#frontpage_add_block").click(function () {
                Modal.create({
                    title: $("#frontpage_add_block_modal").attr("data-title"),
                    body: '<div id="list-models" class="d-flex flex-wrap row"></div>',
                    large: true,
                    show: true,
                    removeOnClose: true,
                }).then(function (modal) {
                    if (!modal.root) {
                        modal.root = modal._root;
                    }
                    modal.modal.addClass('modal-dialog-centered');

                    frontpage.add_block_modal_init(lang);
                }).catch(Notification.exception);
            });
        },

        add_block_modal_init: function (lang) {
            async function loadFiles() {
                const response = await fetch(`${M.cfg.wwwroot}/theme/eadtraining/_editor/model/?lang=${lang}`);

                if (!response.ok) {
                    throw new Error("Error loading files: " + response.status);
                }

                const $list = $("#list-models");
                $list.empty(); // Clear the previous content.

                const data = await response.json();
                // Group by type (part before the '-').
                const groups = {};
                data.forEach(function (item) {
                    const type = item.id.includes('-') ? item.id.split('-')[0] : item.id;
                    if (!groups[type]) groups[type] = [];
                    groups[type].push(item);
                });

                // For each group, render its items.
                Object.values(groups).forEach(function (grupo) {
                    let width = "";
                    if (grupo.length === 4 || grupo.length === 8) {
                        width = "col-md-3"; // 4 items.
                    } else if (grupo.length === 3 || grupo.length === 6) {
                        width = "col-md-4"; // 3 items.
                    } else if (grupo.length === 2) {
                        width = "col-md-6"; // 2 items.
                    } else if (grupo.length === 1) {
                        width = "col-md-12"; // 1 items.
                    }

                    grupo.forEach(function (item) {
                        const block = $(`
                            <div class="item-model ${width} text-center" role="button">
                                <div class="item-model-border">
                                    <img src="${item.image}" 
                                         alt="${item.title}" 
                                         class="img-fluid mb-2" style="width:100%;border:1px solid #ccc;border-radius:8px;">
                                    <h5 style="font-size: 1rem;">${item.title}</h5>
                                    <a href="${item.preview}" 
                                       target="_blank">${M.util.get_string('preview', "theme_eadtraining")}</a>
                                </div>
                            </div>`);
                        $list.append(block);
                        block.find("a").click(function () {
                            event.stopImmediatePropagation();
                        })
                        block.click(function () {
                            location.href = `${M.cfg.wwwroot}/theme/eadtraining/_editor/editor.php?lang=${lang}&local=home&dataid=create&template=${item.id}`;
                        });
                    });
                });
            }

            loadFiles();
        },

        editingswitch: function () {
            $(".editmode-block-form")
                .show(300, function () {
                    $(this).css({"display": "flex"})
                });
            $("#homemode-editingswitch").click(function () {
                $("#homemode-editingswitch-form").submit();
            });
        },

        block_order: function () {
            // Butons move page.
            $(".homemode-pages .btn-move-up").click(function () {
                let $item = $(this).closest('.editmode-page-item');
                let $prev = $item.prev('.editmode-page-item');
                if ($prev.length) {
                    frontpage.block_order_move_item($item, $prev, true);
                }
            });
            $(".homemode-pages .btn-move-down").click(function () {
                let $item = $(this).closest('.editmode-page-item');
                let $next = $item.next('.editmode-page-item');
                if ($next.length) {
                    frontpage.block_order_move_item($item, $next, false);
                }
            });
        },

        // Move pages.
        block_order_move_item: function ($item, $target, isUp) {
            $item.slideUp(400, function () {
                if (isUp) {
                    $target.before($item);
                } else {
                    $target.after($item);
                }
                $item.slideDown(400, function () {
                    frontpage.block_order_save_order(); // <-- save after animation.
                });
            });
        },

        // Save order pages.
        block_order_save_order: function () {
            let order = [];

            $('.editmode-page-item').each(function () {
                order.push($(this).data('pageid'));
            });

            $.ajax({
                url: `${M.cfg.wwwroot}/theme/eadtraining/_editor/actions.php?action=page-order&local=home`,
                type: 'POST',
                data: {
                    order: order,
                    sesskey: M.cfg.sesskey,
                },
                success: function (response) {
                    console.log('Success', response);
                },
                error: function (error) {
                    console.error('error', error);
                }
            });
        }
    };

    return frontpage;
});
