define(["jquery", "theme_eadtraining/geopattern"], function ($, GeoPattern) {
    return {
        generateimage: function (imageid, courseid, baseColor) {

            courseid = Math.pow((courseid + 10000), 2);
            const $img = $(`img[src*="${imageid}"],[style*="${imageid}"]`);

            if (!$img.length) {
                return;
            }

            const pattern = GeoPattern.generate(courseid, {baseColor: baseColor});
            if ($img.is("img")) {
                console.log("image 2");
                $img.attr("src", pattern.toDataUrl());
            } else {
                console.log("background 2");
                console.log({
                    "background-size": "contain",
                    "background-repeat": "repeat",
                    "background-image": pattern.toDataUrl(),
                });
                $img.css({
                    "background-size": "contain",
                    "background-repeat": "repeat",
                    "background-image": pattern.toDataUrl(),
                });
            }
        },
    };
});
