<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language file.
 *
 * @package   theme_eadtraining
 * @copyright 2025 Eduardo Kraus {@link https://eduardokraus.com}
 * @copyright based on work by 2016 Frédéric Massart
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die;

$string['access_course'] = 'Access the course';
$string['access_course_buy'] = 'Course details';
$string['acctoolbar_access_declaration'] = 'Accessibility statement';
$string['acctoolbar_btn_bright'] = 'Bright contrast';
$string['acctoolbar_btn_cursor_black'] = 'Big black cursor';
$string['acctoolbar_btn_cursor_white'] = 'Big white cursor';
$string['acctoolbar_btn_font_down'] = 'Decrease text';
$string['acctoolbar_btn_font_readable'] = 'Readable text';
$string['acctoolbar_btn_font_up'] = 'Increase text';
$string['acctoolbar_btn_images_titles'] = 'Images titles';
$string['acctoolbar_btn_invert'] = 'Reverse contrast';
$string['acctoolbar_btn_monochrome'] = 'Uncolored display';
$string['acctoolbar_btn_open'] = 'Accessibility menu';
$string['acctoolbar_btn_underline_headers'] = 'Underline headers';
$string['acctoolbar_btn_underline_links'] = 'Underline links';
$string['acctoolbar_btn_zoom_in'] = 'Zoom screen';
$string['acctoolbar_content_block_header'] = 'Highlighting content';
$string['acctoolbar_contrast_block_header'] = 'Color contrast';
$string['acctoolbar_debug_contacts'] = 'Report an accessibility problem';
$string['acctoolbar_disable_animattions'] = 'Block animations';
$string['acctoolbar_dyslexic'] = 'Dyslexia Legible Font';
$string['acctoolbar_image_without_alt'] = 'Image without text';
$string['acctoolbar_keyboard_root'] = 'keyboard navigation';
$string['acctoolbar_reset_all_settings'] = 'Reset settings';
$string['acctoolbar_text_block_header'] = 'Text size';
$string['acctoolbar_toolbar'] = 'Accessibility';
$string['acctoolbar_zoom_block_header'] = 'Zoom in';
$string['add_block'] = '+ Add new block';
$string['advancedsettings'] = 'Advanced settings';
$string['background_profile_image'] = 'Default course background image';
$string['background_profile_image_desc'] = 'Sets a default background image for the header of all courses. This image will be displayed at the top of the course page and can be individually replaced in the course settings.';
$string['backgroundimage'] = 'Background image';
$string['backgroundimage_desc'] = 'The image to display as a background of the site. The background image you upload here will override the background image in your theme preset files.';
$string['brandcolor'] = 'Cor primária da interface';
$string['brandcolor_background_menu'] = 'Apply brand color to menu background';
$string['brandcolor_background_menu_desc'] = 'This setting defines whether the color set in "Brand color" will be applied to the menu items or to the menu background.<br>If applied to the background, the menu text will be displayed in white to ensure proper contrast.';
$string['brandcolor_desc'] = 'Set the highlight color using the selection above or by choosing from the palette below.';
$string['cachedef_course_cache'] = 'Course data cache';
$string['cachedef_course_module_cache'] = 'Course modules cache';
$string['cachedef_css_cache'] = 'CSS stylesheets cache';
$string['cachedef_frontpage_cache'] = 'Frontpage cache';
$string['choosereadme'] = 'Ead Training is a modern highly-customisable theme. This theme is intended to be used directly, or as a parent theme when creating new themes utilising Bootstrap 4.';
$string['configtitle'] = 'Ead Training';
$string['course_summary'] = 'Show course summary before the Course';
$string['course_summary_banner'] = 'Show course summary before the Course';
$string['course_summary_banner_desc'] = 'If enabled, the course summary will be displayed before the main course content on the course page.';
$string['course_summary_banner_edit'] = 'Edit the banner image of this course';
$string['course_summary_banner_none'] = 'No header';
$string['course_summary_banner_simple'] = 'Simple header with information';
$string['course_summary_banner_title'] = 'Header with banner';
$string['course_summary_desc'] = 'If enabled, the course summary will be displayed before the main course content on the course page.';
$string['coursesettings'] = 'Course';
$string['delete_block_confirm'] = 'Are you sure you want to delete the block?';
$string['delete_block_success'] = 'Block successfully deleted';
$string['delete_block_title'] = 'Delete block';
$string['details-completaram'] = 'Completed the course';
$string['details-emprogresso'] = 'In progress';
$string['details-not-access'] = 'Never accessed';
$string['details-teachers'] = 'Teachers';
$string['details-users'] = 'Students';
$string['edit_block'] = 'Edit block';
$string['editor_model_banner_no_video'] = 'Banner - No video';
$string['editor_model_banner_video'] = 'Banner - With video';
$string['editor_model_course_description'] = 'Course Description';
$string['editor_model_differentials_3'] = 'Our Differentials - 3 Columns';
$string['editor_model_differentials_4'] = 'Our Differentials - 4 Columns';
$string['editor_model_differentials_6'] = 'Our Differentials - 6 Columns';
$string['editor_model_differentials_8'] = 'Our Differentials - 8 Columns';
$string['editor_model_faq'] = 'FAQ';
$string['editor_model_faq_text'] = 'FAQ Description';
$string['editor_model_faq_title'] = 'FAQ Title';
$string['editor_model_features_3'] = 'Features - 3 columns';
$string['editor_model_features_4'] = 'Features - 4 columns';
$string['editor_model_features_6'] = 'Features - 6 columns';
$string['editor_model_features_8'] = 'Features - 8 columns';
$string['editor_model_form_info'] = 'The blocks generated above will replace the <code>[[change-to-blocks]]</code> placeholder in the editor below. Therefore, do not edit or remove this key.';
$string['editor_model_form_label'] = 'This is a multiple-type module, where blocks are created dynamically and added to the item below. Add as many blocks as needed, and in each one, select the desired course. When displayed, the Theme will organize the courses according to the order of the blocks defined here.';
$string['editor_model_form_label2'] = 'Add as many blocks as needed, and in each one, select the desired course. When displayed, the Theme will organize the courses according to the block order defined here.';
$string['editor_model_form_title'] = 'Module with Multiple Blocks';
$string['editor_model_prices_3'] = 'Prices 3 columns';
$string['editor_model_prices_4'] = 'Prices 4 columns';
$string['editor_model_select_course'] = 'Select a course';
$string['editor_model_top_courses'] = 'Top courses';
$string['editor_model_top_courses_eadflix'] = 'Top courses Number - EadFlix';
$string['editor_model_top_courses_number_eadflix'] = 'Top cursos Number - EadFlix';
$string['editor_model_youtube_video'] = '(Optional) A Youtube background video';
$string['footer_background_color'] = 'Footer background color';
$string['footer_background_color_desc'] = 'Select the background color for the website’s footer section. Leave blank to use the primary color.';
$string['footer_copywriter'] = 'Made with ❤️';
$string['footer_heading'] = 'Block {$a}';
$string['footer_heading_description_desc'] = '<ul>
  <li><strong>No blocks filled:</strong> the footer will not be displayed.</li>
  <li><strong>1 block filled:</strong> the content will be displayed as text, without block formatting.</li>
  <li><strong>2, 3, or 4 blocks filled:</strong> the theme will automatically adjust the layout to display the blocks responsively and proportionally.</li>
</ul>
Fill in only the blocks you need, the theme takes care of the rest.';
$string['footer_heading_description_title'] = 'The theme automatically adapts to the number of footer blocks you fill in:';
$string['footer_html'] = 'Footer Block {$a} HTML';
$string['footer_html_desc'] = 'Add the custom HTML code that will be displayed in footer block {$a}.';
$string['footer_show_copywriter'] = 'Show Made with ❤️';
$string['footer_show_copywriter_desc'] = 'Uncheck if you want to hide the "Made with ❤️"';
$string['footer_title'] = 'Block Title {$a}';
$string['footer_title_desc'] = 'Set the title that will appear above the HTML content in footer block {$a}.';
$string['footersettings'] = 'Footer Settings';
$string['frontpage_add_block'] = 'Add new block';
$string['frontpage_add_block_title'] = 'Select the sample block to add';
$string['frontpage_change_editor'] = 'Create the homepage with the Page editor?';
$string['frontpage_enable_editing'] = 'Enable editing to add items to the homepage';
$string['generalsettings'] = 'General settings';
$string['homesettings'] = 'Home Settings';
$string['imageacceptedtypes'] = 'Only image files of type {$a} are allowed';
$string['language_all'] = 'All available languages';
$string['loginbackgroundimage'] = 'Login page background image';
$string['loginbackgroundimage_desc'] = 'The image to display as a background for the login page.';
$string['pluginname'] = 'Ead Training';
$string['preview'] = 'Block preview';
$string['privacy:drawerblockclosed'] = 'The current preference for the block drawer is closed.';
$string['privacy:drawerblockopen'] = 'The current preference for the block drawer is open.';
$string['privacy:drawerindexclosed'] = 'The current preference for the index drawer is closed.';
$string['privacy:drawerindexopen'] = 'The current preference for the index drawer is open.';
$string['privacy:metadata'] = 'The Ead Training theme does not store any personal data about any user.';
$string['privacy:metadata:preference:draweropenblock'] = 'The user\'s preference for hiding or showing the drawer with blocks.';
$string['privacy:metadata:preference:draweropenindex'] = 'The user\'s preference for hiding or showing the drawer with course index.';
$string['privacy:metadata:preference:draweropennav'] = 'The user\'s preference for hiding or showing the drawer menu navigation.';
$string['quickstart_alert_notadd'] = 'It is not possible to change the homepage banner after it has been added. To modify it, you need to go to the <a href="{$a}/">homepage</a> and delete the existing banner.';
$string['quickstart_alert_notdelete'] = 'It is not possible to remove blocks added here. To delete them, go to the <a href="{$a}/">homepage</a> and remove the blocks you no longer want.';
$string['quickstart_banner-footer_block_count'] = 'Number of footer blocks';
$string['quickstart_banner-recreation-room'] = 'Recreation room';
$string['quickstart_banner-saved'] = 'The settings have been saved successfully.';
$string['quickstart_course_choose_below'] = 'Or choose a banner below';
$string['quickstart_course_upload_or_choose'] = 'Upload an image or choose the type of banner you want';
$string['quickstart_home_pagebuilder'] = 'Home with Page Editor';
$string['quickstart_home_pagebuilder_desc'] = 'Customizable interface with editable sections.';
$string['quickstart_home_selectsections'] = 'Select the desired sections:';
$string['quickstart_home_selectstyle'] = 'Choose the Home style';
$string['quickstart_home_traditional'] = 'Traditional Moodle Home';
$string['quickstart_home_traditional_desc'] = 'Default Moodle homepage with blocks and courses. Click the button below to edit system settings.';
$string['quickstart_settings_link'] = '<div class="card mb-5">
<div class="card-header">Quick Start</div>
<div class="card-body"><a href="{$a}">Access the Quick Start Guide</a> and use the intuitive configurator to customize these and other settings of the Ead Training theme.</div>
</div>';
$string['quickstart_title'] = 'Quick Start';
$string['region-side-pre'] = 'Right';
$string['settings_accessibility'] = 'Enable accessibility options';
$string['settings_accessibility_desc'] = 'Allows customization of options to improve platform accessibility, such as contrast, font size, and keyboard navigation.';
$string['settings_accessibility_heading'] = 'Accessibility';
$string['settings_icons_change_icons'] = 'Change the default icon in the course list';
$string['settings_icons_color_icon'] = 'Set a custom color for the icon.';
$string['settings_icons_color_icon_desc'] = 'Select the background color for the icon displayed in the course list. Leave blank to use the theme\'s default color.';
$string['settings_icons_upload_icon'] = 'Upload the custom icon.';
$string['settings_icons_upload_image'] = 'Block Image';
$string['settings_icons_upload_image_desc'] = 'If an image is provided, the theme will convert the module row into a block, using the image as its background. The image must have a 16:9 aspect ratio.';
$string['showfooter'] = 'Show footer';
$string['top_color_heading'] = 'Scroll Top Color';
$string['top_scroll_background_color'] = 'Background Color of Top Menu on Scroll';
$string['top_scroll_background_color_desc'] = 'Set the background color when scrolling the page.';
$string['top_scroll_fix'] = 'Pin the menu when scrolling the page';
$string['top_scroll_fix_desc'] = 'When enabled, the menu will be pinned to the top of the screen while you scroll the page, ensuring easy access to menu options.';
$string['userprofilesettings'] = 'User Profile';
