<?php

/**
 * featured3_createblocks
 *
 * @param $page
 * @return string
 */
function my_courses_minimalist_3_createblocks($page) {
    global $USER, $CFG;

    $blocks = "";

    $courses = enrol_get_users_courses($USER->id, true, '*');
    foreach ($courses as $course) {
        $backgroundimage = my_courses_minimalist_3_couse_image(new core_course_list_element($course));
        $progress = my_courses_minimalist_3_course_progress($course);
        $blocks .= "
            <div class=\"col-12 col-md-4\">
                <div class=\"curso-card\" style=\"background-image: url('{$backgroundimage}');\">
                    <div class=\"curso-overlay\">
                        <h3 class=\"curso-title\"><a href=\"{$CFG->wwwroot}/course/view.php?id={$course->id}\">{$course->fullname}</a></h3>
                        <div class=\"progress mt-3\">
                            <div class=\"progress-bar bg-primary\" role=\"progressbar\" style=\"width: {$progress}%;\"
                                 aria-valuenow=\"{$progress}\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div>
                        </div>
                        <span class=\"percent\">{$progress}%</span>
                    </div>
                </div>
            </div>\n";
    }

    return "<div class=\"row g-4\">{$blocks}</div>";
}

function my_courses_minimalist_3_course_progress($course) {
    global $USER;

    $all = 0;
    $count = 0;

    $courseformat = course_get_format($course->id);
    $modinfo = $courseformat->get_modinfo();
    $completioninfo = new completion_info($course);

    $sections = $modinfo->get_section_info_all();
    /** @var section_info $section */
    foreach ($sections as $section) {
        if ($courseformat->is_section_visible($section)) {
            if ($section->visible) {
                /** @var cm_info $cminfo */
                foreach ($modinfo->cms as $cminfo) {
                    if ($cminfo->is_visible_on_course_page() && $cminfo->uservisible) {
                        if ($cminfo->get_section_info()->id == $section->id) {
                            if ($cminfo->modname == "label") {
                                continue;
                            }

                            $hascompletion = $completioninfo->is_enabled($cminfo) != COMPLETION_DISABLED;
                            if ($hascompletion) {
                                $count++;

                                $state = $completioninfo->internal_get_state($cminfo, $USER->id, null);
                                if ($state == COMPLETION_COMPLETE) {
                                    $all++;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    if ($count == 0) {
        return 0;
    } else {
        return intval(($all / $count) * 100);
    }
}

function my_courses_minimalist_3_couse_image(core_course_list_element $course) {
    global $CFG, $OUTPUT;

    /** @var stored_file $file */
    foreach ($course->get_course_overviewfiles() as $file) {

        if ($file->is_valid_image()) {
            $contextid = $file->get_contextid();
            $component = $file->get_component();
            $filearea = $file->get_filearea();
            $filepath = $file->get_filepath();
            $filename = $file->get_filename();
            return moodle_url::make_file_url(
                "{$CFG->wwwroot}/pluginfile.php",
                "/{$contextid}/{$component}/{$filearea}{$filepath}{$filename}",
            );
        }
    }

   return $OUTPUT->get_generated_url_for_course(context_course::instance($course->id));
}
