/**
 * AMD module for course generator block.
 *
 * @module     block_dixeo_coursegen/generator
 * @author     Josemaria Bolanos <admin@mako.digital>
 * @copyright  2025 Dixeo (contact@dixeo.com)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("block_dixeo_coursegen/generator",["jquery","core/templates","core/notification","core/str","core/config"],(function($,Template,Notification,Str,Config){const generatorForm=document.getElementById("edai_course_generator_form"),promptContainer=generatorForm.querySelector(".prompt-container"),promptForm=generatorForm.querySelector("#prompt-form"),generationContainer=generatorForm.querySelector(".generation-container"),courseDescription=generatorForm.querySelector("#course_description"),generateCourse=generatorForm.querySelector("#generate_course"),tempCourseFiles=generatorForm.querySelector("#temp_course_files"),courseFiles=generatorForm.querySelector("#course_files"),filesContainer=generatorForm.querySelector("#file_names");return{init:function(generationURL){this.progress=0,this.adjustDescriptionHeight(),this.handleDragAndDrop(),""!==courseDescription.value.trim()&&setTimeout((()=>{generateCourse.click()}),1e3),courseDescription.addEventListener("keydown",(event=>{"Enter"!==event.key||event.shiftKey||(event.preventDefault(),generateCourse.click())})),generateCourse.addEventListener("click",(event=>{event.preventDefault();let courseDescriptionValue=courseDescription.value.trim();if(courseDescription.value="",""===courseDescriptionValue&&0===courseFiles.files.length)return void this.notify("invalidinput","descriptionorfilesrequired");0===this.progress&&this.startProgress();const formdata=new FormData;formdata.append("description",courseDescriptionValue);for(let i=0;i<courseFiles.files.length;i++)formdata.append("course_files[]",courseFiles.files[i]);fetch(generationURL,{method:"POST",body:formdata}).then((async response=>{const data=await response.json();if(!response.ok)throw this.resetProgress(),new Error(data.error);return data})).then((data=>{const courseid=data.courseid,coursename=data.coursename;this.finishProgress(courseid,coursename)})).catch((async error=>{this.resetProgress();const errorTitle=await Str.get_string("error_title","block_dixeo_coursegen");Notification.alert(errorTitle,error.message)}))}))},adjustDescriptionHeight:function(){courseDescription.addEventListener("input",(function(){this.style.height="auto";const maxHeight=9*parseFloat(getComputedStyle(this).lineHeight);this.style.overflowY="hidden",this.scrollHeight>maxHeight?(this.style.height=maxHeight+"px",this.style.overflowY="scroll"):this.style.height=this.scrollHeight+"px"}))},clearAllFiles:function(){let dataTransfer=new DataTransfer;courseFiles.files=dataTransfer.files,this.displayFileNames()},transferFiles:function(newFiles){const allowedtypes=["application/vnd.openxmlformats-officedocument.presentationml.presentation","application/vnd.openxmlformats-officedocument.wordprocessingml.document","application/pdf","text/plain"];let totalSize=0,existingFiles=Array.from(courseFiles.files);for(let file of existingFiles)totalSize+=file.size;for(let file of newFiles){if(!allowedtypes.includes(file.type))return void this.notify("uploaderror",["filetypeinvalid",file.name]);if(totalSize+=file.size,file.size>20971520)return void this.notify("uploaderror",["filetoolarge",file.name]);if(totalSize>52428800)return void this.notify("uploaderror","totaltoolarge")}for(let file of newFiles)existingFiles.some((existingFile=>existingFile.name===file.name&&existingFile.size===file.size))||existingFiles.push(file);let dataTransfer=new DataTransfer;for(let file of existingFiles)dataTransfer.items.add(file);courseFiles.files=dataTransfer.files,this.displayFileNames()},handleDragAndDrop:function(){let dragEnterCounter=0;$("#prompt-form").bind({dragenter:function(event){event.preventDefault(),event.stopPropagation(),dragEnterCounter++,promptContainer.classList.add("drag-over")},dragleave:function(event){event.preventDefault(),event.stopPropagation(),dragEnterCounter--,0===dragEnterCounter&&promptContainer.classList.remove("drag-over")}}),this.dropOnChildElements(promptForm),tempCourseFiles.addEventListener("change",(()=>{let newFiles=Array.from(tempCourseFiles.files);this.transferFiles(newFiles)}))},dropOnChildElements:function(node){node.childNodes.forEach((child=>{this.dropOnChildElements(child),child.addEventListener("dragover",(event=>{event.preventDefault(),event.stopPropagation()})),child.addEventListener("drop",(event=>{event.preventDefault(),event.stopPropagation(),promptContainer.classList.remove("drag-over"),event.dataTransfer.files.length>0&&this.transferFiles(event.dataTransfer.files)}))}))},startProgress:function(){generateCourse.disabled=!0,promptContainer.classList.replace("d-block","d-none"),generationContainer.classList.replace("d-none","d-block");let interval=setInterval((()=>{this.progress>=90&&clearInterval(interval);let increment=Math.floor(5*Math.random());this.setProgress(this.progress+increment)}),1e3)},finishProgress:async function(courseid,coursename){this.setProgress(100),setTimeout((()=>{let context={courseid:courseid,coursename:coursename,wwwroot:Config.wwwroot};Template.render("block_dixeo_coursegen/success_message",context).then((html=>{generationContainer.parentElement.insertAdjacentHTML("beforeend",html),generationContainer.classList.replace("d-block","d-none")})).catch((error=>{Notification.exception(error)}))}),500)},resetProgress:function(){generateCourse.disabled=!1,promptContainer.classList.replace("d-none","d-block"),generationContainer.classList.replace("d-block","d-none"),courseDescription.value="";let successContainer=generatorForm.querySelector("#success_message_container");successContainer&&successContainer.remove(),this.clearAllFiles(),this.setProgress(0)},setProgress:function(progress){this.progress=progress;let progressBar=generatorForm.querySelector(".s-progress--bar");progressBar&&(progressBar.style.width="".concat(progress,"%"),progress>=100?progressBar.classList.add("done"):progressBar.classList.remove("done"))},displayFileNames:function(){let contextFiles=[],totalSize=0;for(let i=0;i<courseFiles.files.length;i++){const file=courseFiles.files[i];totalSize+=file.size,contextFiles.push({name:file.name,size:this.formatFilesize(file.size)})}let context={hasFiles:contextFiles.length>0,totalSize:this.formatFilesize(totalSize),maxTotalSize:this.formatFilesize(52428800),files:contextFiles};Template.render("block_dixeo_coursegen/filenames",context).then((html=>{filesContainer.innerHTML=html,filesContainer.querySelectorAll(".delete-icon").forEach(((deleteIcon,index)=>{let that=this,toDelete=courseFiles.files[index].name;deleteIcon.addEventListener("click",(function(){let toolTipId=deleteIcon.getAttribute("aria-describedby");document.getElementById(toolTipId).remove();let dataTransfer=new DataTransfer;for(let i=0;i<courseFiles.files.length;i++)courseFiles.files[i].name!==toDelete&&dataTransfer.items.add(courseFiles.files[i]);courseFiles.files=dataTransfer.files,that.displayFileNames()}))}))})).catch((error=>{Notification.exception(error)}))},formatFilesize:size=>{const units=["bytes","KB","MB","GB","TB"];let unitIndex=0;for(;size>=1024&&unitIndex<units.length-1;)size/=1024,unitIndex++;return"".concat(size.toFixed(1)," ").concat(units[unitIndex])},notify:async function(){let strings=[],component="block_dixeo_coursegen";for(let i=0;i<arguments.length;i++)Array.isArray(arguments[i])?strings.push({key:arguments[i][0],component:component,param:arguments[i][1]}):strings.push({key:arguments[i],component:component});Str.get_strings(strings).done((s=>{s.length>1?Notification.alert(s[0],s[1]):Notification.alert("",s[0])})).fail(Notification.exception)}}}));

//# sourceMappingURL=generator.min.js.map