// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This module is responsible for LibraPay content in the gateways modal.
 *
 * @module     paygw_librapay/gateways_modal
 * @copyright  2026 Axel eLearning
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

import Config from 'core/config';

/**
 * Process the payment.
 *
 * LibraPay uses a redirect-based payment flow. This function redirects
 * the user to pay.php which then submits a form to LibraPay's payment page.
 *
 * @param {string} component Name of the component that the itemId belongs to
 * @param {string} paymentArea The area of the component that the itemId belongs to
 * @param {number} itemId An internal identifier that is used by the component
 * @param {string} description Description of the payment
 * @returns {Promise<string>}
 */
export const process = (component, paymentArea, itemId, description) => {
    return new Promise(() => {
        const url = new URL(Config.wwwroot + '/payment/gateway/librapay/pay.php');
        url.searchParams.set('component', component);
        url.searchParams.set('paymentarea', paymentArea);
        url.searchParams.set('itemid', itemId);
        url.searchParams.set('description', encodeURIComponent(description));

        window.location.href = url.toString();
    });
};
